/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.e0;
import com.aspose.slides.ms.System.f1;
import com.aspose.slides.ms.System.o3;

@e0
public final class BitArray
implements ICollection,
o3 {
    private int[] p1;
    private int e2;
    private int e9 = 0;

    public BitArray(BitArray bits) {
        if (bits == null) {
            throw new ArgumentNullException("bits");
        }
        this.e2 = bits.e2;
        this.p1 = new int[(this.e2 + 31) / 32];
        if (this.p1.length == 1) {
            this.p1[0] = bits.p1[0];
        } else {
            f1.p1(bits.p1, 0, this.p1, 0, this.p1.length);
        }
    }

    public BitArray(boolean[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        this.e2 = values.length;
        this.p1 = new int[(this.e2 + 31) / 32];
        for (int i = 0; i < values.length; ++i) {
            this.set_Item(i, values[i]);
        }
    }

    public BitArray(byte[] bytes) {
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        this.e2 = bytes.length * 8;
        this.p1 = new int[(this.e2 + 31) / 32];
        for (int i = 0; i < bytes.length; ++i) {
            this.p1(i, bytes[i]);
        }
    }

    public BitArray(int[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        int n = values.length;
        this.e2 = n * 32;
        this.p1 = new int[n];
        f1.p1(values, 0, this.p1, 0, n);
    }

    public BitArray(int length) {
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length");
        }
        this.e2 = length;
        this.p1 = new int[(this.e2 + 31) / 32];
    }

    public BitArray(int length, boolean defaultValue) {
        this(length);
        if (defaultValue) {
            for (int i = 0; i < this.p1.length; ++i) {
                this.p1[i] = -1;
            }
        }
    }

    private byte p1(int n) {
        int n10 = n / 4;
        int n11 = n % 4 * 8;
        int n12 = this.p1[n10] & 255 << n11;
        return (byte)(n12 >> n11 & 0xFF);
    }

    private void p1(int n, byte by) {
        int n10 = n / 4;
        int n11 = n % 4 * 8;
        int n12 = n10;
        this.p1[n12] = this.p1[n12] & ~(255 << n11);
        int n13 = n10;
        this.p1[n13] = this.p1[n13] | (by & 0xFF) << n11;
        ++this.e9;
    }

    private void e2(BitArray bitArray) {
        if (bitArray == null) {
            throw new ArgumentNullException();
        }
        if (bitArray.e2 != this.e2) {
            throw new ArgumentException();
        }
    }

    @Override
    public int size() {
        return this.e2;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    public boolean get_Item(int index) {
        return this.get(index);
    }

    public void set_Item(int index, boolean value) {
        this.set(index, value);
    }

    public int getLength() {
        return this.e2;
    }

    public void setLength(int value) {
        if (this.e2 == value) {
            return;
        }
        if (value < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (value > this.e2) {
            int n = (value + 31) / 32;
            int n10 = (this.e2 + 31) / 32;
            if (n > this.p1.length) {
                int[] nArray = new int[n];
                f1.p1(this.p1, 0, nArray, 0, this.p1.length);
                this.p1 = nArray;
            } else {
                f1.p1(f1.p1((Object)this.p1), n10, n - n10);
            }
            int n11 = this.e2 % 32;
            if (n11 > 0) {
                int n12 = n10 - 1;
                this.p1[n12] = this.p1[n12] & (1 << n11) - 1;
            }
        }
        this.e2 = value;
        ++this.e9;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public Object deepClone() {
        return new BitArray(this);
    }

    @Override
    public void copyTo(f1 array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.f1() != 1) {
            throw new ArgumentException("array", "Array rank must be 1");
        }
        if (index >= array.d7() && this.e2 > 0) {
            throw new ArgumentException("index", "index is greater than array.Length");
        }
        Object object = f1.p1(array);
        if (object instanceof Boolean[]) {
            if (array.d7() - index < this.e2) {
                throw new ArgumentException();
            }
            Boolean[] booleanArray = (Boolean[])object;
            for (int i = 0; i < this.e2; ++i) {
                booleanArray[index + i] = this.get_Item(i);
            }
        } else if (object instanceof boolean[]) {
            if (array.d7() - index < this.e2) {
                throw new ArgumentException();
            }
            boolean[] blArray = (boolean[])object;
            for (int i = 0; i < this.e2; ++i) {
                blArray[index + i] = this.get_Item(i);
            }
        } else if (object instanceof Byte[]) {
            int n = (this.e2 + 7) / 8;
            if (array.d7() - index < n) {
                throw new ArgumentException();
            }
            Byte[] byteArray = (Byte[])object;
            for (int i = 0; i < n; ++i) {
                byteArray[index + i] = this.p1(i);
            }
        } else if (object instanceof byte[]) {
            int n = (this.e2 + 7) / 8;
            if (array.d7() - index < n) {
                throw new ArgumentException();
            }
            byte[] byArray = (byte[])object;
            for (int i = 0; i < n; ++i) {
                byArray[index + i] = this.p1(i);
            }
        } else if (object instanceof Integer[]) {
            f1.p1(f1.p1((Object)this.p1), 0, array, index, (this.e2 + 31) / 32);
        } else if (object instanceof int[]) {
            f1.p1(f1.p1((Object)this.p1), 0, array, index, (this.e2 + 31) / 32);
        } else {
            throw new ArgumentException("array", "Unsupported type");
        }
    }

    public BitArray not() {
        int n = (this.e2 + 31) / 32;
        for (int i = 0; i < n; ++i) {
            this.p1[i] = ~this.p1[i];
        }
        ++this.e9;
        return this;
    }

    public BitArray and(BitArray value) {
        this.e2(value);
        int n = (this.e2 + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.p1[n10] = this.p1[n10] & value.p1[i];
        }
        ++this.e9;
        return this;
    }

    public BitArray or(BitArray value) {
        this.e2(value);
        int n = (this.e2 + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.p1[n10] = this.p1[n10] | value.p1[i];
        }
        ++this.e9;
        return this;
    }

    public BitArray xor(BitArray value) {
        this.e2(value);
        int n = (this.e2 + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.p1[n10] = this.p1[n10] ^ value.p1[i];
        }
        ++this.e9;
        return this;
    }

    public boolean get(int index) {
        if (index < 0 || index >= this.e2) {
            throw new ArgumentOutOfRangeException();
        }
        return (this.p1[index >> 5] & 1 << (index & 0x1F)) != 0;
    }

    public void set(int index, boolean value) {
        if (index < 0 || index >= this.e2) {
            throw new ArgumentOutOfRangeException();
        }
        if (value) {
            int n = index >> 5;
            this.p1[n] = this.p1[n] | 1 << (index & 0x1F);
        } else {
            int n = index >> 5;
            this.p1[n] = this.p1[n] & ~(1 << (index & 0x1F));
        }
        ++this.e9;
    }

    public void setAll(boolean value) {
        if (value) {
            for (int i = 0; i < this.p1.length; ++i) {
                this.p1[i] = -1;
            }
        } else {
            f1.p1(f1.p1((Object)this.p1), 0, this.p1.length);
        }
        ++this.e9;
    }

    @Override
    public IEnumerator iterator() {
        return new BitArrayEnumerator(this);
    }

    @e0
    private static class BitArrayEnumerator
    implements IEnumerator,
    o3,
    Cloneable {
        private BitArray p1;
        private boolean e2;
        private int e9;
        private int f1;

        @Override
        public Object deepClone() {
            return this.p1();
        }

        private BitArrayEnumerator() {
        }

        public BitArrayEnumerator(BitArray ba) {
            this.e9 = -1;
            this.p1 = ba;
            this.f1 = ba.e9;
        }

        @Override
        public Object next() {
            if (this.e9 == -1) {
                throw new InvalidOperationException("Enum not started");
            }
            if (this.e9 >= this.p1.size()) {
                throw new InvalidOperationException("Enum Ended");
            }
            return this.e2;
        }

        @Override
        public boolean hasNext() {
            this.e2();
            if (this.e9 < this.p1.size() - 1) {
                this.e2 = this.p1.get_Item(++this.e9);
                return true;
            }
            this.e9 = this.p1.size();
            return false;
        }

        @Override
        public void reset() {
            this.e2();
            this.e9 = -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        private void e2() {
            if (this.f1 != this.p1.e9) {
                throw new InvalidOperationException();
            }
        }

        protected Object p1() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            BitArrayEnumerator bitArrayEnumerator = new BitArrayEnumerator();
            bitArrayEnumerator.p1 = this.p1;
            bitArrayEnumerator.e2 = this.e2;
            bitArrayEnumerator.e9 = this.e9;
            bitArrayEnumerator.f1 = this.f1;
            return bitArrayEnumerator;
        }
    }
}

