/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.IGenericList;
import com.aspose.slides.Collections.ObjectModel.ReadOnlyCollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.internal.x7s.s1;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.e0;
import com.aspose.slides.ms.System.f1;
import com.aspose.slides.ms.System.i2;
import com.aspose.slides.ms.System.p1;
import com.aspose.slides.ms.System.p8;
import com.aspose.slides.ms.System.v4;
import com.aspose.slides.ms.System.x2;
import com.aspose.slides.ms.System.z4;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@e0
public class List<T>
implements IGenericList<T>,
java.util.List<T> {
    private Object[] p1;
    private int e2;
    private int e9;
    private final Object f1 = new Object();
    static Object[] m6 = new Object[0];

    public List() {
        this.p1 = m6;
    }

    public List(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.p1 = m6;
        this.p1(collection);
    }

    public List(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: capacity");
        }
        this.p1 = new Object[capacity];
    }

    private List(T[] data, int size) {
        this.p1 = data;
        this.e2 = size;
    }

    protected int getVersion() {
        return this.e9;
    }

    @Override
    public void addItem(T item) {
        if (this.e2 == this.p1.length) {
            this.p1(1);
        }
        this.p1[this.e2++] = item;
        ++this.e9;
    }

    private void p1(int n) {
        int n10 = this.e2 + n;
        if (n10 > this.p1.length) {
            this.setCapacity(Math.max(Math.max(this.getCapacity() * 2, 4), n10));
        }
    }

    private void p1(int n, int n10) {
        if (n < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (n10 < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)n & 0xFFFFFFFFL) + ((long)n10 & 0xFFFFFFFFL) > ((long)this.e2 & 0xFFFFFFFFL)) {
            throw new ArgumentException("index and count exceed length of list");
        }
    }

    private void p1(IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t : iGenericEnumerable) {
            this.addItem(t);
        }
    }

    public void addRange(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.p1(new List<T>(collection));
        ++this.e9;
    }

    public void addRange(T[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (T t : collection) {
            this.addItem(t);
        }
        ++this.e9;
    }

    public ReadOnlyCollection<T> asReadOnly() {
        return new ReadOnlyCollection(this);
    }

    public int binarySearch(T item) {
        return p8.p1(this.p1, 0, this.e2, item);
    }

    public int binarySearch(T item, Comparator<T> comparer) {
        return p8.p1(this.p1, 0, this.e2, item, comparer);
    }

    public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
        this.p1(index, count);
        return p8.p1(this.p1, index, count, item, comparer);
    }

    @Override
    public void clear() {
        com.aspose.slides.ms.System.f1.p1(this.p1, 0, this.p1.length);
        this.e2 = 0;
        ++this.e9;
    }

    public <TOutput> List<TOutput> convertAll(z4<T, TOutput> converter) {
        if (converter == null) {
            throw new ArgumentNullException("converter");
        }
        List<T> list = new List<T>(this.e2);
        for (int i = 0; i < this.e2; ++i) {
            list.p1[i] = converter.p1(this.p1[i]);
        }
        list.e2 = this.e2;
        return list;
    }

    public void copyTo(T[] array) {
        com.aspose.slides.ms.System.f1.p1(this.p1, 0, array, 0, this.e2);
    }

    @Override
    public void copyToTArray(T[] array, int arrayIndex) {
        com.aspose.slides.ms.System.f1.p1(this.p1, 0, array, arrayIndex, this.e2);
    }

    public void copyTo(int index, T[] array, int arrayIndex, int count) {
        this.p1(index, count);
        com.aspose.slides.ms.System.f1.p1(this.p1, index, array, arrayIndex, count);
    }

    public boolean exists(v4<T> match) {
        List.p1(match);
        return this.p1(0, this.e2, match) != -1;
    }

    public T find(v4<T> match) {
        List.p1(match);
        int n = this.p1(0, this.e2, match);
        return (T)(n != -1 ? this.p1[n] : null);
    }

    static <T> void p1(v4<T> v42) {
        if (v42 == null) {
            throw new ArgumentNullException("match");
        }
    }

    public List<T> findAll(v4<T> match) {
        List.p1(match);
        return this.e2(match);
    }

    private List<T> e2(v4<T> v42) {
        List<Object> list = new List<Object>();
        for (int i = 0; i < this.e2; ++i) {
            if (!v42.invoke(this.p1[i])) continue;
            list.addItem(this.p1[i]);
        }
        return list;
    }

    public int findIndex(v4<T> match) {
        List.p1(match);
        return this.p1(0, this.e2, match);
    }

    public int findIndex(int startIndex, v4<T> match) {
        List.p1(match);
        this.e2(startIndex);
        return this.p1(startIndex, this.e2 - startIndex, match);
    }

    public int findIndex(int startIndex, int count, v4<T> match) {
        List.p1(match);
        this.p1(startIndex, count);
        return this.p1(startIndex, count, match);
    }

    private int p1(int n, int n10, v4<T> v42) {
        int n11 = n + n10;
        for (int i = n; i < n11; ++i) {
            if (!v42.invoke(this.p1[i])) continue;
            return i;
        }
        return -1;
    }

    public T findLast(v4<T> match) {
        List.p1(match);
        int n = this.e2(0, this.e2, match);
        if (n == -1) {
            return null;
        }
        return this.get_Item(n);
    }

    public int findLastIndex(v4<T> match) {
        List.p1(match);
        return this.e2(0, this.e2, match);
    }

    public int findLastIndex(int startIndex, v4<T> match) {
        List.p1(match);
        this.e2(startIndex);
        return this.e2(0, startIndex + 1, match);
    }

    public int findLastIndex(int startIndex, int count, v4<T> match) {
        List.p1(match);
        int n = startIndex - count + 1;
        this.p1(n, count);
        return this.e2(n, count, match);
    }

    private int e2(int n, int n10, v4<T> v42) {
        int n11 = n + n10;
        while (n11 != n) {
            if (!v42.invoke(this.p1[--n11])) continue;
            return n11;
        }
        return -1;
    }

    @Override
    public void forEach(p1<T> action) {
        if (action == null) {
            throw new ArgumentNullException("action");
        }
        for (int i = 0; i < this.e2; ++i) {
            action.invoke(this.p1[i]);
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    @Deprecated
    public EnumeratorJava<T> iteratorJava() {
        return new EnumeratorJava(this);
    }

    public List<T> getRange(int index, int count) {
        this.p1(index, count);
        Object[] objectArray = new Object[count];
        com.aspose.slides.ms.System.f1.p1(this.p1, index, objectArray, 0, count);
        return new List<Object>(objectArray, count);
    }

    @Override
    public int indexOfItem(T item) {
        return com.aspose.slides.ms.System.f1.p1(this.p1, item, 0, this.e2);
    }

    public int indexOf(T item, int index) {
        this.e2(index);
        return com.aspose.slides.ms.System.f1.p1(this.p1, item, index, this.e2 - index);
    }

    public int indexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.e2 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
        }
        return com.aspose.slides.ms.System.f1.p1(this.p1, item, index, count);
    }

    private void e2(int n, int n10) {
        if (n10 < 0) {
            n -= n10;
        }
        if (n < this.e2) {
            com.aspose.slides.ms.System.f1.p1(this.p1, n, this.p1, n + n10, this.e2 - n);
        }
        this.e2 += n10;
        if (n10 < 0) {
            com.aspose.slides.ms.System.f1.p1(this.p1, this.e2, -n10);
        }
    }

    private void e2(int n) {
        if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.e2 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
    }

    @Override
    public void insertItem(int index, T item) {
        this.e2(index);
        if (this.e2 == this.p1.length) {
            this.p1(1);
        }
        this.e2(index, 1);
        this.p1[index] = item;
        ++this.e9;
    }

    void e9(int n) {
        Object[] objectArray = new Object[this.e2];
        this.copyToTArray(objectArray, 0);
        this.p1(this.e2);
        this.e2(n, objectArray.length);
        com.aspose.slides.ms.System.f1.p1(objectArray, 0, this.p1, n, objectArray.length);
    }

    public void insertRange(int index, IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.e2(index);
        if (collection == this) {
            this.e9(index);
        } else {
            this.p1(index, collection);
        }
        ++this.e9;
    }

    private void p1(int n, IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t : iGenericEnumerable) {
            this.insertItem(n++, t);
        }
    }

    @Override
    public int lastIndexOf(Object item) {
        if (this.e2 == 0) {
            return -1;
        }
        return p8.p1(this.p1, item, this.e2 - 1, this.e2);
    }

    public int lastIndexOf(T item, int index) {
        this.e2(index);
        return p8.p1(this.p1, item, index, index + 1);
    }

    public int lastIndexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index", index, "index is negative");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", count, "count is negative");
        }
        if (index - count + 1 < 0) {
            throw new ArgumentOutOfRangeException("cound", count, "count is too large");
        }
        return p8.p1(this.p1, item, index, count);
    }

    @Override
    public boolean removeItem(T item) {
        int n = this.indexOfItem(item);
        if (n != -1) {
            this.removeAt(n);
        }
        return n != -1;
    }

    public int removeAll(v4<T> match) {
        List.p1(match);
        int n = 0;
        int n10 = 0;
        for (n = 0; n < this.e2 && !match.invoke(this.p1[n]); ++n) {
        }
        if (n == this.e2) {
            return 0;
        }
        ++this.e9;
        for (n10 = n + 1; n10 < this.e2; ++n10) {
            if (match.invoke(this.p1[n10])) continue;
            this.p1[n++] = this.p1[n10];
        }
        if (n10 - n > 0) {
            com.aspose.slides.ms.System.f1.p1(this.p1, n, n10 - n);
        }
        this.e2 = n;
        return n10 - n;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.e2 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.e2(index, -1);
        com.aspose.slides.ms.System.f1.p1(this.p1, this.e2, 1);
        ++this.e9;
    }

    public void removeRange(int index, int count) {
        this.p1(index, count);
        if (count > 0) {
            this.e2(index, -count);
            com.aspose.slides.ms.System.f1.p1(this.p1, this.e2, count);
            ++this.e9;
        }
    }

    public void reverse() {
        p8.p1(this.p1, 0, this.e2);
        ++this.e9;
    }

    public void reverse(int index, int count) {
        this.p1(index, count);
        p8.p1(this.p1, index, count);
        ++this.e9;
    }

    public void sort() {
        Arrays.sort(this.p1, 0, this.e2);
        ++this.e9;
    }

    @Override
    public void sort(Comparator<? super T> comparer) {
        Arrays.sort(this.p1, 0, this.e2, comparer);
        ++this.e9;
    }

    @Override
    public void sort(x2<T> comparison) {
        if (comparison == null) {
            throw new ArgumentNullException("comparison");
        }
        Arrays.sort(this.p1, 0, this.e2, new p8.p1<T>(comparison));
        ++this.e9;
    }

    public void sort(int index, int count, Comparator<T> comparer) {
        this.p1(index, count);
        Arrays.sort(this.p1, index, index + count, comparer);
        ++this.e9;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.e2) {
            return Arrays.copyOf(this.p1, this.e2, a.getClass());
        }
        System.arraycopy(this.p1, 0, a, 0, this.e2);
        if (a.length > this.e2) {
            a[this.e2] = null;
        }
        return a;
    }

    public void trimExcess() {
        this.setCapacity(this.e2);
    }

    public boolean trueForAll(v4<T> match) {
        List.p1(match);
        for (int i = 0; i < this.e2; ++i) {
            if (match.invoke(this.p1[i])) continue;
            return false;
        }
        return true;
    }

    public int getCapacity() {
        return this.p1.length;
    }

    public void setCapacity(int value) {
        if (((long)value & 0xFFFFFFFFL) < ((long)this.e2 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException();
        }
        this.p1 = Arrays.copyOf(this.p1, value);
    }

    @Override
    public int size() {
        return this.e2;
    }

    @Override
    public T get_Item(int index) {
        if (((long)index & 0xFFFFFFFFL) >= ((long)this.e2 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        return (T)this.p1[index];
    }

    @Override
    public void set_Item(int index, T value) {
        this.e2(index);
        if ((long)index == (long)this.e2) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.p1[index] = value;
        ++this.e9;
    }

    public void copyTo(f1 array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.f1() > 1 || array.e2(0) != 0) {
            throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
        }
        com.aspose.slides.ms.System.f1.p1(com.aspose.slides.ms.System.f1.p1(this.p1), 0, array, arrayIndex, this.e2);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public boolean isSynchronized() {
        return false;
    }

    public Object getSyncRoot() {
        return this.f1;
    }

    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.e2 == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            for (int i = 0; i < this.e2; ++i) {
                if (this.p1[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.e2; ++i) {
            if (!this.p1[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsItem(T item) {
        if (item == null) {
            for (int i = 0; i < this.e2; ++i) {
                if (this.p1[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.e2; ++i) {
            if (!this.p1[i].equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.e2];
        System.arraycopy(this.p1, 0, objectArray, 0, this.e2);
        return objectArray;
    }

    @Override
    public boolean add(T t) {
        int n = this.e2;
        this.addItem(t);
        return n != this.e2;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.e2;
        this.removeItem(o);
        return n != this.e2;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        int n = 0;
        int n10 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n10 != this.size();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        int n = index;
        int n10 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n10 != this.size();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int n = this.size();
        for (Object obj : c) {
            this.remove(obj);
        }
        return n != this.size();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Object[] objectArray;
        int n = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c.contains(object)) continue;
            this.remove(object);
        }
        return n != this.size();
    }

    @Override
    public T get(int index) {
        return this.get_Item(index);
    }

    @Override
    public T set(int index, T element) {
        T t = this.get_Item(index);
        this.set_Item(index, element);
        return t;
    }

    @Override
    public void add(int index, T element) {
        this.insertItem(index, element);
    }

    @Override
    public T remove(int index) {
        T t = this.get_Item(index);
        this.removeAt(index);
        return t;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.e2; ++i) {
                if (this.p1[i] != null) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.e2; ++i) {
            if (!o.equals(this.p1[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator listIterator() {
        return new ListItr(0);
    }

    @Override
    public ListIterator listIterator(int index) {
        return new ListItr(index);
    }

    @Override
    public java.util.List<T> subList(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        return this.getRange(fromIndex, n);
    }

    public static <T> List<T> fromJava(java.util.List<T> list) {
        if (list == null) {
            return null;
        }
        return new ListInternalized<T>(list);
    }

    public static <T> java.util.List<T> toJava(List<T> list) {
        return list;
    }

    static class ListInternalized<T>
    extends List<T> {
        private java.util.List<T> p1;
        private int e2;

        public ListInternalized() {
            this.p1 = new ArrayList<T>();
        }

        public ListInternalized(java.util.List<T> list) {
            super(list.size());
            for (T t : list) {
                super.addItem(t);
            }
            this.p1 = list;
        }

        @Override
        protected int getVersion() {
            return this.e2;
        }

        @Override
        public void addRange(IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            this.p1(collection);
            ++this.e2;
        }

        @Override
        public void addRange(T[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            for (T t : collection) {
                this.addItem(t);
            }
            ++this.e2;
        }

        @Override
        public ReadOnlyCollection<T> asReadOnly() {
            return new ReadOnlyCollection(this);
        }

        @Override
        public int binarySearch(T item) {
            return p8.p1(this.p1.toArray(), 0, this.p1.size(), item);
        }

        @Override
        public int binarySearch(T item, Comparator<T> comparer) {
            return p8.p1(this.p1.toArray(), 0, this.p1.size(), item, comparer);
        }

        @Override
        public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
            this.p1(index, count);
            return p8.p1(this.p1.toArray(), index, count, item, comparer);
        }

        @Override
        private void p1(int n, int n10) {
            if (n < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (n10 < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)n & 0xFFFFFFFFL) + ((long)n10 & 0xFFFFFFFFL) > ((long)this.p1.size() & 0xFFFFFFFFL)) {
                throw new ArgumentException("index and count exceed length of list");
            }
        }

        @Override
        public <TOutput> List<TOutput> convertAll(z4<T, TOutput> converter) {
            if (converter == null) {
                throw new ArgumentNullException("converter");
            }
            List list = new List(this.p1.size());
            for (int i = 0; i < this.p1.size(); ++i) {
                list.p1[i] = converter.p1(this.get_Item(i));
            }
            list.e2 = this.p1.size();
            return list;
        }

        @Override
        public void copyTo(T[] array) {
            com.aspose.slides.ms.System.f1.p1(this.p1.toArray(), 0, array, 0, this.p1.size());
        }

        @Override
        public void copyToTArray(T[] array, int arrayIndex) {
            com.aspose.slides.ms.System.f1.p1(this.p1.toArray(), 0, array, arrayIndex, this.p1.size());
        }

        @Override
        public void copyTo(int index, T[] array, int arrayIndex, int count) {
            this.p1(index, count);
            com.aspose.slides.ms.System.f1.p1(this.p1.toArray(), index, array, arrayIndex, count);
        }

        @Override
        public boolean exists(v4<T> match) {
            ListInternalized.e2(match);
            return this.p1(0, this.p1.size(), match) != -1;
        }

        @Override
        private int p1(int n, int n10, v4<T> v42) {
            int n11 = n + n10;
            for (int i = n; i < n11; ++i) {
                if (!v42.invoke(this.p1.get(i))) continue;
                return i;
            }
            return -1;
        }

        static <T> void e2(v4<T> v42) {
            if (v42 == null) {
                throw new ArgumentNullException("match");
            }
        }

        @Override
        public T find(v4<T> match) {
            ListInternalized.e2(match);
            int n = this.p1(0, this.p1.size(), match);
            return n != -1 ? (T)this.p1.get(n) : null;
        }

        @Override
        public List<T> findAll(v4<T> match) {
            ListInternalized.e2(match);
            return this.e9(match);
        }

        private List<T> e9(v4<T> v42) {
            List<T> list = new List<T>();
            for (int i = 0; i < this.size(); ++i) {
                if (!v42.invoke(this.p1.get(i))) continue;
                list.addItem(this.p1.get(i));
            }
            return list;
        }

        @Override
        public int findIndex(v4<T> match) {
            ListInternalized.e2(match);
            return this.p1(0, this.p1.size(), match);
        }

        @Override
        public int findIndex(int startIndex, v4<T> match) {
            ListInternalized.e2(match);
            this.p1(startIndex);
            return this.p1(startIndex, this.p1.size() - startIndex, match);
        }

        @Override
        private void p1(int n) {
            if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.p1.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
        }

        @Override
        public int findIndex(int startIndex, int count, v4<T> match) {
            ListInternalized.e2(match);
            this.p1(startIndex, count);
            return this.p1(startIndex, count, match);
        }

        @Override
        public T findLast(v4<T> match) {
            ListInternalized.e2(match);
            int n = this.e2(0, this.p1.size(), match);
            if (n == -1) {
                return null;
            }
            return this.get_Item(n);
        }

        @Override
        private int e2(int n, int n10, v4<T> v42) {
            int n11 = n + n10;
            while (n11 != n) {
                if (!v42.invoke(this.p1.get(--n11))) continue;
                return n11;
            }
            return -1;
        }

        @Override
        public int findLastIndex(v4<T> match) {
            ListInternalized.e2(match);
            return this.e2(0, this.p1.size(), match);
        }

        @Override
        public int findLastIndex(int startIndex, v4<T> match) {
            ListInternalized.e2(match);
            this.p1(startIndex);
            return this.e2(0, startIndex + 1, match);
        }

        @Override
        public int findLastIndex(int startIndex, int count, v4<T> match) {
            ListInternalized.e2(match);
            int n = startIndex - count + 1;
            this.p1(n, count);
            return this.e2(n, count, match);
        }

        @Override
        public void forEach(p1<T> action) {
            if (action == null) {
                throw new ArgumentNullException("action");
            }
            for (int i = 0; i < this.p1.size(); ++i) {
                action.invoke(this.p1.get(i));
            }
        }

        @Override
        public Enumerator<T> iterator() {
            return new Enumerator(this);
        }

        @Override
        public List<T> getRange(int index, int count) {
            this.p1(index, count);
            Object[] objectArray = new Object[count];
            com.aspose.slides.ms.System.f1.p1(this.p1.toArray(), index, objectArray, 0, count);
            return new List(objectArray, count);
        }

        @Override
        public int indexOfItem(T item) {
            return this.p1.indexOf(item);
        }

        @Override
        public int indexOf(T item, int index) {
            this.p1(index);
            return com.aspose.slides.ms.System.f1.p1(this.p1.toArray(), item, index, this.p1.size() - index);
        }

        @Override
        public int indexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.p1.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
            }
            return com.aspose.slides.ms.System.f1.p1(this.p1.toArray(), item, index, count);
        }

        @Override
        public int lastIndexOf(Object item) {
            if (this.p1.size() == 0) {
                return -1;
            }
            return p8.p1(this.p1.toArray(), item, this.p1.size() - 1, this.p1.size());
        }

        @Override
        public int lastIndexOf(T item, int index) {
            this.p1(index);
            return p8.p1(this.p1.toArray(), item, index, index + 1);
        }

        @Override
        public int lastIndexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "index is negative");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "count is negative");
            }
            if (index - count + 1 < 0) {
                throw new ArgumentOutOfRangeException("cound", count, "count is too large");
            }
            return p8.p1(this.p1.toArray(), item, index, count);
        }

        @Override
        public boolean removeItem(T item) {
            int n = this.indexOfItem(item);
            if (n != -1) {
                this.removeAt(n);
            }
            return n != -1;
        }

        @Override
        public <T1> T1[] toArray(T1[] a) {
            return this.p1.toArray(a);
        }

        @Override
        public void trimExcess() {
            this.setCapacity(this.p1.size());
        }

        @Override
        public boolean trueForAll(v4<T> match) {
            ListInternalized.e2(match);
            for (int i = 0; i < this.p1.size(); ++i) {
                if (match.invoke(this.p1.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getCapacity() {
            return this.p1.size();
        }

        @Override
        public void setCapacity(int value) {
            if (((long)value & 0xFFFFFFFFL) < ((long)this.p1.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException();
            }
            for (int i = 0; i < value - this.p1.size(); ++i) {
                this.p1.add(null);
            }
        }

        @Override
        public int size() {
            return this.p1.size();
        }

        @Override
        public T get_Item(int index) {
            return this.p1.get(index);
        }

        @Override
        public void copyTo(f1 array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.f1() > 1 || array.e2(0) != 0) {
                throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
            }
            com.aspose.slides.ms.System.f1.p1(com.aspose.slides.ms.System.f1.p1(this.p1.toArray()), 0, array, arrayIndex, this.p1.size());
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.size() != 0;
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                for (int i = 0; i < this.p1.size(); ++i) {
                    if (this.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.p1.size(); ++i) {
                if (!this.get(i).equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsItem(T item) {
            if (item == null) {
                for (int i = 0; i < this.p1.size(); ++i) {
                    if (this.p1.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.p1.size(); ++i) {
                if (!this.p1.get(i).equals(item)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object[] toArray() {
            return this.p1.toArray();
        }

        @Override
        public boolean add(T t) {
            ++this.e2;
            return this.p1.add(t);
        }

        @Override
        public boolean remove(Object o) {
            ++this.e2;
            return this.p1.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.p1.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            ++this.e2;
            return this.p1.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            ++this.e2;
            return this.p1.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            ++this.e2;
            return this.p1.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            ++this.e2;
            return this.p1.retainAll(c);
        }

        @Override
        public T get(int index) {
            return this.p1.get(index);
        }

        @Override
        public T set(int index, T element) {
            ++this.e2;
            return this.p1.set(index, element);
        }

        @Override
        public void add(int index, T element) {
            ++this.e2;
            this.p1.add(index, element);
        }

        @Override
        public T remove(int index) {
            ++this.e2;
            return this.p1.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.p1.indexOf(o);
        }

        @Override
        public ListIterator listIterator() {
            return this.p1.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.p1.listIterator(index);
        }

        @Override
        public java.util.List<T> subList(int fromIndex, int toIndex) {
            return this.p1.subList(fromIndex, toIndex);
        }

        @Override
        public void addItem(T item) {
            this.p1.add(item);
            ++this.e2;
        }

        @Override
        public void clear() {
            this.p1.clear();
            ++this.e2;
        }

        @Override
        public void insertItem(int index, T item) {
            this.p1.add(index, item);
            ++this.e2;
        }

        @Override
        public void insertRange(int index, IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            if (index < 0 || ((long)index & 0xFFFFFFFFL) > ((long)this.p1.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            int n = index;
            if (collection == this) {
                Object[] objectArray = new Object[this.size()];
                this.copyTo(objectArray);
                for (Object object : objectArray) {
                    this.p1.add(n++, object);
                }
            } else {
                for (Object e : collection) {
                    this.p1.add(n++, e);
                }
            }
            ++this.e2;
        }

        @Override
        public int removeAll(v4<T> match) {
            ListInternalized.e2(match);
            int n = 0;
            int n10 = 0;
            for (n = 0; n < this.p1.size() && !match.invoke(this.p1.get(n)); ++n) {
            }
            if (n == this.p1.size()) {
                return 0;
            }
            ++this.e2;
            for (n10 = n + 1; n10 < this.p1.size(); ++n10) {
                if (match.invoke(this.p1.get(n10))) continue;
                this.p1.set(n++, this.p1.get(n10));
            }
            if (n10 - n > 0) {
                for (int i = 0; i < n10 - n; ++i) {
                    this.p1.remove(this.p1.size() - 1);
                }
            }
            return n10 - n;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.p1.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.p1.remove(index);
            ++this.e2;
        }

        @Override
        public void removeRange(int index, int count) {
            this.p1(index, count);
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    this.p1.remove(index);
                }
                ++this.e2;
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.size());
        }

        @Override
        public void reverse(int index, int count) {
            this.p1(index, count);
            int n = index;
            for (int i = index + count - 1; n < i; ++n, --i) {
                T t = this.p1.get(n);
                this.p1.set(n, this.p1.get(i));
                this.p1.set(i, t);
            }
            ++this.e2;
        }

        @Override
        public void sort() {
            Collections.sort(this.p1, null);
            ++this.e2;
        }

        @Override
        public void sort(Comparator<? super T> comparer) {
            Collections.sort(this.p1, comparer);
            ++this.e2;
        }

        @Override
        public void sort(final x2<T> tComparison) {
            if (tComparison == null) {
                throw new ArgumentNullException("comparison");
            }
            Collections.sort(this.p1, new Comparator<T>(){

                @Override
                public int compare(T o12, T o22) {
                    return tComparison.p1(o12, o22);
                }
            });
            ++this.e2;
        }

        @Override
        public void sort(int index, int count, Comparator<T> comparer) {
            this.p1(index, count);
            java.util.List<T> list = this.p1.subList(index, count);
            Collections.sort(list, comparer);
            for (int i = 0; i < count; ++i) {
                this.p1.set(index + i, list.get(i));
            }
            ++this.e2;
        }

        @Override
        public void set_Item(int index, T value) {
            this.p1(index);
            if ((long)index == (long)this.p1.size()) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.p1.set(index, value);
            ++this.e2;
        }

        @Override
        private void p1(IGenericEnumerable<T> iGenericEnumerable) {
            for (Object t : iGenericEnumerable) {
                this.addItem(t);
            }
        }
    }

    @Deprecated
    @e0
    public static class EnumeratorJava<T>
    extends s1<EnumeratorJava<T>>
    implements IGenericEnumerator<T>,
    IDisposable {
        private List<T> e2 = new List();
        private int e9;
        private int f1;
        private T d7;

        public EnumeratorJava() {
        }

        EnumeratorJava(List<T> l) {
            this();
            this.e2 = l;
            this.f1 = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void p1() {
            if (this.f1 != this.e2.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public T next() {
            if (this.e9 < 0 || this.e9 >= this.e2.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            if (this.f1 != this.e2.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.d7 = this.e2.get_Item(this.e9++);
            return this.d7;
        }

        @Override
        public boolean hasNext() {
            if (this.f1 == this.e2.getVersion()) {
                if (this.e9 < 0) {
                    return false;
                }
                return this.e9 < this.e2.size();
            }
            throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
        }

        @Override
        public void reset() {
            this.p1();
            this.e9 = 0;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(EnumeratorJava<T> that) {
            that.e2 = this.e2;
            that.e9 = this.e9;
            that.f1 = this.f1;
            that.d7 = this.d7;
        }

        @Override
        public EnumeratorJava<T> Clone() {
            EnumeratorJava<T> enumeratorJava = new EnumeratorJava<T>();
            this.CloneTo(enumeratorJava);
            return enumeratorJava;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean p1(EnumeratorJava enumeratorJava) {
            return i2.p1(enumeratorJava.e2, this.e2) && enumeratorJava.e9 == this.e9 && enumeratorJava.f1 == this.f1 && i2.p1(enumeratorJava.d7, this.d7);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (i2.e2(null, obj)) {
                return false;
            }
            if (i2.e2(this, obj)) {
                return true;
            }
            if (!(obj instanceof EnumeratorJava)) {
                return false;
            }
            return this.p1((EnumeratorJava)obj);
        }

        public static boolean equals(EnumeratorJava obj1, EnumeratorJava obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.e2 != null ? this.e2.hashCode() : 0;
            n = 31 * n + this.e9;
            n = 31 * n + this.f1;
            n = 31 * n + (this.d7 != null ? this.d7.hashCode() : 0);
            return n;
        }
    }

    @e0
    public static class Enumerator<T>
    extends s1<Enumerator<T>>
    implements IGenericEnumerator<T>,
    IDisposable {
        private List<T> e2 = new List();
        private int e9;
        private int f1;
        private T d7;

        public Enumerator() {
        }

        Enumerator(List<T> l) {
            this();
            this.e2 = l;
            this.f1 = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void p1() {
            if (this.f1 != this.e2.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public boolean hasNext() {
            if (this.f1 == this.e2.getVersion()) {
                if (this.e9 < 0) {
                    return false;
                }
                if (this.e9 < this.e2.size()) {
                    this.d7 = this.e2.get_Item(this.e9++);
                    return true;
                }
            } else {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.e9 = this.e2.size() + 1;
            return false;
        }

        @Override
        public void reset() {
            this.p1();
            this.e9 = 0;
        }

        @Override
        public T next() {
            if (this.e9 < 0 || this.e9 >= this.e2.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            return this.d7;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator<T> that) {
            that.e2 = this.e2;
            that.e9 = this.e9;
            that.f1 = this.f1;
            that.d7 = this.d7;
        }

        @Override
        public Enumerator<T> Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean p1(Enumerator enumerator) {
            return i2.p1(enumerator.e2, this.e2) && enumerator.e9 == this.e9 && enumerator.f1 == this.f1 && i2.p1(enumerator.d7, this.d7);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (i2.e2(null, obj)) {
                return false;
            }
            if (i2.e2(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.p1((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.e2 != null ? this.e2.hashCode() : 0;
            n = 31 * n + this.e9;
            n = 31 * n + this.f1;
            n = 31 * n + (this.d7 != null ? this.d7.hashCode() : 0);
            return n;
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.p1 = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.p1 != 0;
        }

        @Override
        public int nextIndex() {
            return this.p1;
        }

        @Override
        public int previousIndex() {
            return this.p1 - 1;
        }

        public T previous() {
            int n = this.p1 - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.p1;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.p1 = n;
            this.e2 = n;
            return objectArray[this.e2];
        }

        public void set(T e) {
            if (this.e2 < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.set(this.e2, e);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(T e) {
            try {
                int n = this.p1;
                List.this.add(n, e);
                this.p1 = n + 1;
                this.e2 = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr<T>
    implements Iterator<T> {
        int p1;
        int e2 = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.p1 != List.this.e2;
        }

        @Override
        public T next() {
            int n = this.p1;
            if (n >= List.this.e2) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.p1;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.p1 = n + 1;
            this.e2 = n;
            return (T)objectArray[this.e2];
        }

        @Override
        public void remove() {
            if (this.e2 < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.remove(this.e2);
                this.p1 = this.e2;
                this.e2 = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

