/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericCollection;
import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.ArrayTypeMismatchException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.internal.x7s.e9;
import com.aspose.slides.internal.x7s.s1;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.e0;
import com.aspose.slides.ms.System.f1;
import com.aspose.slides.ms.System.i2;
import com.aspose.slides.ms.System.p8;
import java.util.Arrays;

@e0
public class Stack<T>
implements IGenericEnumerable<T>,
ICollection<T> {
    private Object[] p1;
    private int e2;
    private int e9;

    public Stack() {
    }

    public Stack(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.p1 = new Object[capacity];
    }

    public Stack(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (Object t : collection) {
            this.push(t);
        }
    }

    public Stack(IGenericCollection<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        if (collection != null) {
            this.e2 = collection.size();
            this.p1 = new Object[this.e2];
            collection.copyToTArray(this.p1, 0);
        }
    }

    public void clear() {
        if (this.p1 != null) {
            f1.p1(this.p1, 0, this.p1.length);
        }
        this.e2 = 0;
        ++this.e9;
    }

    public boolean contains(T item) {
        return this.p1 != null && f1.p1(this.p1, item, 0, this.e2) != -1;
    }

    public void copyToTArray(T[] array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (arrayIndex >= array.length) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (this.e2 - arrayIndex > array.length) {
            throw new ArgumentException("idx");
        }
        if (this.p1 != null) {
            f1.p1(this.p1, 0, array, arrayIndex, this.e2);
            p8.p1(array, arrayIndex, this.e2);
        }
    }

    public T peek() {
        if (this.e2 == 0) {
            throw new InvalidOperationException();
        }
        return (T)this.p1[this.e2 - 1];
    }

    public T pop() {
        if (this.e2 == 0) {
            throw new InvalidOperationException();
        }
        ++this.e9;
        Object object = this.p1[--this.e2];
        this.p1[this.e2] = null;
        return (T)object;
    }

    public void push(T item) {
        if (this.p1 == null || this.e2 == this.p1.length) {
            if (this.p1 == null) {
                this.p1 = new Object[16];
            }
            this.p1 = Arrays.copyOf(this.p1, this.e2 == 0 ? 16 : 2 * this.e2);
        }
        ++this.e9;
        this.p1[this.e2++] = item;
    }

    public <T> T[] toArray(T[] array) {
        if (array.length >= this.e2) {
            this.copyTo(f1.p1(array), 0);
            return array;
        }
        f1 f12 = f1.p1(com.aspose.slides.internal.x7s.e9.p1(array.getClass().getComponentType()), this.e2);
        this.copyTo(f12, 0);
        return (Object[])f1.p1(f12);
    }

    public void trimExcess() {
        if (this.p1 != null && (double)this.e2 < (double)this.p1.length * 0.9) {
            this.p1 = Arrays.copyOf(this.p1, this.e2);
        }
        ++this.e9;
    }

    @Override
    public int size() {
        return this.e2;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(f1 dest, int idx) {
        try {
            if (dest == null) {
                throw new ArgumentNullException();
            }
            if (this.p1 != null) {
                if (idx < 0) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (idx >= this.e2) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (this.e2 - idx > dest.d7()) {
                    throw new ArgumentException("idx");
                }
                f1.p1(f1.p1(this.p1), 0, dest, idx, this.e2);
                f1.e2(dest, idx, this.e2);
            }
        }
        catch (ArrayTypeMismatchException arrayTypeMismatchException) {
            throw new ArgumentException();
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    @e0
    public static class Enumerator<T>
    extends s1<Enumerator>
    implements IGenericEnumerator<T>,
    IDisposable {
        private Stack<T> e2;
        private int e9;
        private int f1;

        public Enumerator() {
        }

        Enumerator(Stack<T> t) {
            this.e2 = t;
            this.e9 = -2;
            this.f1 = ((Stack)t).e9;
        }

        @Override
        public void dispose() {
            this.e9 = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.f1 != ((Stack)this.e2).e9) {
                throw new IllegalStateException();
            }
            if (this.e9 == -2) {
                this.e9 = ((Stack)this.e2).e2;
            }
            return this.e9 != -1 && --this.e9 != -1;
        }

        @Override
        public T next() {
            if (this.e9 < 0) {
                throw new InvalidOperationException();
            }
            return (T)((Stack)this.e2).p1[this.e9];
        }

        @Override
        public void reset() {
            if (this.f1 != ((Stack)this.e2).e9) {
                throw new IllegalStateException();
            }
            this.e9 = -2;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator that) {
            that.e2 = this.e2;
            that.e9 = this.e9;
            that.f1 = this.f1;
        }

        @Override
        public Enumerator Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean p1(Enumerator enumerator) {
            return i2.p1(enumerator.e2, this.e2) && enumerator.e9 == this.e9 && enumerator.f1 == this.f1;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (i2.e2(null, obj)) {
                return false;
            }
            if (i2.e2(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.p1((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.e2 != null ? this.e2.hashCode() : 0;
            n = 31 * n + this.e9;
            n = 31 * n + this.f1;
            return n;
        }
    }
}

