/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.Generic.IGenericEqualityComparer;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IHashCodeProvider;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.exceptions.SerializationException;
import com.aspose.slides.internal.i5n.a5;
import com.aspose.slides.internal.i5n.d2;
import com.aspose.slides.internal.i5n.q9;
import com.aspose.slides.internal.i5n.s1;
import com.aspose.slides.internal.i5n.u7;
import com.aspose.slides.internal.r6c.p2;
import com.aspose.slides.internal.r8r.e2;
import com.aspose.slides.internal.r8r.p1;
import com.aspose.slides.internal.x7s.e9;
import com.aspose.slides.internal.x7s.m6;
import com.aspose.slides.ms.System.e0;
import com.aspose.slides.ms.System.f1;
import com.aspose.slides.ms.System.i2;
import com.aspose.slides.ms.System.n1;
import com.aspose.slides.ms.System.o3;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@e0
public class Hashtable
implements ICollection,
IDictionary,
IEnumerable,
d2,
s1,
o3,
Map {
    private IGenericEqualityComparer p1;
    private final Object e2 = new Object();
    private Bucket[] e9;
    private int f1;
    private volatile boolean d7;
    private ICollection m6;
    private float s1;
    private int v3;
    private u7 p2;
    private int d2;
    private ICollection x6;
    private volatile int y6;
    private static final m6 g6 = new m6("LoadFactor", "HashSize", "KeyComparer", "Comparer", "HashCodeProvider", "Keys", "Values");

    public Hashtable() {
        this(0, 1.0f);
    }

    Hashtable(boolean trash) {
    }

    public Hashtable(IDictionary d) {
        this(d, 1.0f);
    }

    public Hashtable(IGenericEqualityComparer equalityComparer) {
        this(0, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity) {
        this(capacity, 1.0f);
    }

    public Hashtable(IDictionary d, IGenericEqualityComparer equalityComparer) {
        this(d, 1.0f, equalityComparer);
    }

    public Hashtable(IDictionary d, float loadFactor) {
        this(d, loadFactor, (IGenericEqualityComparer)null);
    }

    @Deprecated
    public Hashtable(IHashCodeProvider hcp, Comparator comparer) {
        this(0, 1.0f, hcp, comparer);
    }

    public Hashtable(int capacity, IGenericEqualityComparer equalityComparer) {
        this(capacity, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity, float loadFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Non-negative number required");
        }
        if (loadFactor < 0.1f || loadFactor > 1.0f || Float.isNaN(loadFactor)) {
            throw new ArgumentOutOfRangeException("loadFactor", n1.p1("Load factor needs to be between {0} and {1}", 0.1, 1.0));
        }
        this.s1 = 0.72f * loadFactor;
        double d = (float)capacity / this.s1;
        if (d > 2.147483647E9) {
            throw new ArgumentException("Hashtable's capacity overflowed and went negative. Check load factor, capacity and the current size of the table");
        }
        int n = d > 11.0 ? com.aspose.slides.internal.r8r.p1.p1((int)d) : 11;
        this.e9 = this.e2(n);
        this.v3 = (int)(this.s1 * (float)n);
        this.d7 = false;
    }

    protected Hashtable(u7 info, a5 context) {
        this.p2 = info;
    }

    @Deprecated
    public Hashtable(IDictionary d, IHashCodeProvider hcp, Comparator comparer) {
        this(d, 1.0f, hcp, comparer);
    }

    public Hashtable(IDictionary d, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(d != null ? d.size() : 0, loadFactor, equalityComparer);
        if (d == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, IHashCodeProvider hcp, Comparator comparer) {
        this(capacity, 1.0f, hcp, comparer);
    }

    public Hashtable(int capacity, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(capacity, loadFactor);
        this.p1 = equalityComparer;
    }

    @Deprecated
    public Hashtable(IDictionary d, float loadFactor, IHashCodeProvider hcp, Comparator comparer) {
        this(d != null ? d.size() : 0, loadFactor, hcp, comparer);
        if (d == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, float loadFactor, IHashCodeProvider hcp, Comparator comparer) {
        this(capacity, loadFactor);
        this.p1 = hcp == null && comparer == null ? null : new CompatibleComparer(comparer, hcp);
    }

    @Override
    public void addItem(Object key, Object value) {
        this.p1(key, value, true);
    }

    @Override
    public void clear() {
        if (this.f1 != 0) {
            this.d7 = true;
            for (int i = 0; i < this.e9.length; ++i) {
                this.e9[i].e9 = 0;
                this.e9[i].p1 = null;
                this.e9[i].e2 = null;
            }
            this.f1 = 0;
            this.d2 = 0;
            this.f1();
            this.d7 = false;
        }
    }

    @Override
    public Object deepClone() {
        Bucket[] bucketArray = this.e9;
        Hashtable hashtable = new Hashtable(this.f1, this.p1);
        hashtable.y6 = this.y6;
        hashtable.s1 = this.s1;
        hashtable.f1 = 0;
        int n = this.e9.length;
        while (n > 0) {
            Object object = bucketArray[--n].p1;
            if (object == null || object == bucketArray) continue;
            hashtable.set_Item(object, bucketArray[n].e2);
        }
        return hashtable;
    }

    @Override
    public boolean contains(Object key) {
        return this.containsKey(key);
    }

    @Override
    public boolean containsKey(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.e9;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.p1(key, this.e9.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.e9.length);
        do {
            bucketArray[n10].p1(bucket);
            if (bucket.p1 == null) {
                return false;
            }
            if ((long)(bucket.e9 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.p1, key)) {
                return true;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.e9.length);
        } while (bucket.e9 < 0 && ++n < this.e9.length);
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            int n = this.e9.length;
            while (--n >= 0) {
                if (this.e9[n].p1 == null || this.e9[n].p1 == this.e9 || this.e9[n].e2 != null) continue;
                return true;
            }
        } else {
            int n = this.e9.length;
            while (--n >= 0) {
                Object object = this.e9[n].e2;
                if (object == null || !object.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    private void e9(f1 f12, int n) {
        Bucket[] bucketArray = this.e9;
        int n10 = this.e9.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].p1;
            if (object == null || object == this.e9) continue;
            DictionaryEntry dictionaryEntry = new DictionaryEntry(object, bucketArray[n10].e2);
            f12.e9(dictionaryEntry.Clone(), n++);
        }
    }

    void p1(f1 f12, int n) {
        Bucket[] bucketArray = this.e9;
        int n10 = this.e9.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].p1;
            if (object == null || object == this.e9) continue;
            f12.e9(object, n++);
        }
    }

    @Override
    public void copyTo(f1 array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array", "Array cannot be null");
        }
        if (array.f1() != 1) {
            throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
        }
        if (array.d7() - arrayIndex < this.f1) {
            throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
        }
        this.e9(array, arrayIndex);
    }

    void e2(f1 f12, int n) {
        Bucket[] bucketArray = this.e9;
        int n10 = this.e9.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].p1;
            if (object == null || object == this.e9) continue;
            f12.e9(bucketArray[n10].e2, n++);
        }
    }

    private void e2() {
        int n = com.aspose.slides.internal.r8r.p1.p1(this.e9.length * 2);
        this.p1(n);
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new HashtableEnumerator(this, 3);
    }

    protected int getHash(Object key) {
        if (this.p1 != null) {
            return this.p1.hashCode(key);
        }
        return key.hashCode();
    }

    @Override
    public void getObjectData(u7 info, a5 context) {
        Object[] objectArray;
        if (info == null) {
            throw new ArgumentNullException("info");
        }
        info.p1("LoadFactor", this.s1);
        info.p1("Version", this.y6);
        if (this.p1 == null) {
            info.p1("Comparer", null, com.aspose.slides.internal.x7s.e9.p1(Comparator.class));
            info.p1("HashCodeProvider", null, com.aspose.slides.internal.x7s.e9.p1(IHashCodeProvider.class));
        } else if (this.p1 instanceof CompatibleComparer) {
            objectArray = (Object[])com.aspose.slides.internal.x7s.e9.p1(this.p1, CompatibleComparer.class);
            info.p1("Comparer", objectArray.p1(), com.aspose.slides.internal.x7s.e9.p1(Comparator.class));
            info.p1("HashCodeProvider", objectArray.e2(), com.aspose.slides.internal.x7s.e9.p1(IHashCodeProvider.class));
        } else {
            info.p1("KeyComparer", this.p1, com.aspose.slides.internal.x7s.e9.p1(IGenericEqualityComparer.class));
        }
        info.p1("HashSize", this.e9.length);
        objectArray = new Object[this.f1];
        Object[] objectArray2 = new Object[this.f1];
        this.p1(com.aspose.slides.ms.System.f1.p1(objectArray), 0);
        this.e2(com.aspose.slides.ms.System.f1.p1(objectArray2), 0);
        info.p1("Keys", objectArray, com.aspose.slides.internal.x7s.e9.p1(Object[].class));
        info.p1("Values", objectArray2, com.aspose.slides.internal.x7s.e9.p1(Object[].class));
    }

    private long p1(Object object, int n, long[] lArray, long[] lArray2) {
        long l;
        lArray[0] = l = (long)(this.getHash(object) & Integer.MAX_VALUE);
        lArray2[0] = 1L + (((lArray[0] & 0xFFFFFFFFL) >> 5) + 1L) % (long)(n - 1);
        return l;
    }

    private void p1(Object object, Object object2, boolean bl) {
        block12: {
            long l = 0L;
            long l10 = 0L;
            if (object == null) {
                throw new ArgumentNullException("key", "Key cannot be null");
            }
            if (this.f1 >= this.v3) {
                this.e2();
            } else if (this.d2 > this.v3 && this.f1 > 100) {
                this.e9();
            }
            long[] lArray = new long[]{0L};
            long[] lArray2 = new long[]{0L};
            long l11 = this.p1(object, this.e9.length, lArray, lArray2);
            l = lArray[0];
            l10 = lArray2[0];
            int n = 0;
            int n10 = -1;
            int n11 = (int)((l & 0xFFFFFFFFL) % (long)this.e9.length);
            do {
                if (n10 == -1 && this.e9[n11].p1 == this.e9 && this.e9[n11].e9 < 0) {
                    n10 = n11;
                }
                if (this.e9[n11].p1 == null || this.e9[n11].p1 == this.e9 && ((long)this.e9[n11].e9 & 0x80000000L) == 0L) {
                    if (n10 != -1) {
                        n11 = n10;
                    }
                    this.d7 = true;
                    this.e9[n11].e2 = object2;
                    this.e9[n11].p1 = object;
                    this.e9[n11].e9 |= (int)(l11 & 0xFFFFFFFFL);
                    ++this.f1;
                    this.f1();
                    this.d7 = false;
                    break block12;
                }
                if ((long)(this.e9[n11].e9 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(this.e9[n11].p1, object)) {
                    if (bl) {
                        throw new ArgumentException(n1.p1("Item has already been added. Key in dictionary: '{0}'  Key being added: '{1}'", this.e9[n11].p1, object));
                    }
                    this.d7 = true;
                    this.e9[n11].e2 = object2;
                    this.f1();
                    this.d7 = false;
                    break block12;
                }
                if (n10 == -1 && this.e9[n11].e9 >= 0) {
                    this.e9[n11].e9 = (int)((long)this.e9[n11].e9 | Integer.MIN_VALUE);
                    ++this.d2;
                }
                n11 = (int)(((long)n11 + (l10 & 0xFFFFFFFFL)) % (long)this.e9.length);
            } while (++n < this.e9.length);
            if (n10 == -1) {
                throw new InvalidOperationException("Hashtable insert failed. Load factor too high.");
            }
            this.d7 = true;
            this.e9[n10].e2 = object2;
            this.e9[n10].p1 = object;
            this.e9[n10].e9 |= (int)(l11 & 0xFFFFFFFFL);
            ++this.f1;
            this.f1();
            this.d7 = false;
        }
    }

    protected boolean keyEquals(Object item, Object key) {
        if (i2.e2(this.e9, item)) {
            return false;
        }
        if (this.p1 != null) {
            return this.p1.equals(item, key);
        }
        return item != null && item.equals(key);
    }

    @Override
    public void onDeserialization(Object sender) {
        if (this.e9 == null) {
            if (this.p2 == null) {
                throw new SerializationException("OnDeserialization method was called while the object was not being deserialized.");
            }
            int n = 0;
            Comparator comparator = null;
            IHashCodeProvider iHashCodeProvider = null;
            Object[] objectArray = null;
            Object[] objectArray2 = null;
            q9 q92 = this.p2.f1();
            while (q92.hasNext()) {
                switch (g6.p1(q92.e2())) {
                    case 0: {
                        this.s1 = this.p2.e2("LoadFactor");
                        break;
                    }
                    case 1: {
                        n = this.p2.p1("HashSize");
                        break;
                    }
                    case 2: {
                        this.p1 = (IGenericEqualityComparer)this.p2.p1("KeyComparer", com.aspose.slides.internal.x7s.e9.p1(IGenericEqualityComparer.class));
                        break;
                    }
                    case 3: {
                        comparator = (Comparator)this.p2.p1("Comparer", com.aspose.slides.internal.x7s.e9.p1(Comparator.class));
                        break;
                    }
                    case 4: {
                        iHashCodeProvider = (IHashCodeProvider)this.p2.p1("HashCodeProvider", com.aspose.slides.internal.x7s.e9.p1(IHashCodeProvider.class));
                        break;
                    }
                    case 5: {
                        objectArray = (Object[])this.p2.p1("Keys", com.aspose.slides.internal.x7s.e9.p1(Object[].class));
                        break;
                    }
                    case 6: {
                        objectArray2 = (Object[])this.p2.p1("Values", com.aspose.slides.internal.x7s.e9.p1(Object[].class));
                    }
                }
            }
            this.v3 = (int)(this.s1 * (float)n);
            if (this.p1 == null && (comparator != null || iHashCodeProvider != null)) {
                this.p1 = new CompatibleComparer(comparator, iHashCodeProvider);
            }
            this.e9 = this.e2(n);
            if (objectArray == null) {
                throw new SerializationException("The Keys for this dictionary are missing");
            }
            if (objectArray2 == null) {
                throw new SerializationException("The Values for this dictionary are missing");
            }
            if (objectArray.length != objectArray2.length) {
                throw new SerializationException("The keys and values arrays have different sizes");
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    throw new SerializationException("One of the serialized keys is null");
                }
                this.p1(objectArray[i], objectArray2[i], true);
            }
            this.y6 = this.p2.p1("Version");
            this.p2 = null;
        }
    }

    private void p1(Bucket[] bucketArray, Object object, Object object2, int n) {
        long l = 1L + ((((long)n & 0xFFFFFFFFL) >> 5) + 1L) % (long)(bucketArray.length - 1);
        int n10 = (int)(((long)n & 0xFFFFFFFFL) % (long)bucketArray.length);
        while (true) {
            if (bucketArray[n10].p1 == null || bucketArray[n10].p1 == this.e9) {
                bucketArray[n10].e2 = object2;
                bucketArray[n10].p1 = object;
                bucketArray[n10].e9 |= n;
                break;
            }
            if (bucketArray[n10].e9 >= 0) {
                bucketArray[n10].e9 = (int)((long)bucketArray[n10].e9 | Integer.MIN_VALUE);
                ++this.d2;
            }
            n10 = (int)(((long)n10 + (l & 0xFFFFFFFFL)) % (long)bucketArray.length);
        }
    }

    private void e9() {
        this.p1(this.e9.length);
    }

    private void p1(int n) {
        this.d2 = 0;
        Bucket[] bucketArray = this.e2(n);
        for (int i = 0; i < this.e9.length; ++i) {
            Bucket bucket = this.e9[i].p1();
            if (bucket.p1 == null || bucket.p1 == this.e9) continue;
            this.p1(bucketArray, bucket.p1, bucket.e2, bucket.e9 & Integer.MAX_VALUE);
        }
        this.d7 = true;
        this.e9 = bucketArray;
        this.v3 = (int)(this.s1 * (float)n);
        this.f1();
        this.d7 = false;
    }

    @Override
    public void removeItem(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.p1(key, this.e9.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.e9.length);
        do {
            this.e9[n10].p1(bucket);
            if ((long)(bucket.e9 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.p1, key)) {
                this.d7 = true;
                this.e9[n10].e9 = (int)((long)this.e9[n10].e9 & Integer.MIN_VALUE);
                this.e9[n10].p1 = this.e9[n10].e9 != 0 ? this.e9 : null;
                this.e9[n10].e2 = null;
                --this.f1;
                this.f1();
                this.d7 = false;
                break;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.e9.length);
        } while (bucket.e9 < 0 && ++n < this.e9.length);
    }

    public static Hashtable sync(Hashtable table) {
        if (table == null) {
            throw new ArgumentNullException("table");
        }
        return new SyncHashtable(table);
    }

    KeyValuePairs[] p1() {
        KeyValuePairs[] keyValuePairsArray = new KeyValuePairs[this.f1];
        int n = 0;
        Bucket[] bucketArray = this.e9;
        int n10 = this.e9.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].p1;
            if (object == null || object == this.e9) continue;
            keyValuePairsArray[n++] = new KeyValuePairs(object, bucketArray[n10].e2);
        }
        return keyValuePairsArray;
    }

    private void f1() {
        ++this.y6;
    }

    private Bucket[] e2(int n) {
        Bucket[] bucketArray = new Bucket[n];
        for (int i = 0; i < bucketArray.length; ++i) {
            bucketArray[i] = new Bucket();
        }
        return bucketArray;
    }

    @Override
    public int size() {
        return this.f1;
    }

    protected IGenericEqualityComparer getEqualityComparer() {
        return this.p1;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object get_Item(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.e9;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.p1(key, this.e9.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.e9.length);
        do {
            int n11;
            int n12 = 0;
            do {
                n11 = this.y6;
                bucketArray[n10].p1(bucket);
                if (++n12 % 8 != 0) continue;
                com.aspose.slides.internal.r6c.p2.e2(1);
            } while (this.d7 || n11 != this.y6);
            if (bucket.p1 == null) break;
            if ((long)(bucket.e9 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.p1, key)) {
                return bucket.e2;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.e9.length);
        } while (bucket.e9 < 0 && ++n < this.e9.length);
        return null;
    }

    @Override
    public void set_Item(Object key, Object value) {
        this.p1(key, value, false);
    }

    @Override
    public ICollection getKeys() {
        if (this.m6 == null) {
            this.m6 = new KeyCollection(this);
        }
        return this.m6;
    }

    @Override
    public Object getSyncRoot() {
        return this.e2;
    }

    @Override
    public ICollection getValues() {
        if (this.x6 == null) {
            this.x6 = new ValueCollection(this);
        }
        return this.x6;
    }

    @Override
    public boolean isEmpty() {
        return this.f1 == 0;
    }

    public Object get(Object key) {
        return this.get_Item(key);
    }

    public Object put(Object key, Object value) {
        Object object = this.get_Item(key);
        this.set_Item(key, value);
        return object;
    }

    public Object remove(Object key) {
        Object object = this.get_Item(key);
        this.removeItem(key);
        return object;
    }

    public void putAll(Map m) {
        Set set = m.keySet();
        for (Object k : set) {
            Object v = m.get(k);
            this.put(k, v);
        }
    }

    public Set keySet() {
        Object[] objectArray = new Object[this.size()];
        f1 f12 = com.aspose.slides.ms.System.f1.p1(objectArray);
        this.getKeys().copyTo(f12, 0);
        return new ReadOnlyItemCollection(f12);
    }

    public Collection values() {
        Object[] objectArray = new Object[this.size()];
        f1 f12 = com.aspose.slides.ms.System.f1.p1(objectArray);
        this.getValues().copyTo(f12, 0);
        return new ReadOnlyItemCollection(f12);
    }

    public Set entrySet() {
        KeyValuePairs[] keyValuePairsArray = this.p1();
        Map.Entry[] entryArray = new Map.Entry[keyValuePairsArray.length];
        for (int i = 0; i < entryArray.length; ++i) {
            entryArray[i] = new AbstractMap.SimpleEntry<Object, Object>(keyValuePairsArray[i].p1(), keyValuePairsArray[i].e2());
        }
        return new ReadOnlyItemCollection(com.aspose.slides.ms.System.f1.p1(entryArray));
    }

    public int getVersion() {
        return this.y6;
    }

    public static Hashtable fromJava(Map map) {
        if (map == null) {
            return null;
        }
        return new e2(map);
    }

    public static Map toJava(Hashtable h) {
        return h;
    }

    private class ReadOnlyItemCollection
    implements Set {
        private f1 e2;

        ReadOnlyItemCollection(f1 items) {
            this.e2 = items;
        }

        @Override
        public int size() {
            return this.e2.size();
        }

        @Override
        public boolean isEmpty() {
            return this.e2.size() == 0;
        }

        @Override
        public boolean contains(Object o) {
            return this.e2.contains(o);
        }

        @Override
        public Iterator iterator() {
            return this.e2.iterator();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            f1 f12 = com.aspose.slides.ms.System.f1.p1(objectArray);
            this.e2.copyTo(f12, 0);
            return objectArray;
        }

        @Override
        public boolean add(Object o) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean remove(Object o) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean containsAll(Collection c) {
            for (Object e : c) {
                if (this.contains(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public Object[] toArray(Object[] a) {
            if (a.length <= this.size()) {
                a = new Object[this.size()];
            }
            this.e2.copyTo(com.aspose.slides.ms.System.f1.p1(a), 0);
            return a;
        }
    }

    private static class HashtableDebugView {
    }

    @e0
    private static class SyncHashtable
    extends Hashtable {
        protected Hashtable p1;

        SyncHashtable(Hashtable table) {
            super(false);
            this.p1 = table;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key, Object value) {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                this.p1.addItem(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                this.p1.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                return Hashtable.sync((Hashtable)this.p1.deepClone());
            }
        }

        @Override
        public boolean contains(Object key) {
            return this.p1.contains(key);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.p1.containsKey(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object key) {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                return this.p1.containsValue(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(f1 array, int arrayIndex) {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                this.p1.copyTo(array, arrayIndex);
            }
        }

        @Override
        public IDictionaryEnumerator iterator() {
            return this.p1.iterator();
        }

        @Override
        public void getObjectData(u7 info, a5 context) {
            if (info == null) {
                throw new ArgumentNullException("info");
            }
            info.p1("ParentTable", this.p1, com.aspose.slides.internal.x7s.e9.p1(Hashtable.class));
        }

        @Override
        public void onDeserialization(Object sender) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key) {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                this.p1.removeItem(key);
            }
        }

        @Override
        KeyValuePairs[] p1() {
            return this.p1.p1();
        }

        @Override
        public int size() {
            return this.p1.size();
        }

        @Override
        public boolean isFixedSize() {
            return this.p1.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.p1.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object get_Item(Object key) {
            return this.p1.get_Item(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key, Object value) {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                this.p1.set_Item(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                return this.p1.getKeys();
            }
        }

        @Override
        public Object getSyncRoot() {
            return this.p1.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                return this.p1.getValues();
            }
        }
    }

    @e0
    private static class ValueCollection
    implements ICollection,
    IEnumerable {
        private Hashtable p1;

        ValueCollection(Hashtable hashtable) {
            this.p1 = hashtable;
        }

        @Override
        public void copyTo(f1 array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.f1() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.d7() - arrayIndex < this.p1.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.p1.e2(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.p1, 2);
        }

        @Override
        public int size() {
            return this.p1.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.p1.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.p1.getSyncRoot();
        }
    }

    @e0
    private static class KeyCollection
    implements ICollection,
    IEnumerable {
        private Hashtable p1;

        KeyCollection(Hashtable hashtable) {
            this.p1 = hashtable;
        }

        @Override
        public void copyTo(f1 array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.f1() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.d7() - arrayIndex < this.p1.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.p1.p1(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.p1, 1);
        }

        @Override
        public int size() {
            return this.p1.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.p1.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.p1.getSyncRoot();
        }
    }

    @e0
    private static class HashtableEnumerator
    implements IDictionaryEnumerator,
    IEnumerator {
        private int p1;
        private boolean e2;
        private Object e9;
        private Object f1;
        private int d7;
        private Hashtable m6;
        private int s1;

        HashtableEnumerator(Hashtable hashtable, int getObjRetType) {
            this.m6 = hashtable;
            this.p1 = hashtable.e9.length;
            this.s1 = hashtable.y6;
            this.e2 = false;
            this.d7 = getObjRetType;
        }

        @Override
        public boolean hasNext() {
            if (this.s1 != this.m6.y6) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            while (this.p1 > 0) {
                --this.p1;
                Object object = ((Hashtable)this.m6).e9[this.p1].p1;
                if (object == null || object == this.m6.e9) continue;
                this.e9 = object;
                this.f1 = ((Hashtable)this.m6).e9[this.p1].e2;
                this.e2 = true;
                return true;
            }
            this.e2 = false;
            return false;
        }

        @Override
        public void reset() {
            if (this.s1 != this.m6.y6) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            this.e2 = false;
            this.p1 = this.m6.e9.length;
            this.e9 = null;
            this.f1 = null;
        }

        @Override
        public Object next() {
            if (!this.e2) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            if (this.d7 == 1) {
                return this.e9;
            }
            if (this.d7 == 2) {
                return this.f1;
            }
            return new DictionaryEntry(this.e9, this.f1);
        }

        @Override
        public DictionaryEntry getEntry() {
            if (!this.e2) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return new DictionaryEntry(this.e9, this.f1);
        }

        @Override
        public Object getKey() {
            if (!this.e2) {
                throw new InvalidOperationException("Enumeration has not started. Call HasNext");
            }
            return this.e9;
        }

        @Override
        public Object getValue() {
            if (!this.e2) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return this.f1;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static class KeyValuePairs {
        private Object p1;
        private Object e2;

        public KeyValuePairs(Object key, Object value) {
            this.e2 = value;
            this.p1 = key;
        }

        public Object p1() {
            return this.p1;
        }

        public Object e2() {
            return this.e2;
        }
    }

    private static class Bucket
    extends com.aspose.slides.internal.x7s.s1<Bucket> {
        public Object p1;
        public Object e2;
        public int e9;

        public void p1(Bucket bucket) {
            bucket.p1 = this.p1;
            bucket.e2 = this.e2;
            bucket.e9 = this.e9;
        }

        public Bucket p1() {
            Bucket bucket = new Bucket();
            this.p1(bucket);
            return bucket;
        }

        public Object clone() {
            return this.p1();
        }

        private boolean e2(Bucket bucket) {
            return i2.p1(bucket.p1, this.p1) && i2.p1(bucket.e2, this.e2) && bucket.e9 == this.e9;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (i2.e2(null, obj)) {
                return false;
            }
            if (i2.e2(this, obj)) {
                return true;
            }
            if (!(obj instanceof Bucket)) {
                return false;
            }
            return this.e2((Bucket)obj);
        }

        public int hashCode() {
            int n = this.p1 != null ? this.p1.hashCode() : 0;
            n = 31 * n + (this.e2 != null ? this.e2.hashCode() : 0);
            n = 31 * n + this.e9;
            return n;
        }

        @Override
        public /* synthetic */ Object Clone() {
            return this.p1();
        }

        @Override
        public /* synthetic */ void CloneTo(Object object) {
            this.p1((Bucket)object);
        }
    }

    @e0
    private static class CompatibleComparer
    implements IGenericEqualityComparer {
        private Comparator p1;
        private IHashCodeProvider e2;

        CompatibleComparer(Comparator comparer, IHashCodeProvider hashCodeProvider) {
            this.p1 = comparer;
            this.e2 = hashCodeProvider;
        }

        public int p1(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (this.p1 != null) {
                return this.p1.compare(object, object2);
            }
            Comparable comparable = (Comparable)((Object)com.aspose.slides.internal.x7s.e9.p1(object, Comparable.class));
            if (comparable == null) {
                throw new ArgumentException("At least one object must implement java.lang.Comparable");
            }
            return comparable.compareTo(object2);
        }

        @Override
        public boolean equals(Object x, Object y) {
            return this.equalsT(x, y);
        }

        @Override
        public int hashCode(Object obj) {
            return this.hashCodeT(obj);
        }

        public boolean equalsT(Object a, Object b) {
            return this.p1(a, b) == 0;
        }

        public int hashCodeT(Object obj) {
            if (obj == null) {
                throw new ArgumentNullException("obj");
            }
            if (this.e2 != null) {
                return this.e2.hashCode(obj);
            }
            return obj.hashCode();
        }

        Comparator p1() {
            return this.p1;
        }

        IHashCodeProvider e2() {
            return this.e2;
        }
    }
}

