/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.ObjectModel;

import com.aspose.slides.Collections.Generic.Dictionary;
import com.aspose.slides.Collections.Generic.EqualityComparer;
import com.aspose.slides.Collections.Generic.IGenericDictionary;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.IGenericEqualityComparer;
import com.aspose.slides.Collections.ObjectModel.Collection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.KeyNotFoundException;
import com.aspose.slides.ms.System.e0;

@e0
public abstract class KeyedCollection<TKey, TItem>
extends Collection<TItem> {
    private Dictionary<TKey, TItem> p1;
    private IGenericEqualityComparer<TKey> e2;
    private int e9;

    protected KeyedCollection() {
        this(null, 0);
    }

    protected KeyedCollection(IGenericEqualityComparer<TKey> comparer) {
        this(comparer, 0);
    }

    protected KeyedCollection(IGenericEqualityComparer<TKey> comparer, int dictionaryCreationThreshold) {
        this.e2 = comparer != null ? comparer : new EqualityComparer.DefaultComparer<TKey>();
        this.e9 = dictionaryCreationThreshold;
        if (dictionaryCreationThreshold == 0) {
            this.p1 = new Dictionary(this.e2);
        }
    }

    public boolean containsKey(TKey key) {
        if (this.p1 != null) {
            return this.p1.containsKey(key);
        }
        return this.p1(key) >= 0;
    }

    private int p1(TKey TKey) {
        for (int i = this.size() - 1; i >= 0; --i) {
            TKey TKey2 = this.getKeyForItem(super.get_Item(i));
            if (!this.e2.equalsT(TKey, TKey2)) continue;
            return i;
        }
        return -1;
    }

    public boolean removeByKey(TKey key) {
        Object object = null;
        if (this.p1 != null) {
            Object[] objectArray = new Object[]{object};
            boolean bl = this.p1.tryGetValue(key, objectArray);
            object = objectArray[0];
            if (bl) {
                return super.removeItem(object);
            }
            return false;
        }
        int n = this.p1(key);
        if (n == -1) {
            return false;
        }
        this.removeAt(n);
        return true;
    }

    public IGenericEqualityComparer<TKey> getComparer() {
        return this.e2;
    }

    @Override
    public TItem get_Item(int index) {
        if (this.p1 != null && ((Dictionary.KeyCollection)this.p1.getKeys()).size() > 0) {
            IGenericEnumerator iGenericEnumerator = ((Dictionary.KeyCollection)this.p1.getKeys()).iterator();
            if (iGenericEnumerator.hasNext() && iGenericEnumerator.next() instanceof Integer) {
                return this.get_Item((TKey)index);
            }
            return (TItem)super.get_Item(index);
        }
        return (TItem)super.get_Item(index);
    }

    public TItem get_Item(TKey key) {
        if (this.p1 != null) {
            return this.p1.get_Item(key);
        }
        int n = this.p1(key);
        if (n >= 0) {
            return (TItem)super.get_Item(n);
        }
        throw new KeyNotFoundException();
    }

    protected void changeItemKey(TItem item, TKey newKey) {
        if (!this.containsItem(item)) {
            throw new ArgumentException();
        }
        TKey TKey = this.getKeyForItem(item);
        if (this.e2.equalsT(TKey, newKey)) {
            return;
        }
        if (this.containsKey(newKey)) {
            throw new ArgumentException();
        }
        if (this.p1 != null) {
            if (!this.p1.removeItemByKey(TKey)) {
                throw new ArgumentException();
            }
            this.p1.addItem(newKey, item);
        }
    }

    @Override
    public void clear() {
        if (this.p1 != null) {
            this.p1.clear();
        }
        super.clear();
    }

    protected abstract TKey getKeyForItem(TItem var1);

    @Override
    public void insertItem(int index, TItem item) {
        int n;
        TKey TKey = this.getKeyForItem(item);
        if (TKey == null) {
            throw new ArgumentNullException("GetKeyForItem(item)");
        }
        if (this.p1 != null && this.p1.containsKey(TKey)) {
            throw new ArgumentException("An element with the same key already exists in the dictionary.");
        }
        if (this.p1 == null) {
            for (n = 0; n < this.size(); ++n) {
                if (!this.e2.equalsT(TKey, this.getKeyForItem(super.get_Item(n)))) continue;
                throw new ArgumentException("An element with the same key already exists in the dictionary.");
            }
        }
        super.insertItem(index, item);
        if (this.p1 != null) {
            this.p1.addItem(TKey, item);
        } else if (this.e9 != -1 && this.size() > this.e9) {
            this.p1 = new Dictionary(this.e2);
            for (n = 0; n < this.size(); ++n) {
                Object t = super.get_Item(n);
                this.p1.addItem(this.getKeyForItem(t), t);
            }
        }
    }

    @Override
    public void removeAt(int index) {
        if (this.p1 != null) {
            TKey TKey = this.getKeyForItem(super.get_Item(index));
            this.p1.removeItemByKey(TKey);
        }
        super.removeAt(index);
    }

    @Override
    public void setItem(int index, TItem item) {
        if (this.p1 != null) {
            this.p1.removeItemByKey(this.getKeyForItem(super.get_Item(index)));
            this.p1.addItem(this.getKeyForItem(item), item);
        }
        super.setItem(index, item);
    }

    protected IGenericDictionary<TKey, TItem> getDictionary() {
        return this.p1;
    }
}

