/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.e0;
import com.aspose.slides.ms.System.f1;
import com.aspose.slides.ms.System.o3;
import java.util.Arrays;

@e0
public class Queue
implements ICollection,
IEnumerable,
o3 {
    private Object[] p1;
    private int e2 = 0;
    private int e9 = 0;
    private int f1 = 0;
    private int d7;
    private int m6 = 0;

    public Queue() {
        this(32, 2.0f);
    }

    public Queue(int capacity) {
        this(capacity, 2.0f);
    }

    public Queue(ICollection col) {
        this(col == null ? 32 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e : col) {
            this.enqueue(e);
        }
    }

    public Queue(int capacity, float growFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Needs a non-negative number");
        }
        if (!(growFactor >= 1.0f) || !(growFactor <= 10.0f)) {
            throw new ArgumentOutOfRangeException("growFactor", "Queue growth factor must be between 1.0 and 10.0, inclusive");
        }
        this.p1 = new Object[capacity];
        this.d7 = (int)(growFactor * 100.0f);
    }

    @Override
    public int size() {
        return this.e9;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(f1 array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.f1() > 1 || index != 0 && index >= array.d7() || this.e9 > array.d7() - index) {
            throw new ArgumentException();
        }
        int n = this.p1.length;
        int n10 = n - this.e2;
        com.aspose.slides.ms.System.f1.p1(com.aspose.slides.ms.System.f1.p1(this.p1), this.e2, array, index, Math.min(this.e9, n10));
        if (this.e9 > n10) {
            com.aspose.slides.ms.System.f1.p1(com.aspose.slides.ms.System.f1.p1(this.p1), 0, array, index + n10, this.e9 - n10);
        }
    }

    public IEnumerator iterator() {
        return new QueueEnumerator(this);
    }

    @Override
    public Object deepClone() {
        Queue queue = new Queue(this.p1.length);
        queue.d7 = this.d7;
        com.aspose.slides.ms.System.f1.p1(this.p1, 0, queue.p1, 0, this.p1.length);
        queue.e2 = this.e2;
        queue.e9 = this.e9;
        queue.f1 = this.f1;
        return queue;
    }

    public void clear() {
        ++this.m6;
        this.e2 = 0;
        this.e9 = 0;
        this.f1 = 0;
        for (int i = this.p1.length - 1; i >= 0; --i) {
            this.p1[i] = null;
        }
    }

    public boolean contains(Object obj) {
        int n = this.e2 + this.e9;
        if (obj == null) {
            for (int i = this.e2; i < n; ++i) {
                if (this.p1[i % this.p1.length] != null) continue;
                return true;
            }
        } else {
            for (int i = this.e2; i < n; ++i) {
                if (!obj.equals(this.p1[i % this.p1.length])) continue;
                return true;
            }
        }
        return false;
    }

    public Object dequeue() {
        ++this.m6;
        if (this.e9 < 1) {
            throw new InvalidOperationException();
        }
        Object object = this.p1[this.e2];
        this.p1[this.e2] = null;
        this.e2 = (this.e2 + 1) % this.p1.length;
        --this.e9;
        return object;
    }

    public void enqueue(Object obj) {
        ++this.m6;
        if (this.e9 == this.p1.length) {
            this.p1();
        }
        this.p1[this.f1] = obj;
        this.f1 = (this.f1 + 1) % this.p1.length;
        ++this.e9;
    }

    public Object peek() {
        if (this.e9 < 1) {
            throw new InvalidOperationException();
        }
        return this.p1[this.e2];
    }

    public static Queue sync(Queue queue) {
        if (queue == null) {
            throw new ArgumentNullException("queue");
        }
        return new SyncQueue(queue);
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.e9) {
            return Arrays.copyOf(this.p1, this.e9, a.getClass());
        }
        System.arraycopy(this.p1, 0, a, 0, this.e9);
        if (a.length > this.e9) {
            a[this.e9] = null;
        }
        return a;
    }

    public void trimToSize() {
        ++this.m6;
        Object[] objectArray = new Object[this.e9];
        this.copyTo(com.aspose.slides.ms.System.f1.p1(objectArray), 0);
        this.p1 = objectArray;
        this.e2 = 0;
        this.f1 = 0;
    }

    private void p1() {
        int n = this.p1.length * this.d7 / 100;
        if (n < this.p1.length + 1) {
            n = this.p1.length + 1;
        }
        Object[] objectArray = new Object[n];
        this.copyTo(com.aspose.slides.ms.System.f1.p1(objectArray), 0);
        this.p1 = objectArray;
        this.e2 = 0;
        this.f1 = this.e2 + this.e9;
    }

    @e0
    private static class QueueEnumerator
    implements IEnumerator,
    o3 {
        private Queue p1;
        private int e2;
        private int e9;

        QueueEnumerator(Queue q) {
            this.p1 = q;
            this.e2 = q.m6;
            this.e9 = -1;
        }

        @Override
        public Object deepClone() {
            QueueEnumerator queueEnumerator = new QueueEnumerator(this.p1);
            queueEnumerator.e2 = this.e2;
            queueEnumerator.e9 = this.e9;
            return queueEnumerator;
        }

        @Override
        public Object next() {
            if (this.e2 != this.p1.m6 || this.e9 < 0 || this.e9 >= this.p1.e9) {
                throw new InvalidOperationException();
            }
            return this.p1.p1[(this.p1.e2 + this.e9) % this.p1.p1.length];
        }

        @Override
        public boolean hasNext() {
            if (this.e2 != this.p1.m6) {
                throw new InvalidOperationException();
            }
            if (this.e9 >= this.p1.e9 - 1) {
                this.e9 = Integer.MAX_VALUE;
                return false;
            }
            ++this.e9;
            return true;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.e2 != this.p1.m6) {
                throw new InvalidOperationException();
            }
            this.e9 = -1;
        }
    }

    private static class SyncQueue
    extends Queue {
        private final Queue p1;

        SyncQueue(Queue queue) {
            this.p1 = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Queue queue = this.p1;
            synchronized (queue) {
                return this.p1.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.p1.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(f1 array, int index) {
            Queue queue = this.p1;
            synchronized (queue) {
                this.p1.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Queue queue = this.p1;
            synchronized (queue) {
                return this.p1.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Queue queue = this.p1;
            synchronized (queue) {
                return new SyncQueue((Queue)this.p1.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Queue queue = this.p1;
            synchronized (queue) {
                this.p1.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Queue queue = this.p1;
            synchronized (queue) {
                this.p1.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Queue queue = this.p1;
            synchronized (queue) {
                return this.p1.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object dequeue() {
            Queue queue = this.p1;
            synchronized (queue) {
                return this.p1.dequeue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enqueue(Object obj) {
            Queue queue = this.p1;
            synchronized (queue) {
                this.p1.enqueue(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Queue queue = this.p1;
            synchronized (queue) {
                return this.p1.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Queue queue = this.p1;
            synchronized (queue) {
                return this.p1.toArray(a);
            }
        }
    }
}

