/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.Comparer;
import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IList;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.internal.x7s.s1;
import com.aspose.slides.ms.System.e0;
import com.aspose.slides.ms.System.f1;
import com.aspose.slides.ms.System.i2;
import com.aspose.slides.ms.System.l1;
import com.aspose.slides.ms.System.n1;
import com.aspose.slides.ms.System.o3;
import java.util.Comparator;

@e0
public class SortedList
implements IDictionary,
o3 {
    private final Object p1 = new Object();
    private Slot[] e2;
    private Comparator e9;
    private int f1;
    private int d7;
    private int m6;

    public SortedList() {
        this(null, 16);
    }

    public SortedList(int initialCapacity) {
        this(null, initialCapacity);
    }

    public SortedList(Comparator comparer, int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.m6 = capacity == 0 ? 0 : 16;
        this.e9 = comparer;
        this.e2(capacity, true);
    }

    public SortedList(Comparator comparer) {
        this.e9 = comparer;
        this.e2(16, true);
    }

    public SortedList(IDictionary d) {
        this(d, null);
    }

    public SortedList(IDictionary d, Comparator comparer) {
        if (d == null) {
            throw new ArgumentNullException("dictionary");
        }
        this.e2(d.size(), true);
        this.e9 = comparer;
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Override
    public int size() {
        return this.f1;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this.p1;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ICollection getKeys() {
        return new ListKeys(this);
    }

    @Override
    public ICollection getValues() {
        return new ListValues(this);
    }

    @Override
    public Object get_Item(Object key) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        return this.p1(key);
    }

    @Override
    public void set_Item(Object key, Object value) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        if (this.isReadOnly()) {
            throw new NotSupportedException("SortedList is Read Only.");
        }
        if (this.e2(key) < 0 && this.isFixedSize()) {
            throw new NotSupportedException("Key not found and SortedList is fixed size.");
        }
        this.p1(key, value, true);
    }

    public int getCapacity() {
        return this.e2.length;
    }

    public void setCapacity(int value) {
        int n = this.e2.length;
        if (this.f1 > value) {
            throw new ArgumentOutOfRangeException("capacity too small");
        }
        if (value == 0) {
            Slot[] slotArray = SortedList.p1(this.m6);
            SortedList.p1(this.e2, 0, slotArray, 0, this.f1);
            this.e2 = slotArray;
        } else if (value > this.f1) {
            Slot[] slotArray = SortedList.p1(value);
            SortedList.p1(this.e2, 0, slotArray, 0, this.f1);
            this.e2 = slotArray;
        } else if (value > n) {
            Slot[] slotArray = SortedList.p1(value);
            SortedList.p1(this.e2, 0, slotArray, 0, n);
            this.e2 = slotArray;
        }
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new Enumerator(this, 2);
    }

    @Deprecated
    public IDictionaryEnumerator iteratorJava() {
        return new EnumeratorJava(this, 2);
    }

    @Override
    public void addItem(Object key, Object value) {
        this.p1(key, value, false);
    }

    @Override
    public void clear() {
        this.m6 = 16;
        this.e2 = SortedList.p1(this.m6);
        this.f1 = 0;
        ++this.d7;
    }

    @Override
    public boolean contains(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.e2(key) >= 0;
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void removeItem(Object key) {
        int n = this.indexOfKey(key);
        if (n >= 0) {
            this.removeAt(n);
        }
    }

    @Override
    public void copyTo(f1 array, int arrayIndex) {
        if (null == array) {
            throw new ArgumentNullException();
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (array.f1() > 1) {
            throw new ArgumentException("array is multi-dimensional");
        }
        if (arrayIndex >= array.d7()) {
            throw new ArgumentNullException("arrayIndex is greater than or equal to array.Length");
        }
        if (this.size() > array.d7() - arrayIndex) {
            throw new ArgumentNullException("Not enough space in array from arrayIndex to end of array");
        }
        IDictionaryEnumerator iDictionaryEnumerator = this.iterator();
        int n = arrayIndex;
        while (iDictionaryEnumerator.hasNext()) {
            array.e9(iDictionaryEnumerator.getEntry().Clone(), n++);
        }
    }

    @Override
    public Object deepClone() {
        SortedList sortedList = new SortedList(this, this.e9);
        sortedList.d7 = this.d7;
        return sortedList;
    }

    public IList getKeyList() {
        return new ListKeys(this);
    }

    public IList getValueList() {
        return new ListValues(this);
    }

    public void removeAt(int index) {
        Slot[] slotArray = this.e2;
        int n = this.size();
        if (index >= 0 && index < n) {
            if (index != n - 1) {
                SortedList.p1(slotArray, index + 1, slotArray, index, n - 1 - index);
            } else {
                slotArray[index].p1 = null;
                slotArray[index].e2 = null;
            }
            --this.f1;
            ++this.d7;
        } else {
            throw new ArgumentOutOfRangeException("index out of range");
        }
    }

    public int indexOfKey(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        int n = 0;
        try {
            n = this.e2(key);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        return n | n >> 31;
    }

    public int indexOfValue(Object value) {
        if (this.f1 == 0) {
            return -1;
        }
        for (int i = 0; i < this.f1; ++i) {
            Slot slot = this.e2[i].Clone();
            if (!i2.p1(value, slot.e2)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsKey(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.contains(key);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    public boolean containsValue(Object value) {
        return this.indexOfValue(value) >= 0;
    }

    public Object getByIndex(int index) {
        if (index >= 0 && index < this.size()) {
            return this.e2[index].e2;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public void setByIndex(int index, Object value) {
        if (index < 0 || index >= this.size()) {
            throw new ArgumentOutOfRangeException("index out of range");
        }
        this.e2[index].e2 = value;
    }

    public Object getKey(int index) {
        if (index >= 0 && index < this.size()) {
            return this.e2[index].p1;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public static SortedList sync(SortedList list) {
        if (list == null) {
            throw new ArgumentNullException("Base list is null.");
        }
        return new SynchedSortedList(list);
    }

    public void trimToSize() {
        if (this.size() == 0) {
            this.p1(this.m6, false);
        } else {
            this.p1(this.size(), true);
        }
    }

    private void p1(int n, boolean bl) {
        Slot[] slotArray = this.e2;
        Slot[] slotArray2 = SortedList.p1(n);
        if (bl) {
            SortedList.p1(slotArray, 0, slotArray2, 0, n);
        }
        this.e2 = slotArray2;
    }

    private void p1(int n, int n10) {
        boolean bl;
        Slot[] slotArray = this.e2;
        Slot[] slotArray2 = null;
        int n11 = this.getCapacity();
        boolean bl2 = bl = n10 >= 0 && n10 < this.size();
        if (n > n11) {
            slotArray2 = SortedList.p1(n << 1);
        }
        if (slotArray2 != null) {
            if (bl) {
                int n12 = n10;
                if (n12 > 0) {
                    SortedList.p1(slotArray, 0, slotArray2, 0, n12);
                }
                if ((n12 = this.size() - n10) > 0) {
                    SortedList.p1(slotArray, n10, slotArray2, n10 + 1, n12);
                }
            } else {
                SortedList.p1(slotArray, 0, slotArray2, 0, this.size());
            }
            this.e2 = slotArray2;
        } else if (bl) {
            SortedList.p1(slotArray, n10, slotArray, n10 + 1, this.size() - n10);
        }
    }

    private void p1(Object object, Object object2, boolean bl) {
        if (object == null) {
            throw new ArgumentNullException("null key");
        }
        Slot[] slotArray = this.e2;
        int n = -1;
        try {
            n = this.e2(object);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        if (n >= 0) {
            if (!bl) {
                String string = n1.p1("Key '{0}' already exists in list.", new Object[]{object});
                throw new ArgumentException(string);
            }
            slotArray[n].e2 = object2;
            ++this.d7;
            return;
        }
        if ((n ^= 0xFFFFFFFF) > this.getCapacity() + 1) {
            throw new RuntimeException(n1.p1(new Object[]{"SortedList::internal error (", object, ", ", object2, ") at [", n, "]"}));
        }
        this.p1(this.size() + 1, n);
        slotArray = this.e2;
        slotArray[n].p1 = object;
        slotArray[n].e2 = object2;
        ++this.f1;
        ++this.d7;
    }

    private Object p1(Object object) {
        int n = this.e2(object);
        if (n >= 0) {
            return this.e2[n].e2;
        }
        return null;
    }

    private void e2(int n, boolean bl) {
        if (!bl && n < this.m6) {
            n = this.m6;
        }
        this.e2 = SortedList.p1(n);
        this.f1 = 0;
        this.d7 = 0;
    }

    private void p1(f1 f12, int n, int n10) {
        if (f12 == null) {
            throw new ArgumentNullException("arr");
        }
        if (n < 0 || n + this.size() > f12.d7()) {
            throw new ArgumentOutOfRangeException("i");
        }
        Enumerator enumerator = new Enumerator(this, n10);
        while (enumerator.hasNext()) {
            f12.e9(enumerator.next(), n++);
        }
    }

    private int e2(Object object) {
        Slot[] slotArray = this.e2;
        int n = this.size();
        if (n == 0) {
            return -1;
        }
        Comparator comparator = this.e9 == null ? Comparer.Default : this.e9;
        int n10 = 0;
        int n11 = n - 1;
        while (n10 <= n11) {
            int n12 = n10 + n11 >> 1;
            int n13 = comparator.compare(slotArray[n12].p1, object);
            if (n13 == 0) {
                return n12;
            }
            if (n13 < 0) {
                n10 = n12 + 1;
                continue;
            }
            n11 = n12 - 1;
        }
        return ~n10;
    }

    static Slot[] p1(int n) {
        Slot[] slotArray = new Slot[n];
        for (int i = 0; i < n; ++i) {
            slotArray[i] = new Slot();
        }
        return slotArray;
    }

    private static boolean p1(int n, int n10, int n11) {
        return n < n10 && n + n11 > n10 || n10 < n && n10 + n11 > n;
    }

    static void p1(Slot[] slotArray, int n, Slot[] slotArray2, int n10, int n11) {
        Slot[] slotArray3;
        if (slotArray == slotArray2 && SortedList.p1(n, n10, n11)) {
            slotArray3 = new Slot[n11];
            System.arraycopy(slotArray, n, slotArray3, 0, n11);
            n = 0;
        } else {
            slotArray3 = slotArray;
        }
        for (int i = 0; i < n11; ++i) {
            slotArray2[n10 + i] = slotArray3[n + i].Clone();
        }
    }

    private static class SynchedSortedList
    extends SortedList {
        private SortedList p1;

        public SynchedSortedList(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.p1 = host;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                return this.p1.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                this.p1.setCapacity(value);
            }
        }

        @Override
        public int size() {
            return this.p1.size();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.p1.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.p1.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.p1.isReadOnly();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            ICollection iCollection = null;
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                iCollection = this.p1.getKeys();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            ICollection iCollection = null;
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                iCollection = this.p1.getValues();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(Object key) {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                return this.p1.p1(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key, Object value) {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                this.p1.p1(key, value, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(f1 array, int arrayIndex) {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                this.p1.copyTo(array, arrayIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key, Object value) {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                this.p1.p1(key, value, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                this.p1.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object key) {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                return this.p1.e2(key) >= 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IDictionaryEnumerator iterator() {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                return this.p1.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public IDictionaryEnumerator iteratorJava() {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                return this.p1.iteratorJava();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key) {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                this.p1.removeItem(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                return this.p1.contains(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object value) {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                return this.p1.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                return this.p1.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getByIndex(int index) {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                return this.p1.getByIndex(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getKey(int index) {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                return this.p1.getKey(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getKeyList() {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                return new ListKeys(this.p1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getValueList() {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                return new ListValues(this.p1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                this.p1.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfKey(Object key) {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                return this.p1.indexOfKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfValue(Object val) {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                return this.p1.indexOfValue(val);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setByIndex(int index, Object value) {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                this.p1.setByIndex(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.p1.getSyncRoot();
            synchronized (object) {
                this.p1.trimToSize();
            }
        }
    }

    @e0
    private static class ListValues
    implements IList {
        private SortedList p1;

        public ListValues(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.p1 = host;
        }

        @Override
        public int size() {
            return this.p1.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.p1.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.p1.getSyncRoot();
        }

        @Override
        public void copyTo(f1 array, int arrayIndex) {
            this.p1.p1(array, arrayIndex, 1);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.p1.getByIndex(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("This operation is not supported on GetValueList return");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object value) {
            return this.p1.containsValue(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.p1.indexOfValue(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.p1, 1);
        }
    }

    @e0
    private static class ListKeys
    implements IList {
        private SortedList p1;

        public ListKeys(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.p1 = host;
        }

        @Override
        public int size() {
            return this.p1.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.p1.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.p1.getSyncRoot();
        }

        @Override
        public void copyTo(f1 array, int arrayIndex) {
            this.p1.p1(array, arrayIndex, 0);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.p1.getKey(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("attempt to modify a key");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object key) {
            return this.p1.contains(key);
        }

        @Override
        public int indexOf(Object key) {
            return this.p1.indexOfKey(key);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.p1, 0);
        }
    }

    @Deprecated
    private static final class EnumeratorJava
    implements IDictionaryEnumerator,
    o3 {
        private SortedList p1;
        private Object e2;
        private Object e9;
        private int f1;
        private int d7;
        private int m6;
        private int s1;
        private boolean v3 = false;
        private static String p2 = "SortedList.EnumeratorJava: snapshot out of sync.";

        public EnumeratorJava(SortedList host, int mode) {
            this.p1 = host;
            this.f1 = host.d7;
            this.m6 = host.size();
            this.s1 = mode;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.p1.d7 != this.f1 || this.v3) {
                throw new IllegalStateException(p2);
            }
            this.d7 = -1;
            this.e2 = null;
            this.e9 = null;
        }

        @Override
        public boolean hasNext() {
            if (this.p1.d7 != this.f1 || this.v3) {
                throw new InvalidOperationException(p2);
            }
            return ++this.d7 < this.m6;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.v3 || this.d7 >= this.m6 || this.d7 == -1) {
                throw new IllegalStateException(p2);
            }
            return new DictionaryEntry(this.e2, this.e9);
        }

        @Override
        public Object getKey() {
            if (this.v3 || this.d7 >= this.m6 || this.d7 == -1) {
                throw new IllegalStateException(p2);
            }
            return this.e2;
        }

        @Override
        public Object getValue() {
            if (this.v3 || this.d7 >= this.m6 || this.d7 == -1) {
                throw new IllegalStateException(p2);
            }
            return this.e9;
        }

        @Override
        public Object next() {
            if (this.p1.d7 != this.f1 || this.v3) {
                throw new InvalidOperationException(p2);
            }
            if (this.v3 || this.d7 >= this.m6 || this.d7 == -1) {
                if (this.d7 >= this.m6) {
                    this.e2 = null;
                    this.e9 = null;
                }
                throw new IllegalStateException(p2);
            }
            Slot[] slotArray = this.p1.e2;
            Slot slot = slotArray[this.d7].Clone();
            this.e2 = slot.p1;
            this.e9 = slot.e2;
            switch (this.s1) {
                case 0: {
                    return this.e2;
                }
                case 1: {
                    return this.e9;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(n1.p1(new String[]{l1.getName(EnumeratorMode.class, this.s1), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            EnumeratorJava enumeratorJava = new EnumeratorJava(this.p1, this.s1);
            enumeratorJava.f1 = this.f1;
            enumeratorJava.d7 = this.d7;
            enumeratorJava.m6 = this.m6;
            enumeratorJava.e2 = this.e2;
            enumeratorJava.e9 = this.e9;
            enumeratorJava.v3 = this.v3;
            return enumeratorJava;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class Enumerator
    implements IDictionaryEnumerator,
    o3 {
        private SortedList p1;
        private Object e2;
        private Object e9;
        private int f1;
        private int d7;
        private int m6;
        private int s1;
        private boolean v3 = false;
        private static String p2 = "SortedList.Enumerator: snapshot out of sync.";

        public Enumerator(SortedList host, int mode) {
            this.p1 = host;
            this.f1 = host.d7;
            this.m6 = host.size();
            this.s1 = mode;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.p1.d7 != this.f1 || this.v3) {
                throw new IllegalStateException(p2);
            }
            this.d7 = -1;
            this.e2 = null;
            this.e9 = null;
        }

        @Override
        public boolean hasNext() {
            if (this.p1.d7 != this.f1 || this.v3) {
                throw new InvalidOperationException(p2);
            }
            Slot[] slotArray = this.p1.e2;
            if (++this.d7 < this.m6) {
                Slot slot = slotArray[this.d7].Clone();
                this.e2 = slot.p1;
                this.e9 = slot.e2;
                return true;
            }
            this.e2 = null;
            this.e9 = null;
            return false;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.v3 || this.d7 >= this.m6 || this.d7 == -1) {
                throw new IllegalStateException(p2);
            }
            return new DictionaryEntry(this.e2, this.e9);
        }

        @Override
        public Object getKey() {
            if (this.v3 || this.d7 >= this.m6 || this.d7 == -1) {
                throw new IllegalStateException(p2);
            }
            return this.e2;
        }

        @Override
        public Object getValue() {
            if (this.v3 || this.d7 >= this.m6 || this.d7 == -1) {
                throw new IllegalStateException(p2);
            }
            return this.e9;
        }

        @Override
        public Object next() {
            if (this.v3 || this.d7 >= this.m6 || this.d7 == -1) {
                throw new IllegalStateException(p2);
            }
            switch (this.s1) {
                case 0: {
                    return this.e2;
                }
                case 1: {
                    return this.e9;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(n1.p1(new String[]{l1.getName(EnumeratorMode.class, this.s1), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            Enumerator enumerator = new Enumerator(this.p1, this.s1);
            enumerator.f1 = this.f1;
            enumerator.d7 = this.d7;
            enumerator.m6 = this.m6;
            enumerator.e2 = this.e2;
            enumerator.e9 = this.e9;
            enumerator.v3 = this.v3;
            return enumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class EnumeratorMode
    extends l1 {
        private EnumeratorMode() {
        }

        static {
            l1.register(new l1.d7(EnumeratorMode.class, Integer.class){
                {
                    this.addConstant("KEY_MODE", 0L);
                    this.addConstant("VALUE_MODE", 1L);
                    this.addConstant("ENTRY_MODE", 2L);
                }
            });
        }
    }

    @e0
    public static class Slot
    extends s1<Slot> {
        Object p1;
        Object e2;

        @Override
        public void CloneTo(Slot that) {
            that.p1 = this.p1;
            that.e2 = this.e2;
        }

        @Override
        public Slot Clone() {
            Slot slot = new Slot();
            this.CloneTo(slot);
            return slot;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean p1(Slot slot) {
            return i2.p1(slot.p1, this.p1) && i2.p1(slot.e2, this.e2);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (i2.e2(null, obj)) {
                return false;
            }
            if (i2.e2(this, obj)) {
                return true;
            }
            if (!(obj instanceof Slot)) {
                return false;
            }
            return this.p1((Slot)obj);
        }

        public static boolean equals(Slot obj1, Slot obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.p1 != null ? this.p1.hashCode() : 0;
            n = 31 * n + (this.e2 != null ? this.e2.hashCode() : 0);
            return n;
        }
    }
}

