/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Specialized;

import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.internal.o1n.f0;
import com.aspose.slides.internal.x7s.e9;
import com.aspose.slides.internal.x7s.s1;
import com.aspose.slides.ms.System.z3;
import com.aspose.slides.ms.System.z7;

public class BitVector32
extends s1<BitVector32> {
    private int p1;

    public BitVector32() {
    }

    public BitVector32(BitVector32 value) {
        this.p1 = value.p1;
    }

    public BitVector32(int data) {
        this.p1 = data;
    }

    public int getData() {
        return this.p1;
    }

    public int get_Item(Section section) {
        return this.p1 >> section.getOffset() & section.getMask();
    }

    public void set_Item(Section section, int value) {
        if (value < 0) {
            throw new ArgumentException("Section can't hold negative values");
        }
        if (value > section.getMask()) {
            throw new ArgumentException("Value too large to fit in section");
        }
        this.p1 &= ~(section.getMask() << section.getOffset());
        this.p1 |= value << section.getOffset();
    }

    public boolean get_Item(int bit) {
        return (this.p1 & bit) == bit;
    }

    public void set_Item(int bit, boolean value) {
        this.p1 = value ? (this.p1 |= bit) : (this.p1 &= ~bit);
    }

    public static int createMask() {
        return 1;
    }

    public static int createMask(int previous) {
        if (previous == 0) {
            return 1;
        }
        if (previous == Integer.MIN_VALUE) {
            throw new InvalidOperationException("all bits set");
        }
        return previous << 1;
    }

    public static Section createSection(short maxValue) {
        return BitVector32.createSection(maxValue, new Section(0, 0));
    }

    public static Section createSection(short maxValue, Section previous) {
        if (maxValue < 1) {
            throw new ArgumentException("maxValue");
        }
        int n = BitVector32.p1(maxValue);
        int n10 = (1 << n) - 1;
        int n11 = previous.getOffset() + BitVector32.p1(previous.getMask());
        if (n11 + n > 32) {
            throw new ArgumentException("Sections cannot exceed 32 bits in total");
        }
        return new Section(e9.e2((Object)n10, 9), e9.e2((Object)n11, 9));
    }

    public boolean equals(Object o) {
        return e9.e2(o, BitVector32.class) && this.p1 == e9.f1((Object)o, BitVector32.class).p1;
    }

    public int hashCode() {
        return z3.p1(this.p1);
    }

    public String toString() {
        return BitVector32.toString(this.Clone());
    }

    public static String toString(BitVector32 value) {
        f0 f02 = new f0();
        f02.p1("BitVector32{");
        for (long i = e9.m6((Object)0x80000000L, 10); i > 0L; i >>= 1) {
            f02.p1(((long)value.p1 & i) == 0L ? (char)'0' : '1');
        }
        f02.p1('}');
        return f02.toString();
    }

    private static int p1(int n) {
        int n10 = 0;
        while (n >> n10 != 0) {
            ++n10;
        }
        return n10;
    }

    @Override
    public void CloneTo(BitVector32 that) {
        that.p1 = this.p1;
    }

    @Override
    public BitVector32 Clone() {
        BitVector32 bitVector32 = new BitVector32();
        this.CloneTo(bitVector32);
        return bitVector32;
    }

    public Object clone() {
        return this.Clone();
    }

    public static boolean equals(BitVector32 obj1, BitVector32 obj2) {
        return obj1.equals(obj2);
    }

    public static class Section
    extends s1<Section> {
        private short p1;
        private short e2;

        public Section() {
        }

        Section(short mask, short offset) {
            this.p1 = mask;
            this.e2 = offset;
        }

        public short getMask() {
            return this.p1;
        }

        public short getOffset() {
            return this.e2;
        }

        public static boolean op_Equality(Section a, Section b) {
            return a.p1 == b.p1 && a.e2 == b.e2;
        }

        public static boolean op_Inequality(Section a, Section b) {
            return a.p1 != b.p1 || a.e2 != b.e2;
        }

        public boolean equals(Section obj) {
            return this.p1 == obj.p1 && this.e2 == obj.e2;
        }

        public boolean equals(Object o) {
            if (!e9.e2(o, Section.class)) {
                return false;
            }
            Section section = e9.f1(o, Section.class).Clone();
            return this.p1 == section.p1 && this.e2 == section.e2;
        }

        public int hashCode() {
            return this.p1 << this.e2;
        }

        public String toString() {
            return Section.toString(this.Clone());
        }

        public static String toString(Section value) {
            f0 f02 = new f0();
            f02.p1("Section{0x");
            f02.p1(z7.p1(value.getMask(), 16));
            f02.p1(", 0x");
            f02.p1(z7.p1(value.getOffset(), 16));
            f02.p1("}");
            return f02.toString();
        }

        @Override
        public void CloneTo(Section that) {
            that.p1 = this.p1;
            that.e2 = this.e2;
        }

        @Override
        public Section Clone() {
            Section section = new Section();
            this.CloneTo(section);
            return section;
        }

        public Object clone() {
            return this.Clone();
        }

        public static boolean equals(Section obj1, Section obj2) {
            return obj1.equals(obj2);
        }
    }
}

