/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.e0;
import com.aspose.slides.ms.System.f1;
import com.aspose.slides.ms.System.o3;
import com.aspose.slides.ms.System.p8;
import java.util.Arrays;

@e0
public class Stack
implements ICollection,
IEnumerable,
o3 {
    private Object[] p1;
    private int e2 = -1;
    private int e9;
    private int f1;
    private int d7;

    private void p1(int n) {
        n = Math.max(n, 16);
        Object[] objectArray = new Object[n];
        com.aspose.slides.ms.System.f1.p1(this.p1, 0, objectArray, 0, this.e9);
        this.f1 = n;
        this.p1 = objectArray;
    }

    public Stack() {
        this.p1 = new Object[16];
        this.f1 = 16;
    }

    public Stack(ICollection col) {
        this(col == null ? 16 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e : col) {
            this.push(e);
        }
    }

    public Stack(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new ArgumentOutOfRangeException("initialCapacity");
        }
        this.f1 = initialCapacity;
        this.p1 = new Object[this.f1];
    }

    public static Stack sync(Stack stack) {
        if (stack == null) {
            throw new ArgumentNullException("stack");
        }
        return new SyncStack(stack);
    }

    @Override
    public int size() {
        return this.e9;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    public void clear() {
        ++this.d7;
        for (int i = 0; i < this.e9; ++i) {
            this.p1[i] = null;
        }
        this.e9 = 0;
        this.e2 = -1;
    }

    @Override
    public Object deepClone() {
        Stack stack = new Stack(com.aspose.slides.ms.System.f1.p1(this.p1));
        stack.e2 = this.e2;
        stack.e9 = this.e9;
        return stack;
    }

    public boolean contains(Object obj) {
        if (this.e9 == 0) {
            return false;
        }
        if (obj == null) {
            for (int i = 0; i < this.e9; ++i) {
                if (this.p1[i] != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.e9; ++i) {
                if (!obj.equals(this.p1[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void copyTo(f1 array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.f1() > 1 || array.d7() > 0 && index >= array.d7() || this.e9 > array.d7() - index) {
            throw new ArgumentException();
        }
        for (int i = this.e2; i != -1; --i) {
            array.e9(this.p1[i], this.e9 - (i + 1) + index);
        }
    }

    public IEnumerator iterator() {
        return new Enumerator(this);
    }

    public Object peek() {
        if (this.e2 == -1) {
            throw new InvalidOperationException();
        }
        return this.p1[this.e2];
    }

    public Object pop() {
        if (this.e2 == -1) {
            throw new InvalidOperationException();
        }
        ++this.d7;
        Object object = this.p1[this.e2];
        this.p1[this.e2] = null;
        --this.e9;
        --this.e2;
        if (this.e9 <= this.f1 / 4 && this.e9 > 16) {
            this.p1(this.f1 / 2);
        }
        return object;
    }

    public void push(Object obj) {
        ++this.d7;
        if (this.f1 == this.e9) {
            this.p1(this.f1 * 2);
        }
        ++this.e9;
        ++this.e2;
        this.p1[this.e2] = obj;
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.e9) {
            a = Arrays.copyOf(this.p1, this.e9, a.getClass());
            p8.p1(a);
            return a;
        }
        System.arraycopy(this.p1, 0, a, 0, this.e9);
        if (a.length > this.e9) {
            a[this.e9] = null;
        }
        p8.p1(a);
        return a;
    }

    private static class Enumerator
    implements IEnumerator,
    o3,
    Cloneable {
        private Stack p1;
        private int e2;
        private int e9;

        Enumerator(Stack s) {
            this.p1 = s;
            this.e2 = s.d7;
            this.e9 = -2;
        }

        private Enumerator() {
        }

        @Override
        public Object deepClone() {
            return this.p1();
        }

        @Override
        public Object next() {
            if (this.e2 != this.p1.d7 || this.e9 == -2 || this.e9 == -1 || this.e9 > this.p1.e9) {
                throw new InvalidOperationException();
            }
            return this.p1.p1[this.e9];
        }

        @Override
        public boolean hasNext() {
            if (this.e2 != this.p1.d7) {
                throw new InvalidOperationException();
            }
            switch (this.e9) {
                case -2: {
                    this.e9 = this.p1.e2;
                    return this.e9 != -1;
                }
                case -1: {
                    return false;
                }
            }
            --this.e9;
            return this.e9 != -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.e2 != this.p1.d7) {
                throw new InvalidOperationException();
            }
            this.e9 = -2;
        }

        protected Object p1() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            Enumerator enumerator = new Enumerator();
            enumerator.p1 = this.p1;
            enumerator.e2 = this.e2;
            enumerator.e9 = this.e9;
            return enumerator;
        }
    }

    @e0
    private static class SyncStack
    extends Stack {
        private final Stack p1;

        SyncStack(Stack s) {
            this.p1 = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Stack stack = this.p1;
            synchronized (stack) {
                return this.p1.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.p1.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Stack stack = this.p1;
            synchronized (stack) {
                this.p1.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Stack stack = this.p1;
            synchronized (stack) {
                return Stack.sync((Stack)this.p1.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Stack stack = this.p1;
            synchronized (stack) {
                return this.p1.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(f1 array, int index) {
            Stack stack = this.p1;
            synchronized (stack) {
                this.p1.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Stack stack = this.p1;
            synchronized (stack) {
                return new Enumerator(this.p1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Stack stack = this.p1;
            synchronized (stack) {
                return this.p1.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object pop() {
            Stack stack = this.p1;
            synchronized (stack) {
                return this.p1.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void push(Object obj) {
            Stack stack = this.p1;
            synchronized (stack) {
                this.p1.push(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Stack stack = this.p1;
            synchronized (stack) {
                return this.p1.toArray(a);
            }
        }
    }
}

