/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.List;
import com.aspose.slides.IMathElement;
import com.aspose.slides.IMathMatrix;
import com.aspose.slides.MathElementBase;
import com.aspose.slides.c4d;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.g5p;
import com.aspose.slides.internal.x7s.e9;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.y2t;

public final class MathMatrix
extends MathElementBase
implements IMathMatrix,
c4d {
    private boolean f1;
    private int d7;
    private long m6;
    private int s1;
    private long v3;
    private int p2;
    private long d2;
    private final List<List<IMathElement>> x6;
    private int[] y6;
    final y2t p1;

    @Override
    public final int getRowCount() {
        return this.x6.size();
    }

    @Override
    public final int getColumnCount() {
        return this.x6.get_Item(0).size();
    }

    @Override
    public final boolean getHidePlaceholders() {
        return this.f1;
    }

    @Override
    public final void setHidePlaceholders(boolean value) {
        this.f1 = value;
    }

    @Override
    public final int getBaseJustification() {
        return this.d7;
    }

    @Override
    public final void setBaseJustification(int value) {
        this.d7 = value;
    }

    @Override
    public final long getMinColumnWidth() {
        return this.m6;
    }

    @Override
    public final void setMinColumnWidth(long value) {
        this.m6 = value;
    }

    @Override
    public final int getColumnGapRule() {
        return this.s1;
    }

    @Override
    public final void setColumnGapRule(int value) {
        this.s1 = value;
    }

    @Override
    public final long getColumnGap() {
        return this.v3;
    }

    @Override
    public final void setColumnGap(long value) {
        this.v3 = value;
    }

    @Override
    public final int getRowGapRule() {
        return this.p2;
    }

    @Override
    public final void setRowGapRule(int value) {
        this.p2 = value;
    }

    @Override
    public final long getRowGap() {
        return this.d2;
    }

    @Override
    public final void setRowGap(long value) {
        this.d2 = value;
    }

    @Override
    public final IMathElement get_Item(int row, int column) {
        return this.x6.get_Item(row).get_Item(column);
    }

    @Override
    public final void set_Item(int row, int column, IMathElement value) {
        this.x6.get_Item(row).set_Item(column, value);
    }

    @Override
    public final y2t getControlCharacterProperties() {
        return this.p1;
    }

    public MathMatrix(int rowCount, int columnCount) {
        if (rowCount < 1) {
            throw new ArgumentOutOfRangeException("rowCount");
        }
        if (columnCount < 1) {
            throw new ArgumentOutOfRangeException("columnCount");
        }
        this.x6 = new List(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            this.x6.addItem(this.p1(columnCount));
        }
        this.setHidePlaceholders(false);
        this.setBaseJustification(2);
        this.setMinColumnWidth(0L);
        this.setColumnGapRule(0);
        this.y6 = new int[columnCount];
        this.setColumnsAlignment(0, (long)this.y6.length & 0xFFFFFFFFL, 2);
        this.p1 = new y2t();
    }

    @Override
    public final int getColumnAlignment(int columnIndex) {
        if (columnIndex < 0) {
            throw new ArgumentOutOfRangeException("columnIndex");
        }
        if (columnIndex >= this.getColumnCount()) {
            throw new ArgumentOutOfRangeException("columnIndex");
        }
        return this.y6[columnIndex];
    }

    @Override
    public final void setColumnAlignment(int columnIndex, int val) {
        this.setColumnsAlignment(columnIndex, 1L, val);
    }

    @Override
    public final void setColumnsAlignment(int columnIndex, long columnsCount, int val) {
        if (columnIndex < 0 || columnIndex >= this.getColumnCount()) {
            throw new ArgumentOutOfRangeException("columnIndex");
        }
        if ((columnsCount & 0xFFFFFFFFL) < 0L || ((long)columnIndex + (columnsCount & 0xFFFFFFFFL) & 0xFFFFFFFFL) > (long)this.getColumnCount()) {
            throw new ArgumentOutOfRangeException("columnsCount");
        }
        long l = (long)columnIndex + (columnsCount & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n = columnIndex;
        while ((long)n < l) {
            this.y6[n] = val;
            ++n;
        }
    }

    @Override
    public final void insertRowBefore(int rowIndex) {
        this.x6.insertItem(rowIndex, this.p1(this.getColumnCount()));
    }

    @Override
    public final void insertRowAfter(int rowIndex) {
        this.insertRowBefore(rowIndex + 1);
    }

    @Override
    public final void deleteRow(int rowIndex) {
        if (this.getRowCount() == 1) {
            throw new InvalidOperationException("It is not allowed to delete the last existing row in the matrix");
        }
        this.x6.removeAt(rowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void insertColumnBefore(int columnIndex) {
        IGenericEnumerator iGenericEnumerator = this.x6.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                List list = (List)iGenericEnumerator.next();
                list.insertItem(columnIndex, null);
            }
        }
        finally {
            if (com.aspose.slides.internal.x7s.e9.p1(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    @Override
    public final void insertColumnAfter(int columnIndex) {
        this.insertColumnBefore(columnIndex + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void deleteColumn(int columnIndex) {
        if (this.getColumnCount() == 1) {
            throw new InvalidOperationException("It is not allowed to delete the last existing column in the matrix");
        }
        IGenericEnumerator iGenericEnumerator = this.x6.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                List list = (List)iGenericEnumerator.next();
                list.removeAt(columnIndex);
            }
        }
        finally {
            if (com.aspose.slides.internal.x7s.e9.p1(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final IMathElement[] getChildren() {
        Object object;
        IGenericEnumerator iGenericEnumerator;
        IMathElement[] iMathElementArray;
        int n = 0;
        IGenericEnumerator iGenericEnumerator2 = this.x6.iterator();
        try {
            while (iGenericEnumerator2.hasNext()) {
                iMathElementArray = (IMathElement[])iGenericEnumerator2.next();
                iGenericEnumerator = iMathElementArray.iterator();
                try {
                    while (iGenericEnumerator.hasNext()) {
                        object = (IMathElement)iGenericEnumerator.next();
                        if (object == null) continue;
                        ++n;
                    }
                }
                finally {
                    if (com.aspose.slides.internal.x7s.e9.p1(iGenericEnumerator, IDisposable.class) == false) continue;
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
        }
        finally {
            if (com.aspose.slides.internal.x7s.e9.p1(iGenericEnumerator2, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator2).dispose();
            }
        }
        if (n == 0) {
            return e9;
        }
        iMathElementArray = new IMathElement[n];
        n = 0;
        iGenericEnumerator = this.x6.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                object = (List)iGenericEnumerator.next();
                IGenericEnumerator iGenericEnumerator3 = ((List)object).iterator();
                try {
                    while (iGenericEnumerator3.hasNext()) {
                        IMathElement iMathElement = (IMathElement)iGenericEnumerator3.next();
                        if (iMathElement == null) continue;
                        iMathElementArray[n++] = iMathElement;
                    }
                }
                finally {
                    if (com.aspose.slides.internal.x7s.e9.p1(iGenericEnumerator3, IDisposable.class) == false) continue;
                    ((IDisposable)iGenericEnumerator3).dispose();
                }
            }
            return iMathElementArray;
        }
        finally {
            if (com.aspose.slides.internal.x7s.e9.p1(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    @Override
    void p1(g5p g5p2) {
        g5p2.p1(this);
    }

    private List<IMathElement> p1(int n) {
        List<IMathElement> list = new List<IMathElement>(n);
        for (int i = 0; i < n; ++i) {
            list.addItem(null);
        }
        return list;
    }
}

