/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.Cell;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.List;
import com.aspose.slides.Collections.Generic.SortedDictionary;
import com.aspose.slides.GroupShape;
import com.aspose.slides.IAutoShape;
import com.aspose.slides.IBaseSlide;
import com.aspose.slides.IChart;
import com.aspose.slides.IFindResultCallback;
import com.aspose.slides.IGroupShape;
import com.aspose.slides.IParagraph;
import com.aspose.slides.IPresentation;
import com.aspose.slides.IShape;
import com.aspose.slides.IShapeCollection;
import com.aspose.slides.ISlide;
import com.aspose.slides.ISlideComponent;
import com.aspose.slides.ISmartArt;
import com.aspose.slides.ISmartArtNode;
import com.aspose.slides.ITable;
import com.aspose.slides.ITextFrame;
import com.aspose.slides.ITextSearchOptions;
import com.aspose.slides.PortionFormat;
import com.aspose.slides.Presentation;
import com.aspose.slides.Row;
import com.aspose.slides.TextFrame;
import com.aspose.slides.a0k;
import com.aspose.slides.a6f;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.internal.i3y.v3;
import com.aspose.slides.internal.o1n.f0;
import com.aspose.slides.internal.x7s.e9;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.n1;
import com.aspose.slides.z6v;

public class SlideUtil {
    public static IShape findShape(IPresentation pres, String altText) {
        IShape iShape;
        int n;
        for (n = 0; n < pres.getMasters().size(); ++n) {
            iShape = SlideUtil.findShape(pres.getMasters().get_Item(n), altText);
            if (iShape == null) continue;
            return iShape;
        }
        for (n = 0; n < pres.getSlides().size(); ++n) {
            iShape = SlideUtil.findShape(pres.getSlides().get_Item(n), altText);
            if (iShape == null) continue;
            return iShape;
        }
        return null;
    }

    public static IShape findShape(IBaseSlide slide, String altText) {
        return SlideUtil.p1(slide.getShapes(), altText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IShape[] findShapesByPlaceholderType(IBaseSlide slide, byte placeholderType) {
        List<IShape> list = new List<IShape>();
        IGenericEnumerator iGenericEnumerator = slide.getShapes().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IShape iShape = (IShape)iGenericEnumerator.next();
                if (iShape.getPlaceholder() == null || iShape.getPlaceholder().getType() != placeholderType) continue;
                list.addItem(iShape);
            }
        }
        finally {
            if (e9.p1(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        return list.toArray(new IShape[0]);
    }

    public static void alignShapes(int alignmentType, boolean alignToSlide, IBaseSlide slide) {
        int[] nArray = new int[slide.getShapes().size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        SlideUtil.p1(alignmentType, alignToSlide, slide.getShapes(), nArray);
    }

    public static void alignShapes(int alignmentType, boolean alignToSlide, IBaseSlide slide, int[] shapeIndexes) {
        SlideUtil.p1(alignmentType, alignToSlide, slide.getShapes(), shapeIndexes);
    }

    public static void alignShapes(int alignmentType, boolean alignToSlide, IGroupShape groupShape) {
        int[] nArray = new int[groupShape.getShapes().size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        SlideUtil.p1(alignmentType, alignToSlide, groupShape.getShapes(), nArray);
    }

    public static void alignShapes(int alignmentType, boolean alignToSlide, IGroupShape groupShape, int[] shapeIndexes) {
        SlideUtil.p1(alignmentType, alignToSlide, groupShape.getShapes(), shapeIndexes);
    }

    public static void findAndReplaceText(IPresentation presentation, boolean withMasters, String find, String replace) {
        SlideUtil.findAndReplaceText(presentation, withMasters, find, replace, null);
    }

    public static void findAndReplaceText(IPresentation presentation, boolean withMasters, String find, String replace, PortionFormat format) {
        if (presentation == null) {
            throw new ArgumentNullException("presentation");
        }
        if (n1.p1(find)) {
            throw new ArgumentException("String to find can not be null or empty", "find");
        }
        if (replace == null) {
            throw new ArgumentNullException("replace");
        }
        if (n1.d7(find, replace)) {
            throw new ArgumentException("String to find can not be equal to string to find");
        }
        for (ITextFrame iTextFrame : SlideUtil.getAllTextFrames(presentation, withMasters)) {
            SlideUtil.p1(iTextFrame, find, replace, format);
            iTextFrame.joinPortionsWithSameFormatting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void p1(ITextFrame iTextFrame, String string, String string2, PortionFormat portionFormat) {
        IGenericEnumerator iGenericEnumerator = iTextFrame.getParagraphs().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IParagraph iParagraph = (IParagraph)iGenericEnumerator.next();
                SlideUtil.p1(iParagraph, string, string2, portionFormat);
            }
        }
        finally {
            if (e9.p1(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    private static void p1(IParagraph iParagraph, String string, String string2, PortionFormat portionFormat) {
        if (n1.d7(string, string2)) {
            return;
        }
        z6v z6v2 = z6v.p1(iParagraph);
        while (z6v2.p1(string, string2, portionFormat)) {
        }
        iParagraph.getPortions().clear();
        z6v2.e2(iParagraph);
    }

    public static ITextFrame[] getAllTextBoxes(IBaseSlide slide) {
        List<ITextFrame> list = new List<ITextFrame>();
        SlideUtil.p1(slide.getShapes(), list);
        return list.toArray((ITextFrame[])new ITextFrame[0]);
    }

    public static ITextFrame[] getTextBoxesContainsText(IBaseSlide slide, String text, boolean checkPlaceholderText) {
        List<ITextFrame> list = new List<ITextFrame>();
        SlideUtil.p1(slide.getShapes(), list, true, checkPlaceholderText, text);
        return list.toArray((ITextFrame[])new ITextFrame[0]);
    }

    public static ITextFrame[] getAllTextFrames(IPresentation pres, boolean withMasters) {
        return SlideUtil.p1(pres, withMasters, false);
    }

    static ITextFrame[] p1(IPresentation iPresentation, boolean bl, boolean bl2) {
        int n;
        List<ITextFrame> list = new List<ITextFrame>();
        if (bl) {
            for (n = 0; n < iPresentation.getMasters().size(); ++n) {
                SlideUtil.p1(iPresentation.getMasters().get_Item(n).getShapes(), list);
            }
        }
        for (n = 0; n < iPresentation.getSlides().size(); ++n) {
            SlideUtil.p1(iPresentation.getSlides().get_Item(n).getShapes(), list);
            if (!bl2 || iPresentation.getSlides().get_Item(n).getNotesSlideManager().getNotesSlide() == null) continue;
            list.addItem(iPresentation.getSlides().get_Item(n).getNotesSlideManager().getNotesSlide().getNotesTextFrame());
        }
        return list.toArray(new ITextFrame[0]);
    }

    static ITextFrame[] p1(IPresentation iPresentation, int[] nArray, boolean bl) {
        List<ITextFrame> list = new List<ITextFrame>();
        for (int n : nArray) {
            SlideUtil.p1(iPresentation.getSlides().get_Item(n - 1).getShapes(), list);
            if (!bl) continue;
            SlideUtil.p1(iPresentation.getSlides().get_Item(n - 1).getLayoutSlide().getShapes(), list);
            SlideUtil.p1(iPresentation.getSlides().get_Item(n - 1).getLayoutSlide().getMasterSlide().getShapes(), list);
        }
        return list.toArray(new ITextFrame[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T> List<T> p1(Class<T> clazz, IPresentation iPresentation) {
        List<IShape> list = new List<IShape>();
        IGenericEnumerator iGenericEnumerator = iPresentation.getSlides().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                ISlide iSlide = (ISlide)iGenericEnumerator.next();
                IGenericEnumerator iGenericEnumerator2 = iSlide.getShapes().iterator();
                try {
                    while (iGenericEnumerator2.hasNext()) {
                        IShape iShape = (IShape)iGenericEnumerator2.next();
                        if (!e9.e2((Object)iShape, clazz)) continue;
                        list.addItem(iShape);
                    }
                }
                finally {
                    if (e9.p1(iGenericEnumerator2, IDisposable.class) == false) continue;
                    ((IDisposable)iGenericEnumerator2).dispose();
                }
            }
            return list;
        }
        finally {
            if (e9.p1(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    static String p1(IPresentation iPresentation, int[] nArray) {
        f0 f02 = new f0();
        for (int n : nArray) {
            ITextFrame[] iTextFrameArray;
            ISlide iSlide = iPresentation.getSlides().get_Item(n - 1);
            for (ITextFrame iTextFrame : iTextFrameArray = SlideUtil.getAllTextBoxes(iSlide)) {
                f02.p1(iTextFrame.getText());
            }
        }
        return f02.toString();
    }

    private static void p1(int n, boolean bl, IShapeCollection iShapeCollection, int[] nArray) {
        int n10;
        if (nArray == null) {
            throw new ArgumentNullException("shapeIndexes");
        }
        if (nArray.length == 0) {
            throw new ArgumentException("Indexes of shapes to be aligned should not be empty", "shapeIndexes");
        }
        SortedDictionary<Integer, Integer> sortedDictionary = new SortedDictionary<Integer, Integer>();
        int[] objectArray = nArray;
        int list = objectArray.length;
        for (n10 = 0; n10 < list; ++n10) {
            int n11 = objectArray[n10];
            if (n11 < 0) {
                throw new ArgumentException("Indexes of shapes to be aligned should be positive", "shapeIndexes");
            }
            if (sortedDictionary.containsKey(n11)) continue;
            sortedDictionary.addItem(n11, n11);
        }
        Integer[] integerArray = new Integer[sortedDictionary.size()];
        ((SortedDictionary.KeyCollection)sortedDictionary.getKeys()).copyTo(integerArray, 0);
        if (integerArray[integerArray.length - 1] > iShapeCollection.size() - 1) {
            throw new ArgumentException("Indexes of shapes to be aligned should correspond to slide shape indexes", "shapeIndexes");
        }
        List<IShape> list2 = new List<IShape>(((SortedDictionary.KeyCollection)sortedDictionary.getKeys()).size());
        for (n10 = 0; n10 < ((SortedDictionary.KeyCollection)sortedDictionary.getKeys()).size(); ++n10) {
            list2.addItem(iShapeCollection.get_Item(nArray[n10]));
        }
        a6f.p1(n, bl, list2);
    }

    private static IShape p1(IShapeCollection iShapeCollection, String string) {
        for (int i = 0; i < iShapeCollection.size(); ++i) {
            IShape iShape;
            IShape iShape2 = iShapeCollection.get_Item(i);
            if (n1.m6(iShape2.getAlternativeText(), string) == 0) {
                return iShape2;
            }
            if (!e9.e2((Object)iShape2, GroupShape.class) || (iShape = SlideUtil.p1(((GroupShape)iShape2).getShapes(), string)) == null) continue;
            return iShape;
        }
        return null;
    }

    private static void p1(IShapeCollection iShapeCollection, List<ITextFrame> list) {
        SlideUtil.p1(iShapeCollection, list, false);
    }

    private static void p1(IShapeCollection iShapeCollection, List<ITextFrame> list, boolean bl) {
        SlideUtil.p1(iShapeCollection, list, bl, false);
    }

    private static void p1(IShapeCollection iShapeCollection, List<ITextFrame> list, boolean bl, boolean bl2) {
        SlideUtil.p1(iShapeCollection, list, bl, bl2, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void p1(IShapeCollection iShapeCollection, List<ITextFrame> list, boolean bl, boolean bl2, String string) {
        for (int i = 0; i < iShapeCollection.size(); ++i) {
            Object object;
            IShape iShape;
            ISlideComponent iSlideComponent;
            if (e9.e2((Object)iShapeCollection.get_Item(i), IGroupShape.class)) {
                SlideUtil.p1(((IGroupShape)iShapeCollection.get_Item(i)).getShapes(), list);
                continue;
            }
            IAutoShape iAutoShape = (IAutoShape)((Object)e9.p1(iShapeCollection.get_Item(i), IAutoShape.class));
            if (iAutoShape != null) {
                iSlideComponent = iAutoShape.getTextFrame();
                if (iSlideComponent == null || bl && !n1.p2(iSlideComponent.getText(), string) && (!iSlideComponent.getText().isEmpty() || !bl2 || (iShape = (IAutoShape)((Object)e9.p1(iAutoShape.getBasePlaceholder(), IAutoShape.class))) == null || iShape.getTextFrame() == null || !n1.p2(iShape.getTextFrame().getText(), string))) continue;
                list.addItem((ITextFrame)iSlideComponent);
                continue;
            }
            iSlideComponent = (ITable)((Object)e9.p1(iShapeCollection.get_Item(i), ITable.class));
            if (iSlideComponent != null) {
                for (int j = 0; j < iSlideComponent.getRows().size(); ++j) {
                    for (int k = 0; k < iSlideComponent.getColumns().size(); ++k) {
                        object = ((Row)iSlideComponent.getRows().get_Item(j)).p1(k);
                        if (((Cell)object).getTextFrame() == null) continue;
                        list.addItem(((Cell)object).getTextFrame());
                    }
                }
                continue;
            }
            iShape = (IChart)((Object)e9.p1(iShapeCollection.get_Item(i), IChart.class));
            if (iShape != null && iShape.getUserShapes() != null) {
                SlideUtil.p1(iShape.getUserShapes().getShapes(), list);
                continue;
            }
            ISmartArt iSmartArt = (ISmartArt)((Object)e9.p1(iShapeCollection.get_Item(i), ISmartArt.class));
            if (iSmartArt == null) continue;
            object = iSmartArt.getAllNodes();
            IGenericEnumerator iGenericEnumerator = object.iterator();
            try {
                while (iGenericEnumerator.hasNext()) {
                    ISmartArtNode iSmartArtNode = (ISmartArtNode)iGenericEnumerator.next();
                    list.addItem(iSmartArtNode.getTextFrame());
                }
                continue;
            }
            finally {
                if (e9.p1(iGenericEnumerator, IDisposable.class) != false) {
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
        }
    }

    private static a0k p1(Presentation presentation, String string, ITextSearchOptions iTextSearchOptions, IFindResultCallback iFindResultCallback) {
        if (n1.p1(string)) {
            throw new ArgumentException("Text to highlight can not be null or empty", "text");
        }
        int n = 0;
        if (iTextSearchOptions != null && !iTextSearchOptions.getCaseSensitive()) {
            n |= 0x42;
        }
        v3 v32 = new v3("\\-\\[\\]\\{\\}\\(\\)\\*\\+\\?\\.\\,\\\\\\^\\$\\|#\\s");
        String string2 = v32.e9(string, "\\$0");
        if (iTextSearchOptions != null && iTextSearchOptions.getWholeWordsOnly()) {
            string2 = n1.p1(new String[]{"\\b", string2, "\\b"});
        }
        boolean bl = iTextSearchOptions != null && iTextSearchOptions.getIncludeNotes();
        v3 v33 = new v3(string2, n);
        return SlideUtil.p1(presentation, v33, iFindResultCallback, bl);
    }

    private static a0k p1(Presentation presentation, v3 v32, IFindResultCallback iFindResultCallback) {
        if (v32 == null) {
            throw new ArgumentException("Regex to highlight can not be null", "regex");
        }
        return SlideUtil.p1(presentation, v32, iFindResultCallback, false);
    }

    private static a0k p1(Presentation presentation, v3 v32, IFindResultCallback iFindResultCallback, boolean bl) {
        a0k a0k2 = new a0k(v32);
        for (ITextFrame iTextFrame : SlideUtil.p1((IPresentation)presentation, false, bl)) {
            TextFrame textFrame = (TextFrame)iTextFrame;
            textFrame.p1(v32, iFindResultCallback);
            if (textFrame.e9.d7() <= 0) continue;
            a0k2.p1(textFrame);
        }
        return a0k2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void p1(Presentation presentation, String string, com.aspose.slides.internal.f3f.v3 v32, ITextSearchOptions iTextSearchOptions, IFindResultCallback iFindResultCallback) {
        a0k a0k2 = SlideUtil.p1(presentation, string, iTextSearchOptions, iFindResultCallback);
        IGenericEnumerator iGenericEnumerator = a0k2.e2().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TextFrame textFrame = (TextFrame)iGenericEnumerator.next();
                textFrame.p1(a0k2.p1(), v32.o8());
            }
        }
        finally {
            if (e9.p1(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void p1(Presentation presentation, v3 v32, com.aspose.slides.internal.f3f.v3 v33, IFindResultCallback iFindResultCallback) {
        a0k a0k2 = SlideUtil.p1(presentation, v32, iFindResultCallback);
        IGenericEnumerator iGenericEnumerator = a0k2.e2().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TextFrame textFrame = (TextFrame)iGenericEnumerator.next();
                textFrame.p1(a0k2.p1(), v33.o8());
            }
        }
        finally {
            if (e9.p1(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void p1(Presentation presentation, String string, String string2, ITextSearchOptions iTextSearchOptions, IFindResultCallback iFindResultCallback) {
        a0k a0k2 = SlideUtil.p1(presentation, string, iTextSearchOptions, iFindResultCallback);
        IGenericEnumerator iGenericEnumerator = a0k2.e2().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TextFrame textFrame = (TextFrame)iGenericEnumerator.next();
                textFrame.p1(a0k2.p1(), string2);
            }
        }
        finally {
            if (e9.p1(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void p1(Presentation presentation, v3 v32, String string, IFindResultCallback iFindResultCallback) {
        a0k a0k2 = SlideUtil.p1(presentation, v32, iFindResultCallback);
        IGenericEnumerator iGenericEnumerator = a0k2.e2().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TextFrame textFrame = (TextFrame)iGenericEnumerator.next();
                textFrame.p1(a0k2.p1(), string);
            }
        }
        finally {
            if (e9.p1(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }
}

