/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.IAIWebClient;
import com.aspose.slides.IParagraph;
import com.aspose.slides.IPortion;
import com.aspose.slides.IPresentation;
import com.aspose.slides.Paragraph;
import com.aspose.slides.Portion;
import com.aspose.slides.Presentation;
import com.aspose.slides.SlideUtil;
import com.aspose.slides.SlidesAIAgentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.internal.DOMResourcesUtils;
import com.aspose.slides.internal.a3.g3;
import com.aspose.slides.internal.a3.g6;
import com.aspose.slides.internal.a3.q5;
import com.aspose.slides.internal.a3.s7;
import com.aspose.slides.internal.c9f.b3;
import com.aspose.slides.internal.u4.e9;

public class SlidesAIAgent {
    private final IAIWebClient p1;

    public SlidesAIAgent(IAIWebClient aiClient) {
        if (aiClient == null) {
            throw new ArgumentNullException("aiClient", "AI client instance is not provided.");
        }
        this.p1 = aiClient;
        s7.e2 = new e9<IParagraph>(){

            public IParagraph p1() {
                return new Paragraph();
            }

            @Override
            public /* synthetic */ Object invoke() {
                return this.p1();
            }
        };
        s7.p1 = new e9<IPortion>(){

            public IPortion p1() {
                return new Portion();
            }

            @Override
            public /* synthetic */ Object invoke() {
                return this.p1();
            }
        };
    }

    public void translate(IPresentation presentation, String language) {
        SlidesAIAgent.p1(presentation, language);
        String string = q5.p1(SlideUtil.getAllTextFrames(presentation, true));
        g3 g32 = new g3(presentation, string, language);
        String[] stringArray = g32.p1();
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = this.p1.callChat(stringArray[i]);
        }
        g32.p1(stringArray2);
    }

    public final IPresentation generatePresentation(String description, int presentationContentAmount) {
        if (description == null || description.isEmpty()) {
            throw new IllegalArgumentException("Description can't be null or empty.");
        }
        try {
            b3 b32 = DOMResourcesUtils.getResourceStream("aiTemplate.pptx");
            Presentation presentation = new Presentation(b32);
            return this.generatePresentation(description, presentationContentAmount, presentation);
        }
        catch (RuntimeException runtimeException) {
            throw new SlidesAIAgentException("Failed to load template", runtimeException);
        }
    }

    public final IPresentation generatePresentation(String description, int presentationContentAmount, IPresentation presentationTemplate) {
        if (description == null || description.isEmpty()) {
            throw new IllegalArgumentException("Description can't be null or empty.");
        }
        if (presentationTemplate == null) {
            throw new IllegalArgumentException("Presentation template is not provided.");
        }
        return g6.p1(this.p1, description, presentationContentAmount, presentationTemplate);
    }

    private static void p1(IPresentation iPresentation, String string) {
        if (iPresentation == null) {
            throw new IllegalArgumentException("Presentation instance is not provided.");
        }
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Language value can't be null or empty");
        }
    }
}

