/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.AxesCompositionNotCombinableException;
import com.aspose.slides.AxesManager;
import com.aspose.slides.CannotCombine2DAnd3DChartsException;
import com.aspose.slides.Chart;
import com.aspose.slides.ChartData;
import com.aspose.slides.ChartDataCell;
import com.aspose.slides.ChartDataWorkbook;
import com.aspose.slides.ChartSeries;
import com.aspose.slides.ChartTypeCharacterizer;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.DomObject;
import com.aspose.slides.IChart;
import com.aspose.slides.IChartCellCollection;
import com.aspose.slides.IChartDataCell;
import com.aspose.slides.IChartSeries;
import com.aspose.slides.IChartSeriesCollection;
import com.aspose.slides.IChartSeriesGroup;
import com.aspose.slides.cp7;
import com.aspose.slides.dhw;
import com.aspose.slides.el;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.ms.System.bu;
import com.aspose.slides.ms.System.cv;
import com.aspose.slides.rm;
import com.aspose.slides.zw;

public class ChartSeriesCollection
extends DomObject<ChartData>
implements IChartSeriesCollection {
    private Chart iy;
    private final dhw<IChartSeries> nk;

    ChartSeriesCollection(ChartData parentImmediate) {
        super(parentImmediate);
        this.nk = new dhw(parentImmediate);
    }

    @Override
    public final IChartSeries get_Item(int index) {
        return (IChartSeries)this.nk.get_Item(index);
    }

    @Override
    public final int size() {
        return this.nk.size();
    }

    @Override
    public final IChartSeries add(int type) {
        ChartSeries chartSeries = new ChartSeries(this, type, false);
        boolean bl2 = this.iy(chartSeries);
        chartSeries.nk(bl2);
        this.nk.addItem(chartSeries);
        chartSeries.et();
        return chartSeries;
    }

    @Override
    public final IChartSeries insert(int index, int type) {
        ChartSeries chartSeries = new ChartSeries(this, type, false);
        boolean bl2 = this.iy(chartSeries);
        chartSeries.nk(bl2);
        this.nk.insertItem(index, chartSeries);
        chartSeries.et();
        return chartSeries;
    }

    private boolean iy(ChartSeries chartSeries) {
        if (this.nk.size() > 0) {
            IChartSeries iChartSeries = (IChartSeries)this.nk.get_Item(0);
            boolean bl2 = ChartTypeCharacterizer.is3DChart(iChartSeries.getType());
            for (int i = 1; i < this.nk.size(); ++i) {
                iChartSeries = (IChartSeries)this.nk.get_Item(i);
            }
            if (bl2 != ChartTypeCharacterizer.is3DChart(chartSeries.getType())) {
                if (bl2) {
                    throw new CannotCombine2DAnd3DChartsException(bu.iy(new String[]{"Cannot combine 2D and 3D chart types ", "(the series to be added is 2D and present series is/are 3D)."}));
                }
                throw new CannotCombine2DAnd3DChartsException(bu.iy(new String[]{"Cannot combine 2D and 3D chart types ", "(the series to be added is 3D and present series is/are 2D)."}));
            }
        }
        if (((AxesManager)this.iy().getAxes()).iy(chartSeries.getType(), false)) {
            return false;
        }
        if (((AxesManager)this.iy().getAxes()).iy(chartSeries.getType(), true)) {
            return true;
        }
        throw new AxesCompositionNotCombinableException(bu.iy("Some chart types cannot be combined with other chart types. Select a different chart type. ", "Details: axes composition of the series to be added is not combinable with present ", "axes composition in chart. So series of this type cannot be added to this chart. ", "Preferred axes composition for the series to be added is \"", ChartTypeCharacterizer.et(ChartTypeCharacterizer.iy(chartSeries.getType())), "\"."));
    }

    final void iy(int n, IChartSeries iChartSeries) {
        if (this.nk.containsItem(iChartSeries)) {
            this.nk.removeItem(iChartSeries);
            this.nk.insertItem(n, iChartSeries);
        }
    }

    @Override
    public final IChartSeries add(IChartDataCell cellWithSeriesName, int type) {
        for (IChartSeries iChartSeries : this.nk) {
            if (iChartSeries.getName().getDataSourceType() != 0 || iChartSeries.getName().getAsCells().getCount() != 1 || !iChartSeries.getName().getAsCells().get_Item(0).equals(cellWithSeriesName)) continue;
            return iChartSeries;
        }
        IChartSeries iChartSeries = this.add(type);
        ((ChartData)this.n2).nk().iy(cellWithSeriesName);
        iChartSeries.getName().setFromOneCell(cellWithSeriesName);
        return iChartSeries;
    }

    @Override
    public final IChartSeries add(IChartCellCollection cellsWithSeriesName, int type) {
        for (IChartSeries iChartSeries : this.nk) {
            if (iChartSeries.getName().getDataSourceType() != 0 || iChartSeries.getName().getAsCells().getCount() != cellsWithSeriesName.getCount() || !bu.lg(iChartSeries.getName().getAsCells().getConcatenatedValuesFromCells(), cellsWithSeriesName.getConcatenatedValuesFromCells())) continue;
            return iChartSeries;
        }
        IChartSeries iChartSeries = this.add(type);
        iChartSeries.getName().setAsCells(cellsWithSeriesName);
        return iChartSeries;
    }

    @Override
    public final IChartSeries add(String name, int type) {
        ChartDataCell chartDataCell = ((ChartDataWorkbook)this.iy().getChartData().getChartDataWorkbook()).tg();
        chartDataCell.setValue(name);
        return this.add(chartDataCell, type);
    }

    final IChartSeries iy(int n, IChartSeriesGroup iChartSeriesGroup, boolean bl2) {
        ChartSeries chartSeries = new ChartSeries(this, n, true);
        chartSeries.nk(bl2);
        this.nk.addItem(chartSeries);
        ((AxesManager)this.iy().getAxes()).nk();
        ((rm)iChartSeriesGroup.getSeries()).iy(chartSeries);
        return chartSeries;
    }

    final IChartSeries iy(int n, boolean bl2) {
        ChartSeries chartSeries = new ChartSeries(this, n, true);
        chartSeries.nk(bl2);
        this.nk.addItem(chartSeries);
        ((AxesManager)this.iy().getAxes()).nk();
        ((zw)this.iy().getChartData().getSeriesGroups()).et(chartSeries);
        return chartSeries;
    }

    @Override
    public final int indexOf(IChartSeries value) {
        return this.nk.indexOf(value);
    }

    @Override
    public final void remove(IChartSeries value) {
        if (this.nk.indexOf(value) == -1) {
            throw new ArgumentException("The value parameter was not found in the collection.");
        }
        this.nk.removeItem(value);
        ((AxesManager)this.iy().getAxes()).nk();
        ((zw)this.iy().getChartData().getSeriesGroups()).nk((ChartSeries)value);
    }

    @Override
    public final void removeAt(int index) {
        this.remove((IChartSeries)this.nk.get_Item(index));
    }

    @Override
    public final void clear() {
        while (this.nk.size() > 0) {
            this.removeAt(this.nk.size() - 1);
        }
    }

    final IChart iy() {
        if (this.iy == null) {
            Chart[] chartArray = new Chart[]{this.iy};
            cp7.iy(Chart.class, (el)this.n2, chartArray);
            this.iy = chartArray[0];
        }
        return this.iy;
    }

    @Override
    public final IGenericEnumerator<IChartSeries> iterator() {
        return this.nk.iterator();
    }

    @Override
    public final IGenericEnumerator<IChartSeries> iteratorJava() {
        return this.nk.iteratorJava();
    }

    @Override
    public final void copyTo(cv array, int index) {
        this.nk.copyTo(array, index);
    }

    @Override
    public final boolean isSynchronized() {
        return false;
    }

    @Override
    public final Object getSyncRoot() {
        return this;
    }
}

