/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.Comparer;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IList;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.ms.System.cv;
import com.aspose.slides.ms.System.i2;
import com.aspose.slides.ms.System.ic;
import com.aspose.slides.ms.System.vm;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class ArrayList
implements IList,
List {
    private Object[] iy;
    private int nk;
    private int et;
    private static Object[] cv = new Object[0];

    protected int getVersion() {
        return this.et;
    }

    public ArrayList() {
        this.iy = new Object[4];
    }

    public ArrayList(ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c", "collection is null");
        }
        this.iy = new Object[c.size()];
        this.addRange(c);
    }

    public ArrayList(int capacity) {
        if (capacity < 0) {
            ArrayList.iy("capacity", (Object)capacity, "The initial capacity can't be smaller than zero.");
        }
        if (capacity == 0) {
            capacity = 4;
        }
        this.iy = new Object[capacity];
    }

    private ArrayList(int initialCapacity, boolean forceZeroSize) {
        if (!forceZeroSize) {
            throw new IllegalStateException("Use ArrayList(int)");
        }
        this.iy = null;
    }

    private ArrayList(cv array, int index, int count) {
        this.iy = count == 0 ? new Object[4] : new Object[count];
        com.aspose.slides.ms.System.cv.iy(array, index, com.aspose.slides.ms.System.cv.iy(this.iy), 0, count);
        this.nk = count;
    }

    @Override
    public Object get_Item(int index) {
        if (index < 0 || index >= this.nk) {
            ArrayList.iy("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        return this.iy[index];
    }

    @Override
    public void set_Item(int index, Object value) {
        if (index < 0 || index >= this.nk) {
            ArrayList.iy("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        this.iy[index] = value;
        ++this.et;
    }

    @Override
    public int size() {
        return this.nk;
    }

    public int getCapacity() {
        return this.iy.length;
    }

    public void setCapacity(int value) {
        if (value < this.nk) {
            ArrayList.iy("Capacity", (Object)value, "Must be more than count.");
        }
        this.iy = value > 0 ? Arrays.copyOf(this.iy, value) : new Object[4];
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    private void iy(int n) {
        int n10;
        if (n <= this.iy.length) {
            return;
        }
        int n11 = n10 = this.iy.length == 0 ? 4 : this.iy.length * 2;
        if (n10 < n) {
            n10 = n;
        }
        this.setCapacity(n10);
    }

    private void iy(int n, int n10) {
        if (n10 > 0) {
            if (this.nk + n10 > this.iy.length) {
                int n11;
                int n12 = n11 = this.iy.length > 0 ? this.iy.length << 1 : 1;
                while (n11 < this.nk + n10) {
                    n11 <<= 1;
                }
                Object[] objectArray = new Object[n11];
                com.aspose.slides.ms.System.cv.iy(this.iy, 0, objectArray, 0, n);
                com.aspose.slides.ms.System.cv.iy(this.iy, n, objectArray, n + n10, this.nk - n);
                this.iy = objectArray;
            } else {
                com.aspose.slides.ms.System.cv.iy(this.iy, n, this.iy, n + n10, this.nk - n);
            }
        } else if (n10 < 0) {
            int n13 = n - n10;
            com.aspose.slides.ms.System.cv.iy(this.iy, n13, this.iy, n, this.nk - n13);
            com.aspose.slides.ms.System.cv.iy(this.iy, this.nk + n10, -n10);
        }
    }

    @Override
    public int addItem(Object value) {
        if (this.iy.length <= this.nk) {
            this.iy(this.nk + 1);
        }
        this.iy[this.nk] = value;
        ++this.et;
        return this.nk++;
    }

    @Override
    public void clear() {
        com.aspose.slides.ms.System.cv.iy(this.iy, 0, this.nk);
        this.nk = 0;
        ++this.et;
    }

    @Override
    public boolean contains(Object item) {
        return this.indexOf(item, 0, this.nk) > -1;
    }

    boolean iy(Object object, int n, int n10) {
        return this.indexOf(object, n, n10) > -1;
    }

    @Override
    public int indexOf(Object value) {
        return this.indexOf(value, 0);
    }

    public int indexOf(Object value, int startIndex) {
        return this.indexOf(value, startIndex, this.nk - startIndex);
    }

    public int indexOf(Object value, int startIndex, int count) {
        if (startIndex < 0 || startIndex > this.nk) {
            ArrayList.iy("startIndex", (Object)startIndex, "Does not specify valid index.");
        }
        if (count < 0) {
            ArrayList.iy("count", (Object)count, "Can't be less than 0.");
        }
        if (startIndex > this.nk - count) {
            throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
        }
        return com.aspose.slides.ms.System.cv.iy(this.iy, value, startIndex, count);
    }

    @Override
    public int lastIndexOf(Object value) {
        return this.lastIndexOf(value, this.nk - 1);
    }

    public int lastIndexOf(Object value, int startIndex) {
        return this.lastIndexOf(value, startIndex, startIndex + 1);
    }

    public int lastIndexOf(Object value, int startIndex, int count) {
        return ic.iy(this.iy, value, startIndex, count);
    }

    @Override
    public void insertItem(int index, Object value) {
        if (index < 0 || index > this.nk) {
            ArrayList.iy("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        this.iy(index, 1);
        this.iy[index] = value;
        ++this.nk;
        ++this.et;
    }

    public void insertRange(int index, ICollection c) {
        int n;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.nk) {
            ArrayList.iy("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n = c.size()) > 0) {
            if (this.iy.length < this.nk + n) {
                this.iy(this.nk + n);
            }
            if (index < this.nk) {
                com.aspose.slides.ms.System.cv.iy(this.iy, index, this.iy, index + n, this.nk - index);
            }
            if (this == c.getSyncRoot()) {
                com.aspose.slides.ms.System.cv.iy(this.iy, 0, this.iy, index, index);
                com.aspose.slides.ms.System.cv.iy(this.iy, index + n, this.iy, index << 1, this.nk - index);
            } else {
                c.copyTo(com.aspose.slides.ms.System.cv.iy(this.iy), index);
            }
            this.nk += c.size();
            ++this.et;
        }
    }

    public void insertRange(int index, Object[] c) {
        int n;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.nk) {
            ArrayList.iy("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n = c.length) > 0) {
            if (this.iy.length < this.nk + n) {
                this.iy(this.nk + n);
            }
            if (index < this.nk) {
                com.aspose.slides.ms.System.cv.iy(this.iy, index, this.iy, index + n, this.nk - index);
            }
            com.aspose.slides.ms.System.cv.iy(c).copyTo(com.aspose.slides.ms.System.cv.iy(this.iy), index);
            this.nk += c.length;
            ++this.et;
        }
    }

    @Override
    public void removeItem(Object obj) {
        int n = this.indexOf(obj);
        if (n > -1) {
            this.removeAt(n);
        }
        ++this.et;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || index >= this.nk) {
            ArrayList.iy("index", (Object)index, "Less than 0 or more than list count.");
        }
        this.iy(index, -1);
        --this.nk;
        ++this.et;
    }

    public void removeRange(int index, int count) {
        ArrayList.iy(index, count, this.nk);
        this.iy(index, -count);
        this.nk -= count;
        ++this.et;
    }

    public void reverse() {
        ic.iy(this.iy, 0, this.nk);
        ++this.et;
    }

    public void reverse(int index, int count) {
        ArrayList.iy(index, count, this.nk);
        ic.iy(this.iy, index, count);
        ++this.et;
    }

    public void copyTo(cv array) {
        com.aspose.slides.ms.System.cv.iy(com.aspose.slides.ms.System.cv.iy(this.iy), 0, array, 0, this.nk);
    }

    @Override
    public void copyTo(cv array, int arrayIndex) {
        this.copyTo(0, array, arrayIndex, this.nk);
    }

    public void copyTo(int index, cv array, int arrayIndex, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.cv() != 1) {
            throw new ArgumentException("Must have only 1 dimensions.", "array");
        }
        com.aspose.slides.ms.System.cv.iy(com.aspose.slides.ms.System.cv.iy(this.iy), index, array, arrayIndex, count);
    }

    @Override
    public IEnumerator iterator() {
        return new SimpleEnumerator(this);
    }

    public IEnumerator iterator(int index, int count) {
        ArrayList.iy(index, count, this.nk);
        return new ArrayListEnumerator(this, index, count);
    }

    public void addRange(ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.nk, c);
    }

    public void addRange(Object[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.nk, collection);
    }

    public int binarySearch(Object value) {
        if (value == null) {
            return -1;
        }
        try {
            return ic.iy(this.iy, 0, this.nk, value);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(Object value, Comparator comparer) {
        try {
            return ic.iy(this.iy, 0, this.nk, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(int index, int count, Object value, Comparator comparer) {
        try {
            return ic.iy(this.iy, index, count, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public ArrayList getRange(int index, int count) {
        ArrayList.iy(index, count, this.nk);
        if (this.isSynchronized()) {
            return ArrayList.sync(new RangedArrayList(this, index, count));
        }
        return new RangedArrayList(this, index, count);
    }

    public void setRange(int index, ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index + c.size() > this.nk) {
            throw new ArgumentOutOfRangeException("index");
        }
        c.copyTo(com.aspose.slides.ms.System.cv.iy(this.iy), index);
        ++this.et;
    }

    public void trimToSize() {
        this.setCapacity(this.nk);
    }

    public void sort() {
        Arrays.sort(this.iy, 0, this.nk, Comparer.Default);
        ++this.et;
    }

    public void sort(Comparator comparer) {
        Arrays.sort(this.iy, 0, this.nk, comparer);
    }

    public void sort(int index, int count, Comparator comparer) {
        ArrayList.iy(index, count, this.nk);
        Arrays.sort(this.iy, index, index + count, comparer);
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.nk];
        this.copyTo(com.aspose.slides.ms.System.cv.iy(objectArray));
        return objectArray;
    }

    public cv toArray(vm type) {
        cv cv2 = com.aspose.slides.ms.System.cv.iy(type, this.nk);
        this.copyTo(cv2);
        return cv2;
    }

    public Object deepClone() {
        return new ArrayList(com.aspose.slides.ms.System.cv.iy(this.iy), 0, this.nk);
    }

    static void iy(int n, int n10, int n11) {
        if (n < 0) {
            ArrayList.iy("index", (Object)n, "Can't be less than 0.");
        }
        if (n10 < 0) {
            ArrayList.iy("count", (Object)n10, "Can't be less than 0.");
        }
        if (n > n11 - n10) {
            throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
        }
    }

    static void iy(String string, Object object, String string2) {
        throw new ArgumentOutOfRangeException(string, object, string2);
    }

    public static ArrayList adapter(IList list) {
        ArrayList arrayList;
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        ArrayList arrayList2 = arrayList = list instanceof ArrayList ? (ArrayList)list : null;
        if (arrayList != null) {
            return arrayList;
        }
        arrayList = new ArrayListAdapter(list);
        if (list.isSynchronized()) {
            return ArrayList.sync(arrayList);
        }
        return arrayList;
    }

    public static ArrayList sync(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new SynchronizedArrayListWrapper(list);
    }

    public static IList sync(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new SynchronizedListWrapper(list);
    }

    public static ArrayList readOnly(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new ReadOnlyArrayListWrapper(list);
    }

    public static IList readOnly(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new ReadOnlyListWrapper(list);
    }

    public static ArrayList fixedSize(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new FixedSizeArrayListWrapper(list);
    }

    public static IList fixedSize(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new FixedSizeListWrapper(list);
    }

    public static ArrayList repeat(Object value, int count) {
        ArrayList arrayList = new ArrayList(count);
        for (int i = 0; i < count; ++i) {
            arrayList.addItem(value);
        }
        return arrayList;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (a.length <= this.size()) {
            a = new Object[this.size()];
        }
        this.copyTo(com.aspose.slides.ms.System.cv.iy(a));
        return a;
    }

    @Override
    public boolean add(Object o) {
        int n = this.size();
        this.addItem(o);
        return this.size() != n;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.size();
        this.removeItem(o);
        return this.size() != n;
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        return this.addAll(this.nk, c);
    }

    public boolean addAll(int index, Collection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = index;
        int n10 = this.size();
        for (Object e : c) {
            this.insertItem(n++, e);
        }
        return n10 != this.size();
    }

    @Override
    public boolean removeAll(Collection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = this.size();
        for (Object e : c) {
            this.removeItem(e);
        }
        return n != this.size();
    }

    @Override
    public boolean retainAll(Collection c) {
        Object[] objectArray;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c.contains(object)) continue;
            this.remove(object);
        }
        return n != this.size();
    }

    public Object get(int index) {
        return this.get_Item(index);
    }

    public Object set(int index, Object element) {
        Object object = this.get_Item(index);
        this.set_Item(index, element);
        return object;
    }

    public void add(int index, Object element) {
        this.insertItem(index, element);
    }

    public Object remove(int index) {
        Object object = this.get_Item(index);
        this.removeAt(index);
        return object;
    }

    public ListIterator listIterator() {
        return new ListItr(0);
    }

    public ListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    public List subList(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        return this.getRange(fromIndex, n);
    }

    public static ArrayList fromJava(List list) {
        if (list == null) {
            return null;
        }
        return new ArrayListInternalized(list);
    }

    public static List toJava(ArrayList list) {
        return list;
    }

    private static class ArrayListInternalized
    extends ArrayList {
        private List iy;
        private int nk;

        @Override
        protected int getVersion() {
            return this.iy instanceof ArrayList ? ((ArrayList)this.iy).getVersion() : this.nk;
        }

        public ArrayListInternalized(List internal) {
            this.iy = internal;
            if (internal instanceof ArrayList) {
                this.nk = ((ArrayList)internal).getVersion();
            }
        }

        @Override
        public Object get_Item(int index) {
            return this.iy.get(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.iy.set(index, value);
            ++this.nk;
        }

        @Override
        public int size() {
            return this.iy.size();
        }

        @Override
        public int getCapacity() {
            return Math.max(super.getCapacity(), this.iy.size());
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.iy.size()) {
                throw new ArgumentOutOfRangeException("Capacity", value, "Must be more than count.");
            }
            for (int i = 0; i < value - this.iy.size(); ++i) {
                this.iy.add(null);
            }
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public int addItem(Object value) {
            int n = this.iy.size();
            this.iy.add(value);
            ++this.nk;
            return n;
        }

        @Override
        public void clear() {
            this.iy.clear();
            ++this.nk;
        }

        @Override
        public boolean contains(Object item) {
            return this.iy.contains(item);
        }

        @Override
        public int indexOf(Object value) {
            return this.iy.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.iy.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.iy.size()) {
                throw new ArgumentOutOfRangeException("startIndex", startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (startIndex > this.iy.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            return com.aspose.slides.ms.System.cv.iy(this.iy.toArray(), value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.iy.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return ic.iy(this.iy.toArray(), value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            if (index < 0 || index > this.iy.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.iy.add(index, value);
            ++this.nk;
        }

        @Override
        public void insertRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.iy.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object e : c) {
                this.iy.add(index++, e);
            }
            ++this.nk;
        }

        @Override
        public void insertRange(int index, Object[] c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.iy.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object object : c) {
                this.iy.add(index++, object);
            }
            ++this.nk;
        }

        @Override
        public void removeItem(Object obj) {
            this.iy.remove(obj);
            ++this.nk;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || index > this.iy.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.iy.remove(index);
            ++this.nk;
        }

        @Override
        public void removeRange(int index, int count) {
            if (index < 0 || index > this.iy.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.iy.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i = 0; i < count; ++i) {
                this.iy.remove(index);
            }
            ++this.nk;
        }

        @Override
        public void reverse() {
            this.reverse(0, this.iy.size());
        }

        @Override
        public void reverse(int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.iy.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            int n = index;
            for (int i = index + this.iy.size() - 1; n < i; ++n, --i) {
                Object e = this.iy.get(n);
                this.iy.set(n, this.iy.get(i));
                this.iy.set(i, e);
            }
            ++this.nk;
        }

        @Override
        public void copyTo(cv array) {
            com.aspose.slides.ms.System.cv.iy(com.aspose.slides.ms.System.cv.iy(this.iy.toArray()), 0, array, 0, this.iy.size());
        }

        @Override
        public void copyTo(cv array, int arrayIndex) {
            this.copyTo(0, array, arrayIndex, this.iy.size());
        }

        @Override
        public void copyTo(int index, cv array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.cv() != 1) {
                throw new ArgumentException("Must have only 1 dimensions.", "array");
            }
            com.aspose.slides.ms.System.cv.iy(com.aspose.slides.ms.System.cv.iy(this.iy.toArray()), index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return new SimpleEnumerator(this);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            ArrayList.iy(index, count, this.iy.size());
            return new ArrayListEnumerator(this, index, count);
        }

        @Override
        public void addRange(ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.size(), c);
        }

        @Override
        public void addRange(Object[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.iy.size(), collection);
        }

        @Override
        public int binarySearch(Object value) {
            if (value == null) {
                return -1;
            }
            try {
                return ic.iy(this.iy.toArray(), 0, this.iy.size(), value);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            try {
                return ic.iy(this.iy.toArray(), 0, this.iy.size(), value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            try {
                return ic.iy(this.iy.toArray(), index, count, value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public ArrayList getRange(int index, int count) {
            ArrayList.iy(index, count, this.iy.size());
            if (this.isSynchronized()) {
                return ArrayList.sync(new RangedArrayList(this, index, count));
            }
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void setRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c.size() > this.iy.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            for (Object e : c) {
                this.iy.set(index++, e);
            }
            ++this.nk;
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            Collections.sort(this.iy, null);
            ++this.nk;
        }

        @Override
        public void sort(Comparator comparer) {
            Collections.sort(this.iy, comparer);
            ++this.nk;
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.iy.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            List list = this.iy.subList(index, count);
            if (comparer == null) {
                Collections.sort(list);
            } else {
                Collections.sort(list, comparer);
            }
            for (int i = index; i < count; ++i) {
                this.iy.set(i, list.get(i - index));
            }
            ++this.nk;
        }

        @Override
        public Object[] toArray() {
            return this.iy.toArray();
        }

        @Override
        public cv toArray(vm type) {
            cv cv2 = com.aspose.slides.ms.System.cv.iy(type, this.iy.size());
            this.copyTo(cv2);
            return cv2;
        }

        @Override
        public Object deepClone() {
            Object[] objectArray = new Object[this.iy.size()];
            com.aspose.slides.ms.System.cv.iy(this.iy.toArray(), 0, objectArray, 0, this.iy.size());
            java.util.ArrayList arrayList = new java.util.ArrayList();
            arrayList.addAll(arrayList);
            return new ArrayListInternalized(arrayList);
        }

        @Override
        public boolean isEmpty() {
            return this.iy.size() == 0;
        }

        @Override
        public Object[] toArray(Object[] a) {
            return this.iy.toArray(a);
        }

        @Override
        public boolean add(Object o) {
            ++this.nk;
            return this.iy.add(o);
        }

        @Override
        public boolean remove(Object o) {
            ++this.nk;
            return this.iy.remove(o);
        }

        @Override
        public boolean containsAll(Collection c) {
            return this.iy.containsAll(c);
        }

        @Override
        public boolean addAll(Collection c) {
            ++this.nk;
            return this.iy.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection c) {
            ++this.nk;
            return this.iy.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection c) {
            ++this.nk;
            return this.iy.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection c) {
            ++this.nk;
            return this.iy.retainAll(c);
        }

        @Override
        public Object get(int index) {
            return this.iy.get(index);
        }

        @Override
        public Object set(int index, Object element) {
            ++this.nk;
            return this.iy.set(index, element);
        }

        @Override
        public void add(int index, Object element) {
            this.iy.add(index, element);
            ++this.nk;
        }

        @Override
        public Object remove(int index) {
            ++this.nk;
            return this.iy.remove(index);
        }

        @Override
        public ListIterator listIterator() {
            return this.iy.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.iy.listIterator(index);
        }

        @Override
        public List subList(int fromIndex, int toIndex) {
            return this.iy.subList(fromIndex, toIndex);
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.iy = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.iy != 0;
        }

        @Override
        public int nextIndex() {
            return this.iy;
        }

        @Override
        public int previousIndex() {
            return this.iy - 1;
        }

        public Object previous() {
            int n = this.iy - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.iy;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.iy = n;
            this.nk = n;
            return objectArray[this.nk];
        }

        public void set(Object e) {
            if (this.nk < 0) {
                throw new IllegalStateException();
            }
            try {
                ((ArrayList)ArrayList.this).iy[this.nk] = e;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object e) {
            try {
                int n = this.iy;
                ArrayList.this.add(n, e);
                this.iy = n + 1;
                this.nk = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator {
        int iy;
        int nk = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.iy != ArrayList.this.size();
        }

        public Object next() {
            int n = this.iy;
            if (n >= ArrayList.this.size()) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.iy;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.iy = n + 1;
            this.nk = n;
            return objectArray[this.nk];
        }

        @Override
        public void remove() {
            if (this.nk < 0) {
                throw new IllegalStateException();
            }
            try {
                ArrayList.this.remove(this.nk);
                this.iy = this.nk;
                this.nk = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class ListWrapper
    implements IList {
        protected IList iy;

        public ListWrapper(IList innerList) {
            this.iy = innerList;
        }

        @Override
        public Object get_Item(int index) {
            return this.iy.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.iy.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.iy.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.iy.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.iy.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.iy.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.iy.isReadOnly();
        }

        @Override
        public int addItem(Object value) {
            return this.iy.addItem(value);
        }

        @Override
        public void clear() {
            this.iy.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.iy.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.iy.indexOf(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.iy.insertItem(index, value);
        }

        @Override
        public void removeItem(Object value) {
            this.iy.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.iy.removeAt(index);
        }

        @Override
        public void copyTo(cv array, int index) {
            this.iy.copyTo(array, index);
        }

        @Override
        public IEnumerator iterator() {
            return this.iy.iterator();
        }
    }

    private static final class ReadOnlyListWrapper
    extends FixedSizeListWrapper {
        @Override
        protected String iy() {
            return "List is read-only.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public ReadOnlyListWrapper(IList innerList) {
            super(innerList);
        }

        @Override
        public Object get_Item(int index) {
            return this.iy.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.iy());
        }
    }

    private static class FixedSizeListWrapper
    extends ListWrapper {
        protected String iy() {
            return "List is fixed-size.";
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        public FixedSizeListWrapper(IList innerList) {
            super(innerList);
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.iy());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.iy());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.iy());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.iy());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.iy());
        }
    }

    private static final class SynchronizedListWrapper
    extends ListWrapper {
        private final Object nk;

        public SynchronizedListWrapper(IList innerList) {
            super(innerList);
            this.nk = innerList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getSyncRoot() {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.getSyncRoot();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.isReadOnly();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.nk;
            synchronized (object) {
                this.iy.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.nk;
            synchronized (object) {
                this.iy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.nk;
            synchronized (object) {
                this.iy.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.nk;
            synchronized (object) {
                this.iy.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.nk;
            synchronized (object) {
                this.iy.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(cv array, int index) {
            Object object = this.nk;
            synchronized (object) {
                this.iy.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.iterator();
            }
        }
    }

    private static final class RangedArrayList
    extends ArrayListWrapper {
        private int nk;
        private int et;
        private int cv;

        public RangedArrayList(ArrayList innerList, int index, int count) {
            super(innerList);
            this.nk = index;
            this.et = count;
            this.cv = innerList.getVersion();
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object get_Item(int index) {
            if (index < 0 || index > this.et) {
                throw new ArgumentOutOfRangeException("index");
            }
            return this.iy.get_Item(this.nk + index);
        }

        @Override
        public void set_Item(int index, Object value) {
            if (index < 0 || index > this.et) {
                throw new ArgumentOutOfRangeException("index");
            }
            this.iy.set_Item(this.nk + index, value);
        }

        @Override
        public int size() {
            this.iy();
            return this.et;
        }

        @Override
        public int getCapacity() {
            return this.iy.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.et) {
                throw new ArgumentOutOfRangeException();
            }
        }

        private void iy() {
            if (this.cv != this.iy.getVersion()) {
                throw new IllegalStateException("ArrayList view is invalid because the underlying ArrayList was modified.");
            }
        }

        @Override
        public int addItem(Object value) {
            this.iy();
            this.iy.insertItem(this.nk + this.et, value);
            this.cv = this.iy.getVersion();
            return ++this.et;
        }

        @Override
        public void clear() {
            this.iy();
            this.iy.removeRange(this.nk, this.et);
            this.et = 0;
            this.cv = this.iy.getVersion();
        }

        @Override
        public boolean contains(Object value) {
            return this.iy.iy(value, this.nk, this.et);
        }

        @Override
        public int indexOf(Object value) {
            return this.indexOf(value, 0);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.et - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.et) {
                RangedArrayList.iy("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                RangedArrayList.iy("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.et - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            int n = this.iy.indexOf(value, this.nk + startIndex, count);
            if (n == -1) {
                return -1;
            }
            return n - this.nk;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.et - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            int n;
            if (startIndex < 0) {
                RangedArrayList.iy("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                RangedArrayList.iy("count", (Object)count, "count is negative.");
            }
            if ((n = this.iy.lastIndexOf(value, this.nk + startIndex, count)) == -1) {
                return -1;
            }
            return n - this.nk;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.iy();
            if (index < 0 || index > this.et) {
                RangedArrayList.iy("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.iy.insertItem(this.nk + index, value);
            ++this.et;
            this.cv = this.iy.getVersion();
        }

        @Override
        public void insertRange(int index, ICollection c) {
            this.iy();
            if (index < 0 || index > this.et) {
                RangedArrayList.iy("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.iy.insertRange(this.nk + index, c);
            this.et += c.size();
            this.cv = this.iy.getVersion();
        }

        @Override
        public void removeItem(Object value) {
            this.iy();
            int n = this.indexOf(value);
            if (n > -1) {
                this.removeAt(n);
            }
            this.cv = this.iy.getVersion();
        }

        @Override
        public void removeAt(int index) {
            this.iy();
            if (index < 0 || index > this.et) {
                RangedArrayList.iy("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.iy.removeAt(this.nk + index);
            --this.et;
            this.cv = this.iy.getVersion();
        }

        @Override
        public void removeRange(int index, int count) {
            this.iy();
            RangedArrayList.iy(index, count, this.et);
            this.iy.removeRange(this.nk + index, count);
            this.et -= count;
            this.cv = this.iy.getVersion();
        }

        @Override
        public void reverse() {
            this.reverse(0, this.et);
        }

        @Override
        public void reverse(int index, int count) {
            this.iy();
            RangedArrayList.iy(index, count, this.et);
            this.iy.reverse(this.nk + index, count);
            this.cv = this.iy.getVersion();
        }

        @Override
        public void setRange(int index, ICollection c) {
            this.iy();
            if (index < 0 || index > this.et) {
                RangedArrayList.iy("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.iy.setRange(this.nk + index, c);
            this.cv = this.iy.getVersion();
        }

        @Override
        public void copyTo(cv array) {
            this.copyTo(array, 0);
        }

        @Override
        public void copyTo(cv array, int index) {
            this.copyTo(0, array, index, this.et);
        }

        @Override
        public void copyTo(int index, cv array, int arrayIndex, int count) {
            RangedArrayList.iy(index, count, this.et);
            this.iy.copyTo(this.nk + index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.iterator(0, this.et);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            RangedArrayList.iy(index, count, this.et);
            return this.iy.iterator(this.nk + index, count);
        }

        @Override
        public void addRange(ICollection c) {
            this.iy();
            this.iy.insertRange(this.et, c);
            this.et += c.size();
            this.cv = this.iy.getVersion();
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(0, this.et, value, Comparer.Default);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.et, value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            RangedArrayList.iy(index, count, this.et);
            return this.iy.binarySearch(this.nk + index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return new RangedArrayList((ArrayList)this.iy.deepClone(), this.nk, this.et);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            RangedArrayList.iy(index, count, this.et);
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException();
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.et, comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.iy();
            RangedArrayList.iy(index, count, this.et);
            this.iy.sort(this.nk + index, count, comparer);
            this.cv = this.iy.getVersion();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.et];
            this.iy.copyTo(this.nk, com.aspose.slides.ms.System.cv.iy(objectArray), 0, this.et);
            return objectArray;
        }

        @Override
        public cv toArray(vm elementType) {
            cv cv2 = com.aspose.slides.ms.System.cv.iy(elementType, this.et);
            this.iy.copyTo(this.nk, cv2, 0, this.et);
            return cv2;
        }
    }

    private static final class ReadOnlyArrayListWrapper
    extends FixedSizeArrayListWrapper {
        @Override
        protected String iy() {
            return "Can't modify a readonly list.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public ReadOnlyArrayListWrapper(ArrayList innerArrayList) {
            super(innerArrayList);
        }

        @Override
        public Object get_Item(int index) {
            return this.iy.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.iy());
        }

        @Override
        public void reverse() {
            throw new NotSupportedException(this.iy());
        }

        @Override
        public void reverse(int index, int count) {
            throw new NotSupportedException(this.iy());
        }

        @Override
        public void setRange(int index, ICollection c) {
            throw new NotSupportedException(this.iy());
        }

        @Override
        public void sort() {
            throw new NotSupportedException(this.iy());
        }

        @Override
        public void sort(Comparator comparer) {
            throw new NotSupportedException(this.iy());
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            throw new NotSupportedException(this.iy());
        }
    }

    private static class FixedSizeArrayListWrapper
    extends ArrayListWrapper {
        public FixedSizeArrayListWrapper(ArrayList innerList) {
            super(innerList);
        }

        protected String iy() {
            return "Can't add or remove from a fixed-size list.";
        }

        @Override
        public int getCapacity() {
            return super.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            throw new NotSupportedException(this.iy());
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.iy());
        }

        @Override
        public void addRange(ICollection c) {
            throw new NotSupportedException(this.iy());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.iy());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.iy());
        }

        @Override
        public void insertRange(int index, ICollection c) {
            throw new NotSupportedException(this.iy());
        }

        @Override
        public void insertRange(int index, Object[] c) {
            throw new NotSupportedException(this.iy());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.iy());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.iy());
        }

        @Override
        public void removeRange(int index, int count) {
            throw new NotSupportedException(this.iy());
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException(this.iy());
        }
    }

    private static final class SynchronizedArrayListWrapper
    extends ArrayListWrapper {
        private final Object nk;

        SynchronizedArrayListWrapper(ArrayList innerArrayList) {
            super(innerArrayList);
            this.nk = innerArrayList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.nk;
            synchronized (object) {
                this.iy.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.nk;
            synchronized (object) {
                this.iy.setCapacity(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.isReadOnly();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.nk;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.nk;
            synchronized (object) {
                this.iy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex) {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.indexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex, int count) {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.indexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value) {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.lastIndexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex) {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.lastIndexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.lastIndexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.nk;
            synchronized (object) {
                this.iy.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertRange(int index, ICollection c) {
            Object object = this.nk;
            synchronized (object) {
                this.iy.insertRange(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.nk;
            synchronized (object) {
                this.iy.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.nk;
            synchronized (object) {
                this.iy.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeRange(int index, int count) {
            Object object = this.nk;
            synchronized (object) {
                this.iy.removeRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse() {
            Object object = this.nk;
            synchronized (object) {
                this.iy.reverse();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse(int index, int count) {
            Object object = this.nk;
            synchronized (object) {
                this.iy.reverse(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(cv array) {
            Object object = this.nk;
            synchronized (object) {
                this.iy.copyTo(array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(cv array, int index) {
            Object object = this.nk;
            synchronized (object) {
                this.iy.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(int index, cv array, int arrayIndex, int count) {
            Object object = this.nk;
            synchronized (object) {
                this.iy.copyTo(index, array, arrayIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator(int index, int count) {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.iterator(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addRange(ICollection c) {
            Object object = this.nk;
            synchronized (object) {
                this.iy.addRange(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value) {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.binarySearch(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value, Comparator comparer) {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.binarySearch(value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.binarySearch(index, count, value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArrayList getRange(int index, int count) {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.getRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.nk;
            synchronized (object) {
                this.iy.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort() {
            Object object = this.nk;
            synchronized (object) {
                this.iy.sort();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(Comparator comparer) {
            Object object = this.nk;
            synchronized (object) {
                this.iy.sort(comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(int index, int count, Comparator comparer) {
            Object object = this.nk;
            synchronized (object) {
                this.iy.sort(index, count, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public cv toArray(vm elementType) {
            Object object = this.nk;
            synchronized (object) {
                return this.iy.toArray(elementType);
            }
        }
    }

    private static class ArrayListWrapper
    extends ArrayList {
        protected ArrayList iy;

        public ArrayListWrapper(ArrayList innerArrayList) {
            this.iy = innerArrayList;
        }

        @Override
        public Object get_Item(int index) {
            return this.iy.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.iy.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.iy.size();
        }

        @Override
        public int getCapacity() {
            return this.iy.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            this.iy.setCapacity(value);
        }

        @Override
        public boolean isFixedSize() {
            return this.iy.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.iy.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return this.iy.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.iy.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.iy.addItem(value);
        }

        @Override
        public void clear() {
            this.iy.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.iy.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.iy.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.iy.indexOf(value, startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            return this.iy.indexOf(value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.iy.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.iy.lastIndexOf(value, startIndex);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return this.iy.lastIndexOf(value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.iy.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c) {
            this.iy.insertRange(index, c);
        }

        @Override
        public void removeItem(Object value) {
            this.iy.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.iy.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            this.iy.removeRange(index, count);
        }

        @Override
        public void reverse() {
            this.iy.reverse();
        }

        @Override
        public void reverse(int index, int count) {
            this.iy.reverse(index, count);
        }

        @Override
        public void setRange(int index, ICollection c) {
            this.iy.setRange(index, c);
        }

        @Override
        public void copyTo(cv array) {
            this.iy.copyTo(array);
        }

        @Override
        public void copyTo(cv array, int index) {
            this.iy.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, cv array, int arrayIndex, int count) {
            this.iy.copyTo(index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.iy.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            return this.iy.iterator(index, count);
        }

        @Override
        public void addRange(ICollection c) {
            this.iy.addRange(c);
        }

        @Override
        public int binarySearch(Object value) {
            return this.iy.binarySearch(value);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.iy.binarySearch(value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            return this.iy.binarySearch(index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return this.iy.deepClone();
        }

        @Override
        public ArrayList getRange(int index, int count) {
            return this.iy.getRange(index, count);
        }

        @Override
        public void trimToSize() {
            this.iy.trimToSize();
        }

        @Override
        public void sort() {
            this.iy.sort();
        }

        @Override
        public void sort(Comparator comparer) {
            this.iy.sort(comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.iy.sort(index, count, comparer);
        }

        @Override
        public Object[] toArray() {
            return this.iy.toArray();
        }

        @Override
        public cv toArray(vm elementType) {
            return this.iy.toArray(elementType);
        }
    }

    private static final class ArrayListAdapter
    extends ArrayList {
        private IList iy;

        public ArrayListAdapter(IList adaptee) {
            super(0, true);
            this.iy = adaptee;
        }

        @Override
        public Object get_Item(int index) {
            return this.iy.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.iy.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.iy.size();
        }

        @Override
        public int getCapacity() {
            return this.iy.size();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.iy.size()) {
                throw new ArgumentException("capacity");
            }
        }

        @Override
        public boolean isFixedSize() {
            return this.iy.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.iy.isReadOnly();
        }

        @Override
        public Object getSyncRoot() {
            return this.iy.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.iy.addItem(value);
        }

        @Override
        public void clear() {
            this.iy.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.iy.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.iy.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.iy.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.iy.size()) {
                ArrayListAdapter.iy("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                ArrayListAdapter.iy("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.iy.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            if (value == null) {
                for (int i = startIndex; i < startIndex + count; ++i) {
                    if (this.iy.get_Item(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = startIndex; i < startIndex + count; ++i) {
                    if (!value.equals(this.iy.get_Item(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.iy.size() - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            if (startIndex < 0) {
                ArrayListAdapter.iy("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                ArrayListAdapter.iy("count", (Object)count, "count is negative.");
            }
            if (startIndex - count + 1 < 0) {
                ArrayListAdapter.iy("count", (Object)count, "count is too large.");
            }
            if (value == null) {
                for (int i = startIndex; i > startIndex - count; --i) {
                    if (this.iy.get_Item(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = startIndex; i > startIndex - count; --i) {
                    if (!value.equals(this.iy.get_Item(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.iy.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index > this.iy.size()) {
                ArrayListAdapter.iy("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            for (Object e : c) {
                this.iy.insertItem(index++, e);
            }
        }

        @Override
        public void removeItem(Object value) {
            this.iy.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.iy.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            ArrayListAdapter.iy(index, count, this.iy.size());
            for (int i = 0; i < count; ++i) {
                this.iy.removeAt(index);
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.iy.size());
        }

        @Override
        public void reverse(int index, int count) {
            ArrayListAdapter.iy(index, count, this.iy.size());
            for (int i = 0; i < count / 2; ++i) {
                Object object = this.iy.get_Item(i + index);
                this.iy.set_Item(i + index, this.iy.get_Item(index + count - i + index - 1));
                this.iy.set_Item(index + count - i + index - 1, object);
            }
        }

        @Override
        public void setRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c.size() > this.iy.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            int n = index;
            for (Object e : c) {
                this.iy.set_Item(n++, e);
            }
        }

        @Override
        public void copyTo(cv array) {
            this.iy.copyTo(array, 0);
        }

        @Override
        public void copyTo(cv array, int index) {
            this.iy.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, cv array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (index < 0) {
                ArrayListAdapter.iy("index", (Object)index, "Can't be less than zero.");
            }
            if (arrayIndex < 0) {
                ArrayListAdapter.iy("arrayIndex", (Object)arrayIndex, "Can't be less than zero.");
            }
            if (count < 0) {
                ArrayListAdapter.iy("index", (Object)index, "Can't be less than zero.");
            }
            if (array.cv() > 1) {
                throw new ArgumentException("Can't copy into multi-dimensional array.");
            }
            if (array.lg() - arrayIndex < count) {
                throw new ArgumentException("Destination array is too small.");
            }
            if (index > this.iy.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i = 0; i < count; ++i) {
                array.et(this.iy.get_Item(index + i), arrayIndex + i);
            }
        }

        @Override
        public boolean isSynchronized() {
            return this.iy.isSynchronized();
        }

        @Override
        public IEnumerator iterator() {
            return this.iy.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            ArrayListAdapter.iy(index, count, this.iy.size());
            return new EnumeratorWithRange(this.iy.iterator(), index, count);
        }

        @Override
        public void addRange(ICollection c) {
            for (Object e : c) {
                this.iy.addItem(e);
            }
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(value, null);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.iy.size(), value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            ArrayListAdapter.iy(index, count, this.iy.size());
            if (comparer == null) {
                comparer = Comparer.Default;
            }
            int n = index;
            int n10 = index + count - 1;
            while (n <= n10) {
                int n11;
                int n12 = n + (n10 - n) / 2;
                try {
                    n11 = comparer.compare(value, this.iy.get_Item(n12));
                }
                catch (Exception exception) {
                    throw new InvalidOperationException("value is not of the same type", exception);
                }
                if (n11 < 0) {
                    n10 = n12 - 1;
                    continue;
                }
                if (n11 > 0) {
                    n = n12 + 1;
                    continue;
                }
                return n12;
            }
            return ~n;
        }

        @Override
        public Object deepClone() {
            return new ArrayListAdapter(this.iy);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            ArrayListAdapter.iy(index, count, this.iy.size());
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.iy.size(), comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            ArrayListAdapter.iy(index, count, this.iy.size());
            if (comparer == null) {
                comparer = Comparer.Default;
            }
            ArrayListAdapter.iy(this.iy, index, index + count - 1, comparer);
        }

        private static void iy(IList iList, int n, int n10) {
            Object object = iList.get_Item(n);
            iList.set_Item(n, iList.get_Item(n10));
            iList.set_Item(n10, object);
        }

        static void iy(IList iList, int n, int n10, Comparator comparator) {
            if (n >= n10) {
                return;
            }
            int n11 = n + (n10 - n) / 2;
            if (comparator.compare(iList.get_Item(n11), iList.get_Item(n)) < 0) {
                ArrayListAdapter.iy(iList, n11, n);
            }
            if (comparator.compare(iList.get_Item(n10), iList.get_Item(n)) < 0) {
                ArrayListAdapter.iy(iList, n10, n);
            }
            if (comparator.compare(iList.get_Item(n10), iList.get_Item(n11)) < 0) {
                ArrayListAdapter.iy(iList, n10, n11);
            }
            if (n10 - n + 1 <= 3) {
                return;
            }
            ArrayListAdapter.iy(iList, n10 - 1, n11);
            Object object = iList.get_Item(n10 - 1);
            int n12 = n;
            int n13 = n10 - 1;
            while (true) {
                if (comparator.compare(iList.get_Item(++n12), object) < 0) {
                    continue;
                }
                while (comparator.compare(iList.get_Item(--n13), object) > 0) {
                }
                if (n12 >= n13) break;
                ArrayListAdapter.iy(iList, n12, n13);
            }
            ArrayListAdapter.iy(iList, n10 - 1, n12);
            ArrayListAdapter.iy(iList, n, n12 - 1, comparator);
            ArrayListAdapter.iy(iList, n12 + 1, n10, comparator);
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.iy.size()];
            this.iy.copyTo(com.aspose.slides.ms.System.cv.iy(objectArray), 0);
            return objectArray;
        }

        @Override
        public cv toArray(vm elementType) {
            cv cv2 = com.aspose.slides.ms.System.cv.iy(elementType, this.iy.size());
            this.iy.copyTo(cv2, 0);
            return cv2;
        }

        private static final class EnumeratorWithRange
        implements IEnumerator,
        i2,
        Cloneable {
            private int iy;
            private int nk;
            private int et;
            private IEnumerator cv;

            private EnumeratorWithRange() {
            }

            public EnumeratorWithRange(IEnumerator enumerator, int index, int count) {
                this.nk = 0;
                this.iy = index;
                this.et = count;
                this.cv = enumerator;
                this.reset();
            }

            @Override
            public Object deepClone() {
                return this.iy();
            }

            @Override
            public Object next() {
                return this.cv.next();
            }

            @Override
            public boolean hasNext() {
                if (this.nk >= this.et) {
                    return false;
                }
                ++this.nk;
                return this.cv.hasNext();
            }

            @Override
            public void reset() {
                this.nk = 0;
                this.cv.reset();
                for (int i = 0; i < this.iy; ++i) {
                    this.cv.hasNext();
                }
            }

            protected Object iy() {
                try {
                    return this.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new IllegalStateException(cloneNotSupportedException);
                }
            }

            protected Object clone() throws CloneNotSupportedException {
                EnumeratorWithRange enumeratorWithRange = new EnumeratorWithRange();
                enumeratorWithRange.iy = this.iy;
                enumeratorWithRange.nk = this.nk;
                enumeratorWithRange.et = this.et;
                enumeratorWithRange.cv = this.cv;
                return enumeratorWithRange;
            }

            @Override
            public void remove() {
                throw new NotSupportedException();
            }
        }
    }

    static final class SimpleEnumerator
    implements IEnumerator,
    i2,
    Cloneable {
        private ArrayList nk;
        private Object et;
        private int cv;
        private int lg;
        static Object iy = new Object();

        private SimpleEnumerator() {
        }

        public SimpleEnumerator(ArrayList list) {
            this.nk = list;
            this.cv = -1;
            this.lg = list.getVersion();
            this.et = iy;
        }

        @Override
        public Object deepClone() {
            return this.iy();
        }

        @Override
        public boolean hasNext() {
            if (this.lg != this.nk.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            if (++this.cv < this.nk.size()) {
                this.et = this.nk.get_Item(this.cv);
                return true;
            }
            this.et = iy;
            return false;
        }

        @Override
        public Object next() {
            if (this.et == iy) {
                if (this.cv == -1) {
                    throw new IllegalStateException("Enumerator not started");
                }
                throw new IllegalStateException("Enumerator ended");
            }
            return this.et;
        }

        @Override
        public void reset() {
            if (this.lg != this.nk.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            this.et = iy;
            this.cv = -1;
        }

        protected Object iy() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            SimpleEnumerator simpleEnumerator = new SimpleEnumerator();
            simpleEnumerator.nk = this.nk;
            simpleEnumerator.et = this.et;
            simpleEnumerator.cv = this.cv;
            simpleEnumerator.lg = this.lg;
            return simpleEnumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class ArrayListEnumerator
    implements IEnumerator,
    i2,
    Cloneable {
        private Object iy;
        private ArrayList nk;
        private int et;
        private int cv;
        private int lg;
        private int n2;

        private ArrayListEnumerator() {
        }

        @Override
        public Object deepClone() {
            return this.iy();
        }

        public ArrayListEnumerator(ArrayList list, int index, int count) {
            this.nk = list;
            this.cv = index;
            this.lg = count;
            this.et = this.cv - 1;
            this.iy = null;
            this.n2 = list.getVersion();
        }

        @Override
        public Object next() {
            if (this.et == this.cv - 1) {
                throw new IllegalStateException("Enumerator unusable (Reset pending, or past end of array.");
            }
            return this.iy;
        }

        @Override
        public boolean hasNext() {
            if (this.nk.getVersion() != this.n2) {
                throw new IllegalStateException("List has changed.");
            }
            ++this.et;
            if (this.et - this.cv < this.lg) {
                this.iy = this.nk.get_Item(this.et);
                return true;
            }
            return false;
        }

        @Override
        public void reset() {
            this.iy = null;
            this.et = this.cv - 1;
        }

        protected Object iy() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            ArrayListEnumerator arrayListEnumerator = new ArrayListEnumerator();
            arrayListEnumerator.iy = this.iy;
            arrayListEnumerator.nk = this.nk;
            arrayListEnumerator.et = this.et;
            arrayListEnumerator.cv = this.cv;
            arrayListEnumerator.lg = this.lg;
            arrayListEnumerator.n2 = this.n2;
            return arrayListEnumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }
}

