/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.cv;
import com.aspose.slides.ms.System.i2;

public final class BitArray
implements ICollection,
i2 {
    private int[] iy;
    private int nk;
    private int et = 0;

    public BitArray(BitArray bits) {
        if (bits == null) {
            throw new ArgumentNullException("bits");
        }
        this.nk = bits.nk;
        this.iy = new int[(this.nk + 31) / 32];
        if (this.iy.length == 1) {
            this.iy[0] = bits.iy[0];
        } else {
            cv.iy(bits.iy, 0, this.iy, 0, this.iy.length);
        }
    }

    public BitArray(boolean[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        this.nk = values.length;
        this.iy = new int[(this.nk + 31) / 32];
        for (int i = 0; i < values.length; ++i) {
            this.set_Item(i, values[i]);
        }
    }

    public BitArray(byte[] bytes) {
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        this.nk = bytes.length * 8;
        this.iy = new int[(this.nk + 31) / 32];
        for (int i = 0; i < bytes.length; ++i) {
            this.iy(i, bytes[i]);
        }
    }

    public BitArray(int[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        int n = values.length;
        this.nk = n * 32;
        this.iy = new int[n];
        cv.iy(values, 0, this.iy, 0, n);
    }

    public BitArray(int length) {
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length");
        }
        this.nk = length;
        this.iy = new int[(this.nk + 31) / 32];
    }

    public BitArray(int length, boolean defaultValue) {
        this(length);
        if (defaultValue) {
            for (int i = 0; i < this.iy.length; ++i) {
                this.iy[i] = -1;
            }
        }
    }

    private byte iy(int n) {
        int n10 = n / 4;
        int n11 = n % 4 * 8;
        int n12 = this.iy[n10] & 255 << n11;
        return (byte)(n12 >> n11 & 0xFF);
    }

    private void iy(int n, byte by2) {
        int n10 = n / 4;
        int n11 = n % 4 * 8;
        int n12 = n10;
        this.iy[n12] = this.iy[n12] & ~(255 << n11);
        int n13 = n10;
        this.iy[n13] = this.iy[n13] | (by2 & 0xFF) << n11;
        ++this.et;
    }

    private void nk(BitArray bitArray) {
        if (bitArray == null) {
            throw new ArgumentNullException();
        }
        if (bitArray.nk != this.nk) {
            throw new ArgumentException();
        }
    }

    @Override
    public int size() {
        return this.nk;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    public boolean get_Item(int index) {
        return this.get(index);
    }

    public void set_Item(int index, boolean value) {
        this.set(index, value);
    }

    public int getLength() {
        return this.nk;
    }

    public void setLength(int value) {
        if (this.nk == value) {
            return;
        }
        if (value < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (value > this.nk) {
            int n = (value + 31) / 32;
            int n10 = (this.nk + 31) / 32;
            if (n > this.iy.length) {
                int[] nArray = new int[n];
                cv.iy(this.iy, 0, nArray, 0, this.iy.length);
                this.iy = nArray;
            } else {
                cv.iy(cv.iy((Object)this.iy), n10, n - n10);
            }
            int n11 = this.nk % 32;
            if (n11 > 0) {
                int n12 = n10 - 1;
                this.iy[n12] = this.iy[n12] & (1 << n11) - 1;
            }
        }
        this.nk = value;
        ++this.et;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public Object deepClone() {
        return new BitArray(this);
    }

    @Override
    public void copyTo(cv array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.cv() != 1) {
            throw new ArgumentException("array", "Array rank must be 1");
        }
        if (index >= array.lg() && this.nk > 0) {
            throw new ArgumentException("index", "index is greater than array.Length");
        }
        Object object = cv.iy(array);
        if (object instanceof Boolean[]) {
            if (array.lg() - index < this.nk) {
                throw new ArgumentException();
            }
            Boolean[] booleanArray = (Boolean[])object;
            for (int i = 0; i < this.nk; ++i) {
                booleanArray[index + i] = this.get_Item(i);
            }
        } else if (object instanceof boolean[]) {
            if (array.lg() - index < this.nk) {
                throw new ArgumentException();
            }
            boolean[] blArray = (boolean[])object;
            for (int i = 0; i < this.nk; ++i) {
                blArray[index + i] = this.get_Item(i);
            }
        } else if (object instanceof Byte[]) {
            int n = (this.nk + 7) / 8;
            if (array.lg() - index < n) {
                throw new ArgumentException();
            }
            Byte[] byteArray = (Byte[])object;
            for (int i = 0; i < n; ++i) {
                byteArray[index + i] = this.iy(i);
            }
        } else if (object instanceof byte[]) {
            int n = (this.nk + 7) / 8;
            if (array.lg() - index < n) {
                throw new ArgumentException();
            }
            byte[] byArray = (byte[])object;
            for (int i = 0; i < n; ++i) {
                byArray[index + i] = this.iy(i);
            }
        } else if (object instanceof Integer[]) {
            cv.iy(cv.iy((Object)this.iy), 0, array, index, (this.nk + 31) / 32);
        } else if (object instanceof int[]) {
            cv.iy(cv.iy((Object)this.iy), 0, array, index, (this.nk + 31) / 32);
        } else {
            throw new ArgumentException("array", "Unsupported type");
        }
    }

    public BitArray not() {
        int n = (this.nk + 31) / 32;
        for (int i = 0; i < n; ++i) {
            this.iy[i] = ~this.iy[i];
        }
        ++this.et;
        return this;
    }

    public BitArray and(BitArray value) {
        this.nk(value);
        int n = (this.nk + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.iy[n10] = this.iy[n10] & value.iy[i];
        }
        ++this.et;
        return this;
    }

    public BitArray or(BitArray value) {
        this.nk(value);
        int n = (this.nk + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.iy[n10] = this.iy[n10] | value.iy[i];
        }
        ++this.et;
        return this;
    }

    public BitArray xor(BitArray value) {
        this.nk(value);
        int n = (this.nk + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.iy[n10] = this.iy[n10] ^ value.iy[i];
        }
        ++this.et;
        return this;
    }

    public boolean get(int index) {
        if (index < 0 || index >= this.nk) {
            throw new ArgumentOutOfRangeException();
        }
        return (this.iy[index >> 5] & 1 << (index & 0x1F)) != 0;
    }

    public void set(int index, boolean value) {
        if (index < 0 || index >= this.nk) {
            throw new ArgumentOutOfRangeException();
        }
        if (value) {
            int n = index >> 5;
            this.iy[n] = this.iy[n] | 1 << (index & 0x1F);
        } else {
            int n = index >> 5;
            this.iy[n] = this.iy[n] & ~(1 << (index & 0x1F));
        }
        ++this.et;
    }

    public void setAll(boolean value) {
        if (value) {
            for (int i = 0; i < this.iy.length; ++i) {
                this.iy[i] = -1;
            }
        } else {
            cv.iy(cv.iy((Object)this.iy), 0, this.iy.length);
        }
        ++this.et;
    }

    @Override
    public IEnumerator iterator() {
        return new BitArrayEnumerator(this);
    }

    private static class BitArrayEnumerator
    implements IEnumerator,
    i2,
    Cloneable {
        private BitArray iy;
        private boolean nk;
        private int et;
        private int cv;

        @Override
        public Object deepClone() {
            return this.iy();
        }

        private BitArrayEnumerator() {
        }

        public BitArrayEnumerator(BitArray ba2) {
            this.et = -1;
            this.iy = ba2;
            this.cv = ba2.et;
        }

        @Override
        public Object next() {
            if (this.et == -1) {
                throw new InvalidOperationException("Enum not started");
            }
            if (this.et >= this.iy.size()) {
                throw new InvalidOperationException("Enum Ended");
            }
            return this.nk;
        }

        @Override
        public boolean hasNext() {
            this.nk();
            if (this.et < this.iy.size() - 1) {
                this.nk = this.iy.get_Item(++this.et);
                return true;
            }
            this.et = this.iy.size();
            return false;
        }

        @Override
        public void reset() {
            this.nk();
            this.et = -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        private void nk() {
            if (this.cv != this.iy.et) {
                throw new InvalidOperationException();
            }
        }

        protected Object iy() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            BitArrayEnumerator bitArrayEnumerator = new BitArrayEnumerator();
            bitArrayEnumerator.iy = this.iy;
            bitArrayEnumerator.nk = this.nk;
            bitArrayEnumerator.et = this.et;
            bitArrayEnumerator.cv = this.cv;
            return bitArrayEnumerator;
        }
    }
}

