/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.Hashtable;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.ms.System.cv;

public abstract class DictionaryBase
implements ICollection,
IDictionary,
IEnumerable {
    private Hashtable iy = new Hashtable();

    protected DictionaryBase() {
    }

    @Override
    public void clear() {
        this.onClear();
        this.iy.clear();
        this.onClearComplete();
    }

    @Override
    public int size() {
        return this.iy.size();
    }

    protected IDictionary getDictionary() {
        return this;
    }

    protected Hashtable getInnerHashtable() {
        return this.iy;
    }

    @Override
    public void copyTo(cv array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index must be possitive");
        }
        if (array.cv() > 1) {
            throw new ArgumentException("array is multidimensional");
        }
        int n = array.lg();
        if (index > n) {
            throw new ArgumentException("index is larger than array size");
        }
        if (index + this.size() > n) {
            throw new ArgumentException("Copy will overlflow array");
        }
        this.iy(array, index);
    }

    private void iy(cv cv2, int n) {
        for (DictionaryEntry dictionaryEntry : this.iy) {
            cv2.et(dictionaryEntry.Clone(), n++);
        }
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return this.iy.iterator();
    }

    protected void onClear() {
    }

    protected void onClearComplete() {
    }

    protected Object onGet(Object key, Object currentValue) {
        return currentValue;
    }

    protected void onInsert(Object key, Object value) {
    }

    protected void onInsertComplete(Object key, Object value) {
    }

    protected void onSet(Object key, Object oldValue, Object newValue) {
    }

    protected void onSetComplete(Object key, Object oldValue, Object newValue) {
    }

    protected void onRemove(Object key, Object value) {
    }

    protected void onRemoveComplete(Object key, Object value) {
    }

    protected void onValidate(Object key, Object value) {
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public Object get_Item(Object key) {
        Object object = this.iy.get_Item(key);
        this.onGet(key, object);
        return object;
    }

    @Override
    public void set_Item(Object key, Object value) {
        this.onValidate(key, value);
        Object object = this.iy.get_Item(key);
        this.onSet(key, object, value);
        this.iy.set_Item(key, value);
        try {
            this.onSetComplete(key, object, value);
        }
        catch (RuntimeException runtimeException) {
            this.iy.set_Item(key, object);
            throw runtimeException;
        }
    }

    @Override
    public ICollection getKeys() {
        return this.iy.getKeys();
    }

    @Override
    public ICollection getValues() {
        return this.iy.getValues();
    }

    @Override
    public void addItem(Object key, Object value) {
        this.onValidate(key, value);
        this.onInsert(key, value);
        this.iy.addItem(key, value);
        try {
            this.onInsertComplete(key, value);
        }
        catch (RuntimeException runtimeException) {
            this.iy.removeItem(key);
            throw runtimeException;
        }
    }

    @Override
    public void removeItem(Object key) {
        if (!this.iy.contains(key)) {
            return;
        }
        Object object = this.iy.get_Item(key);
        this.onValidate(key, object);
        this.onRemove(key, object);
        this.iy.removeItem(key);
        try {
            this.onRemoveComplete(key, object);
        }
        catch (RuntimeException runtimeException) {
            this.iy.set_Item(key, object);
            throw runtimeException;
        }
    }

    @Override
    public boolean contains(Object key) {
        return this.iy.contains(key);
    }

    @Override
    public boolean isSynchronized() {
        return this.iy.isSynchronized();
    }

    @Override
    public Object getSyncRoot() {
        return this.iy.getSyncRoot();
    }
}

