/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.IGenericList;
import com.aspose.slides.Collections.ObjectModel.ReadOnlyCollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.internal.vk.an;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.am;
import com.aspose.slides.ms.System.cv;
import com.aspose.slides.ms.System.dy;
import com.aspose.slides.ms.System.ez;
import com.aspose.slides.ms.System.ic;
import com.aspose.slides.ms.System.iy;
import com.aspose.slides.ms.System.vf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class List<T>
implements IGenericList<T>,
java.util.List<T> {
    private Object[] iy;
    private int nk;
    private int et;
    private final Object cv = new Object();
    static Object[] n2 = new Object[0];

    public List() {
        this.iy = n2;
    }

    public List(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.iy = n2;
        this.iy(collection);
    }

    public List(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: capacity");
        }
        this.iy = new Object[capacity];
    }

    private List(T[] data, int size) {
        this.iy = data;
        this.nk = size;
    }

    protected int getVersion() {
        return this.et;
    }

    @Override
    public void addItem(T item) {
        if (this.nk == this.iy.length) {
            this.iy(1);
        }
        this.iy[this.nk++] = item;
        ++this.et;
    }

    private void iy(int n) {
        int n10 = this.nk + n;
        if (n10 > this.iy.length) {
            this.setCapacity(Math.max(Math.max(this.getCapacity() * 2, 4), n10));
        }
    }

    private void iy(int n, int n10) {
        if (n < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (n10 < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)n & 0xFFFFFFFFL) + ((long)n10 & 0xFFFFFFFFL) > ((long)this.nk & 0xFFFFFFFFL)) {
            throw new ArgumentException("index and count exceed length of list");
        }
    }

    private void iy(IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t : iGenericEnumerable) {
            this.addItem(t);
        }
    }

    public void addRange(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.iy(new List<T>(collection));
        ++this.et;
    }

    public void addRange(T[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (T t : collection) {
            this.addItem(t);
        }
        ++this.et;
    }

    public ReadOnlyCollection<T> asReadOnly() {
        return new ReadOnlyCollection(this);
    }

    public int binarySearch(T item) {
        return ic.iy(this.iy, 0, this.nk, item);
    }

    public int binarySearch(T item, Comparator<T> comparer) {
        return ic.iy(this.iy, 0, this.nk, item, comparer);
    }

    public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
        this.iy(index, count);
        return ic.iy(this.iy, index, count, item, comparer);
    }

    @Override
    public void clear() {
        com.aspose.slides.ms.System.cv.iy(this.iy, 0, this.iy.length);
        this.nk = 0;
        ++this.et;
    }

    public <TOutput> List<TOutput> convertAll(am<T, TOutput> converter) {
        if (converter == null) {
            throw new ArgumentNullException("converter");
        }
        List<T> list = new List<T>(this.nk);
        for (int i = 0; i < this.nk; ++i) {
            list.iy[i] = converter.iy(this.iy[i]);
        }
        list.nk = this.nk;
        return list;
    }

    public void copyTo(T[] array) {
        com.aspose.slides.ms.System.cv.iy(this.iy, 0, array, 0, this.nk);
    }

    @Override
    public void copyToTArray(T[] array, int arrayIndex) {
        com.aspose.slides.ms.System.cv.iy(this.iy, 0, array, arrayIndex, this.nk);
    }

    public void copyTo(int index, T[] array, int arrayIndex, int count) {
        this.iy(index, count);
        com.aspose.slides.ms.System.cv.iy(this.iy, index, array, arrayIndex, count);
    }

    public boolean exists(ez<T> match) {
        List.iy(match);
        return this.iy(0, this.nk, match) != -1;
    }

    public T find(ez<T> match) {
        List.iy(match);
        int n = this.iy(0, this.nk, match);
        return (T)(n != -1 ? this.iy[n] : null);
    }

    static <T> void iy(ez<T> ez2) {
        if (ez2 == null) {
            throw new ArgumentNullException("match");
        }
    }

    public List<T> findAll(ez<T> match) {
        List.iy(match);
        return this.nk(match);
    }

    private List<T> nk(ez<T> ez2) {
        List<Object> list = new List<Object>();
        for (int i = 0; i < this.nk; ++i) {
            if (!ez2.invoke(this.iy[i])) continue;
            list.addItem(this.iy[i]);
        }
        return list;
    }

    public int findIndex(ez<T> match) {
        List.iy(match);
        return this.iy(0, this.nk, match);
    }

    public int findIndex(int startIndex, ez<T> match) {
        List.iy(match);
        this.nk(startIndex);
        return this.iy(startIndex, this.nk - startIndex, match);
    }

    public int findIndex(int startIndex, int count, ez<T> match) {
        List.iy(match);
        this.iy(startIndex, count);
        return this.iy(startIndex, count, match);
    }

    private int iy(int n, int n10, ez<T> ez2) {
        int n11 = n + n10;
        for (int i = n; i < n11; ++i) {
            if (!ez2.invoke(this.iy[i])) continue;
            return i;
        }
        return -1;
    }

    public T findLast(ez<T> match) {
        List.iy(match);
        int n = this.nk(0, this.nk, match);
        if (n == -1) {
            return null;
        }
        return this.get_Item(n);
    }

    public int findLastIndex(ez<T> match) {
        List.iy(match);
        return this.nk(0, this.nk, match);
    }

    public int findLastIndex(int startIndex, ez<T> match) {
        List.iy(match);
        this.nk(startIndex);
        return this.nk(0, startIndex + 1, match);
    }

    public int findLastIndex(int startIndex, int count, ez<T> match) {
        List.iy(match);
        int n = startIndex - count + 1;
        this.iy(n, count);
        return this.nk(n, count, match);
    }

    private int nk(int n, int n10, ez<T> ez2) {
        int n11 = n + n10;
        while (n11 != n) {
            if (!ez2.invoke(this.iy[--n11])) continue;
            return n11;
        }
        return -1;
    }

    @Override
    public void forEach(iy<T> action) {
        if (action == null) {
            throw new ArgumentNullException("action");
        }
        for (int i = 0; i < this.nk; ++i) {
            action.invoke(this.iy[i]);
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    @Deprecated
    public EnumeratorJava<T> iteratorJava() {
        return new EnumeratorJava(this);
    }

    public List<T> getRange(int index, int count) {
        this.iy(index, count);
        Object[] objectArray = new Object[count];
        com.aspose.slides.ms.System.cv.iy(this.iy, index, objectArray, 0, count);
        return new List<Object>(objectArray, count);
    }

    @Override
    public int indexOfItem(T item) {
        return com.aspose.slides.ms.System.cv.iy(this.iy, item, 0, this.nk);
    }

    public int indexOf(T item, int index) {
        this.nk(index);
        return com.aspose.slides.ms.System.cv.iy(this.iy, item, index, this.nk - index);
    }

    public int indexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.nk & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
        }
        return com.aspose.slides.ms.System.cv.iy(this.iy, item, index, count);
    }

    private void nk(int n, int n10) {
        if (n10 < 0) {
            n -= n10;
        }
        if (n < this.nk) {
            com.aspose.slides.ms.System.cv.iy(this.iy, n, this.iy, n + n10, this.nk - n);
        }
        this.nk += n10;
        if (n10 < 0) {
            com.aspose.slides.ms.System.cv.iy(this.iy, this.nk, -n10);
        }
    }

    private void nk(int n) {
        if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.nk & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
    }

    @Override
    public void insertItem(int index, T item) {
        this.nk(index);
        if (this.nk == this.iy.length) {
            this.iy(1);
        }
        this.nk(index, 1);
        this.iy[index] = item;
        ++this.et;
    }

    void et(int n) {
        Object[] objectArray = new Object[this.nk];
        this.copyToTArray(objectArray, 0);
        this.iy(this.nk);
        this.nk(n, objectArray.length);
        com.aspose.slides.ms.System.cv.iy(objectArray, 0, this.iy, n, objectArray.length);
    }

    public void insertRange(int index, IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.nk(index);
        if (collection == this) {
            this.et(index);
        } else {
            this.iy(index, collection);
        }
        ++this.et;
    }

    private void iy(int n, IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t : iGenericEnumerable) {
            this.insertItem(n++, t);
        }
    }

    @Override
    public int lastIndexOf(Object item) {
        if (this.nk == 0) {
            return -1;
        }
        return ic.iy(this.iy, item, this.nk - 1, this.nk);
    }

    public int lastIndexOf(T item, int index) {
        this.nk(index);
        return ic.iy(this.iy, item, index, index + 1);
    }

    public int lastIndexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index", index, "index is negative");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", count, "count is negative");
        }
        if (index - count + 1 < 0) {
            throw new ArgumentOutOfRangeException("cound", count, "count is too large");
        }
        return ic.iy(this.iy, item, index, count);
    }

    @Override
    public boolean removeItem(T item) {
        int n = this.indexOfItem(item);
        if (n != -1) {
            this.removeAt(n);
        }
        return n != -1;
    }

    public int removeAll(ez<T> match) {
        List.iy(match);
        int n = 0;
        int n10 = 0;
        for (n = 0; n < this.nk && !match.invoke(this.iy[n]); ++n) {
        }
        if (n == this.nk) {
            return 0;
        }
        ++this.et;
        for (n10 = n + 1; n10 < this.nk; ++n10) {
            if (match.invoke(this.iy[n10])) continue;
            this.iy[n++] = this.iy[n10];
        }
        if (n10 - n > 0) {
            com.aspose.slides.ms.System.cv.iy(this.iy, n, n10 - n);
        }
        this.nk = n;
        return n10 - n;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.nk & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.nk(index, -1);
        com.aspose.slides.ms.System.cv.iy(this.iy, this.nk, 1);
        ++this.et;
    }

    public void removeRange(int index, int count) {
        this.iy(index, count);
        if (count > 0) {
            this.nk(index, -count);
            com.aspose.slides.ms.System.cv.iy(this.iy, this.nk, count);
            ++this.et;
        }
    }

    public void reverse() {
        ic.iy(this.iy, 0, this.nk);
        ++this.et;
    }

    public void reverse(int index, int count) {
        this.iy(index, count);
        ic.iy(this.iy, index, count);
        ++this.et;
    }

    public void sort() {
        Arrays.sort(this.iy, 0, this.nk);
        ++this.et;
    }

    @Override
    public void sort(Comparator<? super T> comparer) {
        Arrays.sort(this.iy, 0, this.nk, comparer);
        ++this.et;
    }

    @Override
    public void sort(vf<T> comparison) {
        if (comparison == null) {
            throw new ArgumentNullException("comparison");
        }
        Arrays.sort(this.iy, 0, this.nk, new ic.iy<T>(comparison));
        ++this.et;
    }

    public void sort(int index, int count, Comparator<T> comparer) {
        this.iy(index, count);
        Arrays.sort(this.iy, index, index + count, comparer);
        ++this.et;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.nk) {
            return Arrays.copyOf(this.iy, this.nk, a.getClass());
        }
        System.arraycopy(this.iy, 0, a, 0, this.nk);
        if (a.length > this.nk) {
            a[this.nk] = null;
        }
        return a;
    }

    public void trimExcess() {
        this.setCapacity(this.nk);
    }

    public boolean trueForAll(ez<T> match) {
        List.iy(match);
        for (int i = 0; i < this.nk; ++i) {
            if (match.invoke(this.iy[i])) continue;
            return false;
        }
        return true;
    }

    public int getCapacity() {
        return this.iy.length;
    }

    public void setCapacity(int value) {
        if (((long)value & 0xFFFFFFFFL) < ((long)this.nk & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException();
        }
        this.iy = Arrays.copyOf(this.iy, value);
    }

    @Override
    public int size() {
        return this.nk;
    }

    @Override
    public T get_Item(int index) {
        if (((long)index & 0xFFFFFFFFL) >= ((long)this.nk & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        return (T)this.iy[index];
    }

    @Override
    public void set_Item(int index, T value) {
        this.nk(index);
        if ((long)index == (long)this.nk) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.iy[index] = value;
        ++this.et;
    }

    public void copyTo(cv array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.cv() > 1 || array.nk(0) != 0) {
            throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
        }
        com.aspose.slides.ms.System.cv.iy(com.aspose.slides.ms.System.cv.iy(this.iy), 0, array, arrayIndex, this.nk);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public boolean isSynchronized() {
        return false;
    }

    public Object getSyncRoot() {
        return this.cv;
    }

    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.nk == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            for (int i = 0; i < this.nk; ++i) {
                if (this.iy[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.nk; ++i) {
            if (!this.iy[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsItem(T item) {
        if (item == null) {
            for (int i = 0; i < this.nk; ++i) {
                if (this.iy[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.nk; ++i) {
            if (!this.iy[i].equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.nk];
        System.arraycopy(this.iy, 0, objectArray, 0, this.nk);
        return objectArray;
    }

    @Override
    public boolean add(T t) {
        int n = this.nk;
        this.addItem(t);
        return n != this.nk;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.nk;
        this.removeItem(o);
        return n != this.nk;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        int n = 0;
        int n10 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n10 != this.size();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        int n = index;
        int n10 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n10 != this.size();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int n = this.size();
        for (Object obj : c) {
            this.remove(obj);
        }
        return n != this.size();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Object[] objectArray;
        int n = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c.contains(object)) continue;
            this.remove(object);
        }
        return n != this.size();
    }

    @Override
    public T get(int index) {
        return this.get_Item(index);
    }

    @Override
    public T set(int index, T element) {
        T t = this.get_Item(index);
        this.set_Item(index, element);
        return t;
    }

    @Override
    public void add(int index, T element) {
        this.insertItem(index, element);
    }

    @Override
    public T remove(int index) {
        T t = this.get_Item(index);
        this.removeAt(index);
        return t;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.nk; ++i) {
                if (this.iy[i] != null) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.nk; ++i) {
            if (!o.equals(this.iy[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator listIterator() {
        return new ListItr(0);
    }

    @Override
    public ListIterator listIterator(int index) {
        return new ListItr(index);
    }

    @Override
    public java.util.List<T> subList(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        return this.getRange(fromIndex, n);
    }

    public static <T> List<T> fromJava(java.util.List<T> list) {
        if (list == null) {
            return null;
        }
        return new ListInternalized<T>(list);
    }

    public static <T> java.util.List<T> toJava(List<T> list) {
        return list;
    }

    static class ListInternalized<T>
    extends List<T> {
        private java.util.List<T> iy;
        private int nk;

        public ListInternalized() {
            this.iy = new ArrayList<T>();
        }

        public ListInternalized(java.util.List<T> list) {
            super(list.size());
            for (T t : list) {
                super.addItem(t);
            }
            this.iy = list;
        }

        @Override
        protected int getVersion() {
            return this.nk;
        }

        @Override
        public void addRange(IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            this.iy(collection);
            ++this.nk;
        }

        @Override
        public void addRange(T[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            for (T t : collection) {
                this.addItem(t);
            }
            ++this.nk;
        }

        @Override
        public ReadOnlyCollection<T> asReadOnly() {
            return new ReadOnlyCollection(this);
        }

        @Override
        public int binarySearch(T item) {
            return ic.iy(this.iy.toArray(), 0, this.iy.size(), item);
        }

        @Override
        public int binarySearch(T item, Comparator<T> comparer) {
            return ic.iy(this.iy.toArray(), 0, this.iy.size(), item, comparer);
        }

        @Override
        public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
            this.iy(index, count);
            return ic.iy(this.iy.toArray(), index, count, item, comparer);
        }

        @Override
        private void iy(int n, int n10) {
            if (n < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (n10 < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)n & 0xFFFFFFFFL) + ((long)n10 & 0xFFFFFFFFL) > ((long)this.iy.size() & 0xFFFFFFFFL)) {
                throw new ArgumentException("index and count exceed length of list");
            }
        }

        @Override
        public <TOutput> List<TOutput> convertAll(am<T, TOutput> converter) {
            if (converter == null) {
                throw new ArgumentNullException("converter");
            }
            List list = new List(this.iy.size());
            for (int i = 0; i < this.iy.size(); ++i) {
                list.iy[i] = converter.iy(this.get_Item(i));
            }
            list.nk = this.iy.size();
            return list;
        }

        @Override
        public void copyTo(T[] array) {
            com.aspose.slides.ms.System.cv.iy(this.iy.toArray(), 0, array, 0, this.iy.size());
        }

        @Override
        public void copyToTArray(T[] array, int arrayIndex) {
            com.aspose.slides.ms.System.cv.iy(this.iy.toArray(), 0, array, arrayIndex, this.iy.size());
        }

        @Override
        public void copyTo(int index, T[] array, int arrayIndex, int count) {
            this.iy(index, count);
            com.aspose.slides.ms.System.cv.iy(this.iy.toArray(), index, array, arrayIndex, count);
        }

        @Override
        public boolean exists(ez<T> match) {
            ListInternalized.nk(match);
            return this.iy(0, this.iy.size(), match) != -1;
        }

        @Override
        private int iy(int n, int n10, ez<T> ez2) {
            int n11 = n + n10;
            for (int i = n; i < n11; ++i) {
                if (!ez2.invoke(this.iy.get(i))) continue;
                return i;
            }
            return -1;
        }

        static <T> void nk(ez<T> ez2) {
            if (ez2 == null) {
                throw new ArgumentNullException("match");
            }
        }

        @Override
        public T find(ez<T> match) {
            ListInternalized.nk(match);
            int n = this.iy(0, this.iy.size(), match);
            return n != -1 ? (T)this.iy.get(n) : null;
        }

        @Override
        public List<T> findAll(ez<T> match) {
            ListInternalized.nk(match);
            return this.et(match);
        }

        private List<T> et(ez<T> ez2) {
            List<T> list = new List<T>();
            for (int i = 0; i < this.size(); ++i) {
                if (!ez2.invoke(this.iy.get(i))) continue;
                list.addItem(this.iy.get(i));
            }
            return list;
        }

        @Override
        public int findIndex(ez<T> match) {
            ListInternalized.nk(match);
            return this.iy(0, this.iy.size(), match);
        }

        @Override
        public int findIndex(int startIndex, ez<T> match) {
            ListInternalized.nk(match);
            this.iy(startIndex);
            return this.iy(startIndex, this.iy.size() - startIndex, match);
        }

        @Override
        private void iy(int n) {
            if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.iy.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
        }

        @Override
        public int findIndex(int startIndex, int count, ez<T> match) {
            ListInternalized.nk(match);
            this.iy(startIndex, count);
            return this.iy(startIndex, count, match);
        }

        @Override
        public T findLast(ez<T> match) {
            ListInternalized.nk(match);
            int n = this.nk(0, this.iy.size(), match);
            if (n == -1) {
                return null;
            }
            return this.get_Item(n);
        }

        @Override
        private int nk(int n, int n10, ez<T> ez2) {
            int n11 = n + n10;
            while (n11 != n) {
                if (!ez2.invoke(this.iy.get(--n11))) continue;
                return n11;
            }
            return -1;
        }

        @Override
        public int findLastIndex(ez<T> match) {
            ListInternalized.nk(match);
            return this.nk(0, this.iy.size(), match);
        }

        @Override
        public int findLastIndex(int startIndex, ez<T> match) {
            ListInternalized.nk(match);
            this.iy(startIndex);
            return this.nk(0, startIndex + 1, match);
        }

        @Override
        public int findLastIndex(int startIndex, int count, ez<T> match) {
            ListInternalized.nk(match);
            int n = startIndex - count + 1;
            this.iy(n, count);
            return this.nk(n, count, match);
        }

        @Override
        public void forEach(iy<T> action) {
            if (action == null) {
                throw new ArgumentNullException("action");
            }
            for (int i = 0; i < this.iy.size(); ++i) {
                action.invoke(this.iy.get(i));
            }
        }

        @Override
        public Enumerator<T> iterator() {
            return new Enumerator(this);
        }

        @Override
        public List<T> getRange(int index, int count) {
            this.iy(index, count);
            Object[] objectArray = new Object[count];
            com.aspose.slides.ms.System.cv.iy(this.iy.toArray(), index, objectArray, 0, count);
            return new List(objectArray, count);
        }

        @Override
        public int indexOfItem(T item) {
            return this.iy.indexOf(item);
        }

        @Override
        public int indexOf(T item, int index) {
            this.iy(index);
            return com.aspose.slides.ms.System.cv.iy(this.iy.toArray(), item, index, this.iy.size() - index);
        }

        @Override
        public int indexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.iy.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
            }
            return com.aspose.slides.ms.System.cv.iy(this.iy.toArray(), item, index, count);
        }

        @Override
        public int lastIndexOf(Object item) {
            if (this.iy.size() == 0) {
                return -1;
            }
            return ic.iy(this.iy.toArray(), item, this.iy.size() - 1, this.iy.size());
        }

        @Override
        public int lastIndexOf(T item, int index) {
            this.iy(index);
            return ic.iy(this.iy.toArray(), item, index, index + 1);
        }

        @Override
        public int lastIndexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "index is negative");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "count is negative");
            }
            if (index - count + 1 < 0) {
                throw new ArgumentOutOfRangeException("cound", count, "count is too large");
            }
            return ic.iy(this.iy.toArray(), item, index, count);
        }

        @Override
        public boolean removeItem(T item) {
            int n = this.indexOfItem(item);
            if (n != -1) {
                this.removeAt(n);
            }
            return n != -1;
        }

        @Override
        public <T1> T1[] toArray(T1[] a) {
            return this.iy.toArray(a);
        }

        @Override
        public void trimExcess() {
            this.setCapacity(this.iy.size());
        }

        @Override
        public boolean trueForAll(ez<T> match) {
            ListInternalized.nk(match);
            for (int i = 0; i < this.iy.size(); ++i) {
                if (match.invoke(this.iy.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getCapacity() {
            return this.iy.size();
        }

        @Override
        public void setCapacity(int value) {
            if (((long)value & 0xFFFFFFFFL) < ((long)this.iy.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException();
            }
            for (int i = 0; i < value - this.iy.size(); ++i) {
                this.iy.add(null);
            }
        }

        @Override
        public int size() {
            return this.iy.size();
        }

        @Override
        public T get_Item(int index) {
            return this.iy.get(index);
        }

        @Override
        public void copyTo(cv array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.cv() > 1 || array.nk(0) != 0) {
                throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
            }
            com.aspose.slides.ms.System.cv.iy(com.aspose.slides.ms.System.cv.iy(this.iy.toArray()), 0, array, arrayIndex, this.iy.size());
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.size() != 0;
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                for (int i = 0; i < this.iy.size(); ++i) {
                    if (this.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.iy.size(); ++i) {
                if (!this.get(i).equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsItem(T item) {
            if (item == null) {
                for (int i = 0; i < this.iy.size(); ++i) {
                    if (this.iy.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.iy.size(); ++i) {
                if (!this.iy.get(i).equals(item)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object[] toArray() {
            return this.iy.toArray();
        }

        @Override
        public boolean add(T t) {
            ++this.nk;
            return this.iy.add(t);
        }

        @Override
        public boolean remove(Object o) {
            ++this.nk;
            return this.iy.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.iy.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            ++this.nk;
            return this.iy.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            ++this.nk;
            return this.iy.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            ++this.nk;
            return this.iy.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            ++this.nk;
            return this.iy.retainAll(c);
        }

        @Override
        public T get(int index) {
            return this.iy.get(index);
        }

        @Override
        public T set(int index, T element) {
            ++this.nk;
            return this.iy.set(index, element);
        }

        @Override
        public void add(int index, T element) {
            ++this.nk;
            this.iy.add(index, element);
        }

        @Override
        public T remove(int index) {
            ++this.nk;
            return this.iy.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.iy.indexOf(o);
        }

        @Override
        public ListIterator listIterator() {
            return this.iy.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.iy.listIterator(index);
        }

        @Override
        public java.util.List<T> subList(int fromIndex, int toIndex) {
            return this.iy.subList(fromIndex, toIndex);
        }

        @Override
        public void addItem(T item) {
            this.iy.add(item);
            ++this.nk;
        }

        @Override
        public void clear() {
            this.iy.clear();
            ++this.nk;
        }

        @Override
        public void insertItem(int index, T item) {
            this.iy.add(index, item);
            ++this.nk;
        }

        @Override
        public void insertRange(int index, IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            if (index < 0 || ((long)index & 0xFFFFFFFFL) > ((long)this.iy.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            int n = index;
            if (collection == this) {
                Object[] objectArray = new Object[this.size()];
                this.copyTo(objectArray);
                for (Object object : objectArray) {
                    this.iy.add(n++, object);
                }
            } else {
                for (Object e : collection) {
                    this.iy.add(n++, e);
                }
            }
            ++this.nk;
        }

        @Override
        public int removeAll(ez<T> match) {
            ListInternalized.nk(match);
            int n = 0;
            int n10 = 0;
            for (n = 0; n < this.iy.size() && !match.invoke(this.iy.get(n)); ++n) {
            }
            if (n == this.iy.size()) {
                return 0;
            }
            ++this.nk;
            for (n10 = n + 1; n10 < this.iy.size(); ++n10) {
                if (match.invoke(this.iy.get(n10))) continue;
                this.iy.set(n++, this.iy.get(n10));
            }
            if (n10 - n > 0) {
                for (int i = 0; i < n10 - n; ++i) {
                    this.iy.remove(this.iy.size() - 1);
                }
            }
            return n10 - n;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.iy.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.iy.remove(index);
            ++this.nk;
        }

        @Override
        public void removeRange(int index, int count) {
            this.iy(index, count);
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    this.iy.remove(index);
                }
                ++this.nk;
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.size());
        }

        @Override
        public void reverse(int index, int count) {
            this.iy(index, count);
            int n = index;
            for (int i = index + count - 1; n < i; ++n, --i) {
                T t = this.iy.get(n);
                this.iy.set(n, this.iy.get(i));
                this.iy.set(i, t);
            }
            ++this.nk;
        }

        @Override
        public void sort() {
            Collections.sort(this.iy, null);
            ++this.nk;
        }

        @Override
        public void sort(Comparator<? super T> comparer) {
            Collections.sort(this.iy, comparer);
            ++this.nk;
        }

        @Override
        public void sort(final vf<T> tComparison) {
            if (tComparison == null) {
                throw new ArgumentNullException("comparison");
            }
            Collections.sort(this.iy, new Comparator<T>(){

                @Override
                public int compare(T o12, T o22) {
                    return tComparison.iy(o12, o22);
                }
            });
            ++this.nk;
        }

        @Override
        public void sort(int index, int count, Comparator<T> comparer) {
            this.iy(index, count);
            java.util.List<T> list = this.iy.subList(index, count);
            Collections.sort(list, comparer);
            for (int i = 0; i < count; ++i) {
                this.iy.set(index + i, list.get(i));
            }
            ++this.nk;
        }

        @Override
        public void set_Item(int index, T value) {
            this.iy(index);
            if ((long)index == (long)this.iy.size()) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.iy.set(index, value);
            ++this.nk;
        }

        @Override
        private void iy(IGenericEnumerable<T> iGenericEnumerable) {
            for (Object t : iGenericEnumerable) {
                this.addItem(t);
            }
        }
    }

    @Deprecated
    public static class EnumeratorJava<T>
    extends an<EnumeratorJava<T>>
    implements IGenericEnumerator<T>,
    IDisposable {
        private List<T> nk = new List();
        private int et;
        private int cv;
        private T lg;

        public EnumeratorJava() {
        }

        EnumeratorJava(List<T> l) {
            this();
            this.nk = l;
            this.cv = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void iy() {
            if (this.cv != this.nk.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public T next() {
            if (this.et < 0 || this.et >= this.nk.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            if (this.cv != this.nk.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.lg = this.nk.get_Item(this.et++);
            return this.lg;
        }

        @Override
        public boolean hasNext() {
            if (this.cv == this.nk.getVersion()) {
                if (this.et < 0) {
                    return false;
                }
                return this.et < this.nk.size();
            }
            throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
        }

        @Override
        public void reset() {
            this.iy();
            this.et = 0;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(EnumeratorJava<T> that) {
            that.nk = this.nk;
            that.et = this.et;
            that.cv = this.cv;
            that.lg = this.lg;
        }

        @Override
        public EnumeratorJava<T> Clone() {
            EnumeratorJava<T> enumeratorJava = new EnumeratorJava<T>();
            this.CloneTo(enumeratorJava);
            return enumeratorJava;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean iy(EnumeratorJava enumeratorJava) {
            return dy.iy(enumeratorJava.nk, this.nk) && enumeratorJava.et == this.et && enumeratorJava.cv == this.cv && dy.iy(enumeratorJava.lg, this.lg);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (dy.nk(null, obj)) {
                return false;
            }
            if (dy.nk(this, obj)) {
                return true;
            }
            if (!(obj instanceof EnumeratorJava)) {
                return false;
            }
            return this.iy((EnumeratorJava)obj);
        }

        public static boolean equals(EnumeratorJava obj1, EnumeratorJava obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.nk != null ? this.nk.hashCode() : 0;
            n = 31 * n + this.et;
            n = 31 * n + this.cv;
            n = 31 * n + (this.lg != null ? this.lg.hashCode() : 0);
            return n;
        }
    }

    public static class Enumerator<T>
    extends an<Enumerator<T>>
    implements IGenericEnumerator<T>,
    IDisposable {
        private List<T> nk = new List();
        private int et;
        private int cv;
        private T lg;

        public Enumerator() {
        }

        Enumerator(List<T> l) {
            this();
            this.nk = l;
            this.cv = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void iy() {
            if (this.cv != this.nk.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public boolean hasNext() {
            if (this.cv == this.nk.getVersion()) {
                if (this.et < 0) {
                    return false;
                }
                if (this.et < this.nk.size()) {
                    this.lg = this.nk.get_Item(this.et++);
                    return true;
                }
            } else {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.et = this.nk.size() + 1;
            return false;
        }

        @Override
        public void reset() {
            this.iy();
            this.et = 0;
        }

        @Override
        public T next() {
            if (this.et < 0 || this.et >= this.nk.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            return this.lg;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator<T> that) {
            that.nk = this.nk;
            that.et = this.et;
            that.cv = this.cv;
            that.lg = this.lg;
        }

        @Override
        public Enumerator<T> Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean iy(Enumerator enumerator) {
            return dy.iy(enumerator.nk, this.nk) && enumerator.et == this.et && enumerator.cv == this.cv && dy.iy(enumerator.lg, this.lg);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (dy.nk(null, obj)) {
                return false;
            }
            if (dy.nk(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.iy((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.nk != null ? this.nk.hashCode() : 0;
            n = 31 * n + this.et;
            n = 31 * n + this.cv;
            n = 31 * n + (this.lg != null ? this.lg.hashCode() : 0);
            return n;
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.iy = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.iy != 0;
        }

        @Override
        public int nextIndex() {
            return this.iy;
        }

        @Override
        public int previousIndex() {
            return this.iy - 1;
        }

        public T previous() {
            int n = this.iy - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.iy;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.iy = n;
            this.nk = n;
            return objectArray[this.nk];
        }

        public void set(T e) {
            if (this.nk < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.set(this.nk, e);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(T e) {
            try {
                int n = this.iy;
                List.this.add(n, e);
                this.iy = n + 1;
                this.nk = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr<T>
    implements Iterator<T> {
        int iy;
        int nk = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.iy != List.this.nk;
        }

        @Override
        public T next() {
            int n = this.iy;
            if (n >= List.this.nk) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.iy;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.iy = n + 1;
            this.nk = n;
            return (T)objectArray[this.nk];
        }

        @Override
        public void remove() {
            if (this.nk < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.remove(this.nk);
                this.iy = this.nk;
                this.nk = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

