/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericCollection;
import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.ArrayTypeMismatchException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.internal.vk.an;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.cv;
import com.aspose.slides.ms.System.dy;
import com.aspose.slides.ms.System.qi;
import java.util.Arrays;

public class Queue<T>
implements IGenericEnumerable<T>,
ICollection<T> {
    private Object[] iy;
    private int nk;
    private int et;
    private int cv;
    private int lg;
    private final Object n2;

    public Queue() {
        this.iy = new Object[0];
        this.n2 = this;
    }

    public Queue(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.iy = new Object[capacity];
        this.n2 = this;
    }

    public Queue(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        IGenericCollection iGenericCollection = collection instanceof IGenericCollection ? (IGenericCollection)collection : null;
        int n = iGenericCollection != null ? iGenericCollection.size() : 0;
        this.iy = new Object[n];
        for (Object t : collection) {
            this.enqueue(t);
        }
        this.n2 = this;
    }

    public void clear() {
        com.aspose.slides.ms.System.cv.iy(this.iy, 0, this.iy.length);
        this.cv = 0;
        this.et = 0;
        this.nk = 0;
        ++this.lg;
    }

    public boolean contains(T item) {
        if (item == null) {
            for (Object t : this) {
                if (t != null) continue;
                return true;
            }
        } else {
            for (Object t : this) {
                if (!item.equals(t)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void copyTo(cv array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException();
        }
        if (((long)arrayIndex & 0xFFFFFFFFL) > ((long)array.lg() & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException();
        }
        if (array.lg() - arrayIndex < this.cv) {
            throw new ArgumentException();
        }
        if (this.cv == 0) {
            return;
        }
        try {
            int n = this.iy.length;
            int n10 = n - this.nk;
            com.aspose.slides.ms.System.cv.iy(com.aspose.slides.ms.System.cv.iy(this.iy), this.nk, array, arrayIndex, qi.nk(this.cv, n10));
            if (this.cv > n10) {
                com.aspose.slides.ms.System.cv.iy(com.aspose.slides.ms.System.cv.iy(this.iy), 0, array, arrayIndex + n10, this.cv - n10);
            }
        }
        catch (ArrayTypeMismatchException arrayTypeMismatchException) {
            throw new ArgumentException();
        }
    }

    public T dequeue() {
        T t = this.peek();
        this.iy[this.nk] = null;
        if (++this.nk == this.iy.length) {
            this.nk = 0;
        }
        --this.cv;
        ++this.lg;
        return t;
    }

    public T peek() {
        if (this.cv == 0) {
            throw new InvalidOperationException();
        }
        return (T)this.iy[this.nk];
    }

    public void enqueue(T item) {
        if (this.cv == this.iy.length || this.et == this.iy.length) {
            this.iy(qi.iy(qi.iy(this.cv, this.et) * 2, 4));
        }
        this.iy[this.et] = item;
        if (++this.et == this.iy.length) {
            this.et = 0;
        }
        ++this.cv;
        ++this.lg;
    }

    public T[] toArray(T[] a) {
        if (a.length < this.cv) {
            return Arrays.copyOf(this.iy, this.cv, a.getClass());
        }
        System.arraycopy(this.iy, 0, a, 0, this.cv);
        if (a.length > this.cv) {
            a[this.cv] = null;
        }
        return a;
    }

    public void trimExcess() {
        if ((double)this.cv < (double)this.iy.length * 0.9) {
            this.iy(this.cv);
        }
    }

    private void iy(int n) {
        if (n == this.iy.length) {
            return;
        }
        if (n < this.cv) {
            throw new InvalidOperationException("shouldnt happen");
        }
        Object[] objectArray = new Object[n];
        if (this.cv > 0) {
            this.copyTo(com.aspose.slides.ms.System.cv.iy(objectArray), 0);
        }
        this.iy = objectArray;
        this.et = this.cv;
        this.nk = 0;
        ++this.lg;
    }

    @Override
    public int size() {
        return this.cv;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this.n2;
    }

    public Enumerator iterator() {
        return new Enumerator(this);
    }

    public static class Enumerator<T>
    extends an<Enumerator>
    implements IGenericEnumerator<T>,
    IDisposable {
        private Queue<T> nk;
        private int et;
        private int cv;

        public Enumerator() {
        }

        Enumerator(Queue<T> q) {
            this.nk = q;
            this.et = -2;
            this.cv = ((Queue)q).lg;
        }

        @Override
        public void dispose() {
            this.et = -2;
        }

        @Override
        public boolean hasNext() {
            if (this.cv != ((Queue)this.nk).lg) {
                throw new InvalidOperationException();
            }
            if (this.et == -2) {
                this.et = ((Queue)this.nk).cv;
            }
            return this.et != -1 && --this.et != -1;
        }

        @Override
        public T next() {
            if (this.et < 0) {
                throw new InvalidOperationException();
            }
            return (T)((Queue)this.nk).iy[(((Queue)this.nk).cv - 1 - this.et + ((Queue)this.nk).nk) % ((Queue)this.nk).iy.length];
        }

        @Override
        public void reset() {
            if (this.cv != ((Queue)this.nk).lg) {
                throw new InvalidOperationException();
            }
            this.et = -2;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }

        @Override
        public void CloneTo(Enumerator that) {
            that.nk = this.nk;
            that.et = this.et;
            that.cv = this.cv;
        }

        @Override
        public Enumerator Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean iy(Enumerator enumerator) {
            return dy.iy(enumerator.nk, this.nk) && enumerator.et == this.et && enumerator.cv == this.cv;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (dy.nk(null, obj)) {
                return false;
            }
            if (dy.nk(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.iy((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.nk != null ? this.nk.hashCode() : 0;
            n = 31 * n + this.et;
            n = 31 * n + this.cv;
            return n;
        }
    }
}

