/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.Generic.Comparer;
import com.aspose.slides.Collections.Generic.EqualityComparer;
import com.aspose.slides.Collections.Generic.IGenericCollection;
import com.aspose.slides.Collections.Generic.IGenericDictionary;
import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.KeyValuePair;
import com.aspose.slides.Collections.Generic.RBTree;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.KeyNotFoundException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.internal.sd.et;
import com.aspose.slides.internal.sd.lg;
import com.aspose.slides.internal.vk.an;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.cv;
import com.aspose.slides.ms.System.dy;
import java.util.Comparator;

public class SortedDictionary<TKey, TValue>
implements IGenericCollection<KeyValuePair<TKey, TValue>>,
IGenericDictionary<TKey, TValue>,
IGenericEnumerable<KeyValuePair<TKey, TValue>> {
    private RBTree iy;
    private NodeHelper nk;

    public SortedDictionary() {
        this((Comparator)null);
    }

    public SortedDictionary(Comparator<TKey> comparer) {
        this.nk = NodeHelper.iy(comparer);
        this.iy = new RBTree(this.nk);
    }

    public SortedDictionary(IGenericDictionary<TKey, TValue> dictionary) {
        this(dictionary, null);
    }

    public SortedDictionary(IGenericDictionary<TKey, TValue> dictionary, Comparator<TKey> comparer) {
        this(comparer);
        if (dictionary == null) {
            throw new ArgumentNullException("dictionary");
        }
        for (KeyValuePair keyValuePair : dictionary) {
            this.addItem(keyValuePair.getKey(), keyValuePair.getValue());
        }
    }

    protected SortedDictionary(et info, lg context) {
        KeyValuePair[] keyValuePairArray;
        this.nk = (NodeHelper)info.iy("Helper", com.aspose.slides.internal.vk.et.iy(NodeHelper.class));
        this.iy = new RBTree(this.nk);
        for (KeyValuePair keyValuePair : keyValuePairArray = (KeyValuePair[])info.iy("KeyValuePairs", com.aspose.slides.internal.vk.et.iy(KeyValuePair[].class))) {
            this.addItem(keyValuePair.getKey(), keyValuePair.getValue());
        }
    }

    public Comparator<TKey> getComparer() {
        return this.nk.iy;
    }

    int iy() {
        return this.iy.et();
    }

    @Override
    public int size() {
        return this.iy();
    }

    TValue iy(TKey TKey) {
        Node node = (Node)this.iy.nk(TKey);
        if (node == null) {
            throw new KeyNotFoundException();
        }
        return node.nk;
    }

    @Override
    public TValue get_Item(TKey key) {
        return this.iy(key);
    }

    void iy(TKey TKey, TValue TValue) {
        if (TKey == null) {
            throw new ArgumentNullException("key");
        }
        Node node = (Node)this.iy.iy(TKey, (RBTree.Node)null);
        node.nk = TValue;
    }

    @Override
    public void set_Item(TKey key, TValue value) {
        this.iy(key, value);
    }

    public KeyCollection<TKey, TValue> getKeys() {
        return new KeyCollection(this);
    }

    public ValueCollection<TKey, TValue> getValues() {
        return new ValueCollection(this);
    }

    void nk(TKey TKey, TValue TValue) {
        if (TKey == null) {
            throw new ArgumentNullException("key");
        }
        Node<TKey, TValue> node = new Node<TKey, TValue>(TKey, TValue);
        if (this.iy.iy(TKey, node) != node) {
            throw new ArgumentException("key already present in dictionary", "key");
        }
    }

    @Override
    public void addItem(TKey key, TValue value) {
        this.nk(key, value);
    }

    @Override
    public void addItem(KeyValuePair<TKey, TValue> item) {
        this.addItem(item.getKey(), item.getValue());
    }

    @Override
    public boolean containsItem(KeyValuePair<TKey, TValue> item) {
        Object[] objectArray = new Object[]{null};
        boolean bl2 = this.tryGetValue(item.getKey(), objectArray);
        boolean bl3 = new EqualityComparer.DefaultComparer().equals(item.getValue(), objectArray[0]);
        return bl2 && bl3;
    }

    @Override
    public boolean removeItem(KeyValuePair<TKey, TValue> item) {
        return this.removeItemByKey(item.getKey());
    }

    void nk() {
        this.iy.nk();
    }

    @Override
    public void clear() {
        this.nk();
    }

    boolean nk(TKey TKey) {
        if (TKey == null) {
            throw new ArgumentNullException();
        }
        return this.iy.nk(TKey) != null;
    }

    @Override
    public boolean containsKey(TKey key) {
        return this.nk(key);
    }

    public boolean containsValue(TValue value) {
        EqualityComparer.DefaultComparer defaultComparer = new EqualityComparer.DefaultComparer();
        for (Node node : this.iy.n2()) {
            if (!defaultComparer.equals(value, node.nk)) continue;
            return true;
        }
        return false;
    }

    void iy(KeyValuePair<TKey, TValue>[] keyValuePairArray, int n) {
        if (this.size() == 0) {
            return;
        }
        if (keyValuePairArray == null) {
            throw new ArgumentNullException();
        }
        if (n < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (keyValuePairArray.length <= n) {
            throw new ArgumentException();
        }
        if (keyValuePairArray.length < this.size()) {
            throw new ArgumentException();
        }
        if (keyValuePairArray.length - n < this.size()) {
            throw new ArgumentException();
        }
        for (Node node : this.iy.n2()) {
            keyValuePairArray[n++] = node.iy().Clone();
        }
    }

    public void copyToTArray(KeyValuePair<TKey, TValue>[] array, int index) {
        this.iy(array, index);
    }

    public Enumerator<TKey, TValue> iterator() {
        return new Enumerator(this);
    }

    boolean et(TKey TKey) {
        return this.iy.iy(TKey) != null;
    }

    @Override
    public boolean removeItemByKey(TKey key) {
        return this.et(key);
    }

    @Override
    public boolean tryGetValue(TKey key, Object[] valueRef) {
        Node node = (Node)this.iy.nk(key);
        valueRef[0] = node == null ? null : node.nk;
        return node != null;
    }

    public void getObjectData(et info, lg context) {
        if (info == null) {
            throw new ArgumentNullException("info");
        }
        KeyValuePair[] keyValuePairArray = (KeyValuePair[])cv.iy(cv.iy(com.aspose.slides.internal.vk.et.iy(KeyValuePair.class), this.size()));
        this.copyToTArray(keyValuePairArray, 0);
        info.iy("KeyValuePairs", keyValuePairArray);
        info.iy("Helper", this.nk);
    }

    private TKey cv(Object object) {
        if (object == null) {
            throw new ArgumentNullException("key");
        }
        return (TKey)object;
    }

    private TValue lg(Object object) {
        return (TValue)object;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public IDictionary getIDictionary() {
        return new IDictionary(){

            @Override
            public boolean isFixedSize() {
                return false;
            }

            @Override
            public boolean isReadOnly() {
                return false;
            }

            @Override
            public Object get_Item(Object o) {
                return SortedDictionary.this.iy(SortedDictionary.this.cv(o));
            }

            @Override
            public void set_Item(Object key, Object value) {
                SortedDictionary.this.iy(SortedDictionary.this.cv(key), SortedDictionary.this.lg(value));
            }

            @Override
            public ICollection getKeys() {
                return new KeyCollection(SortedDictionary.this.et()).getICollection();
            }

            @Override
            public ICollection getValues() {
                return new ValueCollection(SortedDictionary.this.et()).getICollection();
            }

            @Override
            public void addItem(Object key, Object value) {
                SortedDictionary.this.nk(SortedDictionary.this.cv(key), SortedDictionary.this.lg(value));
            }

            @Override
            public void removeItem(Object o) {
                SortedDictionary.this.et(SortedDictionary.this.cv(o));
            }

            @Override
            public void clear() {
                SortedDictionary.this.nk();
            }

            @Override
            public boolean contains(Object key) {
                return SortedDictionary.this.nk(SortedDictionary.this.cv(key));
            }

            @Override
            public IDictionaryEnumerator iterator() {
                return new Enumerator(SortedDictionary.this.et()).getIDictionaryEnumerator();
            }

            @Override
            public int size() {
                return SortedDictionary.this.iy();
            }

            @Override
            public boolean isSynchronized() {
                return false;
            }

            @Override
            public Object getSyncRoot() {
                return SortedDictionary.this.et();
            }

            @Override
            public void copyTo(cv objects, int i) {
                Object object = cv.iy(objects);
                if (!(object instanceof KeyValuePair[])) {
                    throw new ArgumentException();
                }
                SortedDictionary.this.iy((KeyValuePair[])cv.iy(objects), i);
            }
        };
    }

    public ICollection getICollection() {
        return new ICollection(){

            @Override
            public int size() {
                return SortedDictionary.this.iy();
            }

            @Override
            public boolean isSynchronized() {
                return false;
            }

            @Override
            public Object getSyncRoot() {
                return SortedDictionary.this.et();
            }

            @Override
            public void copyTo(cv array, int index) {
                if (this.size() == 0) {
                    return;
                }
                if (array == null) {
                    throw new ArgumentNullException();
                }
                if (index < 0) {
                    throw new ArgumentOutOfRangeException();
                }
                if (array.lg() <= index) {
                    throw new ArgumentException();
                }
                if (array.lg() - index < this.size()) {
                    throw new ArgumentException();
                }
                if (!(cv.iy(array) instanceof KeyValuePair[])) {
                    throw new ArgumentException();
                }
                for (Node node : SortedDictionary.this.iy.n2()) {
                    array.et(node.iy().Clone(), index++);
                }
            }

            @Override
            public IEnumerator iterator() {
                return new Enumerator(SortedDictionary.this.et()).getIEnumerator();
            }
        };
    }

    public IEnumerable getIEnumerable() {
        return new IEnumerable(){

            public IEnumerator iterator() {
                return new Enumerator(SortedDictionary.this.et()).getIEnumerator();
            }
        };
    }

    public IGenericEnumerable<KeyValuePair<TKey, TValue>> getIGenericEnumerable() {
        return new IGenericEnumerable<KeyValuePair<TKey, TValue>>(){

            @Override
            public IGenericEnumerator<KeyValuePair<TKey, TValue>> iterator() {
                return new Enumerator(SortedDictionary.this.et());
            }
        };
    }

    SortedDictionary<TKey, TValue> et() {
        return this;
    }

    public static class Enumerator<TKey, TValue>
    extends an<Enumerator>
    implements IGenericEnumerator<KeyValuePair<TKey, TValue>>,
    IDisposable {
        private RBTree.NodeEnumerator nk = new RBTree.NodeEnumerator();
        private KeyValuePair<TKey, TValue> et = new KeyValuePair();

        public Enumerator() {
        }

        Enumerator(SortedDictionary<TKey, TValue> dic) {
            this();
            ((SortedDictionary)dic).iy.cv().CloneTo(this.nk);
        }

        KeyValuePair<TKey, TValue> iy() {
            return this.et;
        }

        @Override
        public KeyValuePair<TKey, TValue> next() {
            return this.iy();
        }

        boolean nk() {
            if (!this.nk.hasNext()) {
                return false;
            }
            ((Node)this.nk.next()).iy().CloneTo(this.et);
            return true;
        }

        @Override
        public boolean hasNext() {
            return this.nk();
        }

        @Override
        public void dispose() {
            this.nk.dispose();
        }

        private Node lg() {
            this.nk.nk();
            return (Node)this.nk.next();
        }

        public IDictionaryEnumerator getIDictionaryEnumerator() {
            return new IDictionaryEnumerator(){

                @Override
                public DictionaryEntry getEntry() {
                    return Enumerator.this.lg().nk();
                }

                @Override
                public Object getKey() {
                    return ((Enumerator)Enumerator.this).lg().iy;
                }

                @Override
                public Object getValue() {
                    return ((Enumerator)Enumerator.this).lg().nk;
                }

                @Override
                public Object next() {
                    return Enumerator.this.iy();
                }

                @Override
                public boolean hasNext() {
                    return Enumerator.this.nk();
                }

                @Override
                public void reset() {
                    Enumerator.this.et();
                }

                @Override
                public void remove() {
                    Enumerator.this.cv();
                }
            };
        }

        public IEnumerator getIEnumerator() {
            return new IEnumerator(){

                @Override
                public Object next() {
                    return Enumerator.this.lg().iy();
                }

                @Override
                public boolean hasNext() {
                    return Enumerator.this.nk();
                }

                @Override
                public void reset() {
                    Enumerator.this.et();
                }

                @Override
                public void remove() {
                    Enumerator.this.cv();
                }
            };
        }

        void et() {
            this.nk.reset();
        }

        @Override
        public void reset() {
            this.et();
        }

        void cv() {
            throw new NotSupportedException();
        }

        @Override
        public void remove() {
            this.cv();
        }

        @Override
        public void CloneTo(Enumerator that) {
            this.nk.CloneTo(that.nk);
            this.et.CloneTo(that.et);
        }

        @Override
        public Enumerator Clone() {
            Enumerator<TKey, TValue> enumerator = new Enumerator<TKey, TValue>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean nk(Enumerator enumerator) {
            return dy.iy(enumerator.nk, this.nk) && dy.iy(enumerator.et, this.et);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (dy.nk(null, obj)) {
                return false;
            }
            if (dy.nk(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.nk((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.nk != null ? this.nk.hashCode() : 0;
            n = 31 * n + (this.et != null ? this.et.hashCode() : 0);
            return n;
        }
    }

    public static final class KeyCollection<TKey, TValue>
    implements IGenericCollection<TKey>,
    IGenericEnumerable<TKey> {
        private SortedDictionary<TKey, TValue> iy;

        public KeyCollection(SortedDictionary<TKey, TValue> dictionary) {
            this.iy = dictionary;
        }

        @Override
        public int size() {
            return this.iy.size();
        }

        void iy(TKey[] TKeyArray, int n) {
            if (this.size() == 0) {
                return;
            }
            if (TKeyArray == null) {
                throw new ArgumentNullException();
            }
            if (n < 0) {
                throw new ArgumentOutOfRangeException();
            }
            if (TKeyArray.length <= n) {
                throw new ArgumentException();
            }
            if (TKeyArray.length - n < this.size()) {
                throw new ArgumentException();
            }
            for (Node node : ((SortedDictionary)this.iy).iy.n2()) {
                TKeyArray[n++] = node.iy;
            }
        }

        public void copyTo(TKey[] array, int index) {
            this.iy(array, index);
        }

        public Enumerator<TKey, TValue> iterator() {
            return new Enumerator<TKey, TValue>(this.iy);
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public void addItem(TKey tKey) {
            throw new NotSupportedException();
        }

        @Override
        public void clear() {
            throw new NotSupportedException();
        }

        @Override
        public boolean containsItem(TKey item) {
            return this.iy.containsKey(item);
        }

        @Override
        public void copyToTArray(TKey[] tKeys, int i) {
            this.iy(tKeys, i);
        }

        @Override
        public boolean removeItem(TKey tKey) {
            throw new NotSupportedException();
        }

        public ICollection getICollection() {
            return new ICollection(){

                @Override
                public int size() {
                    return KeyCollection.this.iy.size();
                }

                @Override
                public boolean isSynchronized() {
                    return false;
                }

                @Override
                public Object getSyncRoot() {
                    return KeyCollection.this.iy();
                }

                @Override
                public void copyTo(cv array, int index) {
                    if (this.size() == 0) {
                        return;
                    }
                    if (array == null) {
                        throw new ArgumentNullException();
                    }
                    if (index < 0 || array.lg() <= index) {
                        throw new ArgumentOutOfRangeException();
                    }
                    if (array.lg() - index < this.size()) {
                        throw new ArgumentException();
                    }
                    for (Node node : KeyCollection.this.iy.iy.n2()) {
                        array.et(node.iy, index++);
                    }
                }

                @Override
                public IEnumerator iterator() {
                    return new Enumerator(KeyCollection.this.iy).getIEnumerator();
                }
            };
        }

        public IEnumerable getIEnumerable() {
            return new IEnumerable(){

                public IEnumerator iterator() {
                    return new Enumerator(KeyCollection.this.iy).getIEnumerator();
                }
            };
        }

        Object iy() {
            return this.iy;
        }

        public static class Enumerator<TKey, TValue>
        extends an<Enumerator>
        implements IGenericEnumerator<TKey>,
        IDisposable {
            private RBTree.NodeEnumerator nk = new RBTree.NodeEnumerator();
            private TKey et;

            public Enumerator() {
            }

            Enumerator(SortedDictionary<TKey, TValue> dic) {
                this();
                ((SortedDictionary)dic).iy.cv().CloneTo(this.nk);
            }

            TKey iy() {
                return this.et;
            }

            @Override
            public TKey next() {
                return this.iy();
            }

            boolean nk() {
                if (!this.nk.hasNext()) {
                    return false;
                }
                this.et = ((Node)this.nk.next()).iy;
                return true;
            }

            @Override
            public boolean hasNext() {
                return this.nk();
            }

            @Override
            public void dispose() {
                this.nk.dispose();
            }

            public IEnumerator getIEnumerator() {
                return new IEnumerator(){

                    @Override
                    public Object next() {
                        Enumerator.this.nk.nk();
                        return Enumerator.this.et;
                    }

                    @Override
                    public boolean hasNext() {
                        return Enumerator.this.nk();
                    }

                    @Override
                    public void reset() {
                        Enumerator.this.et();
                    }

                    @Override
                    public void remove() {
                        Enumerator.this._remove();
                    }
                };
            }

            void et() {
                this.nk.reset();
            }

            @Override
            public void reset() {
                this.et();
            }

            public void _remove() {
                throw new NotSupportedException();
            }

            @Override
            public void remove() {
                this._remove();
            }

            @Override
            public void CloneTo(Enumerator that) {
                this.nk.CloneTo(that.nk);
                that.et = this.et;
            }

            @Override
            public Enumerator Clone() {
                Enumerator<TKey, TValue> enumerator = new Enumerator<TKey, TValue>();
                this.CloneTo(enumerator);
                return enumerator;
            }

            public Object clone() {
                return this.Clone();
            }

            private boolean et(Enumerator enumerator) {
                return dy.iy(enumerator.nk, this.nk) && dy.iy(enumerator.et, this.et);
            }

            public boolean equals(Object obj) {
                assert (obj != null);
                if (dy.nk(null, obj)) {
                    return false;
                }
                if (dy.nk(this, obj)) {
                    return true;
                }
                if (!(obj instanceof Enumerator)) {
                    return false;
                }
                return this.et((Enumerator)obj);
            }

            public static boolean equals(Enumerator obj1, Enumerator obj2) {
                return obj1.equals(obj2);
            }

            public int hashCode() {
                int n = this.nk != null ? this.nk.hashCode() : 0;
                n = 31 * n + (this.et != null ? this.et.hashCode() : 0);
                return n;
            }
        }
    }

    public static final class ValueCollection<TKey, TValue>
    implements IGenericCollection<TValue>,
    IGenericEnumerable<TValue> {
        private SortedDictionary<TKey, TValue> iy;

        public ValueCollection(SortedDictionary<TKey, TValue> dictionary) {
            this.iy = dictionary;
        }

        @Override
        public int size() {
            return this.iy.size();
        }

        void iy(TValue[] TValueArray, int n) {
            if (this.size() == 0) {
                return;
            }
            if (TValueArray == null) {
                throw new ArgumentNullException();
            }
            if (n < 0) {
                throw new ArgumentOutOfRangeException();
            }
            if (TValueArray.length <= n) {
                throw new ArgumentException();
            }
            if (TValueArray.length - n < this.size()) {
                throw new ArgumentException();
            }
            for (Node node : ((SortedDictionary)this.iy).iy.n2()) {
                TValueArray[n++] = node.nk;
            }
        }

        public void copyTo(TValue[] array, int index) {
            this.iy(array, index);
        }

        public Enumerator<TKey, TValue> iterator() {
            return new Enumerator<TKey, TValue>(this.iy);
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public void addItem(TValue tValue) {
            throw new NotSupportedException();
        }

        @Override
        public void clear() {
            throw new NotSupportedException();
        }

        @Override
        public boolean containsItem(TValue item) {
            return this.iy.containsValue(item);
        }

        @Override
        public void copyToTArray(TValue[] tValues, int i) {
            this.iy(tValues, i);
        }

        @Override
        public boolean removeItem(TValue tValue) {
            throw new NotSupportedException();
        }

        public ICollection getICollection() {
            return new ICollection(){

                @Override
                public int size() {
                    return ValueCollection.this.iy.size();
                }

                @Override
                public boolean isSynchronized() {
                    return false;
                }

                @Override
                public Object getSyncRoot() {
                    return ValueCollection.this.iy;
                }

                @Override
                public void copyTo(cv array, int index) {
                    if (this.size() == 0) {
                        return;
                    }
                    if (array == null) {
                        throw new ArgumentNullException();
                    }
                    if (index < 0 || array.lg() <= index) {
                        throw new ArgumentOutOfRangeException();
                    }
                    if (array.lg() - index < this.size()) {
                        throw new ArgumentException();
                    }
                    for (Node node : ValueCollection.this.iy.iy.n2()) {
                        array.et(node.nk, index++);
                    }
                }

                @Override
                public IEnumerator iterator() {
                    return new Enumerator(ValueCollection.this.iy).getIEnumerator();
                }
            };
        }

        public IEnumerable getIEnumerable() {
            return new IEnumerable(){

                public IEnumerator iterator() {
                    return new Enumerator(ValueCollection.this.iy).getIEnumerator();
                }
            };
        }

        public static class Enumerator<TKey, TValue>
        extends an<Enumerator>
        implements IGenericEnumerator<TValue>,
        IDisposable {
            private RBTree.NodeEnumerator nk = new RBTree.NodeEnumerator();
            private TValue et;

            public Enumerator() {
            }

            Enumerator(SortedDictionary<TKey, TValue> dictionary) {
                this();
                ((SortedDictionary)dictionary).iy.cv().CloneTo(this.nk);
            }

            TValue iy() {
                return this.et;
            }

            @Override
            public TValue next() {
                return this.iy();
            }

            boolean nk() {
                if (!this.nk.hasNext()) {
                    return false;
                }
                this.et = ((Node)this.nk.next()).nk;
                return true;
            }

            @Override
            public boolean hasNext() {
                return this.nk();
            }

            @Override
            public void dispose() {
                this.nk.dispose();
            }

            public IEnumerator getIEnumerator() {
                return new IEnumerator(){

                    @Override
                    public Object next() {
                        Enumerator.this.nk.nk();
                        return Enumerator.this.et;
                    }

                    @Override
                    public boolean hasNext() {
                        return Enumerator.this.nk();
                    }

                    @Override
                    public void reset() {
                        Enumerator.this.et();
                    }

                    @Override
                    public void remove() {
                        Enumerator.this.cv();
                    }
                };
            }

            void et() {
                this.nk.reset();
            }

            @Override
            public void reset() {
                this.et();
            }

            void cv() {
                throw new NotSupportedException();
            }

            @Override
            public void remove() {
                this.cv();
            }

            @Override
            public void CloneTo(Enumerator that) {
                this.nk.CloneTo(that.nk);
                that.et = this.et;
            }

            @Override
            public Enumerator Clone() {
                Enumerator<TKey, TValue> enumerator = new Enumerator<TKey, TValue>();
                this.CloneTo(enumerator);
                return enumerator;
            }

            public Object clone() {
                return this.Clone();
            }

            private boolean et(Enumerator enumerator) {
                return dy.iy(enumerator.nk, this.nk) && dy.iy(enumerator.et, this.et);
            }

            public boolean equals(Object obj) {
                assert (obj != null);
                if (dy.nk(null, obj)) {
                    return false;
                }
                if (dy.nk(this, obj)) {
                    return true;
                }
                if (!(obj instanceof Enumerator)) {
                    return false;
                }
                return this.et((Enumerator)obj);
            }

            public static boolean equals(Enumerator obj1, Enumerator obj2) {
                return obj1.equals(obj2);
            }

            public int hashCode() {
                int n = this.nk != null ? this.nk.hashCode() : 0;
                n = 31 * n + (this.et != null ? this.et.hashCode() : 0);
                return n;
            }
        }
    }

    private static class NodeHelper<TKey>
    implements RBTree.INodeHelper<TKey> {
        public Comparator<TKey> iy;
        static NodeHelper nk = new NodeHelper(Comparer.getDefault());

        @Override
        public int compare(TKey key, RBTree.Node node) {
            return this.iy.compare(key, ((Node)node).iy);
        }

        @Override
        public RBTree.Node createNode(TKey key) {
            return new Node(key);
        }

        private NodeHelper(Comparator<TKey> cmp) {
            this.iy = cmp;
        }

        public static NodeHelper iy(Comparator comparator) {
            if (comparator == null || comparator == Comparer.getDefault()) {
                return nk;
            }
            return new NodeHelper(comparator);
        }
    }

    private static class Node<TKey, TValue>
    extends RBTree.Node {
        public TKey iy;
        public TValue nk;

        public Node(TKey key) {
            this.iy = key;
        }

        public Node(TKey key, TValue value) {
            this.iy = key;
            this.nk = value;
        }

        @Override
        public void swapValue(RBTree.Node other) {
            Node node = (Node)other;
            TKey TKey = this.iy;
            this.iy = node.iy;
            node.iy = TKey;
            TValue TValue = this.nk;
            this.nk = node.nk;
            node.nk = TValue;
        }

        public KeyValuePair<TKey, TValue> iy() {
            return new KeyValuePair<TKey, TValue>(this.iy, this.nk);
        }

        public DictionaryEntry nk() {
            return new DictionaryEntry(this.iy, this.nk);
        }
    }
}

