/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericCollection;
import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.ArrayTypeMismatchException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.internal.vk.an;
import com.aspose.slides.internal.vk.et;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.cv;
import com.aspose.slides.ms.System.dy;
import com.aspose.slides.ms.System.ic;
import java.util.Arrays;

public class Stack<T>
implements IGenericEnumerable<T>,
ICollection<T> {
    private Object[] iy;
    private int nk;
    private int et;

    public Stack() {
    }

    public Stack(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.iy = new Object[capacity];
    }

    public Stack(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (Object t : collection) {
            this.push(t);
        }
    }

    public Stack(IGenericCollection<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        if (collection != null) {
            this.nk = collection.size();
            this.iy = new Object[this.nk];
            collection.copyToTArray(this.iy, 0);
        }
    }

    public void clear() {
        if (this.iy != null) {
            cv.iy(this.iy, 0, this.iy.length);
        }
        this.nk = 0;
        ++this.et;
    }

    public boolean contains(T item) {
        return this.iy != null && cv.iy(this.iy, item, 0, this.nk) != -1;
    }

    public void copyToTArray(T[] array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (arrayIndex >= array.length) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (this.nk - arrayIndex > array.length) {
            throw new ArgumentException("idx");
        }
        if (this.iy != null) {
            cv.iy(this.iy, 0, array, arrayIndex, this.nk);
            ic.iy(array, arrayIndex, this.nk);
        }
    }

    public T peek() {
        if (this.nk == 0) {
            throw new InvalidOperationException();
        }
        return (T)this.iy[this.nk - 1];
    }

    public T pop() {
        if (this.nk == 0) {
            throw new InvalidOperationException();
        }
        ++this.et;
        Object object = this.iy[--this.nk];
        this.iy[this.nk] = null;
        return (T)object;
    }

    public void push(T item) {
        if (this.iy == null || this.nk == this.iy.length) {
            if (this.iy == null) {
                this.iy = new Object[16];
            }
            this.iy = Arrays.copyOf(this.iy, this.nk == 0 ? 16 : 2 * this.nk);
        }
        ++this.et;
        this.iy[this.nk++] = item;
    }

    public <T> T[] toArray(T[] array) {
        if (array.length >= this.nk) {
            this.copyTo(cv.iy(array), 0);
            return array;
        }
        cv cv2 = cv.iy(com.aspose.slides.internal.vk.et.iy(array.getClass().getComponentType()), this.nk);
        this.copyTo(cv2, 0);
        return (Object[])cv.iy(cv2);
    }

    public void trimExcess() {
        if (this.iy != null && (double)this.nk < (double)this.iy.length * 0.9) {
            this.iy = Arrays.copyOf(this.iy, this.nk);
        }
        ++this.et;
    }

    @Override
    public int size() {
        return this.nk;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(cv dest, int idx) {
        try {
            if (dest == null) {
                throw new ArgumentNullException();
            }
            if (this.iy != null) {
                if (idx < 0) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (idx >= this.nk) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (this.nk - idx > dest.lg()) {
                    throw new ArgumentException("idx");
                }
                cv.iy(cv.iy(this.iy), 0, dest, idx, this.nk);
                cv.nk(dest, idx, this.nk);
            }
        }
        catch (ArrayTypeMismatchException arrayTypeMismatchException) {
            throw new ArgumentException();
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    public static class Enumerator<T>
    extends an<Enumerator>
    implements IGenericEnumerator<T>,
    IDisposable {
        private Stack<T> nk;
        private int et;
        private int cv;

        public Enumerator() {
        }

        Enumerator(Stack<T> t) {
            this.nk = t;
            this.et = -2;
            this.cv = ((Stack)t).et;
        }

        @Override
        public void dispose() {
            this.et = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.cv != ((Stack)this.nk).et) {
                throw new IllegalStateException();
            }
            if (this.et == -2) {
                this.et = ((Stack)this.nk).nk;
            }
            return this.et != -1 && --this.et != -1;
        }

        @Override
        public T next() {
            if (this.et < 0) {
                throw new InvalidOperationException();
            }
            return (T)((Stack)this.nk).iy[this.et];
        }

        @Override
        public void reset() {
            if (this.cv != ((Stack)this.nk).et) {
                throw new IllegalStateException();
            }
            this.et = -2;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator that) {
            that.nk = this.nk;
            that.et = this.et;
            that.cv = this.cv;
        }

        @Override
        public Enumerator Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean iy(Enumerator enumerator) {
            return dy.iy(enumerator.nk, this.nk) && enumerator.et == this.et && enumerator.cv == this.cv;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (dy.nk(null, obj)) {
                return false;
            }
            if (dy.nk(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.iy((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.nk != null ? this.nk.hashCode() : 0;
            n = 31 * n + this.et;
            n = 31 * n + this.cv;
            return n;
        }
    }
}

