/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.Generic.IGenericEqualityComparer;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IHashCodeProvider;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.exceptions.SerializationException;
import com.aspose.slides.internal.ej.tg;
import com.aspose.slides.internal.sd.cv;
import com.aspose.slides.internal.sd.et;
import com.aspose.slides.internal.sd.lg;
import com.aspose.slides.internal.vk.an;
import com.aspose.slides.internal.vk.n2;
import com.aspose.slides.internal.xf.iy;
import com.aspose.slides.internal.xf.nk;
import com.aspose.slides.ms.System.bu;
import com.aspose.slides.ms.System.dy;
import com.aspose.slides.ms.System.i2;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Hashtable
implements ICollection,
IDictionary,
IEnumerable,
i2,
Map {
    private IGenericEqualityComparer iy;
    private final Object nk = new Object();
    private Bucket[] et;
    private int cv;
    private volatile boolean lg;
    private ICollection n2;
    private float an;
    private int bm;
    private et tg;
    private int p1;
    private ICollection hw;
    private volatile int e7;
    private static final n2 tm = new n2("LoadFactor", "HashSize", "KeyComparer", "Comparer", "HashCodeProvider", "Keys", "Values");

    public Hashtable() {
        this(0, 1.0f);
    }

    Hashtable(boolean trash) {
    }

    public Hashtable(IDictionary d) {
        this(d, 1.0f);
    }

    public Hashtable(IGenericEqualityComparer equalityComparer) {
        this(0, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity) {
        this(capacity, 1.0f);
    }

    public Hashtable(IDictionary d, IGenericEqualityComparer equalityComparer) {
        this(d, 1.0f, equalityComparer);
    }

    public Hashtable(IDictionary d, float loadFactor) {
        this(d, loadFactor, (IGenericEqualityComparer)null);
    }

    @Deprecated
    public Hashtable(IHashCodeProvider hcp2, Comparator comparer) {
        this(0, 1.0f, hcp2, comparer);
    }

    public Hashtable(int capacity, IGenericEqualityComparer equalityComparer) {
        this(capacity, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity, float loadFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Non-negative number required");
        }
        if (loadFactor < 0.1f || loadFactor > 1.0f || Float.isNaN(loadFactor)) {
            throw new ArgumentOutOfRangeException("loadFactor", bu.iy("Load factor needs to be between {0} and {1}", 0.1, 1.0));
        }
        this.an = 0.72f * loadFactor;
        double d = (float)capacity / this.an;
        if (d > 2.147483647E9) {
            throw new ArgumentException("Hashtable's capacity overflowed and went negative. Check load factor, capacity and the current size of the table");
        }
        int n = d > 11.0 ? com.aspose.slides.internal.xf.iy.iy((int)d) : 11;
        this.et = this.nk(n);
        this.bm = (int)(this.an * (float)n);
        this.lg = false;
    }

    protected Hashtable(et info, lg context) {
        this.tg = info;
    }

    @Deprecated
    public Hashtable(IDictionary d, IHashCodeProvider hcp2, Comparator comparer) {
        this(d, 1.0f, hcp2, comparer);
    }

    public Hashtable(IDictionary d, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(d != null ? d.size() : 0, loadFactor, equalityComparer);
        if (d == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, IHashCodeProvider hcp2, Comparator comparer) {
        this(capacity, 1.0f, hcp2, comparer);
    }

    public Hashtable(int capacity, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(capacity, loadFactor);
        this.iy = equalityComparer;
    }

    @Deprecated
    public Hashtable(IDictionary d, float loadFactor, IHashCodeProvider hcp2, Comparator comparer) {
        this(d != null ? d.size() : 0, loadFactor, hcp2, comparer);
        if (d == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, float loadFactor, IHashCodeProvider hcp2, Comparator comparer) {
        this(capacity, loadFactor);
        this.iy = hcp2 == null && comparer == null ? null : new CompatibleComparer(comparer, hcp2);
    }

    @Override
    public void addItem(Object key, Object value) {
        this.iy(key, value, true);
    }

    @Override
    public void clear() {
        if (this.cv != 0) {
            this.lg = true;
            for (int i = 0; i < this.et.length; ++i) {
                this.et[i].et = 0;
                this.et[i].iy = null;
                this.et[i].nk = null;
            }
            this.cv = 0;
            this.p1 = 0;
            this.cv();
            this.lg = false;
        }
    }

    @Override
    public Object deepClone() {
        Bucket[] bucketArray = this.et;
        Hashtable hashtable = new Hashtable(this.cv, this.iy);
        hashtable.e7 = this.e7;
        hashtable.an = this.an;
        hashtable.cv = 0;
        int n = this.et.length;
        while (n > 0) {
            Object object = bucketArray[--n].iy;
            if (object == null || object == bucketArray) continue;
            hashtable.set_Item(object, bucketArray[n].nk);
        }
        return hashtable;
    }

    @Override
    public boolean contains(Object key) {
        return this.containsKey(key);
    }

    @Override
    public boolean containsKey(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.et;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.iy(key, this.et.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.et.length);
        do {
            bucketArray[n10].iy(bucket);
            if (bucket.iy == null) {
                return false;
            }
            if ((long)(bucket.et & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.iy, key)) {
                return true;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.et.length);
        } while (bucket.et < 0 && ++n < this.et.length);
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            int n = this.et.length;
            while (--n >= 0) {
                if (this.et[n].iy == null || this.et[n].iy == this.et || this.et[n].nk != null) continue;
                return true;
            }
        } else {
            int n = this.et.length;
            while (--n >= 0) {
                Object object = this.et[n].nk;
                if (object == null || !object.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    private void et(com.aspose.slides.ms.System.cv cv2, int n) {
        Bucket[] bucketArray = this.et;
        int n10 = this.et.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].iy;
            if (object == null || object == this.et) continue;
            DictionaryEntry dictionaryEntry = new DictionaryEntry(object, bucketArray[n10].nk);
            cv2.et(dictionaryEntry.Clone(), n++);
        }
    }

    void iy(com.aspose.slides.ms.System.cv cv2, int n) {
        Bucket[] bucketArray = this.et;
        int n10 = this.et.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].iy;
            if (object == null || object == this.et) continue;
            cv2.et(object, n++);
        }
    }

    @Override
    public void copyTo(com.aspose.slides.ms.System.cv array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array", "Array cannot be null");
        }
        if (array.cv() != 1) {
            throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
        }
        if (array.lg() - arrayIndex < this.cv) {
            throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
        }
        this.et(array, arrayIndex);
    }

    void nk(com.aspose.slides.ms.System.cv cv2, int n) {
        Bucket[] bucketArray = this.et;
        int n10 = this.et.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].iy;
            if (object == null || object == this.et) continue;
            cv2.et(bucketArray[n10].nk, n++);
        }
    }

    private void nk() {
        int n = com.aspose.slides.internal.xf.iy.iy(this.et.length * 2);
        this.iy(n);
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new HashtableEnumerator(this, 3);
    }

    protected int getHash(Object key) {
        if (this.iy != null) {
            return this.iy.hashCode(key);
        }
        return key.hashCode();
    }

    public void getObjectData(et info, lg context) {
        Object[] objectArray;
        if (info == null) {
            throw new ArgumentNullException("info");
        }
        info.iy("LoadFactor", this.an);
        info.iy("Version", this.e7);
        if (this.iy == null) {
            info.iy("Comparer", null, com.aspose.slides.internal.vk.et.iy(Comparator.class));
            info.iy("HashCodeProvider", null, com.aspose.slides.internal.vk.et.iy(IHashCodeProvider.class));
        } else if (this.iy instanceof CompatibleComparer) {
            objectArray = (Object[])com.aspose.slides.internal.vk.et.iy(this.iy, CompatibleComparer.class);
            info.iy("Comparer", objectArray.iy(), com.aspose.slides.internal.vk.et.iy(Comparator.class));
            info.iy("HashCodeProvider", objectArray.nk(), com.aspose.slides.internal.vk.et.iy(IHashCodeProvider.class));
        } else {
            info.iy("KeyComparer", this.iy, com.aspose.slides.internal.vk.et.iy(IGenericEqualityComparer.class));
        }
        info.iy("HashSize", this.et.length);
        objectArray = new Object[this.cv];
        Object[] objectArray2 = new Object[this.cv];
        this.iy(com.aspose.slides.ms.System.cv.iy(objectArray), 0);
        this.nk(com.aspose.slides.ms.System.cv.iy(objectArray2), 0);
        info.iy("Keys", objectArray, com.aspose.slides.internal.vk.et.iy(Object[].class));
        info.iy("Values", objectArray2, com.aspose.slides.internal.vk.et.iy(Object[].class));
    }

    private long iy(Object object, int n, long[] lArray, long[] lArray2) {
        long l;
        lArray[0] = l = (long)(this.getHash(object) & Integer.MAX_VALUE);
        lArray2[0] = 1L + (((lArray[0] & 0xFFFFFFFFL) >> 5) + 1L) % (long)(n - 1);
        return l;
    }

    private void iy(Object object, Object object2, boolean bl2) {
        block12: {
            long l = 0L;
            long l10 = 0L;
            if (object == null) {
                throw new ArgumentNullException("key", "Key cannot be null");
            }
            if (this.cv >= this.bm) {
                this.nk();
            } else if (this.p1 > this.bm && this.cv > 100) {
                this.et();
            }
            long[] lArray = new long[]{0L};
            long[] lArray2 = new long[]{0L};
            long l11 = this.iy(object, this.et.length, lArray, lArray2);
            l = lArray[0];
            l10 = lArray2[0];
            int n = 0;
            int n10 = -1;
            int n11 = (int)((l & 0xFFFFFFFFL) % (long)this.et.length);
            do {
                if (n10 == -1 && this.et[n11].iy == this.et && this.et[n11].et < 0) {
                    n10 = n11;
                }
                if (this.et[n11].iy == null || this.et[n11].iy == this.et && ((long)this.et[n11].et & 0x80000000L) == 0L) {
                    if (n10 != -1) {
                        n11 = n10;
                    }
                    this.lg = true;
                    this.et[n11].nk = object2;
                    this.et[n11].iy = object;
                    this.et[n11].et |= (int)(l11 & 0xFFFFFFFFL);
                    ++this.cv;
                    this.cv();
                    this.lg = false;
                    break block12;
                }
                if ((long)(this.et[n11].et & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(this.et[n11].iy, object)) {
                    if (bl2) {
                        throw new ArgumentException(bu.iy("Item has already been added. Key in dictionary: '{0}'  Key being added: '{1}'", this.et[n11].iy, object));
                    }
                    this.lg = true;
                    this.et[n11].nk = object2;
                    this.cv();
                    this.lg = false;
                    break block12;
                }
                if (n10 == -1 && this.et[n11].et >= 0) {
                    this.et[n11].et = (int)((long)this.et[n11].et | Integer.MIN_VALUE);
                    ++this.p1;
                }
                n11 = (int)(((long)n11 + (l10 & 0xFFFFFFFFL)) % (long)this.et.length);
            } while (++n < this.et.length);
            if (n10 == -1) {
                throw new InvalidOperationException("Hashtable insert failed. Load factor too high.");
            }
            this.lg = true;
            this.et[n10].nk = object2;
            this.et[n10].iy = object;
            this.et[n10].et |= (int)(l11 & 0xFFFFFFFFL);
            ++this.cv;
            this.cv();
            this.lg = false;
        }
    }

    protected boolean keyEquals(Object item, Object key) {
        if (dy.nk(this.et, item)) {
            return false;
        }
        if (this.iy != null) {
            return this.iy.equals(item, key);
        }
        return item != null && item.equals(key);
    }

    public void onDeserialization(Object sender) {
        if (this.et == null) {
            if (this.tg == null) {
                throw new SerializationException("OnDeserialization method was called while the object was not being deserialized.");
            }
            int n = 0;
            Comparator comparator = null;
            IHashCodeProvider iHashCodeProvider = null;
            Object[] objectArray = null;
            Object[] objectArray2 = null;
            cv cv2 = this.tg.iy();
            while (cv2.hasNext()) {
                switch (tm.iy(cv2.nk())) {
                    case 0: {
                        this.an = this.tg.nk("LoadFactor");
                        break;
                    }
                    case 1: {
                        n = this.tg.iy("HashSize");
                        break;
                    }
                    case 2: {
                        this.iy = (IGenericEqualityComparer)this.tg.iy("KeyComparer", com.aspose.slides.internal.vk.et.iy(IGenericEqualityComparer.class));
                        break;
                    }
                    case 3: {
                        comparator = (Comparator)this.tg.iy("Comparer", com.aspose.slides.internal.vk.et.iy(Comparator.class));
                        break;
                    }
                    case 4: {
                        iHashCodeProvider = (IHashCodeProvider)this.tg.iy("HashCodeProvider", com.aspose.slides.internal.vk.et.iy(IHashCodeProvider.class));
                        break;
                    }
                    case 5: {
                        objectArray = (Object[])this.tg.iy("Keys", com.aspose.slides.internal.vk.et.iy(Object[].class));
                        break;
                    }
                    case 6: {
                        objectArray2 = (Object[])this.tg.iy("Values", com.aspose.slides.internal.vk.et.iy(Object[].class));
                    }
                }
            }
            this.bm = (int)(this.an * (float)n);
            if (this.iy == null && (comparator != null || iHashCodeProvider != null)) {
                this.iy = new CompatibleComparer(comparator, iHashCodeProvider);
            }
            this.et = this.nk(n);
            if (objectArray == null) {
                throw new SerializationException("The Keys for this dictionary are missing");
            }
            if (objectArray2 == null) {
                throw new SerializationException("The Values for this dictionary are missing");
            }
            if (objectArray.length != objectArray2.length) {
                throw new SerializationException("The keys and values arrays have different sizes");
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    throw new SerializationException("One of the serialized keys is null");
                }
                this.iy(objectArray[i], objectArray2[i], true);
            }
            this.e7 = this.tg.iy("Version");
            this.tg = null;
        }
    }

    private void iy(Bucket[] bucketArray, Object object, Object object2, int n) {
        long l = 1L + ((((long)n & 0xFFFFFFFFL) >> 5) + 1L) % (long)(bucketArray.length - 1);
        int n10 = (int)(((long)n & 0xFFFFFFFFL) % (long)bucketArray.length);
        while (true) {
            if (bucketArray[n10].iy == null || bucketArray[n10].iy == this.et) {
                bucketArray[n10].nk = object2;
                bucketArray[n10].iy = object;
                bucketArray[n10].et |= n;
                break;
            }
            if (bucketArray[n10].et >= 0) {
                bucketArray[n10].et = (int)((long)bucketArray[n10].et | Integer.MIN_VALUE);
                ++this.p1;
            }
            n10 = (int)(((long)n10 + (l & 0xFFFFFFFFL)) % (long)bucketArray.length);
        }
    }

    private void et() {
        this.iy(this.et.length);
    }

    private void iy(int n) {
        this.p1 = 0;
        Bucket[] bucketArray = this.nk(n);
        for (int i = 0; i < this.et.length; ++i) {
            Bucket bucket = this.et[i].iy();
            if (bucket.iy == null || bucket.iy == this.et) continue;
            this.iy(bucketArray, bucket.iy, bucket.nk, bucket.et & Integer.MAX_VALUE);
        }
        this.lg = true;
        this.et = bucketArray;
        this.bm = (int)(this.an * (float)n);
        this.cv();
        this.lg = false;
    }

    @Override
    public void removeItem(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.iy(key, this.et.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.et.length);
        do {
            this.et[n10].iy(bucket);
            if ((long)(bucket.et & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.iy, key)) {
                this.lg = true;
                this.et[n10].et = (int)((long)this.et[n10].et & Integer.MIN_VALUE);
                this.et[n10].iy = this.et[n10].et != 0 ? this.et : null;
                this.et[n10].nk = null;
                --this.cv;
                this.cv();
                this.lg = false;
                break;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.et.length);
        } while (bucket.et < 0 && ++n < this.et.length);
    }

    public static Hashtable sync(Hashtable table) {
        if (table == null) {
            throw new ArgumentNullException("table");
        }
        return new SyncHashtable(table);
    }

    KeyValuePairs[] iy() {
        KeyValuePairs[] keyValuePairsArray = new KeyValuePairs[this.cv];
        int n = 0;
        Bucket[] bucketArray = this.et;
        int n10 = this.et.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].iy;
            if (object == null || object == this.et) continue;
            keyValuePairsArray[n++] = new KeyValuePairs(object, bucketArray[n10].nk);
        }
        return keyValuePairsArray;
    }

    private void cv() {
        ++this.e7;
    }

    private Bucket[] nk(int n) {
        Bucket[] bucketArray = new Bucket[n];
        for (int i = 0; i < bucketArray.length; ++i) {
            bucketArray[i] = new Bucket();
        }
        return bucketArray;
    }

    @Override
    public int size() {
        return this.cv;
    }

    protected IGenericEqualityComparer getEqualityComparer() {
        return this.iy;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object get_Item(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.et;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.iy(key, this.et.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.et.length);
        do {
            int n11;
            int n12 = 0;
            do {
                n11 = this.e7;
                bucketArray[n10].iy(bucket);
                if (++n12 % 8 != 0) continue;
                com.aspose.slides.internal.ej.tg.nk(1);
            } while (this.lg || n11 != this.e7);
            if (bucket.iy == null) break;
            if ((long)(bucket.et & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.iy, key)) {
                return bucket.nk;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.et.length);
        } while (bucket.et < 0 && ++n < this.et.length);
        return null;
    }

    @Override
    public void set_Item(Object key, Object value) {
        this.iy(key, value, false);
    }

    @Override
    public ICollection getKeys() {
        if (this.n2 == null) {
            this.n2 = new KeyCollection(this);
        }
        return this.n2;
    }

    @Override
    public Object getSyncRoot() {
        return this.nk;
    }

    @Override
    public ICollection getValues() {
        if (this.hw == null) {
            this.hw = new ValueCollection(this);
        }
        return this.hw;
    }

    @Override
    public boolean isEmpty() {
        return this.cv == 0;
    }

    public Object get(Object key) {
        return this.get_Item(key);
    }

    public Object put(Object key, Object value) {
        Object object = this.get_Item(key);
        this.set_Item(key, value);
        return object;
    }

    public Object remove(Object key) {
        Object object = this.get_Item(key);
        this.removeItem(key);
        return object;
    }

    public void putAll(Map m) {
        Set set = m.keySet();
        for (Object k : set) {
            Object v = m.get(k);
            this.put(k, v);
        }
    }

    public Set keySet() {
        Object[] objectArray = new Object[this.size()];
        com.aspose.slides.ms.System.cv cv2 = com.aspose.slides.ms.System.cv.iy(objectArray);
        this.getKeys().copyTo(cv2, 0);
        return new ReadOnlyItemCollection(cv2);
    }

    public Collection values() {
        Object[] objectArray = new Object[this.size()];
        com.aspose.slides.ms.System.cv cv2 = com.aspose.slides.ms.System.cv.iy(objectArray);
        this.getValues().copyTo(cv2, 0);
        return new ReadOnlyItemCollection(cv2);
    }

    public Set entrySet() {
        KeyValuePairs[] keyValuePairsArray = this.iy();
        Map.Entry[] entryArray = new Map.Entry[keyValuePairsArray.length];
        for (int i = 0; i < entryArray.length; ++i) {
            entryArray[i] = new AbstractMap.SimpleEntry<Object, Object>(keyValuePairsArray[i].iy(), keyValuePairsArray[i].nk());
        }
        return new ReadOnlyItemCollection(com.aspose.slides.ms.System.cv.iy(entryArray));
    }

    public int getVersion() {
        return this.e7;
    }

    public static Hashtable fromJava(Map map) {
        if (map == null) {
            return null;
        }
        return new nk(map);
    }

    public static Map toJava(Hashtable h) {
        return h;
    }

    private class ReadOnlyItemCollection
    implements Set {
        private com.aspose.slides.ms.System.cv nk;

        ReadOnlyItemCollection(com.aspose.slides.ms.System.cv items) {
            this.nk = items;
        }

        @Override
        public int size() {
            return this.nk.size();
        }

        @Override
        public boolean isEmpty() {
            return this.nk.size() == 0;
        }

        @Override
        public boolean contains(Object o) {
            return this.nk.contains(o);
        }

        @Override
        public Iterator iterator() {
            return this.nk.iterator();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            com.aspose.slides.ms.System.cv cv2 = com.aspose.slides.ms.System.cv.iy(objectArray);
            this.nk.copyTo(cv2, 0);
            return objectArray;
        }

        @Override
        public boolean add(Object o) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean remove(Object o) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean containsAll(Collection c) {
            for (Object e : c) {
                if (this.contains(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public Object[] toArray(Object[] a) {
            if (a.length <= this.size()) {
                a = new Object[this.size()];
            }
            this.nk.copyTo(com.aspose.slides.ms.System.cv.iy(a), 0);
            return a;
        }
    }

    private static class HashtableDebugView {
    }

    private static class SyncHashtable
    extends Hashtable {
        protected Hashtable iy;

        SyncHashtable(Hashtable table) {
            super(false);
            this.iy = table;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key, Object value) {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                this.iy.addItem(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                this.iy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                return Hashtable.sync((Hashtable)this.iy.deepClone());
            }
        }

        @Override
        public boolean contains(Object key) {
            return this.iy.contains(key);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.iy.containsKey(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object key) {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                return this.iy.containsValue(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(com.aspose.slides.ms.System.cv array, int arrayIndex) {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                this.iy.copyTo(array, arrayIndex);
            }
        }

        @Override
        public IDictionaryEnumerator iterator() {
            return this.iy.iterator();
        }

        @Override
        public void getObjectData(et info, lg context) {
            if (info == null) {
                throw new ArgumentNullException("info");
            }
            info.iy("ParentTable", this.iy, com.aspose.slides.internal.vk.et.iy(Hashtable.class));
        }

        @Override
        public void onDeserialization(Object sender) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key) {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                this.iy.removeItem(key);
            }
        }

        @Override
        KeyValuePairs[] iy() {
            return this.iy.iy();
        }

        @Override
        public int size() {
            return this.iy.size();
        }

        @Override
        public boolean isFixedSize() {
            return this.iy.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.iy.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object get_Item(Object key) {
            return this.iy.get_Item(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key, Object value) {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                this.iy.set_Item(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                return this.iy.getKeys();
            }
        }

        @Override
        public Object getSyncRoot() {
            return this.iy.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                return this.iy.getValues();
            }
        }
    }

    private static class ValueCollection
    implements ICollection,
    IEnumerable {
        private Hashtable iy;

        ValueCollection(Hashtable hashtable) {
            this.iy = hashtable;
        }

        @Override
        public void copyTo(com.aspose.slides.ms.System.cv array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.cv() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.lg() - arrayIndex < this.iy.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.iy.nk(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.iy, 2);
        }

        @Override
        public int size() {
            return this.iy.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.iy.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.iy.getSyncRoot();
        }
    }

    private static class KeyCollection
    implements ICollection,
    IEnumerable {
        private Hashtable iy;

        KeyCollection(Hashtable hashtable) {
            this.iy = hashtable;
        }

        @Override
        public void copyTo(com.aspose.slides.ms.System.cv array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.cv() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.lg() - arrayIndex < this.iy.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.iy.iy(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.iy, 1);
        }

        @Override
        public int size() {
            return this.iy.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.iy.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.iy.getSyncRoot();
        }
    }

    private static class HashtableEnumerator
    implements IDictionaryEnumerator,
    IEnumerator {
        private int iy;
        private boolean nk;
        private Object et;
        private Object cv;
        private int lg;
        private Hashtable n2;
        private int an;

        HashtableEnumerator(Hashtable hashtable, int getObjRetType) {
            this.n2 = hashtable;
            this.iy = hashtable.et.length;
            this.an = hashtable.e7;
            this.nk = false;
            this.lg = getObjRetType;
        }

        @Override
        public boolean hasNext() {
            if (this.an != this.n2.e7) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            while (this.iy > 0) {
                --this.iy;
                Object object = ((Hashtable)this.n2).et[this.iy].iy;
                if (object == null || object == this.n2.et) continue;
                this.et = object;
                this.cv = ((Hashtable)this.n2).et[this.iy].nk;
                this.nk = true;
                return true;
            }
            this.nk = false;
            return false;
        }

        @Override
        public void reset() {
            if (this.an != this.n2.e7) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            this.nk = false;
            this.iy = this.n2.et.length;
            this.et = null;
            this.cv = null;
        }

        @Override
        public Object next() {
            if (!this.nk) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            if (this.lg == 1) {
                return this.et;
            }
            if (this.lg == 2) {
                return this.cv;
            }
            return new DictionaryEntry(this.et, this.cv);
        }

        @Override
        public DictionaryEntry getEntry() {
            if (!this.nk) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return new DictionaryEntry(this.et, this.cv);
        }

        @Override
        public Object getKey() {
            if (!this.nk) {
                throw new InvalidOperationException("Enumeration has not started. Call HasNext");
            }
            return this.et;
        }

        @Override
        public Object getValue() {
            if (!this.nk) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return this.cv;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static class KeyValuePairs {
        private Object iy;
        private Object nk;

        public KeyValuePairs(Object key, Object value) {
            this.nk = value;
            this.iy = key;
        }

        public Object iy() {
            return this.iy;
        }

        public Object nk() {
            return this.nk;
        }
    }

    private static class Bucket
    extends an<Bucket> {
        public Object iy;
        public Object nk;
        public int et;

        public void iy(Bucket bucket) {
            bucket.iy = this.iy;
            bucket.nk = this.nk;
            bucket.et = this.et;
        }

        public Bucket iy() {
            Bucket bucket = new Bucket();
            this.iy(bucket);
            return bucket;
        }

        public Object clone() {
            return this.iy();
        }

        private boolean nk(Bucket bucket) {
            return dy.iy(bucket.iy, this.iy) && dy.iy(bucket.nk, this.nk) && bucket.et == this.et;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (dy.nk(null, obj)) {
                return false;
            }
            if (dy.nk(this, obj)) {
                return true;
            }
            if (!(obj instanceof Bucket)) {
                return false;
            }
            return this.nk((Bucket)obj);
        }

        public int hashCode() {
            int n = this.iy != null ? this.iy.hashCode() : 0;
            n = 31 * n + (this.nk != null ? this.nk.hashCode() : 0);
            n = 31 * n + this.et;
            return n;
        }

        @Override
        public /* synthetic */ Object Clone() {
            return this.iy();
        }

        @Override
        public /* synthetic */ void CloneTo(Object object) {
            this.iy((Bucket)object);
        }
    }

    private static class CompatibleComparer
    implements IGenericEqualityComparer {
        private Comparator iy;
        private IHashCodeProvider nk;

        CompatibleComparer(Comparator comparer, IHashCodeProvider hashCodeProvider) {
            this.iy = comparer;
            this.nk = hashCodeProvider;
        }

        public int iy(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (this.iy != null) {
                return this.iy.compare(object, object2);
            }
            Comparable comparable = (Comparable)((Object)com.aspose.slides.internal.vk.et.iy(object, Comparable.class));
            if (comparable == null) {
                throw new ArgumentException("At least one object must implement java.lang.Comparable");
            }
            return comparable.compareTo(object2);
        }

        @Override
        public boolean equals(Object x, Object y) {
            return this.equalsT(x, y);
        }

        @Override
        public int hashCode(Object obj) {
            return this.hashCodeT(obj);
        }

        public boolean equalsT(Object a, Object b) {
            return this.iy(a, b) == 0;
        }

        public int hashCodeT(Object obj) {
            if (obj == null) {
                throw new ArgumentNullException("obj");
            }
            if (this.nk != null) {
                return this.nk.hashCode(obj);
            }
            return obj.hashCode();
        }

        Comparator iy() {
            return this.iy;
        }

        IHashCodeProvider nk() {
            return this.nk;
        }
    }
}

