/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.ObjectModel;

import com.aspose.slides.Collections.Generic.Dictionary;
import com.aspose.slides.Collections.Generic.EqualityComparer;
import com.aspose.slides.Collections.Generic.IGenericDictionary;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.IGenericEqualityComparer;
import com.aspose.slides.Collections.ObjectModel.Collection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.KeyNotFoundException;

public abstract class KeyedCollection<TKey, TItem>
extends Collection<TItem> {
    private Dictionary<TKey, TItem> iy;
    private IGenericEqualityComparer<TKey> nk;
    private int et;

    protected KeyedCollection() {
        this(null, 0);
    }

    protected KeyedCollection(IGenericEqualityComparer<TKey> comparer) {
        this(comparer, 0);
    }

    protected KeyedCollection(IGenericEqualityComparer<TKey> comparer, int dictionaryCreationThreshold) {
        this.nk = comparer != null ? comparer : new EqualityComparer.DefaultComparer<TKey>();
        this.et = dictionaryCreationThreshold;
        if (dictionaryCreationThreshold == 0) {
            this.iy = new Dictionary(this.nk);
        }
    }

    public boolean containsKey(TKey key) {
        if (this.iy != null) {
            return this.iy.containsKey(key);
        }
        return this.iy(key) >= 0;
    }

    private int iy(TKey TKey) {
        for (int i = this.size() - 1; i >= 0; --i) {
            TKey TKey2 = this.getKeyForItem(super.get_Item(i));
            if (!this.nk.equalsT(TKey, TKey2)) continue;
            return i;
        }
        return -1;
    }

    public boolean removeByKey(TKey key) {
        Object object = null;
        if (this.iy != null) {
            Object[] objectArray = new Object[]{object};
            boolean bl2 = this.iy.tryGetValue(key, objectArray);
            object = objectArray[0];
            if (bl2) {
                return super.removeItem(object);
            }
            return false;
        }
        int n = this.iy(key);
        if (n == -1) {
            return false;
        }
        this.removeAt(n);
        return true;
    }

    public IGenericEqualityComparer<TKey> getComparer() {
        return this.nk;
    }

    @Override
    public TItem get_Item(int index) {
        if (this.iy != null && ((Dictionary.KeyCollection)this.iy.getKeys()).size() > 0) {
            IGenericEnumerator iGenericEnumerator = ((Dictionary.KeyCollection)this.iy.getKeys()).iterator();
            if (iGenericEnumerator.hasNext() && iGenericEnumerator.next() instanceof Integer) {
                return this.get_Item((TKey)index);
            }
            return (TItem)super.get_Item(index);
        }
        return (TItem)super.get_Item(index);
    }

    public TItem get_Item(TKey key) {
        if (this.iy != null) {
            return this.iy.get_Item(key);
        }
        int n = this.iy(key);
        if (n >= 0) {
            return (TItem)super.get_Item(n);
        }
        throw new KeyNotFoundException();
    }

    protected void changeItemKey(TItem item, TKey newKey) {
        if (!this.containsItem(item)) {
            throw new ArgumentException();
        }
        TKey TKey = this.getKeyForItem(item);
        if (this.nk.equalsT(TKey, newKey)) {
            return;
        }
        if (this.containsKey(newKey)) {
            throw new ArgumentException();
        }
        if (this.iy != null) {
            if (!this.iy.removeItemByKey(TKey)) {
                throw new ArgumentException();
            }
            this.iy.addItem(newKey, item);
        }
    }

    @Override
    public void clear() {
        if (this.iy != null) {
            this.iy.clear();
        }
        super.clear();
    }

    protected abstract TKey getKeyForItem(TItem var1);

    @Override
    public void insertItem(int index, TItem item) {
        int n;
        TKey TKey = this.getKeyForItem(item);
        if (TKey == null) {
            throw new ArgumentNullException("GetKeyForItem(item)");
        }
        if (this.iy != null && this.iy.containsKey(TKey)) {
            throw new ArgumentException("An element with the same key already exists in the dictionary.");
        }
        if (this.iy == null) {
            for (n = 0; n < this.size(); ++n) {
                if (!this.nk.equalsT(TKey, this.getKeyForItem(super.get_Item(n)))) continue;
                throw new ArgumentException("An element with the same key already exists in the dictionary.");
            }
        }
        super.insertItem(index, item);
        if (this.iy != null) {
            this.iy.addItem(TKey, item);
        } else if (this.et != -1 && this.size() > this.et) {
            this.iy = new Dictionary(this.nk);
            for (n = 0; n < this.size(); ++n) {
                Object t = super.get_Item(n);
                this.iy.addItem(this.getKeyForItem(t), t);
            }
        }
    }

    @Override
    public void removeAt(int index) {
        if (this.iy != null) {
            TKey TKey = this.getKeyForItem(super.get_Item(index));
            this.iy.removeItemByKey(TKey);
        }
        super.removeAt(index);
    }

    @Override
    public void setItem(int index, TItem item) {
        if (this.iy != null) {
            this.iy.removeItemByKey(this.getKeyForItem(super.get_Item(index)));
            this.iy.addItem(this.getKeyForItem(item), item);
        }
        super.setItem(index, item);
    }

    protected IGenericDictionary<TKey, TItem> getDictionary() {
        return this.iy;
    }
}

