/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.cv;
import com.aspose.slides.ms.System.i2;
import java.util.Arrays;

public class Queue
implements ICollection,
IEnumerable,
i2 {
    private Object[] iy;
    private int nk = 0;
    private int et = 0;
    private int cv = 0;
    private int lg;
    private int n2 = 0;

    public Queue() {
        this(32, 2.0f);
    }

    public Queue(int capacity) {
        this(capacity, 2.0f);
    }

    public Queue(ICollection col) {
        this(col == null ? 32 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e : col) {
            this.enqueue(e);
        }
    }

    public Queue(int capacity, float growFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Needs a non-negative number");
        }
        if (!(growFactor >= 1.0f) || !(growFactor <= 10.0f)) {
            throw new ArgumentOutOfRangeException("growFactor", "Queue growth factor must be between 1.0 and 10.0, inclusive");
        }
        this.iy = new Object[capacity];
        this.lg = (int)(growFactor * 100.0f);
    }

    @Override
    public int size() {
        return this.et;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(cv array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.cv() > 1 || index != 0 && index >= array.lg() || this.et > array.lg() - index) {
            throw new ArgumentException();
        }
        int n = this.iy.length;
        int n10 = n - this.nk;
        com.aspose.slides.ms.System.cv.iy(com.aspose.slides.ms.System.cv.iy(this.iy), this.nk, array, index, Math.min(this.et, n10));
        if (this.et > n10) {
            com.aspose.slides.ms.System.cv.iy(com.aspose.slides.ms.System.cv.iy(this.iy), 0, array, index + n10, this.et - n10);
        }
    }

    public IEnumerator iterator() {
        return new QueueEnumerator(this);
    }

    @Override
    public Object deepClone() {
        Queue queue = new Queue(this.iy.length);
        queue.lg = this.lg;
        com.aspose.slides.ms.System.cv.iy(this.iy, 0, queue.iy, 0, this.iy.length);
        queue.nk = this.nk;
        queue.et = this.et;
        queue.cv = this.cv;
        return queue;
    }

    public void clear() {
        ++this.n2;
        this.nk = 0;
        this.et = 0;
        this.cv = 0;
        for (int i = this.iy.length - 1; i >= 0; --i) {
            this.iy[i] = null;
        }
    }

    public boolean contains(Object obj) {
        int n = this.nk + this.et;
        if (obj == null) {
            for (int i = this.nk; i < n; ++i) {
                if (this.iy[i % this.iy.length] != null) continue;
                return true;
            }
        } else {
            for (int i = this.nk; i < n; ++i) {
                if (!obj.equals(this.iy[i % this.iy.length])) continue;
                return true;
            }
        }
        return false;
    }

    public Object dequeue() {
        ++this.n2;
        if (this.et < 1) {
            throw new InvalidOperationException();
        }
        Object object = this.iy[this.nk];
        this.iy[this.nk] = null;
        this.nk = (this.nk + 1) % this.iy.length;
        --this.et;
        return object;
    }

    public void enqueue(Object obj) {
        ++this.n2;
        if (this.et == this.iy.length) {
            this.iy();
        }
        this.iy[this.cv] = obj;
        this.cv = (this.cv + 1) % this.iy.length;
        ++this.et;
    }

    public Object peek() {
        if (this.et < 1) {
            throw new InvalidOperationException();
        }
        return this.iy[this.nk];
    }

    public static Queue sync(Queue queue) {
        if (queue == null) {
            throw new ArgumentNullException("queue");
        }
        return new SyncQueue(queue);
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.et) {
            return Arrays.copyOf(this.iy, this.et, a.getClass());
        }
        System.arraycopy(this.iy, 0, a, 0, this.et);
        if (a.length > this.et) {
            a[this.et] = null;
        }
        return a;
    }

    public void trimToSize() {
        ++this.n2;
        Object[] objectArray = new Object[this.et];
        this.copyTo(com.aspose.slides.ms.System.cv.iy(objectArray), 0);
        this.iy = objectArray;
        this.nk = 0;
        this.cv = 0;
    }

    private void iy() {
        int n = this.iy.length * this.lg / 100;
        if (n < this.iy.length + 1) {
            n = this.iy.length + 1;
        }
        Object[] objectArray = new Object[n];
        this.copyTo(com.aspose.slides.ms.System.cv.iy(objectArray), 0);
        this.iy = objectArray;
        this.nk = 0;
        this.cv = this.nk + this.et;
    }

    private static class QueueEnumerator
    implements IEnumerator,
    i2 {
        private Queue iy;
        private int nk;
        private int et;

        QueueEnumerator(Queue q) {
            this.iy = q;
            this.nk = q.n2;
            this.et = -1;
        }

        @Override
        public Object deepClone() {
            QueueEnumerator queueEnumerator = new QueueEnumerator(this.iy);
            queueEnumerator.nk = this.nk;
            queueEnumerator.et = this.et;
            return queueEnumerator;
        }

        @Override
        public Object next() {
            if (this.nk != this.iy.n2 || this.et < 0 || this.et >= this.iy.et) {
                throw new InvalidOperationException();
            }
            return this.iy.iy[(this.iy.nk + this.et) % this.iy.iy.length];
        }

        @Override
        public boolean hasNext() {
            if (this.nk != this.iy.n2) {
                throw new InvalidOperationException();
            }
            if (this.et >= this.iy.et - 1) {
                this.et = Integer.MAX_VALUE;
                return false;
            }
            ++this.et;
            return true;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.nk != this.iy.n2) {
                throw new InvalidOperationException();
            }
            this.et = -1;
        }
    }

    private static class SyncQueue
    extends Queue {
        private final Queue iy;

        SyncQueue(Queue queue) {
            this.iy = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Queue queue = this.iy;
            synchronized (queue) {
                return this.iy.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.iy.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(cv array, int index) {
            Queue queue = this.iy;
            synchronized (queue) {
                this.iy.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Queue queue = this.iy;
            synchronized (queue) {
                return this.iy.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Queue queue = this.iy;
            synchronized (queue) {
                return new SyncQueue((Queue)this.iy.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Queue queue = this.iy;
            synchronized (queue) {
                this.iy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Queue queue = this.iy;
            synchronized (queue) {
                this.iy.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Queue queue = this.iy;
            synchronized (queue) {
                return this.iy.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object dequeue() {
            Queue queue = this.iy;
            synchronized (queue) {
                return this.iy.dequeue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enqueue(Object obj) {
            Queue queue = this.iy;
            synchronized (queue) {
                this.iy.enqueue(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Queue queue = this.iy;
            synchronized (queue) {
                return this.iy.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Queue queue = this.iy;
            synchronized (queue) {
                return this.iy.toArray(a);
            }
        }
    }
}

