/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.Comparer;
import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IList;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.internal.vk.an;
import com.aspose.slides.ms.System.bu;
import com.aspose.slides.ms.System.cv;
import com.aspose.slides.ms.System.dy;
import com.aspose.slides.ms.System.i2;
import com.aspose.slides.ms.System.zl;
import java.util.Comparator;

public class SortedList
implements IDictionary,
i2 {
    private final Object iy = new Object();
    private Slot[] nk;
    private Comparator et;
    private int cv;
    private int lg;
    private int n2;

    public SortedList() {
        this(null, 16);
    }

    public SortedList(int initialCapacity) {
        this(null, initialCapacity);
    }

    public SortedList(Comparator comparer, int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.n2 = capacity == 0 ? 0 : 16;
        this.et = comparer;
        this.nk(capacity, true);
    }

    public SortedList(Comparator comparer) {
        this.et = comparer;
        this.nk(16, true);
    }

    public SortedList(IDictionary d) {
        this(d, null);
    }

    public SortedList(IDictionary d, Comparator comparer) {
        if (d == null) {
            throw new ArgumentNullException("dictionary");
        }
        this.nk(d.size(), true);
        this.et = comparer;
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Override
    public int size() {
        return this.cv;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this.iy;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ICollection getKeys() {
        return new ListKeys(this);
    }

    @Override
    public ICollection getValues() {
        return new ListValues(this);
    }

    @Override
    public Object get_Item(Object key) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        return this.iy(key);
    }

    @Override
    public void set_Item(Object key, Object value) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        if (this.isReadOnly()) {
            throw new NotSupportedException("SortedList is Read Only.");
        }
        if (this.nk(key) < 0 && this.isFixedSize()) {
            throw new NotSupportedException("Key not found and SortedList is fixed size.");
        }
        this.iy(key, value, true);
    }

    public int getCapacity() {
        return this.nk.length;
    }

    public void setCapacity(int value) {
        int n = this.nk.length;
        if (this.cv > value) {
            throw new ArgumentOutOfRangeException("capacity too small");
        }
        if (value == 0) {
            Slot[] slotArray = SortedList.iy(this.n2);
            SortedList.iy(this.nk, 0, slotArray, 0, this.cv);
            this.nk = slotArray;
        } else if (value > this.cv) {
            Slot[] slotArray = SortedList.iy(value);
            SortedList.iy(this.nk, 0, slotArray, 0, this.cv);
            this.nk = slotArray;
        } else if (value > n) {
            Slot[] slotArray = SortedList.iy(value);
            SortedList.iy(this.nk, 0, slotArray, 0, n);
            this.nk = slotArray;
        }
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new Enumerator(this, 2);
    }

    @Deprecated
    public IDictionaryEnumerator iteratorJava() {
        return new EnumeratorJava(this, 2);
    }

    @Override
    public void addItem(Object key, Object value) {
        this.iy(key, value, false);
    }

    @Override
    public void clear() {
        this.n2 = 16;
        this.nk = SortedList.iy(this.n2);
        this.cv = 0;
        ++this.lg;
    }

    @Override
    public boolean contains(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.nk(key) >= 0;
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void removeItem(Object key) {
        int n = this.indexOfKey(key);
        if (n >= 0) {
            this.removeAt(n);
        }
    }

    @Override
    public void copyTo(cv array, int arrayIndex) {
        if (null == array) {
            throw new ArgumentNullException();
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (array.cv() > 1) {
            throw new ArgumentException("array is multi-dimensional");
        }
        if (arrayIndex >= array.lg()) {
            throw new ArgumentNullException("arrayIndex is greater than or equal to array.Length");
        }
        if (this.size() > array.lg() - arrayIndex) {
            throw new ArgumentNullException("Not enough space in array from arrayIndex to end of array");
        }
        IDictionaryEnumerator iDictionaryEnumerator = this.iterator();
        int n = arrayIndex;
        while (iDictionaryEnumerator.hasNext()) {
            array.et(iDictionaryEnumerator.getEntry().Clone(), n++);
        }
    }

    @Override
    public Object deepClone() {
        SortedList sortedList = new SortedList(this, this.et);
        sortedList.lg = this.lg;
        return sortedList;
    }

    public IList getKeyList() {
        return new ListKeys(this);
    }

    public IList getValueList() {
        return new ListValues(this);
    }

    public void removeAt(int index) {
        Slot[] slotArray = this.nk;
        int n = this.size();
        if (index >= 0 && index < n) {
            if (index != n - 1) {
                SortedList.iy(slotArray, index + 1, slotArray, index, n - 1 - index);
            } else {
                slotArray[index].iy = null;
                slotArray[index].nk = null;
            }
            --this.cv;
            ++this.lg;
        } else {
            throw new ArgumentOutOfRangeException("index out of range");
        }
    }

    public int indexOfKey(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        int n = 0;
        try {
            n = this.nk(key);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        return n | n >> 31;
    }

    public int indexOfValue(Object value) {
        if (this.cv == 0) {
            return -1;
        }
        for (int i = 0; i < this.cv; ++i) {
            Slot slot = this.nk[i].Clone();
            if (!dy.iy(value, slot.nk)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsKey(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.contains(key);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    public boolean containsValue(Object value) {
        return this.indexOfValue(value) >= 0;
    }

    public Object getByIndex(int index) {
        if (index >= 0 && index < this.size()) {
            return this.nk[index].nk;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public void setByIndex(int index, Object value) {
        if (index < 0 || index >= this.size()) {
            throw new ArgumentOutOfRangeException("index out of range");
        }
        this.nk[index].nk = value;
    }

    public Object getKey(int index) {
        if (index >= 0 && index < this.size()) {
            return this.nk[index].iy;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public static SortedList sync(SortedList list) {
        if (list == null) {
            throw new ArgumentNullException("Base list is null.");
        }
        return new SynchedSortedList(list);
    }

    public void trimToSize() {
        if (this.size() == 0) {
            this.iy(this.n2, false);
        } else {
            this.iy(this.size(), true);
        }
    }

    private void iy(int n, boolean bl2) {
        Slot[] slotArray = this.nk;
        Slot[] slotArray2 = SortedList.iy(n);
        if (bl2) {
            SortedList.iy(slotArray, 0, slotArray2, 0, n);
        }
        this.nk = slotArray2;
    }

    private void iy(int n, int n10) {
        boolean bl2;
        Slot[] slotArray = this.nk;
        Slot[] slotArray2 = null;
        int n11 = this.getCapacity();
        boolean bl3 = bl2 = n10 >= 0 && n10 < this.size();
        if (n > n11) {
            slotArray2 = SortedList.iy(n << 1);
        }
        if (slotArray2 != null) {
            if (bl2) {
                int n12 = n10;
                if (n12 > 0) {
                    SortedList.iy(slotArray, 0, slotArray2, 0, n12);
                }
                if ((n12 = this.size() - n10) > 0) {
                    SortedList.iy(slotArray, n10, slotArray2, n10 + 1, n12);
                }
            } else {
                SortedList.iy(slotArray, 0, slotArray2, 0, this.size());
            }
            this.nk = slotArray2;
        } else if (bl2) {
            SortedList.iy(slotArray, n10, slotArray, n10 + 1, this.size() - n10);
        }
    }

    private void iy(Object object, Object object2, boolean bl2) {
        if (object == null) {
            throw new ArgumentNullException("null key");
        }
        Slot[] slotArray = this.nk;
        int n = -1;
        try {
            n = this.nk(object);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        if (n >= 0) {
            if (!bl2) {
                String string = bu.iy("Key '{0}' already exists in list.", new Object[]{object});
                throw new ArgumentException(string);
            }
            slotArray[n].nk = object2;
            ++this.lg;
            return;
        }
        if ((n ^= 0xFFFFFFFF) > this.getCapacity() + 1) {
            throw new RuntimeException(bu.iy(new Object[]{"SortedList::internal error (", object, ", ", object2, ") at [", n, "]"}));
        }
        this.iy(this.size() + 1, n);
        slotArray = this.nk;
        slotArray[n].iy = object;
        slotArray[n].nk = object2;
        ++this.cv;
        ++this.lg;
    }

    private Object iy(Object object) {
        int n = this.nk(object);
        if (n >= 0) {
            return this.nk[n].nk;
        }
        return null;
    }

    private void nk(int n, boolean bl2) {
        if (!bl2 && n < this.n2) {
            n = this.n2;
        }
        this.nk = SortedList.iy(n);
        this.cv = 0;
        this.lg = 0;
    }

    private void iy(cv cv2, int n, int n10) {
        if (cv2 == null) {
            throw new ArgumentNullException("arr");
        }
        if (n < 0 || n + this.size() > cv2.lg()) {
            throw new ArgumentOutOfRangeException("i");
        }
        Enumerator enumerator = new Enumerator(this, n10);
        while (enumerator.hasNext()) {
            cv2.et(enumerator.next(), n++);
        }
    }

    private int nk(Object object) {
        Slot[] slotArray = this.nk;
        int n = this.size();
        if (n == 0) {
            return -1;
        }
        Comparator comparator = this.et == null ? Comparer.Default : this.et;
        int n10 = 0;
        int n11 = n - 1;
        while (n10 <= n11) {
            int n12 = n10 + n11 >> 1;
            int n13 = comparator.compare(slotArray[n12].iy, object);
            if (n13 == 0) {
                return n12;
            }
            if (n13 < 0) {
                n10 = n12 + 1;
                continue;
            }
            n11 = n12 - 1;
        }
        return ~n10;
    }

    static Slot[] iy(int n) {
        Slot[] slotArray = new Slot[n];
        for (int i = 0; i < n; ++i) {
            slotArray[i] = new Slot();
        }
        return slotArray;
    }

    private static boolean iy(int n, int n10, int n11) {
        return n < n10 && n + n11 > n10 || n10 < n && n10 + n11 > n;
    }

    static void iy(Slot[] slotArray, int n, Slot[] slotArray2, int n10, int n11) {
        Slot[] slotArray3;
        if (slotArray == slotArray2 && SortedList.iy(n, n10, n11)) {
            slotArray3 = new Slot[n11];
            System.arraycopy(slotArray, n, slotArray3, 0, n11);
            n = 0;
        } else {
            slotArray3 = slotArray;
        }
        for (int i = 0; i < n11; ++i) {
            slotArray2[n10 + i] = slotArray3[n + i].Clone();
        }
    }

    private static class SynchedSortedList
    extends SortedList {
        private SortedList iy;

        public SynchedSortedList(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.iy = host;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                return this.iy.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                this.iy.setCapacity(value);
            }
        }

        @Override
        public int size() {
            return this.iy.size();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.iy.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.iy.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.iy.isReadOnly();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            ICollection iCollection = null;
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                iCollection = this.iy.getKeys();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            ICollection iCollection = null;
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                iCollection = this.iy.getValues();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(Object key) {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                return this.iy.iy(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key, Object value) {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                this.iy.iy(key, value, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(cv array, int arrayIndex) {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                this.iy.copyTo(array, arrayIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key, Object value) {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                this.iy.iy(key, value, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                this.iy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object key) {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                return this.iy.nk(key) >= 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IDictionaryEnumerator iterator() {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                return this.iy.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public IDictionaryEnumerator iteratorJava() {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                return this.iy.iteratorJava();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key) {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                this.iy.removeItem(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                return this.iy.contains(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object value) {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                return this.iy.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                return this.iy.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getByIndex(int index) {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                return this.iy.getByIndex(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getKey(int index) {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                return this.iy.getKey(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getKeyList() {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                return new ListKeys(this.iy);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getValueList() {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                return new ListValues(this.iy);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                this.iy.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfKey(Object key) {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                return this.iy.indexOfKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfValue(Object val) {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                return this.iy.indexOfValue(val);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setByIndex(int index, Object value) {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                this.iy.setByIndex(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.iy.getSyncRoot();
            synchronized (object) {
                this.iy.trimToSize();
            }
        }
    }

    private static class ListValues
    implements IList {
        private SortedList iy;

        public ListValues(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.iy = host;
        }

        @Override
        public int size() {
            return this.iy.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.iy.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.iy.getSyncRoot();
        }

        @Override
        public void copyTo(cv array, int arrayIndex) {
            this.iy.iy(array, arrayIndex, 1);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.iy.getByIndex(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("This operation is not supported on GetValueList return");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object value) {
            return this.iy.containsValue(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.iy.indexOfValue(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.iy, 1);
        }
    }

    private static class ListKeys
    implements IList {
        private SortedList iy;

        public ListKeys(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.iy = host;
        }

        @Override
        public int size() {
            return this.iy.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.iy.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.iy.getSyncRoot();
        }

        @Override
        public void copyTo(cv array, int arrayIndex) {
            this.iy.iy(array, arrayIndex, 0);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.iy.getKey(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("attempt to modify a key");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object key) {
            return this.iy.contains(key);
        }

        @Override
        public int indexOf(Object key) {
            return this.iy.indexOfKey(key);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.iy, 0);
        }
    }

    @Deprecated
    private static final class EnumeratorJava
    implements IDictionaryEnumerator,
    i2 {
        private SortedList iy;
        private Object nk;
        private Object et;
        private int cv;
        private int lg;
        private int n2;
        private int an;
        private boolean bm = false;
        private static String tg = "SortedList.EnumeratorJava: snapshot out of sync.";

        public EnumeratorJava(SortedList host, int mode) {
            this.iy = host;
            this.cv = host.lg;
            this.n2 = host.size();
            this.an = mode;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.iy.lg != this.cv || this.bm) {
                throw new IllegalStateException(tg);
            }
            this.lg = -1;
            this.nk = null;
            this.et = null;
        }

        @Override
        public boolean hasNext() {
            if (this.iy.lg != this.cv || this.bm) {
                throw new InvalidOperationException(tg);
            }
            return ++this.lg < this.n2;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.bm || this.lg >= this.n2 || this.lg == -1) {
                throw new IllegalStateException(tg);
            }
            return new DictionaryEntry(this.nk, this.et);
        }

        @Override
        public Object getKey() {
            if (this.bm || this.lg >= this.n2 || this.lg == -1) {
                throw new IllegalStateException(tg);
            }
            return this.nk;
        }

        @Override
        public Object getValue() {
            if (this.bm || this.lg >= this.n2 || this.lg == -1) {
                throw new IllegalStateException(tg);
            }
            return this.et;
        }

        @Override
        public Object next() {
            if (this.iy.lg != this.cv || this.bm) {
                throw new InvalidOperationException(tg);
            }
            if (this.bm || this.lg >= this.n2 || this.lg == -1) {
                if (this.lg >= this.n2) {
                    this.nk = null;
                    this.et = null;
                }
                throw new IllegalStateException(tg);
            }
            Slot[] slotArray = this.iy.nk;
            Slot slot = slotArray[this.lg].Clone();
            this.nk = slot.iy;
            this.et = slot.nk;
            switch (this.an) {
                case 0: {
                    return this.nk;
                }
                case 1: {
                    return this.et;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(bu.iy(new String[]{zl.getName(EnumeratorMode.class, this.an), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            EnumeratorJava enumeratorJava = new EnumeratorJava(this.iy, this.an);
            enumeratorJava.cv = this.cv;
            enumeratorJava.lg = this.lg;
            enumeratorJava.n2 = this.n2;
            enumeratorJava.nk = this.nk;
            enumeratorJava.et = this.et;
            enumeratorJava.bm = this.bm;
            return enumeratorJava;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class Enumerator
    implements IDictionaryEnumerator,
    i2 {
        private SortedList iy;
        private Object nk;
        private Object et;
        private int cv;
        private int lg;
        private int n2;
        private int an;
        private boolean bm = false;
        private static String tg = "SortedList.Enumerator: snapshot out of sync.";

        public Enumerator(SortedList host, int mode) {
            this.iy = host;
            this.cv = host.lg;
            this.n2 = host.size();
            this.an = mode;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.iy.lg != this.cv || this.bm) {
                throw new IllegalStateException(tg);
            }
            this.lg = -1;
            this.nk = null;
            this.et = null;
        }

        @Override
        public boolean hasNext() {
            if (this.iy.lg != this.cv || this.bm) {
                throw new InvalidOperationException(tg);
            }
            Slot[] slotArray = this.iy.nk;
            if (++this.lg < this.n2) {
                Slot slot = slotArray[this.lg].Clone();
                this.nk = slot.iy;
                this.et = slot.nk;
                return true;
            }
            this.nk = null;
            this.et = null;
            return false;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.bm || this.lg >= this.n2 || this.lg == -1) {
                throw new IllegalStateException(tg);
            }
            return new DictionaryEntry(this.nk, this.et);
        }

        @Override
        public Object getKey() {
            if (this.bm || this.lg >= this.n2 || this.lg == -1) {
                throw new IllegalStateException(tg);
            }
            return this.nk;
        }

        @Override
        public Object getValue() {
            if (this.bm || this.lg >= this.n2 || this.lg == -1) {
                throw new IllegalStateException(tg);
            }
            return this.et;
        }

        @Override
        public Object next() {
            if (this.bm || this.lg >= this.n2 || this.lg == -1) {
                throw new IllegalStateException(tg);
            }
            switch (this.an) {
                case 0: {
                    return this.nk;
                }
                case 1: {
                    return this.et;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(bu.iy(new String[]{zl.getName(EnumeratorMode.class, this.an), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            Enumerator enumerator = new Enumerator(this.iy, this.an);
            enumerator.cv = this.cv;
            enumerator.lg = this.lg;
            enumerator.n2 = this.n2;
            enumerator.nk = this.nk;
            enumerator.et = this.et;
            enumerator.bm = this.bm;
            return enumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class EnumeratorMode
    extends zl {
        private EnumeratorMode() {
        }

        static {
            zl.register(new zl.lg(EnumeratorMode.class, Integer.class){
                {
                    this.addConstant("KEY_MODE", 0L);
                    this.addConstant("VALUE_MODE", 1L);
                    this.addConstant("ENTRY_MODE", 2L);
                }
            });
        }
    }

    public static class Slot
    extends an<Slot> {
        Object iy;
        Object nk;

        @Override
        public void CloneTo(Slot that) {
            that.iy = this.iy;
            that.nk = this.nk;
        }

        @Override
        public Slot Clone() {
            Slot slot = new Slot();
            this.CloneTo(slot);
            return slot;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean iy(Slot slot) {
            return dy.iy(slot.iy, this.iy) && dy.iy(slot.nk, this.nk);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (dy.nk(null, obj)) {
                return false;
            }
            if (dy.nk(this, obj)) {
                return true;
            }
            if (!(obj instanceof Slot)) {
                return false;
            }
            return this.iy((Slot)obj);
        }

        public static boolean equals(Slot obj1, Slot obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.iy != null ? this.iy.hashCode() : 0;
            n = 31 * n + (this.nk != null ? this.nk.hashCode() : 0);
            return n;
        }
    }
}

