/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Specialized;

import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.internal.vk.an;
import com.aspose.slides.internal.vk.et;
import com.aspose.slides.internal.zo.qb;
import com.aspose.slides.ms.System.vo;
import com.aspose.slides.ms.System.y7;

public class BitVector32
extends an<BitVector32> {
    private int iy;

    public BitVector32() {
    }

    public BitVector32(BitVector32 value) {
        this.iy = value.iy;
    }

    public BitVector32(int data) {
        this.iy = data;
    }

    public int getData() {
        return this.iy;
    }

    public int get_Item(Section section) {
        return this.iy >> section.getOffset() & section.getMask();
    }

    public void set_Item(Section section, int value) {
        if (value < 0) {
            throw new ArgumentException("Section can't hold negative values");
        }
        if (value > section.getMask()) {
            throw new ArgumentException("Value too large to fit in section");
        }
        this.iy &= ~(section.getMask() << section.getOffset());
        this.iy |= value << section.getOffset();
    }

    public boolean get_Item(int bit) {
        return (this.iy & bit) == bit;
    }

    public void set_Item(int bit, boolean value) {
        this.iy = value ? (this.iy |= bit) : (this.iy &= ~bit);
    }

    public static int createMask() {
        return 1;
    }

    public static int createMask(int previous) {
        if (previous == 0) {
            return 1;
        }
        if (previous == Integer.MIN_VALUE) {
            throw new InvalidOperationException("all bits set");
        }
        return previous << 1;
    }

    public static Section createSection(short maxValue) {
        return BitVector32.createSection(maxValue, new Section(0, 0));
    }

    public static Section createSection(short maxValue, Section previous) {
        if (maxValue < 1) {
            throw new ArgumentException("maxValue");
        }
        int n = BitVector32.iy(maxValue);
        int n10 = (1 << n) - 1;
        int n11 = previous.getOffset() + BitVector32.iy(previous.getMask());
        if (n11 + n > 32) {
            throw new ArgumentException("Sections cannot exceed 32 bits in total");
        }
        return new Section(et.nk((Object)n10, 9), et.nk((Object)n11, 9));
    }

    public boolean equals(Object o) {
        return et.nk(o, BitVector32.class) && this.iy == et.cv((Object)o, BitVector32.class).iy;
    }

    public int hashCode() {
        return y7.iy(this.iy);
    }

    public String toString() {
        return BitVector32.toString(this.Clone());
    }

    public static String toString(BitVector32 value) {
        qb qb2 = new qb();
        qb2.iy("BitVector32{");
        for (long i = et.n2((Object)0x80000000L, 10); i > 0L; i >>= 1) {
            qb2.iy(((long)value.iy & i) == 0L ? (char)'0' : '1');
        }
        qb2.iy('}');
        return qb2.toString();
    }

    private static int iy(int n) {
        int n10 = 0;
        while (n >> n10 != 0) {
            ++n10;
        }
        return n10;
    }

    @Override
    public void CloneTo(BitVector32 that) {
        that.iy = this.iy;
    }

    @Override
    public BitVector32 Clone() {
        BitVector32 bitVector32 = new BitVector32();
        this.CloneTo(bitVector32);
        return bitVector32;
    }

    public Object clone() {
        return this.Clone();
    }

    public static boolean equals(BitVector32 obj1, BitVector32 obj2) {
        return obj1.equals(obj2);
    }

    public static class Section
    extends an<Section> {
        private short iy;
        private short nk;

        public Section() {
        }

        Section(short mask, short offset) {
            this.iy = mask;
            this.nk = offset;
        }

        public short getMask() {
            return this.iy;
        }

        public short getOffset() {
            return this.nk;
        }

        public static boolean op_Equality(Section a, Section b) {
            return a.iy == b.iy && a.nk == b.nk;
        }

        public static boolean op_Inequality(Section a, Section b) {
            return a.iy != b.iy || a.nk != b.nk;
        }

        public boolean equals(Section obj) {
            return this.iy == obj.iy && this.nk == obj.nk;
        }

        public boolean equals(Object o) {
            if (!et.nk(o, Section.class)) {
                return false;
            }
            Section section = et.cv(o, Section.class).Clone();
            return this.iy == section.iy && this.nk == section.nk;
        }

        public int hashCode() {
            return this.iy << this.nk;
        }

        public String toString() {
            return Section.toString(this.Clone());
        }

        public static String toString(Section value) {
            qb qb2 = new qb();
            qb2.iy("Section{0x");
            qb2.iy(vo.iy(value.getMask(), 16));
            qb2.iy(", 0x");
            qb2.iy(vo.iy(value.getOffset(), 16));
            qb2.iy("}");
            return qb2.toString();
        }

        @Override
        public void CloneTo(Section that) {
            that.iy = this.iy;
            that.nk = this.nk;
        }

        @Override
        public Section Clone() {
            Section section = new Section();
            this.CloneTo(section);
            return section;
        }

        public Object clone() {
            return this.Clone();
        }

        public static boolean equals(Section obj1, Section obj2) {
            return obj1.equals(obj2);
        }
    }
}

