/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Specialized;

import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.IndexOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.ms.System.cv;
import java.util.Comparator;

public class ListDictionary
implements ICollection,
IDictionary,
IEnumerable {
    private int iy = 0;
    private int nk = 0;
    private DictionaryNode et = null;
    private Comparator cv = null;

    public ListDictionary() {
    }

    public ListDictionary(Comparator comparer) {
        this();
        this.cv = comparer;
    }

    private DictionaryNode iy(Object object) {
        if (object == null) {
            throw new ArgumentNullException("key", "Attempted lookup for a null key.");
        }
        DictionaryNode dictionaryNode = this.et;
        if (this.cv == null) {
            while (dictionaryNode != null && !object.equals(dictionaryNode.iy)) {
                dictionaryNode = dictionaryNode.et;
            }
        } else {
            while (dictionaryNode != null && this.cv.compare(object, dictionaryNode.iy) != 0) {
                dictionaryNode = dictionaryNode.et;
            }
        }
        return dictionaryNode;
    }

    private DictionaryNode iy(Object object, DictionaryNode[] dictionaryNodeArray) {
        if (object == null) {
            throw new ArgumentNullException("key", "Attempted lookup for a null key.");
        }
        DictionaryNode dictionaryNode = this.et;
        dictionaryNodeArray[0] = null;
        if (this.cv == null) {
            while (dictionaryNode != null && !object.equals(dictionaryNode.iy)) {
                dictionaryNodeArray[0] = dictionaryNode;
                dictionaryNode = dictionaryNode.et;
            }
        } else {
            while (dictionaryNode != null && this.cv.compare(object, dictionaryNode.iy) != 0) {
                dictionaryNodeArray[0] = dictionaryNode;
                dictionaryNode = dictionaryNode.et;
            }
        }
        return dictionaryNode;
    }

    private void iy(Object object, Object object2, DictionaryNode dictionaryNode) {
        if (dictionaryNode == null) {
            this.et = new DictionaryNode(object, object2, this.et);
        } else {
            dictionaryNode.et = new DictionaryNode(object, object2, dictionaryNode.et);
        }
        ++this.iy;
        ++this.nk;
    }

    @Override
    public int size() {
        return this.iy;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(cv array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array", "Array cannot be null.");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index", "index is less than 0");
        }
        if (index > array.lg()) {
            throw new IndexOutOfRangeException("index is too large");
        }
        if (this.size() > array.lg() - index) {
            throw new ArgumentException("Not enough room in the array");
        }
        for (DictionaryEntry dictionaryEntry : this) {
            array.et(dictionaryEntry.Clone(), index++);
        }
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public Object get_Item(Object key) {
        DictionaryNode dictionaryNode = this.iy(key);
        return dictionaryNode == null ? null : dictionaryNode.nk;
    }

    @Override
    public void set_Item(Object key, Object value) {
        DictionaryNode dictionaryNode = null;
        DictionaryNode[] dictionaryNodeArray = new DictionaryNode[]{dictionaryNode};
        DictionaryNode dictionaryNode2 = this.iy(key, dictionaryNodeArray);
        dictionaryNode = dictionaryNodeArray[0];
        if (dictionaryNode2 != null) {
            dictionaryNode2.nk = value;
        } else {
            this.iy(key, value, dictionaryNode);
        }
    }

    @Override
    public ICollection getKeys() {
        return new DictionaryNodeCollection(this, true);
    }

    @Override
    public ICollection getValues() {
        return new DictionaryNodeCollection(this, false);
    }

    @Override
    public void addItem(Object key, Object value) {
        DictionaryNode dictionaryNode = null;
        DictionaryNode[] dictionaryNodeArray = new DictionaryNode[]{dictionaryNode};
        DictionaryNode dictionaryNode2 = this.iy(key, dictionaryNodeArray);
        dictionaryNode = dictionaryNodeArray[0];
        if (dictionaryNode2 != null) {
            throw new ArgumentException("key", "Duplicate key in add.");
        }
        this.iy(key, value, dictionaryNode);
    }

    @Override
    public void clear() {
        this.et = null;
        this.iy = 0;
        ++this.nk;
    }

    @Override
    public boolean contains(Object key) {
        return this.iy(key) != null;
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new DictionaryNodeEnumerator(this);
    }

    @Override
    public void removeItem(Object key) {
        DictionaryNode dictionaryNode = null;
        DictionaryNode[] dictionaryNodeArray = new DictionaryNode[]{dictionaryNode};
        DictionaryNode dictionaryNode2 = this.iy(key, dictionaryNodeArray);
        dictionaryNode = dictionaryNodeArray[0];
        if (dictionaryNode2 == null) {
            return;
        }
        if (dictionaryNode == null) {
            this.et = dictionaryNode2.et;
        } else {
            dictionaryNode.et = dictionaryNode2.et;
        }
        dictionaryNode2.nk = null;
        --this.iy;
        ++this.nk;
    }

    private static class DictionaryNodeCollection
    implements ICollection {
        private ListDictionary iy;
        private boolean nk;

        public DictionaryNodeCollection(ListDictionary dict, boolean isKeyList) {
            this.iy = dict;
            this.nk = isKeyList;
        }

        @Override
        public int size() {
            return this.iy.size();
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this.iy.getSyncRoot();
        }

        @Override
        public void copyTo(cv array, int index) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null.");
            }
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", "index is less than 0");
            }
            if (index > array.lg()) {
                throw new IndexOutOfRangeException("index is too large");
            }
            if (this.size() > array.lg() - index) {
                throw new ArgumentException("Not enough room in the array");
            }
            for (Object e : this) {
                array.et(e, index++);
            }
        }

        @Override
        public IEnumerator iterator() {
            return new DictionaryNodeCollectionEnumerator(this.iy.iterator(), this.nk);
        }

        private static class DictionaryNodeCollectionEnumerator
        implements IEnumerator {
            private IDictionaryEnumerator iy;
            private boolean nk;

            public DictionaryNodeCollectionEnumerator(IDictionaryEnumerator inner, boolean isKeyList) {
                this.iy = inner;
                this.nk = isKeyList;
            }

            @Override
            public Object next() {
                return this.nk ? this.iy.getKey() : this.iy.getValue();
            }

            @Override
            public boolean hasNext() {
                return this.iy.hasNext();
            }

            @Override
            public void reset() {
                this.iy.reset();
            }

            @Override
            public void remove() {
                throw new NotSupportedException();
            }
        }
    }

    private static class DictionaryNodeEnumerator
    implements IDictionaryEnumerator,
    IEnumerator {
        private ListDictionary iy;
        private boolean nk;
        private DictionaryNode et;
        private int cv;

        public DictionaryNodeEnumerator(ListDictionary dict) {
            this.iy = dict;
            this.cv = dict.nk;
            this.reset();
        }

        private void iy() {
            if (this.cv != this.iy.nk) {
                throw new InvalidOperationException("The ListDictionary's contents changed after this enumerator was instantiated.");
            }
        }

        @Override
        public boolean hasNext() {
            this.iy();
            if (this.et == null && !this.nk) {
                return false;
            }
            this.et = this.nk ? this.iy.et : this.et.et;
            this.nk = false;
            return this.et != null;
        }

        @Override
        public void reset() {
            this.iy();
            this.nk = true;
            this.et = null;
        }

        @Override
        public Object next() {
            return this.getEntry();
        }

        private DictionaryNode nk() {
            this.iy();
            if (this.et == null) {
                throw new InvalidOperationException("Enumerator is positioned before the collection's first element or after the last element.");
            }
            return this.et;
        }

        @Override
        public DictionaryEntry getEntry() {
            Object object = this.nk().iy;
            return new DictionaryEntry(object, this.et.nk);
        }

        @Override
        public Object getKey() {
            return this.nk().iy;
        }

        @Override
        public Object getValue() {
            return this.nk().nk;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static class DictionaryNode {
        public Object iy;
        public Object nk;
        public DictionaryNode et;

        public DictionaryNode(Object key, Object value, DictionaryNode next) {
            this.iy = key;
            this.nk = value;
            this.et = next;
        }
    }
}

