/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.cv;
import com.aspose.slides.ms.System.i2;
import com.aspose.slides.ms.System.ic;
import java.util.Arrays;

public class Stack
implements ICollection,
IEnumerable,
i2 {
    private Object[] iy;
    private int nk = -1;
    private int et;
    private int cv;
    private int lg;

    private void iy(int n) {
        n = Math.max(n, 16);
        Object[] objectArray = new Object[n];
        com.aspose.slides.ms.System.cv.iy(this.iy, 0, objectArray, 0, this.et);
        this.cv = n;
        this.iy = objectArray;
    }

    public Stack() {
        this.iy = new Object[16];
        this.cv = 16;
    }

    public Stack(ICollection col) {
        this(col == null ? 16 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e : col) {
            this.push(e);
        }
    }

    public Stack(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new ArgumentOutOfRangeException("initialCapacity");
        }
        this.cv = initialCapacity;
        this.iy = new Object[this.cv];
    }

    public static Stack sync(Stack stack) {
        if (stack == null) {
            throw new ArgumentNullException("stack");
        }
        return new SyncStack(stack);
    }

    @Override
    public int size() {
        return this.et;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    public void clear() {
        ++this.lg;
        for (int i = 0; i < this.et; ++i) {
            this.iy[i] = null;
        }
        this.et = 0;
        this.nk = -1;
    }

    @Override
    public Object deepClone() {
        Stack stack = new Stack(com.aspose.slides.ms.System.cv.iy(this.iy));
        stack.nk = this.nk;
        stack.et = this.et;
        return stack;
    }

    public boolean contains(Object obj) {
        if (this.et == 0) {
            return false;
        }
        if (obj == null) {
            for (int i = 0; i < this.et; ++i) {
                if (this.iy[i] != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.et; ++i) {
                if (!obj.equals(this.iy[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void copyTo(cv array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.cv() > 1 || array.lg() > 0 && index >= array.lg() || this.et > array.lg() - index) {
            throw new ArgumentException();
        }
        for (int i = this.nk; i != -1; --i) {
            array.et(this.iy[i], this.et - (i + 1) + index);
        }
    }

    public IEnumerator iterator() {
        return new Enumerator(this);
    }

    public Object peek() {
        if (this.nk == -1) {
            throw new InvalidOperationException();
        }
        return this.iy[this.nk];
    }

    public Object pop() {
        if (this.nk == -1) {
            throw new InvalidOperationException();
        }
        ++this.lg;
        Object object = this.iy[this.nk];
        this.iy[this.nk] = null;
        --this.et;
        --this.nk;
        if (this.et <= this.cv / 4 && this.et > 16) {
            this.iy(this.cv / 2);
        }
        return object;
    }

    public void push(Object obj) {
        ++this.lg;
        if (this.cv == this.et) {
            this.iy(this.cv * 2);
        }
        ++this.et;
        ++this.nk;
        this.iy[this.nk] = obj;
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.et) {
            a = Arrays.copyOf(this.iy, this.et, a.getClass());
            ic.iy(a);
            return a;
        }
        System.arraycopy(this.iy, 0, a, 0, this.et);
        if (a.length > this.et) {
            a[this.et] = null;
        }
        ic.iy(a);
        return a;
    }

    private static class Enumerator
    implements IEnumerator,
    i2,
    Cloneable {
        private Stack iy;
        private int nk;
        private int et;

        Enumerator(Stack s) {
            this.iy = s;
            this.nk = s.lg;
            this.et = -2;
        }

        private Enumerator() {
        }

        @Override
        public Object deepClone() {
            return this.iy();
        }

        @Override
        public Object next() {
            if (this.nk != this.iy.lg || this.et == -2 || this.et == -1 || this.et > this.iy.et) {
                throw new InvalidOperationException();
            }
            return this.iy.iy[this.et];
        }

        @Override
        public boolean hasNext() {
            if (this.nk != this.iy.lg) {
                throw new InvalidOperationException();
            }
            switch (this.et) {
                case -2: {
                    this.et = this.iy.nk;
                    return this.et != -1;
                }
                case -1: {
                    return false;
                }
            }
            --this.et;
            return this.et != -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.nk != this.iy.lg) {
                throw new InvalidOperationException();
            }
            this.et = -2;
        }

        protected Object iy() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            Enumerator enumerator = new Enumerator();
            enumerator.iy = this.iy;
            enumerator.nk = this.nk;
            enumerator.et = this.et;
            return enumerator;
        }
    }

    private static class SyncStack
    extends Stack {
        private final Stack iy;

        SyncStack(Stack s) {
            this.iy = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Stack stack = this.iy;
            synchronized (stack) {
                return this.iy.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.iy.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Stack stack = this.iy;
            synchronized (stack) {
                this.iy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Stack stack = this.iy;
            synchronized (stack) {
                return Stack.sync((Stack)this.iy.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Stack stack = this.iy;
            synchronized (stack) {
                return this.iy.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(cv array, int index) {
            Stack stack = this.iy;
            synchronized (stack) {
                this.iy.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Stack stack = this.iy;
            synchronized (stack) {
                return new Enumerator(this.iy);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Stack stack = this.iy;
            synchronized (stack) {
                return this.iy.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object pop() {
            Stack stack = this.iy;
            synchronized (stack) {
                return this.iy.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void push(Object obj) {
            Stack stack = this.iy;
            synchronized (stack) {
                this.iy.push(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Stack stack = this.iy;
            synchronized (stack) {
                return this.iy.toArray(a);
            }
        }
    }
}

