/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import android.graphics.PointF;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.List;
import com.aspose.slides.Comment;
import com.aspose.slides.CommentAuthor;
import com.aspose.slides.DomObject;
import com.aspose.slides.IComment;
import com.aspose.slides.ICommentCollection;
import com.aspose.slides.IModernComment;
import com.aspose.slides.IShape;
import com.aspose.slides.ISlide;
import com.aspose.slides.ModernComment;
import com.aspose.slides.PptxEditException;
import com.aspose.slides.Presentation;
import com.aspose.slides.Shape;
import com.aspose.slides.Slide;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.internal.jh.g9;
import com.aspose.slides.internal.vk.et;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.cv;
import com.aspose.slides.ms.System.ug;
import com.aspose.slides.ms.System.vf;
import java.util.Date;

public final class CommentCollection
extends DomObject<CommentAuthor>
implements ICommentCollection {
    private final List<IComment> iy = new List();

    @Override
    public final int size() {
        return this.iy.size();
    }

    @Override
    public final IComment get_Item(int index) {
        return this.iy.get_Item(index);
    }

    @Override
    public final IComment addComment(String text, ISlide slide, PointF position, Date creationTime) {
        return this.iy(text, slide, g9.iy(position), ug.iy(creationTime));
    }

    IComment iy(String string, ISlide iSlide, g9 g92, ug ug2) {
        Comment comment = this.iy(string, (Slide)iSlide, g92.cv(), ug2.ui());
        this.iy.addItem(comment);
        return comment;
    }

    @Override
    public final IModernComment addModernComment(String text, ISlide slide, IShape shape, PointF position, Date creationTime) {
        return this.iy(text, slide, shape, g9.iy(position), ug.iy(creationTime));
    }

    IModernComment iy(String string, ISlide iSlide, IShape iShape, g9 g92, ug ug2) {
        ModernComment modernComment = this.iy(string, (Slide)iSlide, (Shape)iShape, g92.cv(), ug2.ui());
        this.iy.addItem(modernComment);
        return modernComment;
    }

    @Override
    public final IComment insertComment(int index, String text, ISlide slide, PointF position, Date creationTime) {
        return this.iy(index, text, slide, g9.iy(position), ug.iy(creationTime));
    }

    IComment iy(int n, String string, ISlide iSlide, g9 g92, ug ug2) {
        Comment comment = this.iy(string, (Slide)iSlide, g92.cv(), ug2.ui());
        this.iy.insertItem(n, comment);
        return comment;
    }

    @Override
    public final IModernComment insertModernComment(int index, String text, ISlide slide, IShape shape, PointF position, Date creationTime) {
        return this.iy(index, text, slide, shape, g9.iy(position), ug.iy(creationTime));
    }

    IModernComment iy(int n, String string, ISlide iSlide, IShape iShape, g9 g92, ug ug2) {
        ModernComment modernComment = this.iy(string, (Slide)iSlide, (Shape)iShape, g92.cv(), ug2.ui());
        this.iy.insertItem(n, modernComment);
        return modernComment;
    }

    @Override
    public final IComment[] toArray() {
        return this.iy.toArray((IComment[])new IComment[0]);
    }

    @Override
    public final IComment[] toArray(int startIndex, int count) {
        if (startIndex < 0) {
            throw new ArgumentOutOfRangeException("startIndex");
        }
        if (count < 0 || startIndex + count > this.size()) {
            throw new ArgumentOutOfRangeException("count");
        }
        IComment[] iCommentArray = new Comment[count];
        for (int i = 0; i < count; ++i) {
            iCommentArray[i] = (Comment)this.iy.get_Item(i + startIndex);
        }
        return iCommentArray;
    }

    @Override
    public final void removeAt(int index) {
        this.iy.get_Item(index).remove();
    }

    @Override
    public final void remove(IComment comment) {
        if (comment == null) {
            throw new ArgumentNullException();
        }
        comment.remove();
    }

    @Override
    public final void clear() {
        for (int i = this.iy.size() - 1; i >= 0; --i) {
            this.iy.get_Item(i).remove();
        }
    }

    @Override
    public final IGenericEnumerator<IComment> iterator() {
        return this.iy.iterator();
    }

    @Override
    public final IGenericEnumerator<IComment> iteratorJava() {
        return this.iy.iteratorJava();
    }

    final Presentation iy() {
        return (Presentation)((CommentAuthor)this.n2).lg().getPresentation();
    }

    CommentCollection(CommentAuthor parentImmediate) {
        super(parentImmediate);
    }

    final void iy(Comment comment) {
        this.iy.removeItem(comment);
    }

    final void nk() {
        this.iy.sort(new vf<IComment>(){

            @Override
            public String getDelegateId() {
                return "Aspose.Slides.CommentCollection.CompareByCreatedTime(Aspose.Slides.IComment,Aspose.Slides.IComment)";
            }

            @Override
            public int iy(IComment iComment, IComment iComment2) {
                return CommentCollection.nk(iComment, iComment2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IComment findCommentByIdx(int idx) {
        IGenericEnumerator iGenericEnumerator = this.iy.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                Comment comment = (Comment)iGenericEnumerator.next();
                if ((comment.cv().iy() & 0xFFFFFFFFL) != (long)idx) continue;
                Comment comment2 = comment;
                return comment2;
            }
        }
        finally {
            if (et.iy(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        return null;
    }

    private Comment iy(String string, Slide slide, g9 g92, ug ug2) {
        if (slide == null) {
            throw new ArgumentNullException("slide", "slide can't be null.");
        }
        if (slide.getPresentation() != this.iy()) {
            throw new PptxEditException("Can't add comment to a slide from another presentation.");
        }
        Comment comment = new Comment(this, (CommentAuthor)this.n2, string, slide, g92.cv(), ug2.ui());
        slide.iy(comment);
        return comment;
    }

    private ModernComment iy(String string, Slide slide, Shape shape, g9 g92, ug ug2) {
        if (slide == null) {
            throw new ArgumentNullException("slide", "slide can't be null.");
        }
        if (slide.getPresentation() != this.iy()) {
            throw new PptxEditException("Can't add comment to a slide from another presentation.");
        }
        ModernComment modernComment = new ModernComment(this, (CommentAuthor)this.n2, string, slide, shape, g92.cv(), ug2.ui());
        slide.iy(modernComment);
        return modernComment;
    }

    @Override
    public final void copyTo(cv array, int index) {
        this.iy.copyTo(array, index);
    }

    @Override
    public final boolean isSynchronized() {
        return false;
    }

    @Override
    public final Object getSyncRoot() {
        return this;
    }

    private static int nk(IComment iComment, IComment iComment2) {
        return ug.lg(((Comment)iComment).iy().ui(), ((Comment)iComment2).iy().ui());
    }
}

