/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.ChartDataCell;
import com.aspose.slides.ChartDataWorkbook;
import com.aspose.slides.Collections.Generic.Dictionary;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.List;
import com.aspose.slides.ExcelDataCell;
import com.aspose.slides.ExcelWorkbookImporter;
import com.aspose.slides.IChartDataWorkbook;
import com.aspose.slides.IChartDataWorksheet;
import com.aspose.slides.IExcelDataCell;
import com.aspose.slides.IExcelDataWorkbook;
import com.aspose.slides.InterruptionToken;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.FileNotFoundException;
import com.aspose.slides.internal.ss.nk;
import com.aspose.slides.internal.vk.et;
import com.aspose.slides.internal.wg.e7;
import com.aspose.slides.internal.wg.g9;
import com.aspose.slides.internal.wg.n2;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.bu;
import java.io.InputStream;

public class ExcelDataWorkbook
implements IExcelDataWorkbook {
    private final IChartDataWorkbook iy;

    public ExcelDataWorkbook(String filePath) {
        if (!n2.et(filePath)) {
            throw new FileNotFoundException("File not found");
        }
        e7 e72 = new e7(filePath, 3);
        try {
            this.iy = new ChartDataWorkbook(null, e72, nk.iy, InterruptionToken.getNone());
        }
        finally {
            e72.dispose();
        }
    }

    public ExcelDataWorkbook(InputStream stream) {
        this(g9.fromJava(stream));
    }

    ExcelDataWorkbook(g9 stream) {
        if (stream == null) {
            throw new ArgumentNullException("stream", "Stream cannot be null.");
        }
        stream.seek(0L, 0);
        this.iy = new ChartDataWorkbook(null, stream, nk.iy, InterruptionToken.getNone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<IExcelDataCell> getCells(String formula, boolean skipHiddenCells) {
        if (bu.iy(formula)) {
            throw new ArgumentException("Formula cannot be null, empty, or whitespace.", "formula");
        }
        List<ChartDataCell> list = ((ChartDataWorkbook)((Object)et.iy(this.iy, ChartDataWorkbook.class))).iy(formula, skipHiddenCells, false);
        List<IExcelDataCell> list2 = new List<IExcelDataCell>();
        IGenericEnumerator iGenericEnumerator = list.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                ChartDataCell chartDataCell = (ChartDataCell)iGenericEnumerator.next();
                list2.addItem(new ExcelDataCell(chartDataCell));
            }
        }
        finally {
            if (et.iy(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        return list2;
    }

    @Override
    public final IExcelDataCell getCell(int worksheetIndex, int row2, int column) {
        return new ExcelDataCell(this.iy.getCell(worksheetIndex, row2, column));
    }

    @Override
    public final IExcelDataCell getCell(String worksheetName, int row2, int column) {
        return new ExcelDataCell(this.iy.getCell(worksheetName, row2, column));
    }

    @Override
    public final IExcelDataCell getCell(int worksheetIndex, String cellName) {
        return new ExcelDataCell(this.iy.getCell(worksheetIndex, cellName));
    }

    @Override
    public final IExcelDataCell getCell(String worksheetName, String cellName) {
        return new ExcelDataCell(((ChartDataWorkbook)((Object)et.iy(this.iy, ChartDataWorkbook.class))).iy(worksheetName, cellName));
    }

    @Override
    public final Dictionary<Integer, String> getChartsFromWorksheet(String worksheetName) {
        return ExcelWorkbookImporter.iy(this.iy, worksheetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<String> getWorksheetNames() {
        List<String> list = new List<String>();
        IGenericEnumerator iGenericEnumerator = this.iy.getWorksheets().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IChartDataWorksheet iChartDataWorksheet = (IChartDataWorksheet)iGenericEnumerator.next();
                list.addItem(iChartDataWorksheet.getName());
            }
        }
        finally {
            if (et.iy(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        return list;
    }

    final IChartDataWorkbook iy() {
        return this.iy;
    }
}

