/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.List;
import com.aspose.slides.FontFallBackRulesCollection;
import com.aspose.slides.IFontFallBackRule;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.i8;
import com.aspose.slides.internal.vk.et;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.bu;

public class FontFallBackRule
implements IFontFallBackRule {
    private long iy;
    private long nk = 0L;
    private long et = 0L;
    private List<i8> cv = null;
    private List<FontFallBackRulesCollection> lg = new List();

    FontFallBackRule(long startIndex, long endIndex) {
        this.nk = startIndex;
        this.et = endIndex;
        this.lg();
        this.cv = new List();
        this.iy(0L);
    }

    public FontFallBackRule(long startIndex, long endIndex, String fontNames) {
        this(startIndex, endIndex);
        this.addFallBackFonts(fontNames);
    }

    public FontFallBackRule(long startIndex, long endIndex, String[] fontNames) {
        this(startIndex, endIndex);
        this.addFallBackFonts(fontNames);
    }

    @Override
    public final void addFallBackFonts(String fontName) {
        String[] stringArray;
        if (bu.iy(bu.nk(fontName))) {
            throw new ArgumentException("Empty name of the font can't be added to list!");
        }
        for (String string : stringArray = bu.n2(fontName, ',')) {
            i8 i82 = new i8(bu.nk(string));
            this.cv.addItem(i82);
            this.n2();
        }
    }

    @Override
    public final void addFallBackFonts(String[] fontNames) {
        if (fontNames == null) {
            throw new ArgumentNullException("fontNames", "Any fonts weren't defined for fall back range!");
        }
        for (String string : fontNames) {
            this.addFallBackFonts(string);
        }
    }

    @Override
    public final long getRangeStartIndex() {
        return this.nk;
    }

    public final void setRangeStartIndex(long value) {
        if ((this.nk & 0xFFFFFFFFL) != (value & 0xFFFFFFFFL)) {
            this.nk = value;
            this.lg();
            this.n2();
        }
    }

    @Override
    public final long getRangeEndIndex() {
        return this.et;
    }

    public final void setRangeEndIndex(long value) {
        if ((this.et & 0xFFFFFFFFL) != (value & 0xFFFFFFFFL)) {
            this.et = value;
            this.lg();
            this.n2();
        }
    }

    @Override
    public final int getCount() {
        return this.cv.size();
    }

    @Override
    public final String get_Item(int index) {
        return this.cv.get_Item(index).iy();
    }

    @Override
    public final void clear() {
        if (this.cv.size() == 0) {
            return;
        }
        this.cv.clear();
        this.n2();
    }

    @Override
    public final void remove(String fontName) {
        int n = this.indexOf(fontName);
        if (n < 0) {
            return;
        }
        this.cv.removeAt(n);
        this.n2();
    }

    @Override
    public final void removeAt(int index) {
        if (index < 0 || index >= this.cv.size()) {
            throw new ArgumentOutOfRangeException("index", "The target index is out of range!");
        }
        this.cv.removeAt(index);
        this.n2();
    }

    @Override
    public final String[] toArray() {
        int n = this.cv.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.cv.get_Item(i).iy();
        }
        return stringArray;
    }

    @Override
    public final String[] toArray(int startIndex, int count) {
        int n = this.cv.size();
        if (startIndex < 0 || startIndex >= n) {
            throw new ArgumentOutOfRangeException("startIndex", "The startIndex index is out of range!");
        }
        if (count < 1) {
            throw new ArgumentOutOfRangeException("count", "The defined length of the out array must be greater then zero!");
        }
        if (startIndex + count > n) {
            throw new ArgumentException("The demanded part of fonts is out of range!");
        }
        String[] stringArray = new String[count];
        for (int i = 0; i < count; ++i) {
            stringArray[i] = this.cv.get_Item(startIndex + i).iy();
        }
        return stringArray;
    }

    @Override
    public final int indexOf(String fontName) {
        if (bu.iy(fontName)) {
            throw new ArgumentException("Font's name doesn't specified!");
        }
        String string = bu.nk(fontName);
        for (int i = 0; i < this.cv.size(); ++i) {
            if (!bu.lg(this.cv.get_Item(i).iy(), string)) continue;
            return i;
        }
        return -1;
    }

    FontFallBackRule(long startIndex, long endIndex, FontFallBackRule sourceFallBackRule) {
        this(startIndex, endIndex);
        if (sourceFallBackRule.cv.size() > 0) {
            this.cv.addRange(sourceFallBackRule.cv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void iy(i8 i82, boolean bl2) {
        if (i82 == null) {
            throw new ArgumentNullException("sourceFallBackFontContext", "Font's context doesn't specified!");
        }
        if (bl2) {
            IGenericEnumerator iGenericEnumerator = this.cv.iterator();
            try {
                while (iGenericEnumerator.hasNext()) {
                    i8 i83 = (i8)iGenericEnumerator.next();
                    if (i82 != i83) continue;
                    return;
                }
            }
            finally {
                if (com.aspose.slides.internal.vk.et.iy(iGenericEnumerator, IDisposable.class) != false) {
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
        }
        this.cv.addItem(i82);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void iy(FontFallBackRule fontFallBackRule, boolean bl2) {
        if (fontFallBackRule == null) {
            return;
        }
        IGenericEnumerator iGenericEnumerator = fontFallBackRule.cv.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                i8 i82 = (i8)iGenericEnumerator.next();
                this.iy(i82, bl2);
            }
        }
        finally {
            if (com.aspose.slides.internal.vk.et.iy(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    private void lg() {
        if ((this.nk & 0xFFFFFFFFL) > (this.et & 0xFFFFFFFFL)) {
            throw new ArgumentException("End index must be equal or greater than start index!");
        }
    }

    final List<i8> iy() {
        return this.cv;
    }

    final long nk() {
        return this.iy;
    }

    final void iy(long l) {
        this.iy = l;
    }

    private void n2() {
        IGenericEnumerator iGenericEnumerator = this.lg.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                FontFallBackRulesCollection fontFallBackRulesCollection = (FontFallBackRulesCollection)iGenericEnumerator.next();
                fontFallBackRulesCollection.iy();
            }
        }
        finally {
            if (com.aspose.slides.internal.vk.et.iy(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    final void iy(FontFallBackRulesCollection fontFallBackRulesCollection) {
        if (fontFallBackRulesCollection == null) {
            return;
        }
        if (!this.lg.containsItem(fontFallBackRulesCollection)) {
            this.lg.addItem(fontFallBackRulesCollection);
        }
    }

    final void nk(FontFallBackRulesCollection fontFallBackRulesCollection) {
        if (fontFallBackRulesCollection == null) {
            return;
        }
        if (this.lg.containsItem(fontFallBackRulesCollection)) {
            this.lg.removeItem(fontFallBackRulesCollection);
        }
    }

    final void et() {
        this.lg.clear();
        this.lg = null;
        this.cv.clear();
        this.cv = null;
    }

    final void cv() {
        IGenericEnumerator iGenericEnumerator = this.cv.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                i8 i82 = (i8)iGenericEnumerator.next();
                i82.iy(false);
            }
        }
        finally {
            if (com.aspose.slides.internal.vk.et.iy(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }
}

