/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.List;
import com.aspose.slides.IGlobalLayoutSlideCollection;
import com.aspose.slides.ILayoutSlide;
import com.aspose.slides.IMasterSlide;
import com.aspose.slides.LayoutSlide;
import com.aspose.slides.LayoutSlideCollection;
import com.aspose.slides.MasterSlideCollection;
import com.aspose.slides.PptxEditException;
import com.aspose.slides.Presentation;
import com.aspose.slides.SlideSize;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.internal.vk.et;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.bu;
import com.aspose.slides.ms.System.y7;
import com.aspose.slides.rq4;
import com.aspose.slides.x3n;

public final class GlobalLayoutSlideCollection
extends LayoutSlideCollection
implements IGlobalLayoutSlideCollection {
    GlobalLayoutSlideCollection(Presentation parent) {
        super(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ILayoutSlide addClone(ILayoutSlide sourceLayout) {
        LayoutSlide layoutSlide = (LayoutSlide)sourceLayout;
        Presentation presentation = this.iy();
        synchronized (presentation) {
            if (layoutSlide.getPresentation() == this.iy()) {
                return rq4.iy(layoutSlide.getMasterSlide(), layoutSlide);
            }
            IMasterSlide iMasterSlide = ((MasterSlideCollection)this.iy().getMasters()).iy(layoutSlide.getMasterSlide(), false);
            return this.addClone(layoutSlide, iMasterSlide);
        }
    }

    @Override
    public final ILayoutSlide addClone(ILayoutSlide sourceLayout, IMasterSlide destMaster) {
        LayoutSlide layoutSlide;
        LayoutSlide layoutSlide2 = (LayoutSlide)sourceLayout;
        if (destMaster.getPresentation() != this.iy()) {
            throw new PptxEditException("Master must belong to the target presentation.");
        }
        if (layoutSlide2.getPresentation() == this.iy()) {
            layoutSlide = (LayoutSlide)rq4.iy(destMaster, layoutSlide2);
        } else {
            layoutSlide = (LayoutSlide)rq4.iy(destMaster, layoutSlide2);
            layoutSlide.iy(layoutSlide2.getPresentation().getDefaultTextStyle());
            float f = ((SlideSize)((Presentation)this.nk).getSlideSize()).iy().nk() / ((SlideSize)sourceLayout.getPresentation().getSlideSize()).iy().nk();
            float f10 = ((SlideSize)((Presentation)this.nk).getSlideSize()).iy().et() / ((SlideSize)sourceLayout.getPresentation().getSlideSize()).iy().et();
            layoutSlide.iy(f, f10);
        }
        return layoutSlide;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ILayoutSlide add(IMasterSlide master, byte layoutType, String layoutName) {
        if (master == null) {
            throw new ArgumentNullException("master");
        }
        if (master.getPresentation() != this.iy()) {
            throw new ArgumentException("Master slide must be from the same presentation.");
        }
        LayoutSlide layoutSlide = x3n.iy(master, layoutType);
        if (layoutName != null) {
            IMasterSlide iMasterSlide = layoutSlide.getMasterSlide();
            List<String> list = new List<String>();
            IGenericEnumerator iGenericEnumerator = iMasterSlide.getLayoutSlides().iterator();
            try {
                while (iGenericEnumerator.hasNext()) {
                    ILayoutSlide iLayoutSlide = (ILayoutSlide)iGenericEnumerator.next();
                    if (iLayoutSlide == layoutSlide) continue;
                    list.addItem(iLayoutSlide.getName());
                }
            }
            finally {
                if (et.iy(iGenericEnumerator, IDisposable.class) != false) {
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
            if (list.containsItem(layoutName)) {
                throw new ArgumentException(bu.iy(new String[]{"The layout name \"", layoutName, "\" is already in use. Please modify the name."}));
            }
            layoutSlide.setName(layoutName);
        } else {
            Object object;
            IMasterSlide iMasterSlide = layoutSlide.getMasterSlide();
            List<String> list = new List<String>();
            IGenericEnumerator iGenericEnumerator = iMasterSlide.getLayoutSlides().iterator();
            try {
                while (iGenericEnumerator.hasNext()) {
                    object = (ILayoutSlide)iGenericEnumerator.next();
                    if (object == layoutSlide) continue;
                    list.addItem(object.getName());
                }
            }
            finally {
                if (et.iy(iGenericEnumerator, IDisposable.class) != false) {
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
            object = layoutSlide.getName();
            int n = 1;
            while (list.containsItem(layoutSlide.getName())) {
                layoutSlide.setName(bu.iy(new String[]{y7.nk(n), "_", object}));
                ++n;
            }
        }
        return layoutSlide;
    }
}

