/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.IAIConversation;
import com.aspose.slides.IAIWebClient;
import com.aspose.slides.SlidesAIAgentException;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.internal.of.an;
import com.aspose.slides.internal.of.bm;
import com.aspose.slides.internal.of.iy;
import com.aspose.slides.internal.of.n2;
import com.aspose.slides.internal.of.nk;
import com.aspose.slides.ms.System.bu;
import com.aspose.slides.yaw;
import java.io.Closeable;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

public class OpenAIWebClient
implements IAIWebClient,
Closeable {
    private an iy;
    private final String nk;
    private final HttpURLConnection et;
    private boolean cv;

    public OpenAIWebClient(String model, String apiKey, String organizationId) {
        this(model, apiKey, organizationId, OpenAIWebClient.iy());
        this.cv = true;
    }

    public OpenAIWebClient(String model, String apiKey, String organizationId, HttpURLConnection httpClient) {
        if (bu.iy(apiKey)) {
            throw new IllegalArgumentException("API key value can't be null or empty");
        }
        if (bu.iy(model)) {
            throw new IllegalArgumentException("Text model value can't be null or empty");
        }
        if (httpClient == null) {
            throw new IllegalArgumentException("HttpClient instance is not provided");
        }
        this.et = httpClient;
        this.iy = new an(apiKey, organizationId);
        this.nk = model;
    }

    private static HttpURLConnection iy() {
        try {
            URL uRL = new URL("https://api.openai.com/v1/chat/completions");
            return (HttpURLConnection)uRL.openConnection();
        }
        catch (IOException iOException) {
            throw new InvalidOperationException("Failed to create default HttpURLConnection");
        }
    }

    @Override
    public String callChat(String instruction) {
        iy iy2 = this.iy(instruction);
        try {
            nk nk2 = this.iy.iy(iy2, this.et);
            if (nk2.iy() == null || nk2.iy().isEmpty()) {
                throw new ArgumentException("No choices in response");
            }
            return nk2.iy().get(0).iy().nk();
        }
        catch (bm bm2) {
            throw new SlidesAIAgentException(bm2.getMessage());
        }
    }

    @Override
    public final IAIConversation createConversation() {
        return new yaw(this.iy, this.nk, this.et);
    }

    private iy iy(String string) {
        if (bu.iy(string)) {
            throw new ArgumentException("Open AI chat instruction can't be null or empty");
        }
        iy iy2 = new iy();
        String string2 = this.nk;
        if (string2 == null) {
            string2 = "gpt-4o-mini";
        }
        iy2.iy(string2);
        n2 n22 = new n2();
        n22.nk(string);
        n22.iy("user");
        iy2.iy().add(n22);
        return iy2;
    }

    @Override
    public final void close() {
        if (this.cv) {
            this.et.disconnect();
        }
    }
}

