/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.List;
import com.aspose.slides.IChartDataPoint;
import com.aspose.slides.IChartDataPointCollection;
import com.aspose.slides.IChartSeriesGroup;
import com.aspose.slides.IPieSplitCustomPointCollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.internal.vk.et;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.bu;

public class PieSplitCustomPointCollection
implements IPieSplitCustomPointCollection {
    private final IChartSeriesGroup iy;
    private final List<IChartDataPoint> nk;

    @Override
    public final IChartDataPoint get_Item(int index) {
        return this.nk.get_Item(index);
    }

    @Override
    public final void add(int dataPointIndex) {
        if (dataPointIndex < 0) {
            throw new ArgumentOutOfRangeException();
        }
        IChartDataPointCollection iChartDataPointCollection = this.iy.get_Item(0).getDataPoints();
        if (dataPointIndex >= iChartDataPointCollection.size()) {
            throw new ArgumentException(bu.iy("Point with index '{0}' was not found", new Object[]{dataPointIndex}), "dataPointIndex");
        }
        IChartDataPoint iChartDataPoint = iChartDataPointCollection.get_Item(dataPointIndex);
        if (this.nk.containsItem(iChartDataPoint)) {
            throw new ArgumentException("Data point is already added");
        }
        this.nk.addItem(iChartDataPoint);
    }

    @Override
    public void addItem(IChartDataPoint dataPoint) {
        this.iy(dataPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void iy(IChartDataPoint iChartDataPoint) {
        IChartDataPointCollection iChartDataPointCollection = this.iy.get_Item(0).getDataPoints();
        IGenericEnumerator iGenericEnumerator = iChartDataPointCollection.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IChartDataPoint iChartDataPoint2 = (IChartDataPoint)iGenericEnumerator.next();
                if (iChartDataPoint2 != iChartDataPoint) continue;
                this.nk.addItem(iChartDataPoint);
                return;
            }
        }
        finally {
            if (et.iy(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        throw new ArgumentException("Coudn't find dataPoint in parent series. Allowed adding dataPoint only from same chart and parent series");
    }

    @Override
    public boolean removeItem(IChartDataPoint dataPoint) {
        return this.nk(dataPoint);
    }

    final boolean nk(IChartDataPoint iChartDataPoint) {
        return this.nk.removeItem(iChartDataPoint);
    }

    @Override
    public final void remove(int dataPointIndex) {
        if (dataPointIndex < 0) {
            throw new ArgumentOutOfRangeException();
        }
        IChartDataPointCollection iChartDataPointCollection = this.iy.get_Item(0).getDataPoints();
        if (dataPointIndex >= iChartDataPointCollection.size()) {
            throw new ArgumentException(bu.iy("Point with index '{0}' was not found", new Object[]{dataPointIndex}), "dataPointIndex");
        }
        this.nk.removeItem(iChartDataPointCollection.get_Item(dataPointIndex));
    }

    @Override
    public final void clear() {
        this.nk.clear();
    }

    @Override
    public boolean containsItem(IChartDataPoint item) {
        return this.et(item);
    }

    final boolean et(IChartDataPoint iChartDataPoint) {
        return this.nk.containsItem(iChartDataPoint);
    }

    public void copyToTArray(IChartDataPoint[] array, int arrayIndex) {
        this.iy(array, arrayIndex);
    }

    final void iy(IChartDataPoint[] iChartDataPointArray, int n) {
        this.nk.copyToTArray((IChartDataPoint[])iChartDataPointArray, n);
    }

    @Override
    public final int size() {
        return this.nk.size();
    }

    @Override
    public final boolean isReadOnly() {
        return this.nk.isReadOnly();
    }

    public final boolean isSynchronized() {
        return false;
    }

    public final Object getSyncRoot() {
        return this;
    }

    @Override
    public final IGenericEnumerator<IChartDataPoint> iterator() {
        return this.nk.iterator();
    }

    public final IGenericEnumerator<IChartDataPoint> iteratorJava() {
        return this.nk.iteratorJava();
    }

    PieSplitCustomPointCollection(IChartSeriesGroup parentSeriesGroup) {
        this.iy = parentSeriesGroup;
        this.nk = new List();
    }
}

