/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.Cell;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.List;
import com.aspose.slides.Collections.Generic.SortedDictionary;
import com.aspose.slides.GroupShape;
import com.aspose.slides.IAutoShape;
import com.aspose.slides.IBaseSlide;
import com.aspose.slides.IChart;
import com.aspose.slides.IFindResultCallback;
import com.aspose.slides.IGroupShape;
import com.aspose.slides.IParagraph;
import com.aspose.slides.IPresentation;
import com.aspose.slides.IShape;
import com.aspose.slides.IShapeCollection;
import com.aspose.slides.ISlide;
import com.aspose.slides.ISlideComponent;
import com.aspose.slides.ISmartArt;
import com.aspose.slides.ISmartArtNode;
import com.aspose.slides.ITable;
import com.aspose.slides.ITextFrame;
import com.aspose.slides.ITextSearchOptions;
import com.aspose.slides.PortionFormat;
import com.aspose.slides.Presentation;
import com.aspose.slides.Row;
import com.aspose.slides.TextFrame;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.i4u;
import com.aspose.slides.internal.jh.lg;
import com.aspose.slides.internal.jy.bm;
import com.aspose.slides.internal.vk.et;
import com.aspose.slides.internal.zo.qb;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.bu;
import com.aspose.slides.vhu;
import com.aspose.slides.vji;

public class SlideUtil {
    public static IShape findShape(IPresentation pres, String altText) {
        IShape iShape;
        int n;
        for (n = 0; n < pres.getMasters().size(); ++n) {
            iShape = SlideUtil.findShape(pres.getMasters().get_Item(n), altText);
            if (iShape == null) continue;
            return iShape;
        }
        for (n = 0; n < pres.getSlides().size(); ++n) {
            iShape = SlideUtil.findShape(pres.getSlides().get_Item(n), altText);
            if (iShape == null) continue;
            return iShape;
        }
        return null;
    }

    public static IShape findShape(IBaseSlide slide, String altText) {
        return SlideUtil.iy(slide.getShapes(), altText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IShape[] findShapesByPlaceholderType(IBaseSlide slide, byte placeholderType) {
        List<IShape> list = new List<IShape>();
        IGenericEnumerator iGenericEnumerator = slide.getShapes().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IShape iShape = (IShape)iGenericEnumerator.next();
                if (iShape.getPlaceholder() == null || iShape.getPlaceholder().getType() != placeholderType) continue;
                list.addItem(iShape);
            }
        }
        finally {
            if (et.iy(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        return list.toArray(new IShape[0]);
    }

    public static void alignShapes(int alignmentType, boolean alignToSlide, IBaseSlide slide) {
        int[] nArray = new int[slide.getShapes().size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        SlideUtil.iy(alignmentType, alignToSlide, slide.getShapes(), nArray);
    }

    public static void alignShapes(int alignmentType, boolean alignToSlide, IBaseSlide slide, int[] shapeIndexes) {
        SlideUtil.iy(alignmentType, alignToSlide, slide.getShapes(), shapeIndexes);
    }

    public static void alignShapes(int alignmentType, boolean alignToSlide, IGroupShape groupShape) {
        int[] nArray = new int[groupShape.getShapes().size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        SlideUtil.iy(alignmentType, alignToSlide, groupShape.getShapes(), nArray);
    }

    public static void alignShapes(int alignmentType, boolean alignToSlide, IGroupShape groupShape, int[] shapeIndexes) {
        SlideUtil.iy(alignmentType, alignToSlide, groupShape.getShapes(), shapeIndexes);
    }

    public static void findAndReplaceText(IPresentation presentation, boolean withMasters, String find, String replace) {
        SlideUtil.findAndReplaceText(presentation, withMasters, find, replace, null);
    }

    public static void findAndReplaceText(IPresentation presentation, boolean withMasters, String find, String replace, PortionFormat format) {
        if (presentation == null) {
            throw new ArgumentNullException("presentation");
        }
        if (bu.iy(find)) {
            throw new ArgumentException("String to find can not be null or empty", "find");
        }
        if (replace == null) {
            throw new ArgumentNullException("replace");
        }
        if (bu.lg(find, replace)) {
            throw new ArgumentException("String to find can not be equal to string to find");
        }
        for (ITextFrame iTextFrame : SlideUtil.getAllTextFrames(presentation, withMasters)) {
            SlideUtil.iy(iTextFrame, find, replace, format);
            iTextFrame.joinPortionsWithSameFormatting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void iy(ITextFrame iTextFrame, String string, String string2, PortionFormat portionFormat) {
        IGenericEnumerator iGenericEnumerator = iTextFrame.getParagraphs().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IParagraph iParagraph = (IParagraph)iGenericEnumerator.next();
                SlideUtil.iy(iParagraph, string, string2, portionFormat);
            }
        }
        finally {
            if (et.iy(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    private static void iy(IParagraph iParagraph, String string, String string2, PortionFormat portionFormat) {
        if (bu.lg(string, string2)) {
            return;
        }
        vji vji2 = vji.iy(iParagraph);
        while (vji2.iy(string, string2, portionFormat)) {
        }
        iParagraph.getPortions().clear();
        vji2.nk(iParagraph);
    }

    public static ITextFrame[] getAllTextBoxes(IBaseSlide slide) {
        List<ITextFrame> list = new List<ITextFrame>();
        SlideUtil.iy(slide.getShapes(), list);
        return list.toArray((ITextFrame[])new ITextFrame[0]);
    }

    public static ITextFrame[] getTextBoxesContainsText(IBaseSlide slide, String text, boolean checkPlaceholderText) {
        List<ITextFrame> list = new List<ITextFrame>();
        SlideUtil.iy(slide.getShapes(), list, true, checkPlaceholderText, text);
        return list.toArray((ITextFrame[])new ITextFrame[0]);
    }

    public static ITextFrame[] getAllTextFrames(IPresentation pres, boolean withMasters) {
        int n;
        List<ITextFrame> list = new List<ITextFrame>();
        if (withMasters) {
            for (n = 0; n < pres.getMasters().size(); ++n) {
                SlideUtil.iy(pres.getMasters().get_Item(n).getShapes(), list);
            }
        }
        for (n = 0; n < pres.getSlides().size(); ++n) {
            SlideUtil.iy(pres.getSlides().get_Item(n).getShapes(), list);
        }
        return list.toArray(new ITextFrame[0]);
    }

    static ITextFrame[] iy(IPresentation iPresentation, int[] nArray, boolean bl2) {
        List<ITextFrame> list = new List<ITextFrame>();
        for (int n : nArray) {
            SlideUtil.iy(iPresentation.getSlides().get_Item(n - 1).getShapes(), list);
            if (!bl2) continue;
            SlideUtil.iy(iPresentation.getSlides().get_Item(n - 1).getLayoutSlide().getShapes(), list);
            SlideUtil.iy(iPresentation.getSlides().get_Item(n - 1).getLayoutSlide().getMasterSlide().getShapes(), list);
        }
        return list.toArray(new ITextFrame[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T> List<T> iy(Class<T> clazz, IPresentation iPresentation) {
        List<IShape> list = new List<IShape>();
        IGenericEnumerator iGenericEnumerator = iPresentation.getSlides().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                ISlide iSlide = (ISlide)iGenericEnumerator.next();
                IGenericEnumerator iGenericEnumerator2 = iSlide.getShapes().iterator();
                try {
                    while (iGenericEnumerator2.hasNext()) {
                        IShape iShape = (IShape)iGenericEnumerator2.next();
                        if (!et.nk((Object)iShape, clazz)) continue;
                        list.addItem(iShape);
                    }
                }
                finally {
                    if (et.iy(iGenericEnumerator2, IDisposable.class) == false) continue;
                    ((IDisposable)iGenericEnumerator2).dispose();
                }
            }
            return list;
        }
        finally {
            if (et.iy(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    static String iy(IPresentation iPresentation, int[] nArray) {
        qb qb2 = new qb();
        for (int n : nArray) {
            ITextFrame[] iTextFrameArray;
            ISlide iSlide = iPresentation.getSlides().get_Item(n - 1);
            for (ITextFrame iTextFrame : iTextFrameArray = SlideUtil.getAllTextBoxes(iSlide)) {
                qb2.iy(iTextFrame.getText());
            }
        }
        return qb2.toString();
    }

    private static void iy(int n, boolean bl2, IShapeCollection iShapeCollection, int[] nArray) {
        int n10;
        if (nArray == null) {
            throw new ArgumentNullException("shapeIndexes");
        }
        if (nArray.length == 0) {
            throw new ArgumentException("Indexes of shapes to be aligned should not be empty", "shapeIndexes");
        }
        SortedDictionary<Integer, Integer> sortedDictionary = new SortedDictionary<Integer, Integer>();
        int[] objectArray = nArray;
        int list = objectArray.length;
        for (n10 = 0; n10 < list; ++n10) {
            int n11 = objectArray[n10];
            if (n11 < 0) {
                throw new ArgumentException("Indexes of shapes to be aligned should be positive", "shapeIndexes");
            }
            if (sortedDictionary.containsKey(n11)) continue;
            sortedDictionary.addItem(n11, n11);
        }
        Integer[] integerArray = new Integer[sortedDictionary.size()];
        ((SortedDictionary.KeyCollection)sortedDictionary.getKeys()).copyTo(integerArray, 0);
        if (integerArray[integerArray.length - 1] > iShapeCollection.size() - 1) {
            throw new ArgumentException("Indexes of shapes to be aligned should correspond to slide shape indexes", "shapeIndexes");
        }
        List<IShape> list2 = new List<IShape>(((SortedDictionary.KeyCollection)sortedDictionary.getKeys()).size());
        for (n10 = 0; n10 < ((SortedDictionary.KeyCollection)sortedDictionary.getKeys()).size(); ++n10) {
            list2.addItem(iShapeCollection.get_Item(nArray[n10]));
        }
        i4u.iy(n, bl2, list2);
    }

    private static IShape iy(IShapeCollection iShapeCollection, String string) {
        for (int i = 0; i < iShapeCollection.size(); ++i) {
            IShape iShape;
            IShape iShape2 = iShapeCollection.get_Item(i);
            if (bu.n2(iShape2.getAlternativeText(), string) == 0) {
                return iShape2;
            }
            if (!et.nk((Object)iShape2, GroupShape.class) || (iShape = SlideUtil.iy(((GroupShape)iShape2).getShapes(), string)) == null) continue;
            return iShape;
        }
        return null;
    }

    private static void iy(IShapeCollection iShapeCollection, List<ITextFrame> list) {
        SlideUtil.iy(iShapeCollection, list, false);
    }

    private static void iy(IShapeCollection iShapeCollection, List<ITextFrame> list, boolean bl2) {
        SlideUtil.iy(iShapeCollection, list, bl2, false);
    }

    private static void iy(IShapeCollection iShapeCollection, List<ITextFrame> list, boolean bl2, boolean bl3) {
        SlideUtil.iy(iShapeCollection, list, bl2, bl3, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void iy(IShapeCollection iShapeCollection, List<ITextFrame> list, boolean bl2, boolean bl3, String string) {
        for (int i = 0; i < iShapeCollection.size(); ++i) {
            Object object;
            IShape iShape;
            ISlideComponent iSlideComponent;
            if (et.nk((Object)iShapeCollection.get_Item(i), IGroupShape.class)) {
                SlideUtil.iy(((IGroupShape)iShapeCollection.get_Item(i)).getShapes(), list);
                continue;
            }
            IAutoShape iAutoShape = (IAutoShape)((Object)et.iy(iShapeCollection.get_Item(i), IAutoShape.class));
            if (iAutoShape != null) {
                iSlideComponent = iAutoShape.getTextFrame();
                if (iSlideComponent == null || bl2 && !bu.tg(iSlideComponent.getText(), string) && (!iSlideComponent.getText().isEmpty() || !bl3 || (iShape = (IAutoShape)((Object)et.iy(iAutoShape.getBasePlaceholder(), IAutoShape.class))) == null || iShape.getTextFrame() == null || !bu.tg(iShape.getTextFrame().getText(), string))) continue;
                list.addItem((ITextFrame)iSlideComponent);
                continue;
            }
            iSlideComponent = (ITable)((Object)et.iy(iShapeCollection.get_Item(i), ITable.class));
            if (iSlideComponent != null) {
                for (int j = 0; j < iSlideComponent.getRows().size(); ++j) {
                    for (int k = 0; k < iSlideComponent.getColumns().size(); ++k) {
                        object = ((Row)iSlideComponent.getRows().get_Item(j)).iy(k);
                        if (((Cell)object).getTextFrame() == null) continue;
                        list.addItem(((Cell)object).getTextFrame());
                    }
                }
                continue;
            }
            iShape = (IChart)((Object)et.iy(iShapeCollection.get_Item(i), IChart.class));
            if (iShape != null && iShape.getUserShapes() != null) {
                SlideUtil.iy(iShape.getUserShapes().getShapes(), list);
                continue;
            }
            ISmartArt iSmartArt = (ISmartArt)((Object)et.iy(iShapeCollection.get_Item(i), ISmartArt.class));
            if (iSmartArt == null) continue;
            object = iSmartArt.getAllNodes();
            IGenericEnumerator iGenericEnumerator = object.iterator();
            try {
                while (iGenericEnumerator.hasNext()) {
                    ISmartArtNode iSmartArtNode = (ISmartArtNode)iGenericEnumerator.next();
                    list.addItem(iSmartArtNode.getTextFrame());
                }
                continue;
            }
            finally {
                if (et.iy(iGenericEnumerator, IDisposable.class) != false) {
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
        }
    }

    private static vhu iy(Presentation presentation, String string, ITextSearchOptions iTextSearchOptions, IFindResultCallback iFindResultCallback) {
        if (bu.iy(string)) {
            throw new ArgumentException("Text to highlight can not be null or empty", "text");
        }
        int n = 0;
        if (iTextSearchOptions != null && !iTextSearchOptions.getCaseSensitive()) {
            n |= 0x42;
        }
        bm bm2 = new bm("\\-\\[\\]\\{\\}\\(\\)\\*\\+\\?\\.\\,\\\\\\^\\$\\|#\\s");
        String string2 = bm2.et(string, "\\$0");
        if (iTextSearchOptions != null && iTextSearchOptions.getWholeWordsOnly()) {
            string2 = bu.iy(new String[]{"\\b", string2, "\\b"});
        }
        bm bm3 = new bm(string2, n);
        return SlideUtil.nk(presentation, bm3, iFindResultCallback);
    }

    private static vhu iy(Presentation presentation, bm bm2, IFindResultCallback iFindResultCallback) {
        if (bm2 == null) {
            throw new ArgumentException("Regex to highlight can not be null", "regex");
        }
        return SlideUtil.nk(presentation, bm2, iFindResultCallback);
    }

    private static vhu nk(Presentation presentation, bm bm2, IFindResultCallback iFindResultCallback) {
        vhu vhu2 = new vhu(bm2);
        for (ITextFrame iTextFrame : SlideUtil.getAllTextFrames(presentation, false)) {
            TextFrame textFrame = (TextFrame)iTextFrame;
            textFrame.iy(bm2, iFindResultCallback);
            if (textFrame.et.lg() <= 0) continue;
            vhu2.iy(textFrame);
        }
        return vhu2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void iy(Presentation presentation, String string, lg lg3, ITextSearchOptions iTextSearchOptions, IFindResultCallback iFindResultCallback) {
        vhu vhu2 = SlideUtil.iy(presentation, string, iTextSearchOptions, iFindResultCallback);
        IGenericEnumerator iGenericEnumerator = vhu2.nk().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TextFrame textFrame = (TextFrame)iGenericEnumerator.next();
                textFrame.iy(vhu2.iy(), lg3.ou());
            }
        }
        finally {
            if (et.iy(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void iy(Presentation presentation, bm bm2, lg lg3, IFindResultCallback iFindResultCallback) {
        vhu vhu2 = SlideUtil.iy(presentation, bm2, iFindResultCallback);
        IGenericEnumerator iGenericEnumerator = vhu2.nk().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TextFrame textFrame = (TextFrame)iGenericEnumerator.next();
                textFrame.iy(vhu2.iy(), lg3.ou());
            }
        }
        finally {
            if (et.iy(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void iy(Presentation presentation, String string, String string2, ITextSearchOptions iTextSearchOptions, IFindResultCallback iFindResultCallback) {
        vhu vhu2 = SlideUtil.iy(presentation, string, iTextSearchOptions, iFindResultCallback);
        IGenericEnumerator iGenericEnumerator = vhu2.nk().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TextFrame textFrame = (TextFrame)iGenericEnumerator.next();
                textFrame.iy(vhu2.iy(), string2);
            }
        }
        finally {
            if (et.iy(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void iy(Presentation presentation, bm bm2, String string, IFindResultCallback iFindResultCallback) {
        vhu vhu2 = SlideUtil.iy(presentation, bm2, iFindResultCallback);
        IGenericEnumerator iGenericEnumerator = vhu2.nk().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TextFrame textFrame = (TextFrame)iGenericEnumerator.next();
                textFrame.iy(vhu2.iy(), string);
            }
        }
        finally {
            if (et.iy(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }
}

