/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.IAIWebClient;
import com.aspose.slides.IParagraph;
import com.aspose.slides.IPortion;
import com.aspose.slides.IPresentation;
import com.aspose.slides.Paragraph;
import com.aspose.slides.Portion;
import com.aspose.slides.Presentation;
import com.aspose.slides.SlideUtil;
import com.aspose.slides.SlidesAIAgentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.internal.ee.iy;
import com.aspose.slides.internal.fx.eb;
import com.aspose.slides.internal.fx.q6;
import com.aspose.slides.internal.fx.tm;
import com.aspose.slides.internal.fx.yl;
import com.aspose.slides.internal.i0.et;
import com.aspose.slides.internal.wg.g9;

public class SlidesAIAgent {
    private IAIWebClient iy;

    public SlidesAIAgent(IAIWebClient aiClient) {
        if (aiClient == null) {
            throw new ArgumentNullException("aiClient", "AI client instance is not provided.");
        }
        this.iy = aiClient;
        eb.nk = new et<IParagraph>(){

            public IParagraph iy() {
                return new Paragraph();
            }

            @Override
            public /* synthetic */ Object invoke() {
                return this.iy();
            }
        };
        eb.iy = new et<IPortion>(){

            public IPortion iy() {
                return new Portion();
            }

            @Override
            public /* synthetic */ Object invoke() {
                return this.iy();
            }
        };
    }

    public void translate(IPresentation presentation, String language) {
        this.iy(presentation, language);
        String string = yl.iy(SlideUtil.getAllTextFrames(presentation, true));
        q6 q62 = new q6(presentation, string, language);
        String string2 = q62.iy();
        String string3 = this.iy.callChat(string2);
        q62.iy(string3);
    }

    public final IPresentation generatePresentation(String description, int presentationContentAmount) {
        if (description == null || description.isEmpty()) {
            throw new IllegalArgumentException("Description can't be null or empty.");
        }
        try {
            g9 g92 = com.aspose.slides.internal.ee.iy.iy("aiTemplate.pptx");
            Presentation presentation = new Presentation(g92);
            return this.generatePresentation(description, presentationContentAmount, presentation);
        }
        catch (RuntimeException runtimeException) {
            throw new SlidesAIAgentException("Failed to load template", runtimeException);
        }
    }

    public final IPresentation generatePresentation(String description, int presentationContentAmount, IPresentation presentationTemplate) {
        if (description == null || description.isEmpty()) {
            throw new IllegalArgumentException("Description can't be null or empty.");
        }
        if (presentationTemplate == null) {
            throw new IllegalArgumentException("Presentation template is not provided.");
        }
        return tm.iy(this.iy, description, presentationContentAmount, presentationTemplate);
    }

    private void iy(IPresentation iPresentation, String string) {
        if (iPresentation == null) {
            throw new IllegalArgumentException("Presentation instance is not provided.");
        }
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Language value can't be null or empty");
        }
    }
}

