/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.KeyValuePair;
import com.aspose.slides.IOutputFile;
import com.aspose.slides.Input;
import com.aspose.slides.Output;
import com.aspose.slides.Storage;
import com.aspose.slides.WebDocumentOptions;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.internal.vk.et;
import com.aspose.slides.ms.System.IDisposable;

public class WebDocument {
    private final WebDocumentOptions iy;
    private final Input nk;
    private final Output et;
    private final Storage cv = new Storage();

    public WebDocument(WebDocumentOptions options) {
        if (options == null) {
            throw new ArgumentNullException("options");
        }
        if (options.getTemplateEngine() == null) {
            throw new ArgumentException("TemplateEngine should not be null", "options");
        }
        if (options.getOutputSaver() == null) {
            throw new ArgumentException("OutputSaver should not be null", "options");
        }
        this.iy = options;
        this.nk = new Input(this.iy.getTemplateEngine());
        this.et = new Output(this.iy.getTemplateEngine(), this.cv);
    }

    public final void save() {
        IGenericEnumerator iGenericEnumerator = this.et.iy().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                KeyValuePair keyValuePair = (KeyValuePair)iGenericEnumerator.next();
                this.iy.getOutputSaver().save((String)keyValuePair.getKey(), (IOutputFile)keyValuePair.getValue());
            }
        }
        finally {
            if (com.aspose.slides.internal.vk.et.iy(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    public final Input getInput() {
        return this.nk;
    }

    public final Output getOutput() {
        return this.et;
    }

    public final Storage getGlobal() {
        return this.cv;
    }
}

