/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.internal.wg;

import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.FileNotFoundException;
import com.aspose.slides.exceptions.IOException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.exceptions.ObjectDisposedException;
import com.aspose.slides.internal.dn.cv;
import com.aspose.slides.internal.wg.an;
import com.aspose.slides.internal.wg.g9;
import com.aspose.slides.internal.wg.p1;
import com.aspose.slides.ms.System.bu;
import com.aspose.slides.ms.System.yl;
import com.aspose.slides.ms.System.zl;
import java.io.File;

public class e7
extends g9 {
    private boolean iy = false;
    private boolean nk;
    private boolean et;
    private boolean cv;
    private cv lg;
    private final String n2;

    public e7(String string, int n) {
        this(string, n, n == 6 ? 2 : 3);
    }

    private e7(int n, String string, int n10, int n11) {
        String string2;
        if (n != -2 && n <= 0) {
            throw new ArgumentOutOfRangeException("bufferSize", "Positive number required.");
        }
        boolean bl2 = n > 0;
        this.n2 = string;
        if (string == null) {
            throw new ArgumentNullException("path", "Path cannot be null.");
        }
        if (bu.nk(string).length() == 0) {
            throw new ArgumentException("Empty path name is not legal.");
        }
        if (n10 < 1 || n10 > 6) {
            throw new ArgumentOutOfRangeException("mode", "Enum value was out of legal range.");
        }
        if (n11 < 1 || n11 > 3) {
            throw new ArgumentOutOfRangeException("access", "Enum value was out of legal range.");
        }
        if (n11 == 1) {
            this.et = false;
            this.nk = true;
            string2 = "r";
        } else if (n11 == 2) {
            this.et = true;
            this.nk = false;
            string2 = "rw";
        } else {
            this.et = true;
            this.nk = true;
            string2 = "rw";
        }
        File file = new File(string);
        if (n10 == 6) {
            if (n11 == 3) {
                throw new ArgumentException("Append access can be requested only in write-only mode.");
            }
            if (n11 == 1) {
                throw new ArgumentException(bu.iy("Combining FileMode: {0} with FileAccess: {1} is invalid.", new Object[]{zl.getName(p1.class, n10), zl.getName(an.class, n11)}));
            }
        }
        if ((n10 == 2 || n10 == 1 || n10 == 5) && n11 == 1) {
            throw new ArgumentException(bu.iy("Combining FileMode: {0} with FileAccess: {1} is invalid.", new Object[]{zl.getName(p1.class, n10), zl.getName(an.class, n11)}));
        }
        if (file.exists()) {
            if (n10 == 1) {
                throw new IOException("Can't create new file. File '" + string + "' already exist.");
            }
            if (n10 == 2 || n10 == 5) {
                file.delete();
            }
            this.lg = bl2 ? new cv(file, string2, n) : new cv(file, string2);
            if (n10 == 6) {
                this.lg.iy(this.lg.cv());
            }
        } else {
            if (n10 == 3 || n10 == 5) {
                throw new FileNotFoundException("Can't find file: " + string + ".", string);
            }
            if (bl2) {
                this.lg = new cv(file, string2, n);
            } else if (string2.equals("r") && n10 == 4) {
                string2 = "rw";
                this.lg = new cv(file, string2);
                this.lg.iy(true);
            } else {
                this.lg = new cv(file, string2);
            }
        }
        this.cv = true;
    }

    public e7(String string, int n, int n10) {
        this(-2, string, n, n10);
    }

    public e7(String string, int n, int n10, int n11) {
        this(string, n, n10);
    }

    public e7(String string, int n, int n10, int n11, int n12) {
        this(n12, string, n, n10);
    }

    @Override
    public boolean canRead() {
        return this.nk;
    }

    @Override
    public boolean canSeek() {
        return this.cv;
    }

    @Override
    public boolean canWrite() {
        return this.et;
    }

    @Override
    public long getLength() {
        if (this.iy) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        return this.lg.cv();
    }

    @Override
    public long getPosition() {
        if (this.iy) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        return this.lg.et();
    }

    @Override
    public void setPosition(long position) {
        if (position < 0L) {
            throw new ArgumentOutOfRangeException("value", "Non-negative number required.");
        }
        if (this.iy) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        this.lg.iy(position);
    }

    @Override
    public void flush() {
        if (this.iy) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        this.lg.lg();
    }

    @Override
    public long seek(long offset, int origin) {
        if (origin < 0 || origin > 2) {
            throw new ArgumentException("Invalid seek origin.");
        }
        if (this.iy) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        switch (origin) {
            case 0: {
                this.lg.iy(offset);
                break;
            }
            case 1: {
                this.lg.iy(this.lg.et() + offset);
                break;
            }
            case 2: {
                this.lg.iy(this.lg.cv() + offset);
            }
        }
        return this.lg.et();
    }

    @Override
    protected void dispose(boolean disposing) {
        try {
            if (this.lg != null && !this.lg.nk()) {
                this.lg.iy();
            }
        }
        finally {
            this.nk = false;
            this.et = false;
            this.cv = false;
            super.dispose(disposing);
            this.iy = true;
        }
    }

    @Override
    public void setLength(long length) {
        if (length < 0L) {
            throw new ArgumentOutOfRangeException("length", "Non-negative number required.");
        }
        if (length == Long.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("length", "file length too big");
        }
        if (this.iy) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        if (!this.et) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        this.lg.et(length);
    }

    @Override
    public int read(byte[] buffer, int offset, int count) {
        if (buffer == null) {
            throw new ArgumentNullException("array", "Buffer cannot be null.");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", "Non-negative number required.");
        }
        if (buffer.length - offset < count) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.iy) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (this.nk) {
            int n = this.lg.nk(buffer, offset, count);
            return n == -1 ? 0 : n;
        }
        throw new NotSupportedException("Stream does not support reading.");
    }

    @Override
    public int readByte() {
        if (this.iy) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (this.nk) {
            return this.lg.n2();
        }
        throw new NotSupportedException("Stream does not support reading.");
    }

    @Override
    public void write(byte[] array, int offset, int count) {
        if (array == null) {
            throw new ArgumentNullException("array", "Buffer cannot be null.");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", "Non-negative number required.");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (array.length - offset < count) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.iy) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.et) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        this.lg.write(array, offset, count);
    }

    @Override
    public void writeByte(byte value) {
        if (this.iy) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.et) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        this.lg.write(value);
    }

    public String iy() {
        return this.n2;
    }

    @Override
    public yl beginRead(byte[] buffer, int offset, int count, com.aspose.slides.ms.System.an callback, Object state) {
        if (buffer == null) {
            throw new ArgumentNullException("buffer");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("numBytes", "Non-negative number required.");
        }
        if (buffer.length - offset < count) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.iy) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        return super.beginRead(buffer, offset, count, callback, state);
    }

    @Override
    public int endRead(yl asyncResult) {
        if (asyncResult == null) {
            throw new ArgumentNullException("asyncResult");
        }
        return super.endRead(asyncResult);
    }

    @Override
    public yl beginWrite(byte[] array, int offset, int numBytes, com.aspose.slides.ms.System.an userCallback, Object stateObject) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (numBytes < 0) {
            throw new ArgumentOutOfRangeException("numBytes", "Non-negative number required.");
        }
        if (array.length - offset < numBytes) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.iy) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        return super.beginWrite(array, offset, numBytes, userCallback, stateObject);
    }

    @Override
    public void endWrite(yl asyncResult) {
        if (asyncResult == null) {
            throw new ArgumentNullException("asyncResult");
        }
        super.endWrite(asyncResult);
    }
}

