/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.Comparer;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IList;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.ms.System.c8;
import com.aspose.slides.ms.System.i6;
import com.aspose.slides.ms.System.n3;
import com.aspose.slides.ms.System.o8;
import com.aspose.slides.ms.System.r7;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@c8
public class ArrayList
implements IList,
List {
    private Object[] p2;
    private int i5;
    private int q5;
    private static Object[] n3 = new Object[0];

    protected int getVersion() {
        return this.q5;
    }

    public ArrayList() {
        this.p2 = new Object[4];
    }

    public ArrayList(ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c", "collection is null");
        }
        this.p2 = new Object[c.size()];
        this.addRange(c);
    }

    public ArrayList(int capacity) {
        if (capacity < 0) {
            ArrayList.p2("capacity", (Object)capacity, "The initial capacity can't be smaller than zero.");
        }
        if (capacity == 0) {
            capacity = 4;
        }
        this.p2 = new Object[capacity];
    }

    private ArrayList(int initialCapacity, boolean forceZeroSize) {
        if (!forceZeroSize) {
            throw new IllegalStateException("Use ArrayList(int)");
        }
        this.p2 = null;
    }

    private ArrayList(n3 array, int index, int count) {
        this.p2 = count == 0 ? new Object[4] : new Object[count];
        com.aspose.slides.ms.System.n3.p2(array, index, com.aspose.slides.ms.System.n3.p2(this.p2), 0, count);
        this.i5 = count;
    }

    @Override
    public Object get_Item(int index) {
        if (index < 0 || index >= this.i5) {
            ArrayList.p2("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        return this.p2[index];
    }

    @Override
    public void set_Item(int index, Object value) {
        if (index < 0 || index >= this.i5) {
            ArrayList.p2("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        this.p2[index] = value;
        ++this.q5;
    }

    @Override
    public int size() {
        return this.i5;
    }

    public int getCapacity() {
        return this.p2.length;
    }

    public void setCapacity(int value) {
        if (value < this.i5) {
            ArrayList.p2("Capacity", (Object)value, "Must be more than count.");
        }
        this.p2 = value > 0 ? Arrays.copyOf(this.p2, value) : new Object[4];
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    private void p2(int n) {
        int n10;
        if (n <= this.p2.length) {
            return;
        }
        int n11 = n10 = this.p2.length == 0 ? 4 : this.p2.length * 2;
        if (n10 < n) {
            n10 = n;
        }
        this.setCapacity(n10);
    }

    private void p2(int n, int n10) {
        if (n10 > 0) {
            if (this.i5 + n10 > this.p2.length) {
                int n11;
                int n12 = n11 = this.p2.length > 0 ? this.p2.length << 1 : 1;
                while (n11 < this.i5 + n10) {
                    n11 <<= 1;
                }
                Object[] objectArray = new Object[n11];
                com.aspose.slides.ms.System.n3.p2(this.p2, 0, objectArray, 0, n);
                com.aspose.slides.ms.System.n3.p2(this.p2, n, objectArray, n + n10, this.i5 - n);
                this.p2 = objectArray;
            } else {
                com.aspose.slides.ms.System.n3.p2(this.p2, n, this.p2, n + n10, this.i5 - n);
            }
        } else if (n10 < 0) {
            int n13 = n - n10;
            com.aspose.slides.ms.System.n3.p2(this.p2, n13, this.p2, n, this.i5 - n13);
            com.aspose.slides.ms.System.n3.p2(this.p2, this.i5 + n10, -n10);
        }
    }

    @Override
    public int addItem(Object value) {
        if (this.p2.length <= this.i5) {
            this.p2(this.i5 + 1);
        }
        this.p2[this.i5] = value;
        ++this.q5;
        return this.i5++;
    }

    @Override
    public void clear() {
        com.aspose.slides.ms.System.n3.p2(this.p2, 0, this.i5);
        this.i5 = 0;
        ++this.q5;
    }

    @Override
    public boolean contains(Object item) {
        return this.indexOf(item, 0, this.i5) > -1;
    }

    boolean p2(Object object, int n, int n10) {
        return this.indexOf(object, n, n10) > -1;
    }

    @Override
    public int indexOf(Object value) {
        return this.indexOf(value, 0);
    }

    public int indexOf(Object value, int startIndex) {
        return this.indexOf(value, startIndex, this.i5 - startIndex);
    }

    public int indexOf(Object value, int startIndex, int count) {
        if (startIndex < 0 || startIndex > this.i5) {
            ArrayList.p2("startIndex", (Object)startIndex, "Does not specify valid index.");
        }
        if (count < 0) {
            ArrayList.p2("count", (Object)count, "Can't be less than 0.");
        }
        if (startIndex > this.i5 - count) {
            throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
        }
        return com.aspose.slides.ms.System.n3.p2(this.p2, value, startIndex, count);
    }

    @Override
    public int lastIndexOf(Object value) {
        return this.lastIndexOf(value, this.i5 - 1);
    }

    public int lastIndexOf(Object value, int startIndex) {
        return this.lastIndexOf(value, startIndex, startIndex + 1);
    }

    public int lastIndexOf(Object value, int startIndex, int count) {
        return i6.p2(this.p2, value, startIndex, count);
    }

    @Override
    public void insertItem(int index, Object value) {
        if (index < 0 || index > this.i5) {
            ArrayList.p2("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        this.p2(index, 1);
        this.p2[index] = value;
        ++this.i5;
        ++this.q5;
    }

    public void insertRange(int index, ICollection c) {
        int n;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.i5) {
            ArrayList.p2("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n = c.size()) > 0) {
            if (this.p2.length < this.i5 + n) {
                this.p2(this.i5 + n);
            }
            if (index < this.i5) {
                com.aspose.slides.ms.System.n3.p2(this.p2, index, this.p2, index + n, this.i5 - index);
            }
            if (this == c.getSyncRoot()) {
                com.aspose.slides.ms.System.n3.p2(this.p2, 0, this.p2, index, index);
                com.aspose.slides.ms.System.n3.p2(this.p2, index + n, this.p2, index << 1, this.i5 - index);
            } else {
                c.copyTo(com.aspose.slides.ms.System.n3.p2(this.p2), index);
            }
            this.i5 += c.size();
            ++this.q5;
        }
    }

    public void insertRange(int index, Object[] c) {
        int n;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.i5) {
            ArrayList.p2("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n = c.length) > 0) {
            if (this.p2.length < this.i5 + n) {
                this.p2(this.i5 + n);
            }
            if (index < this.i5) {
                com.aspose.slides.ms.System.n3.p2(this.p2, index, this.p2, index + n, this.i5 - index);
            }
            com.aspose.slides.ms.System.n3.p2(c).copyTo(com.aspose.slides.ms.System.n3.p2(this.p2), index);
            this.i5 += c.length;
            ++this.q5;
        }
    }

    @Override
    public void removeItem(Object obj) {
        int n = this.indexOf(obj);
        if (n > -1) {
            this.removeAt(n);
        }
        ++this.q5;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || index >= this.i5) {
            ArrayList.p2("index", (Object)index, "Less than 0 or more than list count.");
        }
        this.p2(index, -1);
        --this.i5;
        ++this.q5;
    }

    public void removeRange(int index, int count) {
        ArrayList.p2(index, count, this.i5);
        this.p2(index, -count);
        this.i5 -= count;
        ++this.q5;
    }

    public void reverse() {
        i6.p2(this.p2, 0, this.i5);
        ++this.q5;
    }

    public void reverse(int index, int count) {
        ArrayList.p2(index, count, this.i5);
        i6.p2(this.p2, index, count);
        ++this.q5;
    }

    public void copyTo(n3 array) {
        com.aspose.slides.ms.System.n3.p2(com.aspose.slides.ms.System.n3.p2(this.p2), 0, array, 0, this.i5);
    }

    @Override
    public void copyTo(n3 array, int arrayIndex) {
        this.copyTo(0, array, arrayIndex, this.i5);
    }

    public void copyTo(int index, n3 array, int arrayIndex, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.n3() != 1) {
            throw new ArgumentException("Must have only 1 dimensions.", "array");
        }
        com.aspose.slides.ms.System.n3.p2(com.aspose.slides.ms.System.n3.p2(this.p2), index, array, arrayIndex, count);
    }

    @Override
    public IEnumerator iterator() {
        return new SimpleEnumerator(this);
    }

    public IEnumerator iterator(int index, int count) {
        ArrayList.p2(index, count, this.i5);
        return new ArrayListEnumerator(this, index, count);
    }

    public void addRange(ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.i5, c);
    }

    public void addRange(Object[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.i5, collection);
    }

    public int binarySearch(Object value) {
        if (value == null) {
            return -1;
        }
        try {
            return i6.p2(this.p2, 0, this.i5, value);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(Object value, Comparator comparer) {
        try {
            return i6.p2(this.p2, 0, this.i5, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(int index, int count, Object value, Comparator comparer) {
        try {
            return i6.p2(this.p2, index, count, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public ArrayList getRange(int index, int count) {
        ArrayList.p2(index, count, this.i5);
        if (this.isSynchronized()) {
            return ArrayList.sync(new RangedArrayList(this, index, count));
        }
        return new RangedArrayList(this, index, count);
    }

    public void setRange(int index, ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index + c.size() > this.i5) {
            throw new ArgumentOutOfRangeException("index");
        }
        c.copyTo(com.aspose.slides.ms.System.n3.p2(this.p2), index);
        ++this.q5;
    }

    public void trimToSize() {
        this.setCapacity(this.i5);
    }

    public void sort() {
        Arrays.sort(this.p2, 0, this.i5, Comparer.Default);
        ++this.q5;
    }

    public void sort(Comparator comparer) {
        Arrays.sort(this.p2, 0, this.i5, comparer);
    }

    public void sort(int index, int count, Comparator comparer) {
        ArrayList.p2(index, count, this.i5);
        Arrays.sort(this.p2, index, index + count, comparer);
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.i5];
        this.copyTo(com.aspose.slides.ms.System.n3.p2(objectArray));
        return objectArray;
    }

    public n3 toArray(o8 type) {
        n3 n32 = com.aspose.slides.ms.System.n3.p2(type, this.i5);
        this.copyTo(n32);
        return n32;
    }

    public Object deepClone() {
        return new ArrayList(com.aspose.slides.ms.System.n3.p2(this.p2), 0, this.i5);
    }

    static void p2(int n, int n10, int n11) {
        if (n < 0) {
            ArrayList.p2("index", (Object)n, "Can't be less than 0.");
        }
        if (n10 < 0) {
            ArrayList.p2("count", (Object)n10, "Can't be less than 0.");
        }
        if (n > n11 - n10) {
            throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
        }
    }

    static void p2(String string, Object object, String string2) {
        throw new ArgumentOutOfRangeException(string, object, string2);
    }

    public static ArrayList adapter(IList list) {
        ArrayList arrayList;
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        ArrayList arrayList2 = arrayList = list instanceof ArrayList ? (ArrayList)list : null;
        if (arrayList != null) {
            return arrayList;
        }
        arrayList = new ArrayListAdapter(list);
        if (list.isSynchronized()) {
            return ArrayList.sync(arrayList);
        }
        return arrayList;
    }

    public static ArrayList sync(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new SynchronizedArrayListWrapper(list);
    }

    public static IList sync(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new SynchronizedListWrapper(list);
    }

    public static ArrayList readOnly(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new ReadOnlyArrayListWrapper(list);
    }

    public static IList readOnly(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new ReadOnlyListWrapper(list);
    }

    public static ArrayList fixedSize(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new FixedSizeArrayListWrapper(list);
    }

    public static IList fixedSize(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new FixedSizeListWrapper(list);
    }

    public static ArrayList repeat(Object value, int count) {
        ArrayList arrayList = new ArrayList(count);
        for (int i = 0; i < count; ++i) {
            arrayList.addItem(value);
        }
        return arrayList;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (a.length <= this.size()) {
            a = new Object[this.size()];
        }
        this.copyTo(com.aspose.slides.ms.System.n3.p2(a));
        return a;
    }

    @Override
    public boolean add(Object o) {
        int n = this.size();
        this.addItem(o);
        return this.size() != n;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.size();
        this.removeItem(o);
        return this.size() != n;
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        return this.addAll(this.i5, c);
    }

    public boolean addAll(int index, Collection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = index;
        int n10 = this.size();
        for (Object e : c) {
            this.insertItem(n++, e);
        }
        return n10 != this.size();
    }

    @Override
    public boolean removeAll(Collection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = this.size();
        for (Object e : c) {
            this.removeItem(e);
        }
        return n != this.size();
    }

    @Override
    public boolean retainAll(Collection c) {
        Object[] objectArray;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c.contains(object)) continue;
            this.remove(object);
        }
        return n != this.size();
    }

    public Object get(int index) {
        return this.get_Item(index);
    }

    public Object set(int index, Object element) {
        Object object = this.get_Item(index);
        this.set_Item(index, element);
        return object;
    }

    public void add(int index, Object element) {
        this.insertItem(index, element);
    }

    public Object remove(int index) {
        Object object = this.get_Item(index);
        this.removeAt(index);
        return object;
    }

    public ListIterator listIterator() {
        return new ListItr(0);
    }

    public ListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    public List subList(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        return this.getRange(fromIndex, n);
    }

    public static ArrayList fromJava(List list) {
        if (list == null) {
            return null;
        }
        return new ArrayListInternalized(list);
    }

    public static List toJava(ArrayList list) {
        return list;
    }

    private static class ArrayListInternalized
    extends ArrayList {
        private List p2;
        private int i5;

        @Override
        protected int getVersion() {
            return this.p2 instanceof ArrayList ? ((ArrayList)this.p2).getVersion() : this.i5;
        }

        public ArrayListInternalized(List internal) {
            this.p2 = internal;
            if (internal instanceof ArrayList) {
                this.i5 = ((ArrayList)internal).getVersion();
            }
        }

        @Override
        public Object get_Item(int index) {
            return this.p2.get(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.p2.set(index, value);
            ++this.i5;
        }

        @Override
        public int size() {
            return this.p2.size();
        }

        @Override
        public int getCapacity() {
            return Math.max(super.getCapacity(), this.p2.size());
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.p2.size()) {
                throw new ArgumentOutOfRangeException("Capacity", value, "Must be more than count.");
            }
            for (int i = 0; i < value - this.p2.size(); ++i) {
                this.p2.add(null);
            }
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public int addItem(Object value) {
            int n = this.p2.size();
            this.p2.add(value);
            ++this.i5;
            return n;
        }

        @Override
        public void clear() {
            this.p2.clear();
            ++this.i5;
        }

        @Override
        public boolean contains(Object item) {
            return this.p2.contains(item);
        }

        @Override
        public int indexOf(Object value) {
            return this.p2.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.p2.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.p2.size()) {
                throw new ArgumentOutOfRangeException("startIndex", startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (startIndex > this.p2.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            return com.aspose.slides.ms.System.n3.p2(this.p2.toArray(), value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.p2.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return i6.p2(this.p2.toArray(), value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            if (index < 0 || index > this.p2.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.p2.add(index, value);
            ++this.i5;
        }

        @Override
        public void insertRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.p2.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object e : c) {
                this.p2.add(index++, e);
            }
            ++this.i5;
        }

        @Override
        public void insertRange(int index, Object[] c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.p2.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object object : c) {
                this.p2.add(index++, object);
            }
            ++this.i5;
        }

        @Override
        public void removeItem(Object obj) {
            this.p2.remove(obj);
            ++this.i5;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || index > this.p2.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.p2.remove(index);
            ++this.i5;
        }

        @Override
        public void removeRange(int index, int count) {
            if (index < 0 || index > this.p2.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.p2.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i = 0; i < count; ++i) {
                this.p2.remove(index);
            }
            ++this.i5;
        }

        @Override
        public void reverse() {
            this.reverse(0, this.p2.size());
        }

        @Override
        public void reverse(int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.p2.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            int n = index;
            for (int i = index + this.p2.size() - 1; n < i; ++n, --i) {
                Object e = this.p2.get(n);
                this.p2.set(n, this.p2.get(i));
                this.p2.set(i, e);
            }
            ++this.i5;
        }

        @Override
        public void copyTo(n3 array) {
            com.aspose.slides.ms.System.n3.p2(com.aspose.slides.ms.System.n3.p2(this.p2.toArray()), 0, array, 0, this.p2.size());
        }

        @Override
        public void copyTo(n3 array, int arrayIndex) {
            this.copyTo(0, array, arrayIndex, this.p2.size());
        }

        @Override
        public void copyTo(int index, n3 array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.n3() != 1) {
                throw new ArgumentException("Must have only 1 dimensions.", "array");
            }
            com.aspose.slides.ms.System.n3.p2(com.aspose.slides.ms.System.n3.p2(this.p2.toArray()), index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return new SimpleEnumerator(this);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            ArrayList.p2(index, count, this.p2.size());
            return new ArrayListEnumerator(this, index, count);
        }

        @Override
        public void addRange(ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.size(), c);
        }

        @Override
        public void addRange(Object[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.p2.size(), collection);
        }

        @Override
        public int binarySearch(Object value) {
            if (value == null) {
                return -1;
            }
            try {
                return i6.p2(this.p2.toArray(), 0, this.p2.size(), value);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            try {
                return i6.p2(this.p2.toArray(), 0, this.p2.size(), value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            try {
                return i6.p2(this.p2.toArray(), index, count, value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public ArrayList getRange(int index, int count) {
            ArrayList.p2(index, count, this.p2.size());
            if (this.isSynchronized()) {
                return ArrayList.sync(new RangedArrayList(this, index, count));
            }
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void setRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c.size() > this.p2.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            for (Object e : c) {
                this.p2.set(index++, e);
            }
            ++this.i5;
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            Collections.sort(this.p2, null);
            ++this.i5;
        }

        @Override
        public void sort(Comparator comparer) {
            Collections.sort(this.p2, comparer);
            ++this.i5;
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.p2.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            List list = this.p2.subList(index, count);
            if (comparer == null) {
                Collections.sort(list);
            } else {
                Collections.sort(list, comparer);
            }
            for (int i = index; i < count; ++i) {
                this.p2.set(i, list.get(i - index));
            }
            ++this.i5;
        }

        @Override
        public Object[] toArray() {
            return this.p2.toArray();
        }

        @Override
        public n3 toArray(o8 type) {
            n3 n32 = com.aspose.slides.ms.System.n3.p2(type, this.p2.size());
            this.copyTo(n32);
            return n32;
        }

        @Override
        public Object deepClone() {
            Object[] objectArray = new Object[this.p2.size()];
            com.aspose.slides.ms.System.n3.p2(this.p2.toArray(), 0, objectArray, 0, this.p2.size());
            java.util.ArrayList arrayList = new java.util.ArrayList();
            arrayList.addAll(arrayList);
            return new ArrayListInternalized(arrayList);
        }

        @Override
        public boolean isEmpty() {
            return this.p2.size() == 0;
        }

        @Override
        public Object[] toArray(Object[] a) {
            return this.p2.toArray(a);
        }

        @Override
        public boolean add(Object o) {
            ++this.i5;
            return this.p2.add(o);
        }

        @Override
        public boolean remove(Object o) {
            ++this.i5;
            return this.p2.remove(o);
        }

        @Override
        public boolean containsAll(Collection c) {
            return this.p2.containsAll(c);
        }

        @Override
        public boolean addAll(Collection c) {
            ++this.i5;
            return this.p2.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection c) {
            ++this.i5;
            return this.p2.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection c) {
            ++this.i5;
            return this.p2.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection c) {
            ++this.i5;
            return this.p2.retainAll(c);
        }

        @Override
        public Object get(int index) {
            return this.p2.get(index);
        }

        @Override
        public Object set(int index, Object element) {
            ++this.i5;
            return this.p2.set(index, element);
        }

        @Override
        public void add(int index, Object element) {
            this.p2.add(index, element);
            ++this.i5;
        }

        @Override
        public Object remove(int index) {
            ++this.i5;
            return this.p2.remove(index);
        }

        @Override
        public ListIterator listIterator() {
            return this.p2.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.p2.listIterator(index);
        }

        @Override
        public List subList(int fromIndex, int toIndex) {
            return this.p2.subList(fromIndex, toIndex);
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.p2 = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.p2 != 0;
        }

        @Override
        public int nextIndex() {
            return this.p2;
        }

        @Override
        public int previousIndex() {
            return this.p2 - 1;
        }

        public Object previous() {
            int n = this.p2 - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.p2;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.p2 = n;
            this.i5 = n;
            return objectArray[this.i5];
        }

        public void set(Object e) {
            if (this.i5 < 0) {
                throw new IllegalStateException();
            }
            try {
                ((ArrayList)ArrayList.this).p2[this.i5] = e;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object e) {
            try {
                int n = this.p2;
                ArrayList.this.add(n, e);
                this.p2 = n + 1;
                this.i5 = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator {
        int p2;
        int i5 = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.p2 != ArrayList.this.size();
        }

        public Object next() {
            int n = this.p2;
            if (n >= ArrayList.this.size()) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.p2;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.p2 = n + 1;
            this.i5 = n;
            return objectArray[this.i5];
        }

        @Override
        public void remove() {
            if (this.i5 < 0) {
                throw new IllegalStateException();
            }
            try {
                ArrayList.this.remove(this.i5);
                this.p2 = this.i5;
                this.i5 = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    @c8
    private static class ListWrapper
    implements IList {
        protected IList p2;

        public ListWrapper(IList innerList) {
            this.p2 = innerList;
        }

        @Override
        public Object get_Item(int index) {
            return this.p2.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.p2.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.p2.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.p2.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.p2.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.p2.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.p2.isReadOnly();
        }

        @Override
        public int addItem(Object value) {
            return this.p2.addItem(value);
        }

        @Override
        public void clear() {
            this.p2.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.p2.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.p2.indexOf(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.p2.insertItem(index, value);
        }

        @Override
        public void removeItem(Object value) {
            this.p2.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.p2.removeAt(index);
        }

        @Override
        public void copyTo(n3 array, int index) {
            this.p2.copyTo(array, index);
        }

        @Override
        public IEnumerator iterator() {
            return this.p2.iterator();
        }
    }

    @c8
    private static final class ReadOnlyListWrapper
    extends FixedSizeListWrapper {
        @Override
        protected String p2() {
            return "List is read-only.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public ReadOnlyListWrapper(IList innerList) {
            super(innerList);
        }

        @Override
        public Object get_Item(int index) {
            return this.p2.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.p2());
        }
    }

    @c8
    private static class FixedSizeListWrapper
    extends ListWrapper {
        protected String p2() {
            return "List is fixed-size.";
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        public FixedSizeListWrapper(IList innerList) {
            super(innerList);
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.p2());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.p2());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.p2());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.p2());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.p2());
        }
    }

    @c8
    private static final class SynchronizedListWrapper
    extends ListWrapper {
        private final Object i5;

        public SynchronizedListWrapper(IList innerList) {
            super(innerList);
            this.i5 = innerList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getSyncRoot() {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.getSyncRoot();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.isReadOnly();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.i5;
            synchronized (object) {
                this.p2.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.i5;
            synchronized (object) {
                this.p2.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.i5;
            synchronized (object) {
                this.p2.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.i5;
            synchronized (object) {
                this.p2.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.i5;
            synchronized (object) {
                this.p2.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(n3 array, int index) {
            Object object = this.i5;
            synchronized (object) {
                this.p2.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.iterator();
            }
        }
    }

    @c8
    private static final class RangedArrayList
    extends ArrayListWrapper {
        private int i5;
        private int q5;
        private int n3;

        public RangedArrayList(ArrayList innerList, int index, int count) {
            super(innerList);
            this.i5 = index;
            this.q5 = count;
            this.n3 = innerList.getVersion();
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object get_Item(int index) {
            if (index < 0 || index > this.q5) {
                throw new ArgumentOutOfRangeException("index");
            }
            return this.p2.get_Item(this.i5 + index);
        }

        @Override
        public void set_Item(int index, Object value) {
            if (index < 0 || index > this.q5) {
                throw new ArgumentOutOfRangeException("index");
            }
            this.p2.set_Item(this.i5 + index, value);
        }

        @Override
        public int size() {
            this.p2();
            return this.q5;
        }

        @Override
        public int getCapacity() {
            return this.p2.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.q5) {
                throw new ArgumentOutOfRangeException();
            }
        }

        private void p2() {
            if (this.n3 != this.p2.getVersion()) {
                throw new IllegalStateException("ArrayList view is invalid because the underlying ArrayList was modified.");
            }
        }

        @Override
        public int addItem(Object value) {
            this.p2();
            this.p2.insertItem(this.i5 + this.q5, value);
            this.n3 = this.p2.getVersion();
            return ++this.q5;
        }

        @Override
        public void clear() {
            this.p2();
            this.p2.removeRange(this.i5, this.q5);
            this.q5 = 0;
            this.n3 = this.p2.getVersion();
        }

        @Override
        public boolean contains(Object value) {
            return this.p2.p2(value, this.i5, this.q5);
        }

        @Override
        public int indexOf(Object value) {
            return this.indexOf(value, 0);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.q5 - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.q5) {
                RangedArrayList.p2("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                RangedArrayList.p2("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.q5 - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            int n = this.p2.indexOf(value, this.i5 + startIndex, count);
            if (n == -1) {
                return -1;
            }
            return n - this.i5;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.q5 - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            int n;
            if (startIndex < 0) {
                RangedArrayList.p2("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                RangedArrayList.p2("count", (Object)count, "count is negative.");
            }
            if ((n = this.p2.lastIndexOf(value, this.i5 + startIndex, count)) == -1) {
                return -1;
            }
            return n - this.i5;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.p2();
            if (index < 0 || index > this.q5) {
                RangedArrayList.p2("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.p2.insertItem(this.i5 + index, value);
            ++this.q5;
            this.n3 = this.p2.getVersion();
        }

        @Override
        public void insertRange(int index, ICollection c) {
            this.p2();
            if (index < 0 || index > this.q5) {
                RangedArrayList.p2("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.p2.insertRange(this.i5 + index, c);
            this.q5 += c.size();
            this.n3 = this.p2.getVersion();
        }

        @Override
        public void removeItem(Object value) {
            this.p2();
            int n = this.indexOf(value);
            if (n > -1) {
                this.removeAt(n);
            }
            this.n3 = this.p2.getVersion();
        }

        @Override
        public void removeAt(int index) {
            this.p2();
            if (index < 0 || index > this.q5) {
                RangedArrayList.p2("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.p2.removeAt(this.i5 + index);
            --this.q5;
            this.n3 = this.p2.getVersion();
        }

        @Override
        public void removeRange(int index, int count) {
            this.p2();
            RangedArrayList.p2(index, count, this.q5);
            this.p2.removeRange(this.i5 + index, count);
            this.q5 -= count;
            this.n3 = this.p2.getVersion();
        }

        @Override
        public void reverse() {
            this.reverse(0, this.q5);
        }

        @Override
        public void reverse(int index, int count) {
            this.p2();
            RangedArrayList.p2(index, count, this.q5);
            this.p2.reverse(this.i5 + index, count);
            this.n3 = this.p2.getVersion();
        }

        @Override
        public void setRange(int index, ICollection c) {
            this.p2();
            if (index < 0 || index > this.q5) {
                RangedArrayList.p2("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.p2.setRange(this.i5 + index, c);
            this.n3 = this.p2.getVersion();
        }

        @Override
        public void copyTo(n3 array) {
            this.copyTo(array, 0);
        }

        @Override
        public void copyTo(n3 array, int index) {
            this.copyTo(0, array, index, this.q5);
        }

        @Override
        public void copyTo(int index, n3 array, int arrayIndex, int count) {
            RangedArrayList.p2(index, count, this.q5);
            this.p2.copyTo(this.i5 + index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.iterator(0, this.q5);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            RangedArrayList.p2(index, count, this.q5);
            return this.p2.iterator(this.i5 + index, count);
        }

        @Override
        public void addRange(ICollection c) {
            this.p2();
            this.p2.insertRange(this.q5, c);
            this.q5 += c.size();
            this.n3 = this.p2.getVersion();
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(0, this.q5, value, Comparer.Default);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.q5, value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            RangedArrayList.p2(index, count, this.q5);
            return this.p2.binarySearch(this.i5 + index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return new RangedArrayList((ArrayList)this.p2.deepClone(), this.i5, this.q5);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            RangedArrayList.p2(index, count, this.q5);
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException();
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.q5, comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.p2();
            RangedArrayList.p2(index, count, this.q5);
            this.p2.sort(this.i5 + index, count, comparer);
            this.n3 = this.p2.getVersion();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.q5];
            this.p2.copyTo(this.i5, com.aspose.slides.ms.System.n3.p2(objectArray), 0, this.q5);
            return objectArray;
        }

        @Override
        public n3 toArray(o8 elementType) {
            n3 n32 = com.aspose.slides.ms.System.n3.p2(elementType, this.q5);
            this.p2.copyTo(this.i5, n32, 0, this.q5);
            return n32;
        }
    }

    @c8
    private static final class ReadOnlyArrayListWrapper
    extends FixedSizeArrayListWrapper {
        @Override
        protected String p2() {
            return "Can't modify a readonly list.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public ReadOnlyArrayListWrapper(ArrayList innerArrayList) {
            super(innerArrayList);
        }

        @Override
        public Object get_Item(int index) {
            return this.p2.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.p2());
        }

        @Override
        public void reverse() {
            throw new NotSupportedException(this.p2());
        }

        @Override
        public void reverse(int index, int count) {
            throw new NotSupportedException(this.p2());
        }

        @Override
        public void setRange(int index, ICollection c) {
            throw new NotSupportedException(this.p2());
        }

        @Override
        public void sort() {
            throw new NotSupportedException(this.p2());
        }

        @Override
        public void sort(Comparator comparer) {
            throw new NotSupportedException(this.p2());
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            throw new NotSupportedException(this.p2());
        }
    }

    @c8
    private static class FixedSizeArrayListWrapper
    extends ArrayListWrapper {
        public FixedSizeArrayListWrapper(ArrayList innerList) {
            super(innerList);
        }

        protected String p2() {
            return "Can't add or remove from a fixed-size list.";
        }

        @Override
        public int getCapacity() {
            return super.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            throw new NotSupportedException(this.p2());
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.p2());
        }

        @Override
        public void addRange(ICollection c) {
            throw new NotSupportedException(this.p2());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.p2());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.p2());
        }

        @Override
        public void insertRange(int index, ICollection c) {
            throw new NotSupportedException(this.p2());
        }

        @Override
        public void insertRange(int index, Object[] c) {
            throw new NotSupportedException(this.p2());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.p2());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.p2());
        }

        @Override
        public void removeRange(int index, int count) {
            throw new NotSupportedException(this.p2());
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException(this.p2());
        }
    }

    @c8
    private static final class SynchronizedArrayListWrapper
    extends ArrayListWrapper {
        private final Object i5;

        SynchronizedArrayListWrapper(ArrayList innerArrayList) {
            super(innerArrayList);
            this.i5 = innerArrayList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.i5;
            synchronized (object) {
                this.p2.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.i5;
            synchronized (object) {
                this.p2.setCapacity(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.isReadOnly();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.i5;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.i5;
            synchronized (object) {
                this.p2.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex) {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.indexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex, int count) {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.indexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value) {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.lastIndexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex) {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.lastIndexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.lastIndexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.i5;
            synchronized (object) {
                this.p2.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertRange(int index, ICollection c) {
            Object object = this.i5;
            synchronized (object) {
                this.p2.insertRange(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.i5;
            synchronized (object) {
                this.p2.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.i5;
            synchronized (object) {
                this.p2.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeRange(int index, int count) {
            Object object = this.i5;
            synchronized (object) {
                this.p2.removeRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse() {
            Object object = this.i5;
            synchronized (object) {
                this.p2.reverse();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse(int index, int count) {
            Object object = this.i5;
            synchronized (object) {
                this.p2.reverse(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(n3 array) {
            Object object = this.i5;
            synchronized (object) {
                this.p2.copyTo(array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(n3 array, int index) {
            Object object = this.i5;
            synchronized (object) {
                this.p2.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(int index, n3 array, int arrayIndex, int count) {
            Object object = this.i5;
            synchronized (object) {
                this.p2.copyTo(index, array, arrayIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator(int index, int count) {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.iterator(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addRange(ICollection c) {
            Object object = this.i5;
            synchronized (object) {
                this.p2.addRange(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value) {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.binarySearch(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value, Comparator comparer) {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.binarySearch(value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.binarySearch(index, count, value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArrayList getRange(int index, int count) {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.getRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.i5;
            synchronized (object) {
                this.p2.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort() {
            Object object = this.i5;
            synchronized (object) {
                this.p2.sort();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(Comparator comparer) {
            Object object = this.i5;
            synchronized (object) {
                this.p2.sort(comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(int index, int count, Comparator comparer) {
            Object object = this.i5;
            synchronized (object) {
                this.p2.sort(index, count, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public n3 toArray(o8 elementType) {
            Object object = this.i5;
            synchronized (object) {
                return this.p2.toArray(elementType);
            }
        }
    }

    @c8
    private static class ArrayListWrapper
    extends ArrayList {
        protected ArrayList p2;

        public ArrayListWrapper(ArrayList innerArrayList) {
            this.p2 = innerArrayList;
        }

        @Override
        public Object get_Item(int index) {
            return this.p2.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.p2.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.p2.size();
        }

        @Override
        public int getCapacity() {
            return this.p2.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            this.p2.setCapacity(value);
        }

        @Override
        public boolean isFixedSize() {
            return this.p2.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.p2.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return this.p2.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.p2.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.p2.addItem(value);
        }

        @Override
        public void clear() {
            this.p2.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.p2.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.p2.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.p2.indexOf(value, startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            return this.p2.indexOf(value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.p2.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.p2.lastIndexOf(value, startIndex);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return this.p2.lastIndexOf(value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.p2.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c) {
            this.p2.insertRange(index, c);
        }

        @Override
        public void removeItem(Object value) {
            this.p2.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.p2.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            this.p2.removeRange(index, count);
        }

        @Override
        public void reverse() {
            this.p2.reverse();
        }

        @Override
        public void reverse(int index, int count) {
            this.p2.reverse(index, count);
        }

        @Override
        public void setRange(int index, ICollection c) {
            this.p2.setRange(index, c);
        }

        @Override
        public void copyTo(n3 array) {
            this.p2.copyTo(array);
        }

        @Override
        public void copyTo(n3 array, int index) {
            this.p2.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, n3 array, int arrayIndex, int count) {
            this.p2.copyTo(index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.p2.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            return this.p2.iterator(index, count);
        }

        @Override
        public void addRange(ICollection c) {
            this.p2.addRange(c);
        }

        @Override
        public int binarySearch(Object value) {
            return this.p2.binarySearch(value);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.p2.binarySearch(value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            return this.p2.binarySearch(index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return this.p2.deepClone();
        }

        @Override
        public ArrayList getRange(int index, int count) {
            return this.p2.getRange(index, count);
        }

        @Override
        public void trimToSize() {
            this.p2.trimToSize();
        }

        @Override
        public void sort() {
            this.p2.sort();
        }

        @Override
        public void sort(Comparator comparer) {
            this.p2.sort(comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.p2.sort(index, count, comparer);
        }

        @Override
        public Object[] toArray() {
            return this.p2.toArray();
        }

        @Override
        public n3 toArray(o8 elementType) {
            return this.p2.toArray(elementType);
        }
    }

    @c8
    private static final class ArrayListAdapter
    extends ArrayList {
        private IList p2;

        public ArrayListAdapter(IList adaptee) {
            super(0, true);
            this.p2 = adaptee;
        }

        @Override
        public Object get_Item(int index) {
            return this.p2.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.p2.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.p2.size();
        }

        @Override
        public int getCapacity() {
            return this.p2.size();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.p2.size()) {
                throw new ArgumentException("capacity");
            }
        }

        @Override
        public boolean isFixedSize() {
            return this.p2.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.p2.isReadOnly();
        }

        @Override
        public Object getSyncRoot() {
            return this.p2.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.p2.addItem(value);
        }

        @Override
        public void clear() {
            this.p2.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.p2.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.p2.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.p2.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.p2.size()) {
                ArrayListAdapter.p2("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                ArrayListAdapter.p2("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.p2.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            if (value == null) {
                for (int i = startIndex; i < startIndex + count; ++i) {
                    if (this.p2.get_Item(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = startIndex; i < startIndex + count; ++i) {
                    if (!value.equals(this.p2.get_Item(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.p2.size() - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            if (startIndex < 0) {
                ArrayListAdapter.p2("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                ArrayListAdapter.p2("count", (Object)count, "count is negative.");
            }
            if (startIndex - count + 1 < 0) {
                ArrayListAdapter.p2("count", (Object)count, "count is too large.");
            }
            if (value == null) {
                for (int i = startIndex; i > startIndex - count; --i) {
                    if (this.p2.get_Item(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = startIndex; i > startIndex - count; --i) {
                    if (!value.equals(this.p2.get_Item(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.p2.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index > this.p2.size()) {
                ArrayListAdapter.p2("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            for (Object e : c) {
                this.p2.insertItem(index++, e);
            }
        }

        @Override
        public void removeItem(Object value) {
            this.p2.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.p2.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            ArrayListAdapter.p2(index, count, this.p2.size());
            for (int i = 0; i < count; ++i) {
                this.p2.removeAt(index);
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.p2.size());
        }

        @Override
        public void reverse(int index, int count) {
            ArrayListAdapter.p2(index, count, this.p2.size());
            for (int i = 0; i < count / 2; ++i) {
                Object object = this.p2.get_Item(i + index);
                this.p2.set_Item(i + index, this.p2.get_Item(index + count - i + index - 1));
                this.p2.set_Item(index + count - i + index - 1, object);
            }
        }

        @Override
        public void setRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c.size() > this.p2.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            int n = index;
            for (Object e : c) {
                this.p2.set_Item(n++, e);
            }
        }

        @Override
        public void copyTo(n3 array) {
            this.p2.copyTo(array, 0);
        }

        @Override
        public void copyTo(n3 array, int index) {
            this.p2.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, n3 array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (index < 0) {
                ArrayListAdapter.p2("index", (Object)index, "Can't be less than zero.");
            }
            if (arrayIndex < 0) {
                ArrayListAdapter.p2("arrayIndex", (Object)arrayIndex, "Can't be less than zero.");
            }
            if (count < 0) {
                ArrayListAdapter.p2("index", (Object)index, "Can't be less than zero.");
            }
            if (array.n3() > 1) {
                throw new ArgumentException("Can't copy into multi-dimensional array.");
            }
            if (array.s3() - arrayIndex < count) {
                throw new ArgumentException("Destination array is too small.");
            }
            if (index > this.p2.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i = 0; i < count; ++i) {
                array.q5(this.p2.get_Item(index + i), arrayIndex + i);
            }
        }

        @Override
        public boolean isSynchronized() {
            return this.p2.isSynchronized();
        }

        @Override
        public IEnumerator iterator() {
            return this.p2.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            ArrayListAdapter.p2(index, count, this.p2.size());
            return new EnumeratorWithRange(this.p2.iterator(), index, count);
        }

        @Override
        public void addRange(ICollection c) {
            for (Object e : c) {
                this.p2.addItem(e);
            }
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(value, null);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.p2.size(), value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            ArrayListAdapter.p2(index, count, this.p2.size());
            if (comparer == null) {
                comparer = Comparer.Default;
            }
            int n = index;
            int n10 = index + count - 1;
            while (n <= n10) {
                int n11;
                int n12 = n + (n10 - n) / 2;
                try {
                    n11 = comparer.compare(value, this.p2.get_Item(n12));
                }
                catch (Exception exception) {
                    throw new InvalidOperationException("value is not of the same type", exception);
                }
                if (n11 < 0) {
                    n10 = n12 - 1;
                    continue;
                }
                if (n11 > 0) {
                    n = n12 + 1;
                    continue;
                }
                return n12;
            }
            return ~n;
        }

        @Override
        public Object deepClone() {
            return new ArrayListAdapter(this.p2);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            ArrayListAdapter.p2(index, count, this.p2.size());
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.p2.size(), comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            ArrayListAdapter.p2(index, count, this.p2.size());
            if (comparer == null) {
                comparer = Comparer.Default;
            }
            ArrayListAdapter.p2(this.p2, index, index + count - 1, comparer);
        }

        private static void p2(IList iList, int n, int n10) {
            Object object = iList.get_Item(n);
            iList.set_Item(n, iList.get_Item(n10));
            iList.set_Item(n10, object);
        }

        static void p2(IList iList, int n, int n10, Comparator comparator) {
            if (n >= n10) {
                return;
            }
            int n11 = n + (n10 - n) / 2;
            if (comparator.compare(iList.get_Item(n11), iList.get_Item(n)) < 0) {
                ArrayListAdapter.p2(iList, n11, n);
            }
            if (comparator.compare(iList.get_Item(n10), iList.get_Item(n)) < 0) {
                ArrayListAdapter.p2(iList, n10, n);
            }
            if (comparator.compare(iList.get_Item(n10), iList.get_Item(n11)) < 0) {
                ArrayListAdapter.p2(iList, n10, n11);
            }
            if (n10 - n + 1 <= 3) {
                return;
            }
            ArrayListAdapter.p2(iList, n10 - 1, n11);
            Object object = iList.get_Item(n10 - 1);
            int n12 = n;
            int n13 = n10 - 1;
            while (true) {
                if (comparator.compare(iList.get_Item(++n12), object) < 0) {
                    continue;
                }
                while (comparator.compare(iList.get_Item(--n13), object) > 0) {
                }
                if (n12 >= n13) break;
                ArrayListAdapter.p2(iList, n12, n13);
            }
            ArrayListAdapter.p2(iList, n10 - 1, n12);
            ArrayListAdapter.p2(iList, n, n12 - 1, comparator);
            ArrayListAdapter.p2(iList, n12 + 1, n10, comparator);
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.p2.size()];
            this.p2.copyTo(com.aspose.slides.ms.System.n3.p2(objectArray), 0);
            return objectArray;
        }

        @Override
        public n3 toArray(o8 elementType) {
            n3 n32 = com.aspose.slides.ms.System.n3.p2(elementType, this.p2.size());
            this.p2.copyTo(n32, 0);
            return n32;
        }

        private static final class EnumeratorWithRange
        implements IEnumerator,
        r7,
        Cloneable {
            private int p2;
            private int i5;
            private int q5;
            private IEnumerator n3;

            private EnumeratorWithRange() {
            }

            public EnumeratorWithRange(IEnumerator enumerator, int index, int count) {
                this.i5 = 0;
                this.p2 = index;
                this.q5 = count;
                this.n3 = enumerator;
                this.reset();
            }

            @Override
            public Object deepClone() {
                return this.p2();
            }

            @Override
            public Object next() {
                return this.n3.next();
            }

            @Override
            public boolean hasNext() {
                if (this.i5 >= this.q5) {
                    return false;
                }
                ++this.i5;
                return this.n3.hasNext();
            }

            @Override
            public void reset() {
                this.i5 = 0;
                this.n3.reset();
                for (int i = 0; i < this.p2; ++i) {
                    this.n3.hasNext();
                }
            }

            protected Object p2() {
                try {
                    return this.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new IllegalStateException(cloneNotSupportedException);
                }
            }

            protected Object clone() throws CloneNotSupportedException {
                EnumeratorWithRange enumeratorWithRange = new EnumeratorWithRange();
                enumeratorWithRange.p2 = this.p2;
                enumeratorWithRange.i5 = this.i5;
                enumeratorWithRange.q5 = this.q5;
                enumeratorWithRange.n3 = this.n3;
                return enumeratorWithRange;
            }

            @Override
            public void remove() {
                throw new NotSupportedException();
            }
        }
    }

    static final class SimpleEnumerator
    implements IEnumerator,
    r7,
    Cloneable {
        private ArrayList i5;
        private Object q5;
        private int n3;
        private int s3;
        static Object p2 = new Object();

        private SimpleEnumerator() {
        }

        public SimpleEnumerator(ArrayList list) {
            this.i5 = list;
            this.n3 = -1;
            this.s3 = list.getVersion();
            this.q5 = p2;
        }

        @Override
        public Object deepClone() {
            return this.p2();
        }

        @Override
        public boolean hasNext() {
            if (this.s3 != this.i5.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            if (++this.n3 < this.i5.size()) {
                this.q5 = this.i5.get_Item(this.n3);
                return true;
            }
            this.q5 = p2;
            return false;
        }

        @Override
        public Object next() {
            if (this.q5 == p2) {
                if (this.n3 == -1) {
                    throw new IllegalStateException("Enumerator not started");
                }
                throw new IllegalStateException("Enumerator ended");
            }
            return this.q5;
        }

        @Override
        public void reset() {
            if (this.s3 != this.i5.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            this.q5 = p2;
            this.n3 = -1;
        }

        protected Object p2() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            SimpleEnumerator simpleEnumerator = new SimpleEnumerator();
            simpleEnumerator.i5 = this.i5;
            simpleEnumerator.q5 = this.q5;
            simpleEnumerator.n3 = this.n3;
            simpleEnumerator.s3 = this.s3;
            return simpleEnumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class ArrayListEnumerator
    implements IEnumerator,
    r7,
    Cloneable {
        private Object p2;
        private ArrayList i5;
        private int q5;
        private int n3;
        private int s3;
        private int s4;

        private ArrayListEnumerator() {
        }

        @Override
        public Object deepClone() {
            return this.p2();
        }

        public ArrayListEnumerator(ArrayList list, int index, int count) {
            this.i5 = list;
            this.n3 = index;
            this.s3 = count;
            this.q5 = this.n3 - 1;
            this.p2 = null;
            this.s4 = list.getVersion();
        }

        @Override
        public Object next() {
            if (this.q5 == this.n3 - 1) {
                throw new IllegalStateException("Enumerator unusable (Reset pending, or past end of array.");
            }
            return this.p2;
        }

        @Override
        public boolean hasNext() {
            if (this.i5.getVersion() != this.s4) {
                throw new IllegalStateException("List has changed.");
            }
            ++this.q5;
            if (this.q5 - this.n3 < this.s3) {
                this.p2 = this.i5.get_Item(this.q5);
                return true;
            }
            return false;
        }

        @Override
        public void reset() {
            this.p2 = null;
            this.q5 = this.n3 - 1;
        }

        protected Object p2() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            ArrayListEnumerator arrayListEnumerator = new ArrayListEnumerator();
            arrayListEnumerator.p2 = this.p2;
            arrayListEnumerator.i5 = this.i5;
            arrayListEnumerator.q5 = this.q5;
            arrayListEnumerator.n3 = this.n3;
            arrayListEnumerator.s3 = this.s3;
            arrayListEnumerator.s4 = this.s4;
            return arrayListEnumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }
}

