/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.c8;
import com.aspose.slides.ms.System.n3;
import com.aspose.slides.ms.System.r7;

@c8
public final class BitArray
implements ICollection,
r7 {
    private int[] p2;
    private int i5;
    private int q5 = 0;

    public BitArray(BitArray bits) {
        if (bits == null) {
            throw new ArgumentNullException("bits");
        }
        this.i5 = bits.i5;
        this.p2 = new int[(this.i5 + 31) / 32];
        if (this.p2.length == 1) {
            this.p2[0] = bits.p2[0];
        } else {
            n3.p2(bits.p2, 0, this.p2, 0, this.p2.length);
        }
    }

    public BitArray(boolean[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        this.i5 = values.length;
        this.p2 = new int[(this.i5 + 31) / 32];
        for (int i = 0; i < values.length; ++i) {
            this.set_Item(i, values[i]);
        }
    }

    public BitArray(byte[] bytes) {
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        this.i5 = bytes.length * 8;
        this.p2 = new int[(this.i5 + 31) / 32];
        for (int i = 0; i < bytes.length; ++i) {
            this.p2(i, bytes[i]);
        }
    }

    public BitArray(int[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        int n = values.length;
        this.i5 = n * 32;
        this.p2 = new int[n];
        n3.p2(values, 0, this.p2, 0, n);
    }

    public BitArray(int length) {
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length");
        }
        this.i5 = length;
        this.p2 = new int[(this.i5 + 31) / 32];
    }

    public BitArray(int length, boolean defaultValue) {
        this(length);
        if (defaultValue) {
            for (int i = 0; i < this.p2.length; ++i) {
                this.p2[i] = -1;
            }
        }
    }

    private byte p2(int n) {
        int n10 = n / 4;
        int n11 = n % 4 * 8;
        int n12 = this.p2[n10] & 255 << n11;
        return (byte)(n12 >> n11 & 0xFF);
    }

    private void p2(int n, byte by) {
        int n10 = n / 4;
        int n11 = n % 4 * 8;
        int n12 = n10;
        this.p2[n12] = this.p2[n12] & ~(255 << n11);
        int n13 = n10;
        this.p2[n13] = this.p2[n13] | (by & 0xFF) << n11;
        ++this.q5;
    }

    private void i5(BitArray bitArray) {
        if (bitArray == null) {
            throw new ArgumentNullException();
        }
        if (bitArray.i5 != this.i5) {
            throw new ArgumentException();
        }
    }

    @Override
    public int size() {
        return this.i5;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    public boolean get_Item(int index) {
        return this.get(index);
    }

    public void set_Item(int index, boolean value) {
        this.set(index, value);
    }

    public int getLength() {
        return this.i5;
    }

    public void setLength(int value) {
        if (this.i5 == value) {
            return;
        }
        if (value < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (value > this.i5) {
            int n = (value + 31) / 32;
            int n10 = (this.i5 + 31) / 32;
            if (n > this.p2.length) {
                int[] nArray = new int[n];
                n3.p2(this.p2, 0, nArray, 0, this.p2.length);
                this.p2 = nArray;
            } else {
                n3.p2(n3.p2((Object)this.p2), n10, n - n10);
            }
            int n11 = this.i5 % 32;
            if (n11 > 0) {
                int n12 = n10 - 1;
                this.p2[n12] = this.p2[n12] & (1 << n11) - 1;
            }
        }
        this.i5 = value;
        ++this.q5;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public Object deepClone() {
        return new BitArray(this);
    }

    @Override
    public void copyTo(n3 array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.n3() != 1) {
            throw new ArgumentException("array", "Array rank must be 1");
        }
        if (index >= array.s3() && this.i5 > 0) {
            throw new ArgumentException("index", "index is greater than array.Length");
        }
        Object object = n3.p2(array);
        if (object instanceof Boolean[]) {
            if (array.s3() - index < this.i5) {
                throw new ArgumentException();
            }
            Boolean[] booleanArray = (Boolean[])object;
            for (int i = 0; i < this.i5; ++i) {
                booleanArray[index + i] = this.get_Item(i);
            }
        } else if (object instanceof boolean[]) {
            if (array.s3() - index < this.i5) {
                throw new ArgumentException();
            }
            boolean[] blArray = (boolean[])object;
            for (int i = 0; i < this.i5; ++i) {
                blArray[index + i] = this.get_Item(i);
            }
        } else if (object instanceof Byte[]) {
            int n = (this.i5 + 7) / 8;
            if (array.s3() - index < n) {
                throw new ArgumentException();
            }
            Byte[] byteArray = (Byte[])object;
            for (int i = 0; i < n; ++i) {
                byteArray[index + i] = this.p2(i);
            }
        } else if (object instanceof byte[]) {
            int n = (this.i5 + 7) / 8;
            if (array.s3() - index < n) {
                throw new ArgumentException();
            }
            byte[] byArray = (byte[])object;
            for (int i = 0; i < n; ++i) {
                byArray[index + i] = this.p2(i);
            }
        } else if (object instanceof Integer[]) {
            n3.p2(n3.p2((Object)this.p2), 0, array, index, (this.i5 + 31) / 32);
        } else if (object instanceof int[]) {
            n3.p2(n3.p2((Object)this.p2), 0, array, index, (this.i5 + 31) / 32);
        } else {
            throw new ArgumentException("array", "Unsupported type");
        }
    }

    public BitArray not() {
        int n = (this.i5 + 31) / 32;
        for (int i = 0; i < n; ++i) {
            this.p2[i] = ~this.p2[i];
        }
        ++this.q5;
        return this;
    }

    public BitArray and(BitArray value) {
        this.i5(value);
        int n = (this.i5 + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.p2[n10] = this.p2[n10] & value.p2[i];
        }
        ++this.q5;
        return this;
    }

    public BitArray or(BitArray value) {
        this.i5(value);
        int n = (this.i5 + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.p2[n10] = this.p2[n10] | value.p2[i];
        }
        ++this.q5;
        return this;
    }

    public BitArray xor(BitArray value) {
        this.i5(value);
        int n = (this.i5 + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.p2[n10] = this.p2[n10] ^ value.p2[i];
        }
        ++this.q5;
        return this;
    }

    public boolean get(int index) {
        if (index < 0 || index >= this.i5) {
            throw new ArgumentOutOfRangeException();
        }
        return (this.p2[index >> 5] & 1 << (index & 0x1F)) != 0;
    }

    public void set(int index, boolean value) {
        if (index < 0 || index >= this.i5) {
            throw new ArgumentOutOfRangeException();
        }
        if (value) {
            int n = index >> 5;
            this.p2[n] = this.p2[n] | 1 << (index & 0x1F);
        } else {
            int n = index >> 5;
            this.p2[n] = this.p2[n] & ~(1 << (index & 0x1F));
        }
        ++this.q5;
    }

    public void setAll(boolean value) {
        if (value) {
            for (int i = 0; i < this.p2.length; ++i) {
                this.p2[i] = -1;
            }
        } else {
            n3.p2(n3.p2((Object)this.p2), 0, this.p2.length);
        }
        ++this.q5;
    }

    @Override
    public IEnumerator iterator() {
        return new BitArrayEnumerator(this);
    }

    @c8
    private static class BitArrayEnumerator
    implements IEnumerator,
    r7,
    Cloneable {
        private BitArray p2;
        private boolean i5;
        private int q5;
        private int n3;

        @Override
        public Object deepClone() {
            return this.p2();
        }

        private BitArrayEnumerator() {
        }

        public BitArrayEnumerator(BitArray ba) {
            this.q5 = -1;
            this.p2 = ba;
            this.n3 = ba.q5;
        }

        @Override
        public Object next() {
            if (this.q5 == -1) {
                throw new InvalidOperationException("Enum not started");
            }
            if (this.q5 >= this.p2.size()) {
                throw new InvalidOperationException("Enum Ended");
            }
            return this.i5;
        }

        @Override
        public boolean hasNext() {
            this.i5();
            if (this.q5 < this.p2.size() - 1) {
                this.i5 = this.p2.get_Item(++this.q5);
                return true;
            }
            this.q5 = this.p2.size();
            return false;
        }

        @Override
        public void reset() {
            this.i5();
            this.q5 = -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        private void i5() {
            if (this.n3 != this.p2.q5) {
                throw new InvalidOperationException();
            }
        }

        protected Object p2() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            BitArrayEnumerator bitArrayEnumerator = new BitArrayEnumerator();
            bitArrayEnumerator.p2 = this.p2;
            bitArrayEnumerator.i5 = this.i5;
            bitArrayEnumerator.q5 = this.q5;
            bitArrayEnumerator.n3 = this.n3;
            return bitArrayEnumerator;
        }
    }
}

