/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.IGenericList;
import com.aspose.slides.Collections.ObjectModel.ReadOnlyCollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.internal.v6t.l5;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.c8;
import com.aspose.slides.ms.System.f4;
import com.aspose.slides.ms.System.i6;
import com.aspose.slides.ms.System.j6;
import com.aspose.slides.ms.System.m2;
import com.aspose.slides.ms.System.n3;
import com.aspose.slides.ms.System.p2;
import com.aspose.slides.ms.System.r5;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@c8
public class List<T>
implements IGenericList<T>,
java.util.List<T> {
    private Object[] p2;
    private int i5;
    private int q5;
    private final Object n3 = new Object();
    static Object[] s4 = new Object[0];

    public List() {
        this.p2 = s4;
    }

    public List(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.p2 = s4;
        this.p2(collection);
    }

    public List(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: capacity");
        }
        this.p2 = new Object[capacity];
    }

    private List(T[] data, int size) {
        this.p2 = data;
        this.i5 = size;
    }

    protected int getVersion() {
        return this.q5;
    }

    @Override
    public void addItem(T item) {
        if (this.i5 == this.p2.length) {
            this.p2(1);
        }
        this.p2[this.i5++] = item;
        ++this.q5;
    }

    private void p2(int n) {
        int n10 = this.i5 + n;
        if (n10 > this.p2.length) {
            this.setCapacity(Math.max(Math.max(this.getCapacity() * 2, 4), n10));
        }
    }

    private void p2(int n, int n10) {
        if (n < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (n10 < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)n & 0xFFFFFFFFL) + ((long)n10 & 0xFFFFFFFFL) > ((long)this.i5 & 0xFFFFFFFFL)) {
            throw new ArgumentException("index and count exceed length of list");
        }
    }

    private void p2(IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t : iGenericEnumerable) {
            this.addItem(t);
        }
    }

    public void addRange(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.p2(new List<T>(collection));
        ++this.q5;
    }

    public void addRange(T[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (T t : collection) {
            this.addItem(t);
        }
        ++this.q5;
    }

    public ReadOnlyCollection<T> asReadOnly() {
        return new ReadOnlyCollection(this);
    }

    public int binarySearch(T item) {
        return i6.p2(this.p2, 0, this.i5, item);
    }

    public int binarySearch(T item, Comparator<T> comparer) {
        return i6.p2(this.p2, 0, this.i5, item, comparer);
    }

    public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
        this.p2(index, count);
        return i6.p2(this.p2, index, count, item, comparer);
    }

    @Override
    public void clear() {
        com.aspose.slides.ms.System.n3.p2(this.p2, 0, this.p2.length);
        this.i5 = 0;
        ++this.q5;
    }

    public <TOutput> List<TOutput> convertAll(r5<T, TOutput> converter) {
        if (converter == null) {
            throw new ArgumentNullException("converter");
        }
        List<T> list = new List<T>(this.i5);
        for (int i = 0; i < this.i5; ++i) {
            list.p2[i] = converter.p2(this.p2[i]);
        }
        list.i5 = this.i5;
        return list;
    }

    public void copyTo(T[] array) {
        com.aspose.slides.ms.System.n3.p2(this.p2, 0, array, 0, this.i5);
    }

    @Override
    public void copyToTArray(T[] array, int arrayIndex) {
        com.aspose.slides.ms.System.n3.p2(this.p2, 0, array, arrayIndex, this.i5);
    }

    public void copyTo(int index, T[] array, int arrayIndex, int count) {
        this.p2(index, count);
        com.aspose.slides.ms.System.n3.p2(this.p2, index, array, arrayIndex, count);
    }

    public boolean exists(j6<T> match) {
        List.p2(match);
        return this.p2(0, this.i5, match) != -1;
    }

    public T find(j6<T> match) {
        List.p2(match);
        int n = this.p2(0, this.i5, match);
        return (T)(n != -1 ? this.p2[n] : null);
    }

    static <T> void p2(j6<T> j62) {
        if (j62 == null) {
            throw new ArgumentNullException("match");
        }
    }

    public List<T> findAll(j6<T> match) {
        List.p2(match);
        return this.i5(match);
    }

    private List<T> i5(j6<T> j62) {
        List<Object> list = new List<Object>();
        for (int i = 0; i < this.i5; ++i) {
            if (!j62.invoke(this.p2[i])) continue;
            list.addItem(this.p2[i]);
        }
        return list;
    }

    public int findIndex(j6<T> match) {
        List.p2(match);
        return this.p2(0, this.i5, match);
    }

    public int findIndex(int startIndex, j6<T> match) {
        List.p2(match);
        this.i5(startIndex);
        return this.p2(startIndex, this.i5 - startIndex, match);
    }

    public int findIndex(int startIndex, int count, j6<T> match) {
        List.p2(match);
        this.p2(startIndex, count);
        return this.p2(startIndex, count, match);
    }

    private int p2(int n, int n10, j6<T> j62) {
        int n11 = n + n10;
        for (int i = n; i < n11; ++i) {
            if (!j62.invoke(this.p2[i])) continue;
            return i;
        }
        return -1;
    }

    public T findLast(j6<T> match) {
        List.p2(match);
        int n = this.i5(0, this.i5, match);
        if (n == -1) {
            return null;
        }
        return this.get_Item(n);
    }

    public int findLastIndex(j6<T> match) {
        List.p2(match);
        return this.i5(0, this.i5, match);
    }

    public int findLastIndex(int startIndex, j6<T> match) {
        List.p2(match);
        this.i5(startIndex);
        return this.i5(0, startIndex + 1, match);
    }

    public int findLastIndex(int startIndex, int count, j6<T> match) {
        List.p2(match);
        int n = startIndex - count + 1;
        this.p2(n, count);
        return this.i5(n, count, match);
    }

    private int i5(int n, int n10, j6<T> j62) {
        int n11 = n + n10;
        while (n11 != n) {
            if (!j62.invoke(this.p2[--n11])) continue;
            return n11;
        }
        return -1;
    }

    @Override
    public void forEach(p2<T> action) {
        if (action == null) {
            throw new ArgumentNullException("action");
        }
        for (int i = 0; i < this.i5; ++i) {
            action.invoke(this.p2[i]);
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    @Deprecated
    public EnumeratorJava<T> iteratorJava() {
        return new EnumeratorJava(this);
    }

    public List<T> getRange(int index, int count) {
        this.p2(index, count);
        Object[] objectArray = new Object[count];
        com.aspose.slides.ms.System.n3.p2(this.p2, index, objectArray, 0, count);
        return new List<Object>(objectArray, count);
    }

    @Override
    public int indexOfItem(T item) {
        return com.aspose.slides.ms.System.n3.p2(this.p2, item, 0, this.i5);
    }

    public int indexOf(T item, int index) {
        this.i5(index);
        return com.aspose.slides.ms.System.n3.p2(this.p2, item, index, this.i5 - index);
    }

    public int indexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.i5 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
        }
        return com.aspose.slides.ms.System.n3.p2(this.p2, item, index, count);
    }

    private void i5(int n, int n10) {
        if (n10 < 0) {
            n -= n10;
        }
        if (n < this.i5) {
            com.aspose.slides.ms.System.n3.p2(this.p2, n, this.p2, n + n10, this.i5 - n);
        }
        this.i5 += n10;
        if (n10 < 0) {
            com.aspose.slides.ms.System.n3.p2(this.p2, this.i5, -n10);
        }
    }

    private void i5(int n) {
        if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.i5 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
    }

    @Override
    public void insertItem(int index, T item) {
        this.i5(index);
        if (this.i5 == this.p2.length) {
            this.p2(1);
        }
        this.i5(index, 1);
        this.p2[index] = item;
        ++this.q5;
    }

    void q5(int n) {
        Object[] objectArray = new Object[this.i5];
        this.copyToTArray(objectArray, 0);
        this.p2(this.i5);
        this.i5(n, objectArray.length);
        com.aspose.slides.ms.System.n3.p2(objectArray, 0, this.p2, n, objectArray.length);
    }

    public void insertRange(int index, IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.i5(index);
        if (collection == this) {
            this.q5(index);
        } else {
            this.p2(index, collection);
        }
        ++this.q5;
    }

    private void p2(int n, IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t : iGenericEnumerable) {
            this.insertItem(n++, t);
        }
    }

    @Override
    public int lastIndexOf(Object item) {
        if (this.i5 == 0) {
            return -1;
        }
        return i6.p2(this.p2, item, this.i5 - 1, this.i5);
    }

    public int lastIndexOf(T item, int index) {
        this.i5(index);
        return i6.p2(this.p2, item, index, index + 1);
    }

    public int lastIndexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index", index, "index is negative");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", count, "count is negative");
        }
        if (index - count + 1 < 0) {
            throw new ArgumentOutOfRangeException("cound", count, "count is too large");
        }
        return i6.p2(this.p2, item, index, count);
    }

    @Override
    public boolean removeItem(T item) {
        int n = this.indexOfItem(item);
        if (n != -1) {
            this.removeAt(n);
        }
        return n != -1;
    }

    public int removeAll(j6<T> match) {
        List.p2(match);
        int n = 0;
        int n10 = 0;
        for (n = 0; n < this.i5 && !match.invoke(this.p2[n]); ++n) {
        }
        if (n == this.i5) {
            return 0;
        }
        ++this.q5;
        for (n10 = n + 1; n10 < this.i5; ++n10) {
            if (match.invoke(this.p2[n10])) continue;
            this.p2[n++] = this.p2[n10];
        }
        if (n10 - n > 0) {
            com.aspose.slides.ms.System.n3.p2(this.p2, n, n10 - n);
        }
        this.i5 = n;
        return n10 - n;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.i5 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.i5(index, -1);
        com.aspose.slides.ms.System.n3.p2(this.p2, this.i5, 1);
        ++this.q5;
    }

    public void removeRange(int index, int count) {
        this.p2(index, count);
        if (count > 0) {
            this.i5(index, -count);
            com.aspose.slides.ms.System.n3.p2(this.p2, this.i5, count);
            ++this.q5;
        }
    }

    public void reverse() {
        i6.p2(this.p2, 0, this.i5);
        ++this.q5;
    }

    public void reverse(int index, int count) {
        this.p2(index, count);
        i6.p2(this.p2, index, count);
        ++this.q5;
    }

    public void sort() {
        Arrays.sort(this.p2, 0, this.i5);
        ++this.q5;
    }

    @Override
    public void sort(Comparator<? super T> comparer) {
        Arrays.sort(this.p2, 0, this.i5, comparer);
        ++this.q5;
    }

    @Override
    public void sort(f4<T> comparison) {
        if (comparison == null) {
            throw new ArgumentNullException("comparison");
        }
        Arrays.sort(this.p2, 0, this.i5, new i6.p2<T>(comparison));
        ++this.q5;
    }

    public void sort(int index, int count, Comparator<T> comparer) {
        this.p2(index, count);
        Arrays.sort(this.p2, index, index + count, comparer);
        ++this.q5;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.i5) {
            return Arrays.copyOf(this.p2, this.i5, a.getClass());
        }
        System.arraycopy(this.p2, 0, a, 0, this.i5);
        if (a.length > this.i5) {
            a[this.i5] = null;
        }
        return a;
    }

    public void trimExcess() {
        this.setCapacity(this.i5);
    }

    public boolean trueForAll(j6<T> match) {
        List.p2(match);
        for (int i = 0; i < this.i5; ++i) {
            if (match.invoke(this.p2[i])) continue;
            return false;
        }
        return true;
    }

    public int getCapacity() {
        return this.p2.length;
    }

    public void setCapacity(int value) {
        if (((long)value & 0xFFFFFFFFL) < ((long)this.i5 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException();
        }
        this.p2 = Arrays.copyOf(this.p2, value);
    }

    @Override
    public int size() {
        return this.i5;
    }

    @Override
    public T get_Item(int index) {
        if (((long)index & 0xFFFFFFFFL) >= ((long)this.i5 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        return (T)this.p2[index];
    }

    @Override
    public void set_Item(int index, T value) {
        this.i5(index);
        if ((long)index == (long)this.i5) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.p2[index] = value;
        ++this.q5;
    }

    public void copyTo(n3 array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.n3() > 1 || array.i5(0) != 0) {
            throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
        }
        com.aspose.slides.ms.System.n3.p2(com.aspose.slides.ms.System.n3.p2(this.p2), 0, array, arrayIndex, this.i5);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public boolean isSynchronized() {
        return false;
    }

    public Object getSyncRoot() {
        return this.n3;
    }

    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.i5 == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            for (int i = 0; i < this.i5; ++i) {
                if (this.p2[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.i5; ++i) {
            if (!this.p2[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsItem(T item) {
        if (item == null) {
            for (int i = 0; i < this.i5; ++i) {
                if (this.p2[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.i5; ++i) {
            if (!this.p2[i].equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.i5];
        System.arraycopy(this.p2, 0, objectArray, 0, this.i5);
        return objectArray;
    }

    @Override
    public boolean add(T t) {
        int n = this.i5;
        this.addItem(t);
        return n != this.i5;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.i5;
        this.removeItem(o);
        return n != this.i5;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        int n = 0;
        int n10 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n10 != this.size();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        int n = index;
        int n10 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n10 != this.size();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int n = this.size();
        for (Object obj : c) {
            this.remove(obj);
        }
        return n != this.size();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Object[] objectArray;
        int n = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c.contains(object)) continue;
            this.remove(object);
        }
        return n != this.size();
    }

    @Override
    public T get(int index) {
        return this.get_Item(index);
    }

    @Override
    public T set(int index, T element) {
        T t = this.get_Item(index);
        this.set_Item(index, element);
        return t;
    }

    @Override
    public void add(int index, T element) {
        this.insertItem(index, element);
    }

    @Override
    public T remove(int index) {
        T t = this.get_Item(index);
        this.removeAt(index);
        return t;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.i5; ++i) {
                if (this.p2[i] != null) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.i5; ++i) {
            if (!o.equals(this.p2[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator listIterator() {
        return new ListItr(0);
    }

    @Override
    public ListIterator listIterator(int index) {
        return new ListItr(index);
    }

    @Override
    public java.util.List<T> subList(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        return this.getRange(fromIndex, n);
    }

    public static <T> List<T> fromJava(java.util.List<T> list) {
        if (list == null) {
            return null;
        }
        return new ListInternalized<T>(list);
    }

    public static <T> java.util.List<T> toJava(List<T> list) {
        return list;
    }

    static class ListInternalized<T>
    extends List<T> {
        private java.util.List<T> p2;
        private int i5;

        public ListInternalized() {
            this.p2 = new ArrayList<T>();
        }

        public ListInternalized(java.util.List<T> list) {
            super(list.size());
            for (T t : list) {
                super.addItem(t);
            }
            this.p2 = list;
        }

        @Override
        protected int getVersion() {
            return this.i5;
        }

        @Override
        public void addRange(IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            this.p2(collection);
            ++this.i5;
        }

        @Override
        public void addRange(T[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            for (T t : collection) {
                this.addItem(t);
            }
            ++this.i5;
        }

        @Override
        public ReadOnlyCollection<T> asReadOnly() {
            return new ReadOnlyCollection(this);
        }

        @Override
        public int binarySearch(T item) {
            return i6.p2(this.p2.toArray(), 0, this.p2.size(), item);
        }

        @Override
        public int binarySearch(T item, Comparator<T> comparer) {
            return i6.p2(this.p2.toArray(), 0, this.p2.size(), item, comparer);
        }

        @Override
        public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
            this.p2(index, count);
            return i6.p2(this.p2.toArray(), index, count, item, comparer);
        }

        @Override
        private void p2(int n, int n10) {
            if (n < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (n10 < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)n & 0xFFFFFFFFL) + ((long)n10 & 0xFFFFFFFFL) > ((long)this.p2.size() & 0xFFFFFFFFL)) {
                throw new ArgumentException("index and count exceed length of list");
            }
        }

        @Override
        public <TOutput> List<TOutput> convertAll(r5<T, TOutput> converter) {
            if (converter == null) {
                throw new ArgumentNullException("converter");
            }
            List list = new List(this.p2.size());
            for (int i = 0; i < this.p2.size(); ++i) {
                list.p2[i] = converter.p2(this.get_Item(i));
            }
            list.i5 = this.p2.size();
            return list;
        }

        @Override
        public void copyTo(T[] array) {
            com.aspose.slides.ms.System.n3.p2(this.p2.toArray(), 0, array, 0, this.p2.size());
        }

        @Override
        public void copyToTArray(T[] array, int arrayIndex) {
            com.aspose.slides.ms.System.n3.p2(this.p2.toArray(), 0, array, arrayIndex, this.p2.size());
        }

        @Override
        public void copyTo(int index, T[] array, int arrayIndex, int count) {
            this.p2(index, count);
            com.aspose.slides.ms.System.n3.p2(this.p2.toArray(), index, array, arrayIndex, count);
        }

        @Override
        public boolean exists(j6<T> match) {
            ListInternalized.i5(match);
            return this.p2(0, this.p2.size(), match) != -1;
        }

        @Override
        private int p2(int n, int n10, j6<T> j62) {
            int n11 = n + n10;
            for (int i = n; i < n11; ++i) {
                if (!j62.invoke(this.p2.get(i))) continue;
                return i;
            }
            return -1;
        }

        static <T> void i5(j6<T> j62) {
            if (j62 == null) {
                throw new ArgumentNullException("match");
            }
        }

        @Override
        public T find(j6<T> match) {
            ListInternalized.i5(match);
            int n = this.p2(0, this.p2.size(), match);
            return n != -1 ? (T)this.p2.get(n) : null;
        }

        @Override
        public List<T> findAll(j6<T> match) {
            ListInternalized.i5(match);
            return this.q5(match);
        }

        private List<T> q5(j6<T> j62) {
            List<T> list = new List<T>();
            for (int i = 0; i < this.size(); ++i) {
                if (!j62.invoke(this.p2.get(i))) continue;
                list.addItem(this.p2.get(i));
            }
            return list;
        }

        @Override
        public int findIndex(j6<T> match) {
            ListInternalized.i5(match);
            return this.p2(0, this.p2.size(), match);
        }

        @Override
        public int findIndex(int startIndex, j6<T> match) {
            ListInternalized.i5(match);
            this.p2(startIndex);
            return this.p2(startIndex, this.p2.size() - startIndex, match);
        }

        @Override
        private void p2(int n) {
            if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.p2.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
        }

        @Override
        public int findIndex(int startIndex, int count, j6<T> match) {
            ListInternalized.i5(match);
            this.p2(startIndex, count);
            return this.p2(startIndex, count, match);
        }

        @Override
        public T findLast(j6<T> match) {
            ListInternalized.i5(match);
            int n = this.i5(0, this.p2.size(), match);
            if (n == -1) {
                return null;
            }
            return this.get_Item(n);
        }

        @Override
        private int i5(int n, int n10, j6<T> j62) {
            int n11 = n + n10;
            while (n11 != n) {
                if (!j62.invoke(this.p2.get(--n11))) continue;
                return n11;
            }
            return -1;
        }

        @Override
        public int findLastIndex(j6<T> match) {
            ListInternalized.i5(match);
            return this.i5(0, this.p2.size(), match);
        }

        @Override
        public int findLastIndex(int startIndex, j6<T> match) {
            ListInternalized.i5(match);
            this.p2(startIndex);
            return this.i5(0, startIndex + 1, match);
        }

        @Override
        public int findLastIndex(int startIndex, int count, j6<T> match) {
            ListInternalized.i5(match);
            int n = startIndex - count + 1;
            this.p2(n, count);
            return this.i5(n, count, match);
        }

        @Override
        public void forEach(p2<T> action) {
            if (action == null) {
                throw new ArgumentNullException("action");
            }
            for (int i = 0; i < this.p2.size(); ++i) {
                action.invoke(this.p2.get(i));
            }
        }

        @Override
        public Enumerator<T> iterator() {
            return new Enumerator(this);
        }

        @Override
        public List<T> getRange(int index, int count) {
            this.p2(index, count);
            Object[] objectArray = new Object[count];
            com.aspose.slides.ms.System.n3.p2(this.p2.toArray(), index, objectArray, 0, count);
            return new List(objectArray, count);
        }

        @Override
        public int indexOfItem(T item) {
            return this.p2.indexOf(item);
        }

        @Override
        public int indexOf(T item, int index) {
            this.p2(index);
            return com.aspose.slides.ms.System.n3.p2(this.p2.toArray(), item, index, this.p2.size() - index);
        }

        @Override
        public int indexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.p2.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
            }
            return com.aspose.slides.ms.System.n3.p2(this.p2.toArray(), item, index, count);
        }

        @Override
        public int lastIndexOf(Object item) {
            if (this.p2.size() == 0) {
                return -1;
            }
            return i6.p2(this.p2.toArray(), item, this.p2.size() - 1, this.p2.size());
        }

        @Override
        public int lastIndexOf(T item, int index) {
            this.p2(index);
            return i6.p2(this.p2.toArray(), item, index, index + 1);
        }

        @Override
        public int lastIndexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "index is negative");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "count is negative");
            }
            if (index - count + 1 < 0) {
                throw new ArgumentOutOfRangeException("cound", count, "count is too large");
            }
            return i6.p2(this.p2.toArray(), item, index, count);
        }

        @Override
        public boolean removeItem(T item) {
            int n = this.indexOfItem(item);
            if (n != -1) {
                this.removeAt(n);
            }
            return n != -1;
        }

        @Override
        public <T1> T1[] toArray(T1[] a) {
            return this.p2.toArray(a);
        }

        @Override
        public void trimExcess() {
            this.setCapacity(this.p2.size());
        }

        @Override
        public boolean trueForAll(j6<T> match) {
            ListInternalized.i5(match);
            for (int i = 0; i < this.p2.size(); ++i) {
                if (match.invoke(this.p2.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getCapacity() {
            return this.p2.size();
        }

        @Override
        public void setCapacity(int value) {
            if (((long)value & 0xFFFFFFFFL) < ((long)this.p2.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException();
            }
            for (int i = 0; i < value - this.p2.size(); ++i) {
                this.p2.add(null);
            }
        }

        @Override
        public int size() {
            return this.p2.size();
        }

        @Override
        public T get_Item(int index) {
            return this.p2.get(index);
        }

        @Override
        public void copyTo(n3 array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.n3() > 1 || array.i5(0) != 0) {
                throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
            }
            com.aspose.slides.ms.System.n3.p2(com.aspose.slides.ms.System.n3.p2(this.p2.toArray()), 0, array, arrayIndex, this.p2.size());
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.size() != 0;
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                for (int i = 0; i < this.p2.size(); ++i) {
                    if (this.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.p2.size(); ++i) {
                if (!this.get(i).equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsItem(T item) {
            if (item == null) {
                for (int i = 0; i < this.p2.size(); ++i) {
                    if (this.p2.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.p2.size(); ++i) {
                if (!this.p2.get(i).equals(item)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object[] toArray() {
            return this.p2.toArray();
        }

        @Override
        public boolean add(T t) {
            ++this.i5;
            return this.p2.add(t);
        }

        @Override
        public boolean remove(Object o) {
            ++this.i5;
            return this.p2.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.p2.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            ++this.i5;
            return this.p2.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            ++this.i5;
            return this.p2.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            ++this.i5;
            return this.p2.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            ++this.i5;
            return this.p2.retainAll(c);
        }

        @Override
        public T get(int index) {
            return this.p2.get(index);
        }

        @Override
        public T set(int index, T element) {
            ++this.i5;
            return this.p2.set(index, element);
        }

        @Override
        public void add(int index, T element) {
            ++this.i5;
            this.p2.add(index, element);
        }

        @Override
        public T remove(int index) {
            ++this.i5;
            return this.p2.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.p2.indexOf(o);
        }

        @Override
        public ListIterator listIterator() {
            return this.p2.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.p2.listIterator(index);
        }

        @Override
        public java.util.List<T> subList(int fromIndex, int toIndex) {
            return this.p2.subList(fromIndex, toIndex);
        }

        @Override
        public void addItem(T item) {
            this.p2.add(item);
            ++this.i5;
        }

        @Override
        public void clear() {
            this.p2.clear();
            ++this.i5;
        }

        @Override
        public void insertItem(int index, T item) {
            this.p2.add(index, item);
            ++this.i5;
        }

        @Override
        public void insertRange(int index, IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            if (index < 0 || ((long)index & 0xFFFFFFFFL) > ((long)this.p2.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            int n = index;
            if (collection == this) {
                Object[] objectArray = new Object[this.size()];
                this.copyTo(objectArray);
                for (Object object : objectArray) {
                    this.p2.add(n++, object);
                }
            } else {
                for (Object e : collection) {
                    this.p2.add(n++, e);
                }
            }
            ++this.i5;
        }

        @Override
        public int removeAll(j6<T> match) {
            ListInternalized.i5(match);
            int n = 0;
            int n10 = 0;
            for (n = 0; n < this.p2.size() && !match.invoke(this.p2.get(n)); ++n) {
            }
            if (n == this.p2.size()) {
                return 0;
            }
            ++this.i5;
            for (n10 = n + 1; n10 < this.p2.size(); ++n10) {
                if (match.invoke(this.p2.get(n10))) continue;
                this.p2.set(n++, this.p2.get(n10));
            }
            if (n10 - n > 0) {
                for (int i = 0; i < n10 - n; ++i) {
                    this.p2.remove(this.p2.size() - 1);
                }
            }
            return n10 - n;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.p2.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.p2.remove(index);
            ++this.i5;
        }

        @Override
        public void removeRange(int index, int count) {
            this.p2(index, count);
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    this.p2.remove(index);
                }
                ++this.i5;
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.size());
        }

        @Override
        public void reverse(int index, int count) {
            this.p2(index, count);
            int n = index;
            for (int i = index + count - 1; n < i; ++n, --i) {
                T t = this.p2.get(n);
                this.p2.set(n, this.p2.get(i));
                this.p2.set(i, t);
            }
            ++this.i5;
        }

        @Override
        public void sort() {
            Collections.sort(this.p2, null);
            ++this.i5;
        }

        @Override
        public void sort(Comparator<? super T> comparer) {
            Collections.sort(this.p2, comparer);
            ++this.i5;
        }

        @Override
        public void sort(final f4<T> tComparison) {
            if (tComparison == null) {
                throw new ArgumentNullException("comparison");
            }
            Collections.sort(this.p2, new Comparator<T>(){

                @Override
                public int compare(T o12, T o22) {
                    return tComparison.p2(o12, o22);
                }
            });
            ++this.i5;
        }

        @Override
        public void sort(int index, int count, Comparator<T> comparer) {
            this.p2(index, count);
            java.util.List<T> list = this.p2.subList(index, count);
            Collections.sort(list, comparer);
            for (int i = 0; i < count; ++i) {
                this.p2.set(index + i, list.get(i));
            }
            ++this.i5;
        }

        @Override
        public void set_Item(int index, T value) {
            this.p2(index);
            if ((long)index == (long)this.p2.size()) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.p2.set(index, value);
            ++this.i5;
        }

        @Override
        private void p2(IGenericEnumerable<T> iGenericEnumerable) {
            for (Object t : iGenericEnumerable) {
                this.addItem(t);
            }
        }
    }

    @Deprecated
    @c8
    public static class EnumeratorJava<T>
    extends l5<EnumeratorJava<T>>
    implements IGenericEnumerator<T>,
    IDisposable {
        private List<T> i5 = new List();
        private int q5;
        private int n3;
        private T s3;

        public EnumeratorJava() {
        }

        EnumeratorJava(List<T> l) {
            this();
            this.i5 = l;
            this.n3 = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void p2() {
            if (this.n3 != this.i5.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public T next() {
            if (this.q5 < 0 || this.q5 >= this.i5.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            if (this.n3 != this.i5.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.s3 = this.i5.get_Item(this.q5++);
            return this.s3;
        }

        @Override
        public boolean hasNext() {
            if (this.n3 == this.i5.getVersion()) {
                if (this.q5 < 0) {
                    return false;
                }
                return this.q5 < this.i5.size();
            }
            throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
        }

        @Override
        public void reset() {
            this.p2();
            this.q5 = 0;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(EnumeratorJava<T> that) {
            that.i5 = this.i5;
            that.q5 = this.q5;
            that.n3 = this.n3;
            that.s3 = this.s3;
        }

        @Override
        public EnumeratorJava<T> Clone() {
            EnumeratorJava<T> enumeratorJava = new EnumeratorJava<T>();
            this.CloneTo(enumeratorJava);
            return enumeratorJava;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean p2(EnumeratorJava enumeratorJava) {
            return m2.p2(enumeratorJava.i5, this.i5) && enumeratorJava.q5 == this.q5 && enumeratorJava.n3 == this.n3 && m2.p2(enumeratorJava.s3, this.s3);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (m2.i5(null, obj)) {
                return false;
            }
            if (m2.i5(this, obj)) {
                return true;
            }
            if (!(obj instanceof EnumeratorJava)) {
                return false;
            }
            return this.p2((EnumeratorJava)obj);
        }

        public static boolean equals(EnumeratorJava obj1, EnumeratorJava obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.i5 != null ? this.i5.hashCode() : 0;
            n = 31 * n + this.q5;
            n = 31 * n + this.n3;
            n = 31 * n + (this.s3 != null ? this.s3.hashCode() : 0);
            return n;
        }
    }

    @c8
    public static class Enumerator<T>
    extends l5<Enumerator<T>>
    implements IGenericEnumerator<T>,
    IDisposable {
        private List<T> i5 = new List();
        private int q5;
        private int n3;
        private T s3;

        public Enumerator() {
        }

        Enumerator(List<T> l) {
            this();
            this.i5 = l;
            this.n3 = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void p2() {
            if (this.n3 != this.i5.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public boolean hasNext() {
            if (this.n3 == this.i5.getVersion()) {
                if (this.q5 < 0) {
                    return false;
                }
                if (this.q5 < this.i5.size()) {
                    this.s3 = this.i5.get_Item(this.q5++);
                    return true;
                }
            } else {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.q5 = this.i5.size() + 1;
            return false;
        }

        @Override
        public void reset() {
            this.p2();
            this.q5 = 0;
        }

        @Override
        public T next() {
            if (this.q5 < 0 || this.q5 >= this.i5.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            return this.s3;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator<T> that) {
            that.i5 = this.i5;
            that.q5 = this.q5;
            that.n3 = this.n3;
            that.s3 = this.s3;
        }

        @Override
        public Enumerator<T> Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean p2(Enumerator enumerator) {
            return m2.p2(enumerator.i5, this.i5) && enumerator.q5 == this.q5 && enumerator.n3 == this.n3 && m2.p2(enumerator.s3, this.s3);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (m2.i5(null, obj)) {
                return false;
            }
            if (m2.i5(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.p2((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.i5 != null ? this.i5.hashCode() : 0;
            n = 31 * n + this.q5;
            n = 31 * n + this.n3;
            n = 31 * n + (this.s3 != null ? this.s3.hashCode() : 0);
            return n;
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.p2 = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.p2 != 0;
        }

        @Override
        public int nextIndex() {
            return this.p2;
        }

        @Override
        public int previousIndex() {
            return this.p2 - 1;
        }

        public T previous() {
            int n = this.p2 - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.p2;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.p2 = n;
            this.i5 = n;
            return objectArray[this.i5];
        }

        public void set(T e) {
            if (this.i5 < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.set(this.i5, e);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(T e) {
            try {
                int n = this.p2;
                List.this.add(n, e);
                this.p2 = n + 1;
                this.i5 = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr<T>
    implements Iterator<T> {
        int p2;
        int i5 = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.p2 != List.this.i5;
        }

        @Override
        public T next() {
            int n = this.p2;
            if (n >= List.this.i5) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.p2;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.p2 = n + 1;
            this.i5 = n;
            return (T)objectArray[this.i5];
        }

        @Override
        public void remove() {
            if (this.i5 < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.remove(this.i5);
                this.p2 = this.i5;
                this.i5 = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

