/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericCollection;
import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.ArrayTypeMismatchException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.internal.v6t.l5;
import com.aspose.slides.internal.v6t.q5;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.c8;
import com.aspose.slides.ms.System.i6;
import com.aspose.slides.ms.System.m2;
import com.aspose.slides.ms.System.n3;
import java.util.Arrays;

@c8
public class Stack<T>
implements IGenericEnumerable<T>,
ICollection<T> {
    private Object[] p2;
    private int i5;
    private int q5;

    public Stack() {
    }

    public Stack(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.p2 = new Object[capacity];
    }

    public Stack(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (Object t : collection) {
            this.push(t);
        }
    }

    public Stack(IGenericCollection<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        if (collection != null) {
            this.i5 = collection.size();
            this.p2 = new Object[this.i5];
            collection.copyToTArray(this.p2, 0);
        }
    }

    public void clear() {
        if (this.p2 != null) {
            n3.p2(this.p2, 0, this.p2.length);
        }
        this.i5 = 0;
        ++this.q5;
    }

    public boolean contains(T item) {
        return this.p2 != null && n3.p2(this.p2, item, 0, this.i5) != -1;
    }

    public void copyToTArray(T[] array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (arrayIndex >= array.length) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (this.i5 - arrayIndex > array.length) {
            throw new ArgumentException("idx");
        }
        if (this.p2 != null) {
            n3.p2(this.p2, 0, array, arrayIndex, this.i5);
            i6.p2(array, arrayIndex, this.i5);
        }
    }

    public T peek() {
        if (this.i5 == 0) {
            throw new InvalidOperationException();
        }
        return (T)this.p2[this.i5 - 1];
    }

    public T pop() {
        if (this.i5 == 0) {
            throw new InvalidOperationException();
        }
        ++this.q5;
        Object object = this.p2[--this.i5];
        this.p2[this.i5] = null;
        return (T)object;
    }

    public void push(T item) {
        if (this.p2 == null || this.i5 == this.p2.length) {
            if (this.p2 == null) {
                this.p2 = new Object[16];
            }
            this.p2 = Arrays.copyOf(this.p2, this.i5 == 0 ? 16 : 2 * this.i5);
        }
        ++this.q5;
        this.p2[this.i5++] = item;
    }

    public <T> T[] toArray(T[] array) {
        if (array.length >= this.i5) {
            this.copyTo(n3.p2(array), 0);
            return array;
        }
        n3 n32 = n3.p2(com.aspose.slides.internal.v6t.q5.p2(array.getClass().getComponentType()), this.i5);
        this.copyTo(n32, 0);
        return (Object[])n3.p2(n32);
    }

    public void trimExcess() {
        if (this.p2 != null && (double)this.i5 < (double)this.p2.length * 0.9) {
            this.p2 = Arrays.copyOf(this.p2, this.i5);
        }
        ++this.q5;
    }

    @Override
    public int size() {
        return this.i5;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(n3 dest, int idx) {
        try {
            if (dest == null) {
                throw new ArgumentNullException();
            }
            if (this.p2 != null) {
                if (idx < 0) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (idx >= this.i5) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (this.i5 - idx > dest.s3()) {
                    throw new ArgumentException("idx");
                }
                n3.p2(n3.p2(this.p2), 0, dest, idx, this.i5);
                n3.i5(dest, idx, this.i5);
            }
        }
        catch (ArrayTypeMismatchException arrayTypeMismatchException) {
            throw new ArgumentException();
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    @c8
    public static class Enumerator<T>
    extends l5<Enumerator>
    implements IGenericEnumerator<T>,
    IDisposable {
        private Stack<T> i5;
        private int q5;
        private int n3;

        public Enumerator() {
        }

        Enumerator(Stack<T> t) {
            this.i5 = t;
            this.q5 = -2;
            this.n3 = ((Stack)t).q5;
        }

        @Override
        public void dispose() {
            this.q5 = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.n3 != ((Stack)this.i5).q5) {
                throw new IllegalStateException();
            }
            if (this.q5 == -2) {
                this.q5 = ((Stack)this.i5).i5;
            }
            return this.q5 != -1 && --this.q5 != -1;
        }

        @Override
        public T next() {
            if (this.q5 < 0) {
                throw new InvalidOperationException();
            }
            return (T)((Stack)this.i5).p2[this.q5];
        }

        @Override
        public void reset() {
            if (this.n3 != ((Stack)this.i5).q5) {
                throw new IllegalStateException();
            }
            this.q5 = -2;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator that) {
            that.i5 = this.i5;
            that.q5 = this.q5;
            that.n3 = this.n3;
        }

        @Override
        public Enumerator Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean p2(Enumerator enumerator) {
            return m2.p2(enumerator.i5, this.i5) && enumerator.q5 == this.q5 && enumerator.n3 == this.n3;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (m2.i5(null, obj)) {
                return false;
            }
            if (m2.i5(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.p2((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.i5 != null ? this.i5.hashCode() : 0;
            n = 31 * n + this.q5;
            n = 31 * n + this.n3;
            return n;
        }
    }
}

