/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.Generic.IGenericEqualityComparer;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IHashCodeProvider;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.exceptions.SerializationException;
import com.aspose.slides.internal.c3u.i5;
import com.aspose.slides.internal.c3u.p2;
import com.aspose.slides.internal.d5z.g4;
import com.aspose.slides.internal.d5z.l5;
import com.aspose.slides.internal.d5z.r3;
import com.aspose.slides.internal.d5z.s2;
import com.aspose.slides.internal.d5z.u5;
import com.aspose.slides.internal.e2m.c2;
import com.aspose.slides.internal.v6t.q5;
import com.aspose.slides.internal.v6t.s4;
import com.aspose.slides.ms.System.c8;
import com.aspose.slides.ms.System.h4;
import com.aspose.slides.ms.System.m2;
import com.aspose.slides.ms.System.n3;
import com.aspose.slides.ms.System.r7;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@c8
public class Hashtable
implements ICollection,
IDictionary,
IEnumerable,
l5,
u5,
r7,
Map {
    private IGenericEqualityComparer p2;
    private final Object i5 = new Object();
    private Bucket[] q5;
    private int n3;
    private volatile boolean s3;
    private ICollection s4;
    private float l5;
    private int p5;
    private s2 c2;
    private int u5;
    private ICollection h2;
    private volatile int b9;
    private static final s4 y1 = new s4("LoadFactor", "HashSize", "KeyComparer", "Comparer", "HashCodeProvider", "Keys", "Values");

    public Hashtable() {
        this(0, 1.0f);
    }

    Hashtable(boolean trash) {
    }

    public Hashtable(IDictionary d) {
        this(d, 1.0f);
    }

    public Hashtable(IGenericEqualityComparer equalityComparer) {
        this(0, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity) {
        this(capacity, 1.0f);
    }

    public Hashtable(IDictionary d, IGenericEqualityComparer equalityComparer) {
        this(d, 1.0f, equalityComparer);
    }

    public Hashtable(IDictionary d, float loadFactor) {
        this(d, loadFactor, (IGenericEqualityComparer)null);
    }

    @Deprecated
    public Hashtable(IHashCodeProvider hcp, Comparator comparer) {
        this(0, 1.0f, hcp, comparer);
    }

    public Hashtable(int capacity, IGenericEqualityComparer equalityComparer) {
        this(capacity, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity, float loadFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Non-negative number required");
        }
        if (loadFactor < 0.1f || loadFactor > 1.0f || Float.isNaN(loadFactor)) {
            throw new ArgumentOutOfRangeException("loadFactor", h4.p2("Load factor needs to be between {0} and {1}", 0.1, 1.0));
        }
        this.l5 = 0.72f * loadFactor;
        double d = (float)capacity / this.l5;
        if (d > 2.147483647E9) {
            throw new ArgumentException("Hashtable's capacity overflowed and went negative. Check load factor, capacity and the current size of the table");
        }
        int n = d > 11.0 ? com.aspose.slides.internal.c3u.p2.p2((int)d) : 11;
        this.q5 = this.i5(n);
        this.p5 = (int)(this.l5 * (float)n);
        this.s3 = false;
    }

    protected Hashtable(s2 info, g4 context) {
        this.c2 = info;
    }

    @Deprecated
    public Hashtable(IDictionary d, IHashCodeProvider hcp, Comparator comparer) {
        this(d, 1.0f, hcp, comparer);
    }

    public Hashtable(IDictionary d, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(d != null ? d.size() : 0, loadFactor, equalityComparer);
        if (d == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, IHashCodeProvider hcp, Comparator comparer) {
        this(capacity, 1.0f, hcp, comparer);
    }

    public Hashtable(int capacity, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(capacity, loadFactor);
        this.p2 = equalityComparer;
    }

    @Deprecated
    public Hashtable(IDictionary d, float loadFactor, IHashCodeProvider hcp, Comparator comparer) {
        this(d != null ? d.size() : 0, loadFactor, hcp, comparer);
        if (d == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, float loadFactor, IHashCodeProvider hcp, Comparator comparer) {
        this(capacity, loadFactor);
        this.p2 = hcp == null && comparer == null ? null : new CompatibleComparer(comparer, hcp);
    }

    @Override
    public void addItem(Object key, Object value) {
        this.p2(key, value, true);
    }

    @Override
    public void clear() {
        if (this.n3 != 0) {
            this.s3 = true;
            for (int i = 0; i < this.q5.length; ++i) {
                this.q5[i].q5 = 0;
                this.q5[i].p2 = null;
                this.q5[i].i5 = null;
            }
            this.n3 = 0;
            this.u5 = 0;
            this.n3();
            this.s3 = false;
        }
    }

    @Override
    public Object deepClone() {
        Bucket[] bucketArray = this.q5;
        Hashtable hashtable = new Hashtable(this.n3, this.p2);
        hashtable.b9 = this.b9;
        hashtable.l5 = this.l5;
        hashtable.n3 = 0;
        int n = this.q5.length;
        while (n > 0) {
            Object object = bucketArray[--n].p2;
            if (object == null || object == bucketArray) continue;
            hashtable.set_Item(object, bucketArray[n].i5);
        }
        return hashtable;
    }

    @Override
    public boolean contains(Object key) {
        return this.containsKey(key);
    }

    @Override
    public boolean containsKey(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.q5;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.p2(key, this.q5.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.q5.length);
        do {
            bucketArray[n10].p2(bucket);
            if (bucket.p2 == null) {
                return false;
            }
            if ((long)(bucket.q5 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.p2, key)) {
                return true;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.q5.length);
        } while (bucket.q5 < 0 && ++n < this.q5.length);
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            int n = this.q5.length;
            while (--n >= 0) {
                if (this.q5[n].p2 == null || this.q5[n].p2 == this.q5 || this.q5[n].i5 != null) continue;
                return true;
            }
        } else {
            int n = this.q5.length;
            while (--n >= 0) {
                Object object = this.q5[n].i5;
                if (object == null || !object.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    private void q5(n3 n32, int n) {
        Bucket[] bucketArray = this.q5;
        int n10 = this.q5.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].p2;
            if (object == null || object == this.q5) continue;
            DictionaryEntry dictionaryEntry = new DictionaryEntry(object, bucketArray[n10].i5);
            n32.q5(dictionaryEntry.Clone(), n++);
        }
    }

    void p2(n3 n32, int n) {
        Bucket[] bucketArray = this.q5;
        int n10 = this.q5.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].p2;
            if (object == null || object == this.q5) continue;
            n32.q5(object, n++);
        }
    }

    @Override
    public void copyTo(n3 array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array", "Array cannot be null");
        }
        if (array.n3() != 1) {
            throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
        }
        if (array.s3() - arrayIndex < this.n3) {
            throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
        }
        this.q5(array, arrayIndex);
    }

    void i5(n3 n32, int n) {
        Bucket[] bucketArray = this.q5;
        int n10 = this.q5.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].p2;
            if (object == null || object == this.q5) continue;
            n32.q5(bucketArray[n10].i5, n++);
        }
    }

    private void i5() {
        int n = com.aspose.slides.internal.c3u.p2.p2(this.q5.length * 2);
        this.p2(n);
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new HashtableEnumerator(this, 3);
    }

    protected int getHash(Object key) {
        if (this.p2 != null) {
            return this.p2.hashCode(key);
        }
        return key.hashCode();
    }

    @Override
    public void getObjectData(s2 info, g4 context) {
        Object[] objectArray;
        if (info == null) {
            throw new ArgumentNullException("info");
        }
        info.p2("LoadFactor", this.l5);
        info.p2("Version", this.b9);
        if (this.p2 == null) {
            info.p2("Comparer", null, com.aspose.slides.internal.v6t.q5.p2(Comparator.class));
            info.p2("HashCodeProvider", null, com.aspose.slides.internal.v6t.q5.p2(IHashCodeProvider.class));
        } else if (this.p2 instanceof CompatibleComparer) {
            objectArray = (Object[])com.aspose.slides.internal.v6t.q5.p2(this.p2, CompatibleComparer.class);
            info.p2("Comparer", objectArray.p2(), com.aspose.slides.internal.v6t.q5.p2(Comparator.class));
            info.p2("HashCodeProvider", objectArray.i5(), com.aspose.slides.internal.v6t.q5.p2(IHashCodeProvider.class));
        } else {
            info.p2("KeyComparer", this.p2, com.aspose.slides.internal.v6t.q5.p2(IGenericEqualityComparer.class));
        }
        info.p2("HashSize", this.q5.length);
        objectArray = new Object[this.n3];
        Object[] objectArray2 = new Object[this.n3];
        this.p2(com.aspose.slides.ms.System.n3.p2(objectArray), 0);
        this.i5(com.aspose.slides.ms.System.n3.p2(objectArray2), 0);
        info.p2("Keys", objectArray, com.aspose.slides.internal.v6t.q5.p2(Object[].class));
        info.p2("Values", objectArray2, com.aspose.slides.internal.v6t.q5.p2(Object[].class));
    }

    private long p2(Object object, int n, long[] lArray, long[] lArray2) {
        long l;
        lArray[0] = l = (long)(this.getHash(object) & Integer.MAX_VALUE);
        lArray2[0] = 1L + (((lArray[0] & 0xFFFFFFFFL) >> 5) + 1L) % (long)(n - 1);
        return l;
    }

    private void p2(Object object, Object object2, boolean bl) {
        block12: {
            long l = 0L;
            long l10 = 0L;
            if (object == null) {
                throw new ArgumentNullException("key", "Key cannot be null");
            }
            if (this.n3 >= this.p5) {
                this.i5();
            } else if (this.u5 > this.p5 && this.n3 > 100) {
                this.q5();
            }
            long[] lArray = new long[]{0L};
            long[] lArray2 = new long[]{0L};
            long l11 = this.p2(object, this.q5.length, lArray, lArray2);
            l = lArray[0];
            l10 = lArray2[0];
            int n = 0;
            int n10 = -1;
            int n11 = (int)((l & 0xFFFFFFFFL) % (long)this.q5.length);
            do {
                if (n10 == -1 && this.q5[n11].p2 == this.q5 && this.q5[n11].q5 < 0) {
                    n10 = n11;
                }
                if (this.q5[n11].p2 == null || this.q5[n11].p2 == this.q5 && ((long)this.q5[n11].q5 & 0x80000000L) == 0L) {
                    if (n10 != -1) {
                        n11 = n10;
                    }
                    this.s3 = true;
                    this.q5[n11].i5 = object2;
                    this.q5[n11].p2 = object;
                    this.q5[n11].q5 |= (int)(l11 & 0xFFFFFFFFL);
                    ++this.n3;
                    this.n3();
                    this.s3 = false;
                    break block12;
                }
                if ((long)(this.q5[n11].q5 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(this.q5[n11].p2, object)) {
                    if (bl) {
                        throw new ArgumentException(h4.p2("Item has already been added. Key in dictionary: '{0}'  Key being added: '{1}'", this.q5[n11].p2, object));
                    }
                    this.s3 = true;
                    this.q5[n11].i5 = object2;
                    this.n3();
                    this.s3 = false;
                    break block12;
                }
                if (n10 == -1 && this.q5[n11].q5 >= 0) {
                    this.q5[n11].q5 = (int)((long)this.q5[n11].q5 | Integer.MIN_VALUE);
                    ++this.u5;
                }
                n11 = (int)(((long)n11 + (l10 & 0xFFFFFFFFL)) % (long)this.q5.length);
            } while (++n < this.q5.length);
            if (n10 == -1) {
                throw new InvalidOperationException("Hashtable insert failed. Load factor too high.");
            }
            this.s3 = true;
            this.q5[n10].i5 = object2;
            this.q5[n10].p2 = object;
            this.q5[n10].q5 |= (int)(l11 & 0xFFFFFFFFL);
            ++this.n3;
            this.n3();
            this.s3 = false;
        }
    }

    protected boolean keyEquals(Object item, Object key) {
        if (m2.i5(this.q5, item)) {
            return false;
        }
        if (this.p2 != null) {
            return this.p2.equals(item, key);
        }
        return item != null && item.equals(key);
    }

    @Override
    public void onDeserialization(Object sender) {
        if (this.q5 == null) {
            if (this.c2 == null) {
                throw new SerializationException("OnDeserialization method was called while the object was not being deserialized.");
            }
            int n = 0;
            Comparator comparator = null;
            IHashCodeProvider iHashCodeProvider = null;
            Object[] objectArray = null;
            Object[] objectArray2 = null;
            r3 r32 = this.c2.n3();
            while (r32.hasNext()) {
                switch (y1.p2(r32.i5())) {
                    case 0: {
                        this.l5 = this.c2.i5("LoadFactor");
                        break;
                    }
                    case 1: {
                        n = this.c2.p2("HashSize");
                        break;
                    }
                    case 2: {
                        this.p2 = (IGenericEqualityComparer)this.c2.p2("KeyComparer", com.aspose.slides.internal.v6t.q5.p2(IGenericEqualityComparer.class));
                        break;
                    }
                    case 3: {
                        comparator = (Comparator)this.c2.p2("Comparer", com.aspose.slides.internal.v6t.q5.p2(Comparator.class));
                        break;
                    }
                    case 4: {
                        iHashCodeProvider = (IHashCodeProvider)this.c2.p2("HashCodeProvider", com.aspose.slides.internal.v6t.q5.p2(IHashCodeProvider.class));
                        break;
                    }
                    case 5: {
                        objectArray = (Object[])this.c2.p2("Keys", com.aspose.slides.internal.v6t.q5.p2(Object[].class));
                        break;
                    }
                    case 6: {
                        objectArray2 = (Object[])this.c2.p2("Values", com.aspose.slides.internal.v6t.q5.p2(Object[].class));
                    }
                }
            }
            this.p5 = (int)(this.l5 * (float)n);
            if (this.p2 == null && (comparator != null || iHashCodeProvider != null)) {
                this.p2 = new CompatibleComparer(comparator, iHashCodeProvider);
            }
            this.q5 = this.i5(n);
            if (objectArray == null) {
                throw new SerializationException("The Keys for this dictionary are missing");
            }
            if (objectArray2 == null) {
                throw new SerializationException("The Values for this dictionary are missing");
            }
            if (objectArray.length != objectArray2.length) {
                throw new SerializationException("The keys and values arrays have different sizes");
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    throw new SerializationException("One of the serialized keys is null");
                }
                this.p2(objectArray[i], objectArray2[i], true);
            }
            this.b9 = this.c2.p2("Version");
            this.c2 = null;
        }
    }

    private void p2(Bucket[] bucketArray, Object object, Object object2, int n) {
        long l = 1L + ((((long)n & 0xFFFFFFFFL) >> 5) + 1L) % (long)(bucketArray.length - 1);
        int n10 = (int)(((long)n & 0xFFFFFFFFL) % (long)bucketArray.length);
        while (true) {
            if (bucketArray[n10].p2 == null || bucketArray[n10].p2 == this.q5) {
                bucketArray[n10].i5 = object2;
                bucketArray[n10].p2 = object;
                bucketArray[n10].q5 |= n;
                break;
            }
            if (bucketArray[n10].q5 >= 0) {
                bucketArray[n10].q5 = (int)((long)bucketArray[n10].q5 | Integer.MIN_VALUE);
                ++this.u5;
            }
            n10 = (int)(((long)n10 + (l & 0xFFFFFFFFL)) % (long)bucketArray.length);
        }
    }

    private void q5() {
        this.p2(this.q5.length);
    }

    private void p2(int n) {
        this.u5 = 0;
        Bucket[] bucketArray = this.i5(n);
        for (int i = 0; i < this.q5.length; ++i) {
            Bucket bucket = this.q5[i].p2();
            if (bucket.p2 == null || bucket.p2 == this.q5) continue;
            this.p2(bucketArray, bucket.p2, bucket.i5, bucket.q5 & Integer.MAX_VALUE);
        }
        this.s3 = true;
        this.q5 = bucketArray;
        this.p5 = (int)(this.l5 * (float)n);
        this.n3();
        this.s3 = false;
    }

    @Override
    public void removeItem(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.p2(key, this.q5.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.q5.length);
        do {
            this.q5[n10].p2(bucket);
            if ((long)(bucket.q5 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.p2, key)) {
                this.s3 = true;
                this.q5[n10].q5 = (int)((long)this.q5[n10].q5 & Integer.MIN_VALUE);
                this.q5[n10].p2 = this.q5[n10].q5 != 0 ? this.q5 : null;
                this.q5[n10].i5 = null;
                --this.n3;
                this.n3();
                this.s3 = false;
                break;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.q5.length);
        } while (bucket.q5 < 0 && ++n < this.q5.length);
    }

    public static Hashtable sync(Hashtable table) {
        if (table == null) {
            throw new ArgumentNullException("table");
        }
        return new SyncHashtable(table);
    }

    KeyValuePairs[] p2() {
        KeyValuePairs[] keyValuePairsArray = new KeyValuePairs[this.n3];
        int n = 0;
        Bucket[] bucketArray = this.q5;
        int n10 = this.q5.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].p2;
            if (object == null || object == this.q5) continue;
            keyValuePairsArray[n++] = new KeyValuePairs(object, bucketArray[n10].i5);
        }
        return keyValuePairsArray;
    }

    private void n3() {
        ++this.b9;
    }

    private Bucket[] i5(int n) {
        Bucket[] bucketArray = new Bucket[n];
        for (int i = 0; i < bucketArray.length; ++i) {
            bucketArray[i] = new Bucket();
        }
        return bucketArray;
    }

    @Override
    public int size() {
        return this.n3;
    }

    protected IGenericEqualityComparer getEqualityComparer() {
        return this.p2;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object get_Item(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.q5;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.p2(key, this.q5.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.q5.length);
        do {
            int n11;
            int n12 = 0;
            do {
                n11 = this.b9;
                bucketArray[n10].p2(bucket);
                if (++n12 % 8 != 0) continue;
                com.aspose.slides.internal.e2m.c2.i5(1);
            } while (this.s3 || n11 != this.b9);
            if (bucket.p2 == null) break;
            if ((long)(bucket.q5 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.p2, key)) {
                return bucket.i5;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.q5.length);
        } while (bucket.q5 < 0 && ++n < this.q5.length);
        return null;
    }

    @Override
    public void set_Item(Object key, Object value) {
        this.p2(key, value, false);
    }

    @Override
    public ICollection getKeys() {
        if (this.s4 == null) {
            this.s4 = new KeyCollection(this);
        }
        return this.s4;
    }

    @Override
    public Object getSyncRoot() {
        return this.i5;
    }

    @Override
    public ICollection getValues() {
        if (this.h2 == null) {
            this.h2 = new ValueCollection(this);
        }
        return this.h2;
    }

    @Override
    public boolean isEmpty() {
        return this.n3 == 0;
    }

    public Object get(Object key) {
        return this.get_Item(key);
    }

    public Object put(Object key, Object value) {
        Object object = this.get_Item(key);
        this.set_Item(key, value);
        return object;
    }

    public Object remove(Object key) {
        Object object = this.get_Item(key);
        this.removeItem(key);
        return object;
    }

    public void putAll(Map m) {
        Set set = m.keySet();
        for (Object k : set) {
            Object v = m.get(k);
            this.put(k, v);
        }
    }

    public Set keySet() {
        Object[] objectArray = new Object[this.size()];
        n3 n32 = com.aspose.slides.ms.System.n3.p2(objectArray);
        this.getKeys().copyTo(n32, 0);
        return new ReadOnlyItemCollection(n32);
    }

    public Collection values() {
        Object[] objectArray = new Object[this.size()];
        n3 n32 = com.aspose.slides.ms.System.n3.p2(objectArray);
        this.getValues().copyTo(n32, 0);
        return new ReadOnlyItemCollection(n32);
    }

    public Set entrySet() {
        KeyValuePairs[] keyValuePairsArray = this.p2();
        Map.Entry[] entryArray = new Map.Entry[keyValuePairsArray.length];
        for (int i = 0; i < entryArray.length; ++i) {
            entryArray[i] = new AbstractMap.SimpleEntry<Object, Object>(keyValuePairsArray[i].p2(), keyValuePairsArray[i].i5());
        }
        return new ReadOnlyItemCollection(com.aspose.slides.ms.System.n3.p2(entryArray));
    }

    public int getVersion() {
        return this.b9;
    }

    public static Hashtable fromJava(Map map) {
        if (map == null) {
            return null;
        }
        return new i5(map);
    }

    public static Map toJava(Hashtable h) {
        return h;
    }

    private class ReadOnlyItemCollection
    implements Set {
        private n3 i5;

        ReadOnlyItemCollection(n3 items) {
            this.i5 = items;
        }

        @Override
        public int size() {
            return this.i5.size();
        }

        @Override
        public boolean isEmpty() {
            return this.i5.size() == 0;
        }

        @Override
        public boolean contains(Object o) {
            return this.i5.contains(o);
        }

        @Override
        public Iterator iterator() {
            return this.i5.iterator();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            n3 n32 = com.aspose.slides.ms.System.n3.p2(objectArray);
            this.i5.copyTo(n32, 0);
            return objectArray;
        }

        @Override
        public boolean add(Object o) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean remove(Object o) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean containsAll(Collection c) {
            for (Object e : c) {
                if (this.contains(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public Object[] toArray(Object[] a) {
            if (a.length <= this.size()) {
                a = new Object[this.size()];
            }
            this.i5.copyTo(com.aspose.slides.ms.System.n3.p2(a), 0);
            return a;
        }
    }

    private static class HashtableDebugView {
    }

    @c8
    private static class SyncHashtable
    extends Hashtable {
        protected Hashtable p2;

        SyncHashtable(Hashtable table) {
            super(false);
            this.p2 = table;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key, Object value) {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                this.p2.addItem(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                this.p2.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                return Hashtable.sync((Hashtable)this.p2.deepClone());
            }
        }

        @Override
        public boolean contains(Object key) {
            return this.p2.contains(key);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.p2.containsKey(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object key) {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                return this.p2.containsValue(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(n3 array, int arrayIndex) {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                this.p2.copyTo(array, arrayIndex);
            }
        }

        @Override
        public IDictionaryEnumerator iterator() {
            return this.p2.iterator();
        }

        @Override
        public void getObjectData(s2 info, g4 context) {
            if (info == null) {
                throw new ArgumentNullException("info");
            }
            info.p2("ParentTable", this.p2, com.aspose.slides.internal.v6t.q5.p2(Hashtable.class));
        }

        @Override
        public void onDeserialization(Object sender) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key) {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                this.p2.removeItem(key);
            }
        }

        @Override
        KeyValuePairs[] p2() {
            return this.p2.p2();
        }

        @Override
        public int size() {
            return this.p2.size();
        }

        @Override
        public boolean isFixedSize() {
            return this.p2.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.p2.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object get_Item(Object key) {
            return this.p2.get_Item(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key, Object value) {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                this.p2.set_Item(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                return this.p2.getKeys();
            }
        }

        @Override
        public Object getSyncRoot() {
            return this.p2.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                return this.p2.getValues();
            }
        }
    }

    @c8
    private static class ValueCollection
    implements ICollection,
    IEnumerable {
        private Hashtable p2;

        ValueCollection(Hashtable hashtable) {
            this.p2 = hashtable;
        }

        @Override
        public void copyTo(n3 array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.n3() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.s3() - arrayIndex < this.p2.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.p2.i5(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.p2, 2);
        }

        @Override
        public int size() {
            return this.p2.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.p2.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.p2.getSyncRoot();
        }
    }

    @c8
    private static class KeyCollection
    implements ICollection,
    IEnumerable {
        private Hashtable p2;

        KeyCollection(Hashtable hashtable) {
            this.p2 = hashtable;
        }

        @Override
        public void copyTo(n3 array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.n3() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.s3() - arrayIndex < this.p2.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.p2.p2(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.p2, 1);
        }

        @Override
        public int size() {
            return this.p2.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.p2.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.p2.getSyncRoot();
        }
    }

    @c8
    private static class HashtableEnumerator
    implements IDictionaryEnumerator,
    IEnumerator {
        private int p2;
        private boolean i5;
        private Object q5;
        private Object n3;
        private int s3;
        private Hashtable s4;
        private int l5;

        HashtableEnumerator(Hashtable hashtable, int getObjRetType) {
            this.s4 = hashtable;
            this.p2 = hashtable.q5.length;
            this.l5 = hashtable.b9;
            this.i5 = false;
            this.s3 = getObjRetType;
        }

        @Override
        public boolean hasNext() {
            if (this.l5 != this.s4.b9) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            while (this.p2 > 0) {
                --this.p2;
                Object object = ((Hashtable)this.s4).q5[this.p2].p2;
                if (object == null || object == this.s4.q5) continue;
                this.q5 = object;
                this.n3 = ((Hashtable)this.s4).q5[this.p2].i5;
                this.i5 = true;
                return true;
            }
            this.i5 = false;
            return false;
        }

        @Override
        public void reset() {
            if (this.l5 != this.s4.b9) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            this.i5 = false;
            this.p2 = this.s4.q5.length;
            this.q5 = null;
            this.n3 = null;
        }

        @Override
        public Object next() {
            if (!this.i5) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            if (this.s3 == 1) {
                return this.q5;
            }
            if (this.s3 == 2) {
                return this.n3;
            }
            return new DictionaryEntry(this.q5, this.n3);
        }

        @Override
        public DictionaryEntry getEntry() {
            if (!this.i5) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return new DictionaryEntry(this.q5, this.n3);
        }

        @Override
        public Object getKey() {
            if (!this.i5) {
                throw new InvalidOperationException("Enumeration has not started. Call HasNext");
            }
            return this.q5;
        }

        @Override
        public Object getValue() {
            if (!this.i5) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return this.n3;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static class KeyValuePairs {
        private Object p2;
        private Object i5;

        public KeyValuePairs(Object key, Object value) {
            this.i5 = value;
            this.p2 = key;
        }

        public Object p2() {
            return this.p2;
        }

        public Object i5() {
            return this.i5;
        }
    }

    private static class Bucket
    extends com.aspose.slides.internal.v6t.l5<Bucket> {
        public Object p2;
        public Object i5;
        public int q5;

        public void p2(Bucket bucket) {
            bucket.p2 = this.p2;
            bucket.i5 = this.i5;
            bucket.q5 = this.q5;
        }

        public Bucket p2() {
            Bucket bucket = new Bucket();
            this.p2(bucket);
            return bucket;
        }

        public Object clone() {
            return this.p2();
        }

        private boolean i5(Bucket bucket) {
            return m2.p2(bucket.p2, this.p2) && m2.p2(bucket.i5, this.i5) && bucket.q5 == this.q5;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (m2.i5(null, obj)) {
                return false;
            }
            if (m2.i5(this, obj)) {
                return true;
            }
            if (!(obj instanceof Bucket)) {
                return false;
            }
            return this.i5((Bucket)obj);
        }

        public int hashCode() {
            int n = this.p2 != null ? this.p2.hashCode() : 0;
            n = 31 * n + (this.i5 != null ? this.i5.hashCode() : 0);
            n = 31 * n + this.q5;
            return n;
        }

        @Override
        public /* synthetic */ Object Clone() {
            return this.p2();
        }

        @Override
        public /* synthetic */ void CloneTo(Object object) {
            this.p2((Bucket)object);
        }
    }

    @c8
    private static class CompatibleComparer
    implements IGenericEqualityComparer {
        private Comparator p2;
        private IHashCodeProvider i5;

        CompatibleComparer(Comparator comparer, IHashCodeProvider hashCodeProvider) {
            this.p2 = comparer;
            this.i5 = hashCodeProvider;
        }

        public int p2(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (this.p2 != null) {
                return this.p2.compare(object, object2);
            }
            Comparable comparable = (Comparable)((Object)com.aspose.slides.internal.v6t.q5.p2(object, Comparable.class));
            if (comparable == null) {
                throw new ArgumentException("At least one object must implement java.lang.Comparable");
            }
            return comparable.compareTo(object2);
        }

        @Override
        public boolean equals(Object x, Object y) {
            return this.equalsT(x, y);
        }

        @Override
        public int hashCode(Object obj) {
            return this.hashCodeT(obj);
        }

        public boolean equalsT(Object a, Object b) {
            return this.p2(a, b) == 0;
        }

        public int hashCodeT(Object obj) {
            if (obj == null) {
                throw new ArgumentNullException("obj");
            }
            if (this.i5 != null) {
                return this.i5.hashCode(obj);
            }
            return obj.hashCode();
        }

        Comparator p2() {
            return this.p2;
        }

        IHashCodeProvider i5() {
            return this.i5;
        }
    }
}

