/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.c8;
import com.aspose.slides.ms.System.n3;
import com.aspose.slides.ms.System.r7;
import java.util.Arrays;

@c8
public class Queue
implements ICollection,
IEnumerable,
r7 {
    private Object[] p2;
    private int i5 = 0;
    private int q5 = 0;
    private int n3 = 0;
    private int s3;
    private int s4 = 0;

    public Queue() {
        this(32, 2.0f);
    }

    public Queue(int capacity) {
        this(capacity, 2.0f);
    }

    public Queue(ICollection col) {
        this(col == null ? 32 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e : col) {
            this.enqueue(e);
        }
    }

    public Queue(int capacity, float growFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Needs a non-negative number");
        }
        if (!(growFactor >= 1.0f) || !(growFactor <= 10.0f)) {
            throw new ArgumentOutOfRangeException("growFactor", "Queue growth factor must be between 1.0 and 10.0, inclusive");
        }
        this.p2 = new Object[capacity];
        this.s3 = (int)(growFactor * 100.0f);
    }

    @Override
    public int size() {
        return this.q5;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(n3 array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.n3() > 1 || index != 0 && index >= array.s3() || this.q5 > array.s3() - index) {
            throw new ArgumentException();
        }
        int n = this.p2.length;
        int n10 = n - this.i5;
        com.aspose.slides.ms.System.n3.p2(com.aspose.slides.ms.System.n3.p2(this.p2), this.i5, array, index, Math.min(this.q5, n10));
        if (this.q5 > n10) {
            com.aspose.slides.ms.System.n3.p2(com.aspose.slides.ms.System.n3.p2(this.p2), 0, array, index + n10, this.q5 - n10);
        }
    }

    public IEnumerator iterator() {
        return new QueueEnumerator(this);
    }

    @Override
    public Object deepClone() {
        Queue queue = new Queue(this.p2.length);
        queue.s3 = this.s3;
        com.aspose.slides.ms.System.n3.p2(this.p2, 0, queue.p2, 0, this.p2.length);
        queue.i5 = this.i5;
        queue.q5 = this.q5;
        queue.n3 = this.n3;
        return queue;
    }

    public void clear() {
        ++this.s4;
        this.i5 = 0;
        this.q5 = 0;
        this.n3 = 0;
        for (int i = this.p2.length - 1; i >= 0; --i) {
            this.p2[i] = null;
        }
    }

    public boolean contains(Object obj) {
        int n = this.i5 + this.q5;
        if (obj == null) {
            for (int i = this.i5; i < n; ++i) {
                if (this.p2[i % this.p2.length] != null) continue;
                return true;
            }
        } else {
            for (int i = this.i5; i < n; ++i) {
                if (!obj.equals(this.p2[i % this.p2.length])) continue;
                return true;
            }
        }
        return false;
    }

    public Object dequeue() {
        ++this.s4;
        if (this.q5 < 1) {
            throw new InvalidOperationException();
        }
        Object object = this.p2[this.i5];
        this.p2[this.i5] = null;
        this.i5 = (this.i5 + 1) % this.p2.length;
        --this.q5;
        return object;
    }

    public void enqueue(Object obj) {
        ++this.s4;
        if (this.q5 == this.p2.length) {
            this.p2();
        }
        this.p2[this.n3] = obj;
        this.n3 = (this.n3 + 1) % this.p2.length;
        ++this.q5;
    }

    public Object peek() {
        if (this.q5 < 1) {
            throw new InvalidOperationException();
        }
        return this.p2[this.i5];
    }

    public static Queue sync(Queue queue) {
        if (queue == null) {
            throw new ArgumentNullException("queue");
        }
        return new SyncQueue(queue);
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.q5) {
            return Arrays.copyOf(this.p2, this.q5, a.getClass());
        }
        System.arraycopy(this.p2, 0, a, 0, this.q5);
        if (a.length > this.q5) {
            a[this.q5] = null;
        }
        return a;
    }

    public void trimToSize() {
        ++this.s4;
        Object[] objectArray = new Object[this.q5];
        this.copyTo(com.aspose.slides.ms.System.n3.p2(objectArray), 0);
        this.p2 = objectArray;
        this.i5 = 0;
        this.n3 = 0;
    }

    private void p2() {
        int n = this.p2.length * this.s3 / 100;
        if (n < this.p2.length + 1) {
            n = this.p2.length + 1;
        }
        Object[] objectArray = new Object[n];
        this.copyTo(com.aspose.slides.ms.System.n3.p2(objectArray), 0);
        this.p2 = objectArray;
        this.i5 = 0;
        this.n3 = this.i5 + this.q5;
    }

    @c8
    private static class QueueEnumerator
    implements IEnumerator,
    r7 {
        private Queue p2;
        private int i5;
        private int q5;

        QueueEnumerator(Queue q) {
            this.p2 = q;
            this.i5 = q.s4;
            this.q5 = -1;
        }

        @Override
        public Object deepClone() {
            QueueEnumerator queueEnumerator = new QueueEnumerator(this.p2);
            queueEnumerator.i5 = this.i5;
            queueEnumerator.q5 = this.q5;
            return queueEnumerator;
        }

        @Override
        public Object next() {
            if (this.i5 != this.p2.s4 || this.q5 < 0 || this.q5 >= this.p2.q5) {
                throw new InvalidOperationException();
            }
            return this.p2.p2[(this.p2.i5 + this.q5) % this.p2.p2.length];
        }

        @Override
        public boolean hasNext() {
            if (this.i5 != this.p2.s4) {
                throw new InvalidOperationException();
            }
            if (this.q5 >= this.p2.q5 - 1) {
                this.q5 = Integer.MAX_VALUE;
                return false;
            }
            ++this.q5;
            return true;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.i5 != this.p2.s4) {
                throw new InvalidOperationException();
            }
            this.q5 = -1;
        }
    }

    private static class SyncQueue
    extends Queue {
        private final Queue p2;

        SyncQueue(Queue queue) {
            this.p2 = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Queue queue = this.p2;
            synchronized (queue) {
                return this.p2.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.p2.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(n3 array, int index) {
            Queue queue = this.p2;
            synchronized (queue) {
                this.p2.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Queue queue = this.p2;
            synchronized (queue) {
                return this.p2.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Queue queue = this.p2;
            synchronized (queue) {
                return new SyncQueue((Queue)this.p2.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Queue queue = this.p2;
            synchronized (queue) {
                this.p2.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Queue queue = this.p2;
            synchronized (queue) {
                this.p2.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Queue queue = this.p2;
            synchronized (queue) {
                return this.p2.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object dequeue() {
            Queue queue = this.p2;
            synchronized (queue) {
                return this.p2.dequeue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enqueue(Object obj) {
            Queue queue = this.p2;
            synchronized (queue) {
                this.p2.enqueue(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Queue queue = this.p2;
            synchronized (queue) {
                return this.p2.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Queue queue = this.p2;
            synchronized (queue) {
                return this.p2.toArray(a);
            }
        }
    }
}

