/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.Comparer;
import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IList;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.internal.v6t.l5;
import com.aspose.slides.ms.System.c8;
import com.aspose.slides.ms.System.h4;
import com.aspose.slides.ms.System.k9;
import com.aspose.slides.ms.System.m2;
import com.aspose.slides.ms.System.n3;
import com.aspose.slides.ms.System.r7;
import java.util.Comparator;

@c8
public class SortedList
implements IDictionary,
r7 {
    private final Object p2 = new Object();
    private Slot[] i5;
    private Comparator q5;
    private int n3;
    private int s3;
    private int s4;

    public SortedList() {
        this(null, 16);
    }

    public SortedList(int initialCapacity) {
        this(null, initialCapacity);
    }

    public SortedList(Comparator comparer, int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.s4 = capacity == 0 ? 0 : 16;
        this.q5 = comparer;
        this.i5(capacity, true);
    }

    public SortedList(Comparator comparer) {
        this.q5 = comparer;
        this.i5(16, true);
    }

    public SortedList(IDictionary d) {
        this(d, null);
    }

    public SortedList(IDictionary d, Comparator comparer) {
        if (d == null) {
            throw new ArgumentNullException("dictionary");
        }
        this.i5(d.size(), true);
        this.q5 = comparer;
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Override
    public int size() {
        return this.n3;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this.p2;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ICollection getKeys() {
        return new ListKeys(this);
    }

    @Override
    public ICollection getValues() {
        return new ListValues(this);
    }

    @Override
    public Object get_Item(Object key) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        return this.p2(key);
    }

    @Override
    public void set_Item(Object key, Object value) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        if (this.isReadOnly()) {
            throw new NotSupportedException("SortedList is Read Only.");
        }
        if (this.i5(key) < 0 && this.isFixedSize()) {
            throw new NotSupportedException("Key not found and SortedList is fixed size.");
        }
        this.p2(key, value, true);
    }

    public int getCapacity() {
        return this.i5.length;
    }

    public void setCapacity(int value) {
        int n = this.i5.length;
        if (this.n3 > value) {
            throw new ArgumentOutOfRangeException("capacity too small");
        }
        if (value == 0) {
            Slot[] slotArray = SortedList.p2(this.s4);
            SortedList.p2(this.i5, 0, slotArray, 0, this.n3);
            this.i5 = slotArray;
        } else if (value > this.n3) {
            Slot[] slotArray = SortedList.p2(value);
            SortedList.p2(this.i5, 0, slotArray, 0, this.n3);
            this.i5 = slotArray;
        } else if (value > n) {
            Slot[] slotArray = SortedList.p2(value);
            SortedList.p2(this.i5, 0, slotArray, 0, n);
            this.i5 = slotArray;
        }
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new Enumerator(this, 2);
    }

    @Deprecated
    public IDictionaryEnumerator iteratorJava() {
        return new EnumeratorJava(this, 2);
    }

    @Override
    public void addItem(Object key, Object value) {
        this.p2(key, value, false);
    }

    @Override
    public void clear() {
        this.s4 = 16;
        this.i5 = SortedList.p2(this.s4);
        this.n3 = 0;
        ++this.s3;
    }

    @Override
    public boolean contains(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.i5(key) >= 0;
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void removeItem(Object key) {
        int n = this.indexOfKey(key);
        if (n >= 0) {
            this.removeAt(n);
        }
    }

    @Override
    public void copyTo(n3 array, int arrayIndex) {
        if (null == array) {
            throw new ArgumentNullException();
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (array.n3() > 1) {
            throw new ArgumentException("array is multi-dimensional");
        }
        if (arrayIndex >= array.s3()) {
            throw new ArgumentNullException("arrayIndex is greater than or equal to array.Length");
        }
        if (this.size() > array.s3() - arrayIndex) {
            throw new ArgumentNullException("Not enough space in array from arrayIndex to end of array");
        }
        IDictionaryEnumerator iDictionaryEnumerator = this.iterator();
        int n = arrayIndex;
        while (iDictionaryEnumerator.hasNext()) {
            array.q5(iDictionaryEnumerator.getEntry().Clone(), n++);
        }
    }

    @Override
    public Object deepClone() {
        SortedList sortedList = new SortedList(this, this.q5);
        sortedList.s3 = this.s3;
        return sortedList;
    }

    public IList getKeyList() {
        return new ListKeys(this);
    }

    public IList getValueList() {
        return new ListValues(this);
    }

    public void removeAt(int index) {
        Slot[] slotArray = this.i5;
        int n = this.size();
        if (index >= 0 && index < n) {
            if (index != n - 1) {
                SortedList.p2(slotArray, index + 1, slotArray, index, n - 1 - index);
            } else {
                slotArray[index].p2 = null;
                slotArray[index].i5 = null;
            }
            --this.n3;
            ++this.s3;
        } else {
            throw new ArgumentOutOfRangeException("index out of range");
        }
    }

    public int indexOfKey(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        int n = 0;
        try {
            n = this.i5(key);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        return n | n >> 31;
    }

    public int indexOfValue(Object value) {
        if (this.n3 == 0) {
            return -1;
        }
        for (int i = 0; i < this.n3; ++i) {
            Slot slot = this.i5[i].Clone();
            if (!m2.p2(value, slot.i5)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsKey(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.contains(key);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    public boolean containsValue(Object value) {
        return this.indexOfValue(value) >= 0;
    }

    public Object getByIndex(int index) {
        if (index >= 0 && index < this.size()) {
            return this.i5[index].i5;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public void setByIndex(int index, Object value) {
        if (index < 0 || index >= this.size()) {
            throw new ArgumentOutOfRangeException("index out of range");
        }
        this.i5[index].i5 = value;
    }

    public Object getKey(int index) {
        if (index >= 0 && index < this.size()) {
            return this.i5[index].p2;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public static SortedList sync(SortedList list) {
        if (list == null) {
            throw new ArgumentNullException("Base list is null.");
        }
        return new SynchedSortedList(list);
    }

    public void trimToSize() {
        if (this.size() == 0) {
            this.p2(this.s4, false);
        } else {
            this.p2(this.size(), true);
        }
    }

    private void p2(int n, boolean bl) {
        Slot[] slotArray = this.i5;
        Slot[] slotArray2 = SortedList.p2(n);
        if (bl) {
            SortedList.p2(slotArray, 0, slotArray2, 0, n);
        }
        this.i5 = slotArray2;
    }

    private void p2(int n, int n10) {
        boolean bl;
        Slot[] slotArray = this.i5;
        Slot[] slotArray2 = null;
        int n11 = this.getCapacity();
        boolean bl2 = bl = n10 >= 0 && n10 < this.size();
        if (n > n11) {
            slotArray2 = SortedList.p2(n << 1);
        }
        if (slotArray2 != null) {
            if (bl) {
                int n12 = n10;
                if (n12 > 0) {
                    SortedList.p2(slotArray, 0, slotArray2, 0, n12);
                }
                if ((n12 = this.size() - n10) > 0) {
                    SortedList.p2(slotArray, n10, slotArray2, n10 + 1, n12);
                }
            } else {
                SortedList.p2(slotArray, 0, slotArray2, 0, this.size());
            }
            this.i5 = slotArray2;
        } else if (bl) {
            SortedList.p2(slotArray, n10, slotArray, n10 + 1, this.size() - n10);
        }
    }

    private void p2(Object object, Object object2, boolean bl) {
        if (object == null) {
            throw new ArgumentNullException("null key");
        }
        Slot[] slotArray = this.i5;
        int n = -1;
        try {
            n = this.i5(object);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        if (n >= 0) {
            if (!bl) {
                String string = h4.p2("Key '{0}' already exists in list.", new Object[]{object});
                throw new ArgumentException(string);
            }
            slotArray[n].i5 = object2;
            ++this.s3;
            return;
        }
        if ((n ^= 0xFFFFFFFF) > this.getCapacity() + 1) {
            throw new RuntimeException(h4.p2(new Object[]{"SortedList::internal error (", object, ", ", object2, ") at [", n, "]"}));
        }
        this.p2(this.size() + 1, n);
        slotArray = this.i5;
        slotArray[n].p2 = object;
        slotArray[n].i5 = object2;
        ++this.n3;
        ++this.s3;
    }

    private Object p2(Object object) {
        int n = this.i5(object);
        if (n >= 0) {
            return this.i5[n].i5;
        }
        return null;
    }

    private void i5(int n, boolean bl) {
        if (!bl && n < this.s4) {
            n = this.s4;
        }
        this.i5 = SortedList.p2(n);
        this.n3 = 0;
        this.s3 = 0;
    }

    private void p2(n3 n32, int n, int n10) {
        if (n32 == null) {
            throw new ArgumentNullException("arr");
        }
        if (n < 0 || n + this.size() > n32.s3()) {
            throw new ArgumentOutOfRangeException("i");
        }
        Enumerator enumerator = new Enumerator(this, n10);
        while (enumerator.hasNext()) {
            n32.q5(enumerator.next(), n++);
        }
    }

    private int i5(Object object) {
        Slot[] slotArray = this.i5;
        int n = this.size();
        if (n == 0) {
            return -1;
        }
        Comparator comparator = this.q5 == null ? Comparer.Default : this.q5;
        int n10 = 0;
        int n11 = n - 1;
        while (n10 <= n11) {
            int n12 = n10 + n11 >> 1;
            int n13 = comparator.compare(slotArray[n12].p2, object);
            if (n13 == 0) {
                return n12;
            }
            if (n13 < 0) {
                n10 = n12 + 1;
                continue;
            }
            n11 = n12 - 1;
        }
        return ~n10;
    }

    static Slot[] p2(int n) {
        Slot[] slotArray = new Slot[n];
        for (int i = 0; i < n; ++i) {
            slotArray[i] = new Slot();
        }
        return slotArray;
    }

    private static boolean p2(int n, int n10, int n11) {
        return n < n10 && n + n11 > n10 || n10 < n && n10 + n11 > n;
    }

    static void p2(Slot[] slotArray, int n, Slot[] slotArray2, int n10, int n11) {
        Slot[] slotArray3;
        if (slotArray == slotArray2 && SortedList.p2(n, n10, n11)) {
            slotArray3 = new Slot[n11];
            System.arraycopy(slotArray, n, slotArray3, 0, n11);
            n = 0;
        } else {
            slotArray3 = slotArray;
        }
        for (int i = 0; i < n11; ++i) {
            slotArray2[n10 + i] = slotArray3[n + i].Clone();
        }
    }

    private static class SynchedSortedList
    extends SortedList {
        private SortedList p2;

        public SynchedSortedList(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.p2 = host;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                return this.p2.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                this.p2.setCapacity(value);
            }
        }

        @Override
        public int size() {
            return this.p2.size();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.p2.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.p2.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.p2.isReadOnly();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            ICollection iCollection = null;
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                iCollection = this.p2.getKeys();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            ICollection iCollection = null;
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                iCollection = this.p2.getValues();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(Object key) {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                return this.p2.p2(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key, Object value) {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                this.p2.p2(key, value, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(n3 array, int arrayIndex) {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                this.p2.copyTo(array, arrayIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key, Object value) {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                this.p2.p2(key, value, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                this.p2.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object key) {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                return this.p2.i5(key) >= 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IDictionaryEnumerator iterator() {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                return this.p2.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public IDictionaryEnumerator iteratorJava() {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                return this.p2.iteratorJava();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key) {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                this.p2.removeItem(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                return this.p2.contains(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object value) {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                return this.p2.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                return this.p2.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getByIndex(int index) {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                return this.p2.getByIndex(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getKey(int index) {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                return this.p2.getKey(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getKeyList() {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                return new ListKeys(this.p2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getValueList() {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                return new ListValues(this.p2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                this.p2.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfKey(Object key) {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                return this.p2.indexOfKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfValue(Object val) {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                return this.p2.indexOfValue(val);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setByIndex(int index, Object value) {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                this.p2.setByIndex(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.p2.getSyncRoot();
            synchronized (object) {
                this.p2.trimToSize();
            }
        }
    }

    @c8
    private static class ListValues
    implements IList {
        private SortedList p2;

        public ListValues(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.p2 = host;
        }

        @Override
        public int size() {
            return this.p2.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.p2.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.p2.getSyncRoot();
        }

        @Override
        public void copyTo(n3 array, int arrayIndex) {
            this.p2.p2(array, arrayIndex, 1);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.p2.getByIndex(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("This operation is not supported on GetValueList return");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object value) {
            return this.p2.containsValue(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.p2.indexOfValue(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.p2, 1);
        }
    }

    @c8
    private static class ListKeys
    implements IList {
        private SortedList p2;

        public ListKeys(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.p2 = host;
        }

        @Override
        public int size() {
            return this.p2.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.p2.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.p2.getSyncRoot();
        }

        @Override
        public void copyTo(n3 array, int arrayIndex) {
            this.p2.p2(array, arrayIndex, 0);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.p2.getKey(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("attempt to modify a key");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object key) {
            return this.p2.contains(key);
        }

        @Override
        public int indexOf(Object key) {
            return this.p2.indexOfKey(key);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.p2, 0);
        }
    }

    @Deprecated
    private static final class EnumeratorJava
    implements IDictionaryEnumerator,
    r7 {
        private SortedList p2;
        private Object i5;
        private Object q5;
        private int n3;
        private int s3;
        private int s4;
        private int l5;
        private boolean p5 = false;
        private static String c2 = "SortedList.EnumeratorJava: snapshot out of sync.";

        public EnumeratorJava(SortedList host, int mode) {
            this.p2 = host;
            this.n3 = host.s3;
            this.s4 = host.size();
            this.l5 = mode;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.p2.s3 != this.n3 || this.p5) {
                throw new IllegalStateException(c2);
            }
            this.s3 = -1;
            this.i5 = null;
            this.q5 = null;
        }

        @Override
        public boolean hasNext() {
            if (this.p2.s3 != this.n3 || this.p5) {
                throw new InvalidOperationException(c2);
            }
            return ++this.s3 < this.s4;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.p5 || this.s3 >= this.s4 || this.s3 == -1) {
                throw new IllegalStateException(c2);
            }
            return new DictionaryEntry(this.i5, this.q5);
        }

        @Override
        public Object getKey() {
            if (this.p5 || this.s3 >= this.s4 || this.s3 == -1) {
                throw new IllegalStateException(c2);
            }
            return this.i5;
        }

        @Override
        public Object getValue() {
            if (this.p5 || this.s3 >= this.s4 || this.s3 == -1) {
                throw new IllegalStateException(c2);
            }
            return this.q5;
        }

        @Override
        public Object next() {
            if (this.p2.s3 != this.n3 || this.p5) {
                throw new InvalidOperationException(c2);
            }
            if (this.p5 || this.s3 >= this.s4 || this.s3 == -1) {
                if (this.s3 >= this.s4) {
                    this.i5 = null;
                    this.q5 = null;
                }
                throw new IllegalStateException(c2);
            }
            Slot[] slotArray = this.p2.i5;
            Slot slot = slotArray[this.s3].Clone();
            this.i5 = slot.p2;
            this.q5 = slot.i5;
            switch (this.l5) {
                case 0: {
                    return this.i5;
                }
                case 1: {
                    return this.q5;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(h4.p2(new String[]{k9.getName(EnumeratorMode.class, this.l5), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            EnumeratorJava enumeratorJava = new EnumeratorJava(this.p2, this.l5);
            enumeratorJava.n3 = this.n3;
            enumeratorJava.s3 = this.s3;
            enumeratorJava.s4 = this.s4;
            enumeratorJava.i5 = this.i5;
            enumeratorJava.q5 = this.q5;
            enumeratorJava.p5 = this.p5;
            return enumeratorJava;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class Enumerator
    implements IDictionaryEnumerator,
    r7 {
        private SortedList p2;
        private Object i5;
        private Object q5;
        private int n3;
        private int s3;
        private int s4;
        private int l5;
        private boolean p5 = false;
        private static String c2 = "SortedList.Enumerator: snapshot out of sync.";

        public Enumerator(SortedList host, int mode) {
            this.p2 = host;
            this.n3 = host.s3;
            this.s4 = host.size();
            this.l5 = mode;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.p2.s3 != this.n3 || this.p5) {
                throw new IllegalStateException(c2);
            }
            this.s3 = -1;
            this.i5 = null;
            this.q5 = null;
        }

        @Override
        public boolean hasNext() {
            if (this.p2.s3 != this.n3 || this.p5) {
                throw new InvalidOperationException(c2);
            }
            Slot[] slotArray = this.p2.i5;
            if (++this.s3 < this.s4) {
                Slot slot = slotArray[this.s3].Clone();
                this.i5 = slot.p2;
                this.q5 = slot.i5;
                return true;
            }
            this.i5 = null;
            this.q5 = null;
            return false;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.p5 || this.s3 >= this.s4 || this.s3 == -1) {
                throw new IllegalStateException(c2);
            }
            return new DictionaryEntry(this.i5, this.q5);
        }

        @Override
        public Object getKey() {
            if (this.p5 || this.s3 >= this.s4 || this.s3 == -1) {
                throw new IllegalStateException(c2);
            }
            return this.i5;
        }

        @Override
        public Object getValue() {
            if (this.p5 || this.s3 >= this.s4 || this.s3 == -1) {
                throw new IllegalStateException(c2);
            }
            return this.q5;
        }

        @Override
        public Object next() {
            if (this.p5 || this.s3 >= this.s4 || this.s3 == -1) {
                throw new IllegalStateException(c2);
            }
            switch (this.l5) {
                case 0: {
                    return this.i5;
                }
                case 1: {
                    return this.q5;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(h4.p2(new String[]{k9.getName(EnumeratorMode.class, this.l5), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            Enumerator enumerator = new Enumerator(this.p2, this.l5);
            enumerator.n3 = this.n3;
            enumerator.s3 = this.s3;
            enumerator.s4 = this.s4;
            enumerator.i5 = this.i5;
            enumerator.q5 = this.q5;
            enumerator.p5 = this.p5;
            return enumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class EnumeratorMode
    extends k9 {
        private EnumeratorMode() {
        }

        static {
            k9.register(new k9.s3(EnumeratorMode.class, Integer.class){
                {
                    this.addConstant("KEY_MODE", 0L);
                    this.addConstant("VALUE_MODE", 1L);
                    this.addConstant("ENTRY_MODE", 2L);
                }
            });
        }
    }

    @c8
    public static class Slot
    extends l5<Slot> {
        Object p2;
        Object i5;

        @Override
        public void CloneTo(Slot that) {
            that.p2 = this.p2;
            that.i5 = this.i5;
        }

        @Override
        public Slot Clone() {
            Slot slot = new Slot();
            this.CloneTo(slot);
            return slot;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean p2(Slot slot) {
            return m2.p2(slot.p2, this.p2) && m2.p2(slot.i5, this.i5);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (m2.i5(null, obj)) {
                return false;
            }
            if (m2.i5(this, obj)) {
                return true;
            }
            if (!(obj instanceof Slot)) {
                return false;
            }
            return this.p2((Slot)obj);
        }

        public static boolean equals(Slot obj1, Slot obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.p2 != null ? this.p2.hashCode() : 0;
            n = 31 * n + (this.i5 != null ? this.i5.hashCode() : 0);
            return n;
        }
    }
}

