/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Specialized;

import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.internal.m5i.h7;
import com.aspose.slides.internal.v6t.l5;
import com.aspose.slides.internal.v6t.q5;
import com.aspose.slides.ms.System.l4;
import com.aspose.slides.ms.System.n2;

public class BitVector32
extends l5<BitVector32> {
    private int p2;

    public BitVector32() {
    }

    public BitVector32(BitVector32 value) {
        this.p2 = value.p2;
    }

    public BitVector32(int data) {
        this.p2 = data;
    }

    public int getData() {
        return this.p2;
    }

    public int get_Item(Section section) {
        return this.p2 >> section.getOffset() & section.getMask();
    }

    public void set_Item(Section section, int value) {
        if (value < 0) {
            throw new ArgumentException("Section can't hold negative values");
        }
        if (value > section.getMask()) {
            throw new ArgumentException("Value too large to fit in section");
        }
        this.p2 &= ~(section.getMask() << section.getOffset());
        this.p2 |= value << section.getOffset();
    }

    public boolean get_Item(int bit) {
        return (this.p2 & bit) == bit;
    }

    public void set_Item(int bit, boolean value) {
        this.p2 = value ? (this.p2 |= bit) : (this.p2 &= ~bit);
    }

    public static int createMask() {
        return 1;
    }

    public static int createMask(int previous) {
        if (previous == 0) {
            return 1;
        }
        if (previous == Integer.MIN_VALUE) {
            throw new InvalidOperationException("all bits set");
        }
        return previous << 1;
    }

    public static Section createSection(short maxValue) {
        return BitVector32.createSection(maxValue, new Section(0, 0));
    }

    public static Section createSection(short maxValue, Section previous) {
        if (maxValue < 1) {
            throw new ArgumentException("maxValue");
        }
        int n = BitVector32.p2(maxValue);
        int n10 = (1 << n) - 1;
        int n11 = previous.getOffset() + BitVector32.p2(previous.getMask());
        if (n11 + n > 32) {
            throw new ArgumentException("Sections cannot exceed 32 bits in total");
        }
        return new Section(q5.i5((Object)n10, 9), q5.i5((Object)n11, 9));
    }

    public boolean equals(Object o) {
        return q5.i5(o, BitVector32.class) && this.p2 == q5.n3((Object)o, BitVector32.class).p2;
    }

    public int hashCode() {
        return l4.p2(this.p2);
    }

    public String toString() {
        return BitVector32.toString(this.Clone());
    }

    public static String toString(BitVector32 value) {
        h7 h72 = new h7();
        h72.p2("BitVector32{");
        for (long i = q5.s4((Object)0x80000000L, 10); i > 0L; i >>= 1) {
            h72.p2(((long)value.p2 & i) == 0L ? (char)'0' : '1');
        }
        h72.p2('}');
        return h72.toString();
    }

    private static int p2(int n) {
        int n10 = 0;
        while (n >> n10 != 0) {
            ++n10;
        }
        return n10;
    }

    @Override
    public void CloneTo(BitVector32 that) {
        that.p2 = this.p2;
    }

    @Override
    public BitVector32 Clone() {
        BitVector32 bitVector32 = new BitVector32();
        this.CloneTo(bitVector32);
        return bitVector32;
    }

    public Object clone() {
        return this.Clone();
    }

    public static boolean equals(BitVector32 obj1, BitVector32 obj2) {
        return obj1.equals(obj2);
    }

    public static class Section
    extends l5<Section> {
        private short p2;
        private short i5;

        public Section() {
        }

        Section(short mask, short offset) {
            this.p2 = mask;
            this.i5 = offset;
        }

        public short getMask() {
            return this.p2;
        }

        public short getOffset() {
            return this.i5;
        }

        public static boolean op_Equality(Section a, Section b) {
            return a.p2 == b.p2 && a.i5 == b.i5;
        }

        public static boolean op_Inequality(Section a, Section b) {
            return a.p2 != b.p2 || a.i5 != b.i5;
        }

        public boolean equals(Section obj) {
            return this.p2 == obj.p2 && this.i5 == obj.i5;
        }

        public boolean equals(Object o) {
            if (!q5.i5(o, Section.class)) {
                return false;
            }
            Section section = q5.n3(o, Section.class).Clone();
            return this.p2 == section.p2 && this.i5 == section.i5;
        }

        public int hashCode() {
            return this.p2 << this.i5;
        }

        public String toString() {
            return Section.toString(this.Clone());
        }

        public static String toString(Section value) {
            h7 h72 = new h7();
            h72.p2("Section{0x");
            h72.p2(n2.p2(value.getMask(), 16));
            h72.p2(", 0x");
            h72.p2(n2.p2(value.getOffset(), 16));
            h72.p2("}");
            return h72.toString();
        }

        @Override
        public void CloneTo(Section that) {
            that.p2 = this.p2;
            that.i5 = this.i5;
        }

        @Override
        public Section Clone() {
            Section section = new Section();
            this.CloneTo(section);
            return section;
        }

        public Object clone() {
            return this.Clone();
        }

        public static boolean equals(Section obj1, Section obj2) {
            return obj1.equals(obj2);
        }
    }
}

