/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.c8;
import com.aspose.slides.ms.System.i6;
import com.aspose.slides.ms.System.n3;
import com.aspose.slides.ms.System.r7;
import java.util.Arrays;

@c8
public class Stack
implements ICollection,
IEnumerable,
r7 {
    private Object[] p2;
    private int i5 = -1;
    private int q5;
    private int n3;
    private int s3;

    private void p2(int n) {
        n = Math.max(n, 16);
        Object[] objectArray = new Object[n];
        com.aspose.slides.ms.System.n3.p2(this.p2, 0, objectArray, 0, this.q5);
        this.n3 = n;
        this.p2 = objectArray;
    }

    public Stack() {
        this.p2 = new Object[16];
        this.n3 = 16;
    }

    public Stack(ICollection col) {
        this(col == null ? 16 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e : col) {
            this.push(e);
        }
    }

    public Stack(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new ArgumentOutOfRangeException("initialCapacity");
        }
        this.n3 = initialCapacity;
        this.p2 = new Object[this.n3];
    }

    public static Stack sync(Stack stack) {
        if (stack == null) {
            throw new ArgumentNullException("stack");
        }
        return new SyncStack(stack);
    }

    @Override
    public int size() {
        return this.q5;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    public void clear() {
        ++this.s3;
        for (int i = 0; i < this.q5; ++i) {
            this.p2[i] = null;
        }
        this.q5 = 0;
        this.i5 = -1;
    }

    @Override
    public Object deepClone() {
        Stack stack = new Stack(com.aspose.slides.ms.System.n3.p2(this.p2));
        stack.i5 = this.i5;
        stack.q5 = this.q5;
        return stack;
    }

    public boolean contains(Object obj) {
        if (this.q5 == 0) {
            return false;
        }
        if (obj == null) {
            for (int i = 0; i < this.q5; ++i) {
                if (this.p2[i] != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.q5; ++i) {
                if (!obj.equals(this.p2[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void copyTo(n3 array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.n3() > 1 || array.s3() > 0 && index >= array.s3() || this.q5 > array.s3() - index) {
            throw new ArgumentException();
        }
        for (int i = this.i5; i != -1; --i) {
            array.q5(this.p2[i], this.q5 - (i + 1) + index);
        }
    }

    public IEnumerator iterator() {
        return new Enumerator(this);
    }

    public Object peek() {
        if (this.i5 == -1) {
            throw new InvalidOperationException();
        }
        return this.p2[this.i5];
    }

    public Object pop() {
        if (this.i5 == -1) {
            throw new InvalidOperationException();
        }
        ++this.s3;
        Object object = this.p2[this.i5];
        this.p2[this.i5] = null;
        --this.q5;
        --this.i5;
        if (this.q5 <= this.n3 / 4 && this.q5 > 16) {
            this.p2(this.n3 / 2);
        }
        return object;
    }

    public void push(Object obj) {
        ++this.s3;
        if (this.n3 == this.q5) {
            this.p2(this.n3 * 2);
        }
        ++this.q5;
        ++this.i5;
        this.p2[this.i5] = obj;
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.q5) {
            a = Arrays.copyOf(this.p2, this.q5, a.getClass());
            i6.p2(a);
            return a;
        }
        System.arraycopy(this.p2, 0, a, 0, this.q5);
        if (a.length > this.q5) {
            a[this.q5] = null;
        }
        i6.p2(a);
        return a;
    }

    private static class Enumerator
    implements IEnumerator,
    r7,
    Cloneable {
        private Stack p2;
        private int i5;
        private int q5;

        Enumerator(Stack s) {
            this.p2 = s;
            this.i5 = s.s3;
            this.q5 = -2;
        }

        private Enumerator() {
        }

        @Override
        public Object deepClone() {
            return this.p2();
        }

        @Override
        public Object next() {
            if (this.i5 != this.p2.s3 || this.q5 == -2 || this.q5 == -1 || this.q5 > this.p2.q5) {
                throw new InvalidOperationException();
            }
            return this.p2.p2[this.q5];
        }

        @Override
        public boolean hasNext() {
            if (this.i5 != this.p2.s3) {
                throw new InvalidOperationException();
            }
            switch (this.q5) {
                case -2: {
                    this.q5 = this.p2.i5;
                    return this.q5 != -1;
                }
                case -1: {
                    return false;
                }
            }
            --this.q5;
            return this.q5 != -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.i5 != this.p2.s3) {
                throw new InvalidOperationException();
            }
            this.q5 = -2;
        }

        protected Object p2() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            Enumerator enumerator = new Enumerator();
            enumerator.p2 = this.p2;
            enumerator.i5 = this.i5;
            enumerator.q5 = this.q5;
            return enumerator;
        }
    }

    @c8
    private static class SyncStack
    extends Stack {
        private final Stack p2;

        SyncStack(Stack s) {
            this.p2 = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Stack stack = this.p2;
            synchronized (stack) {
                return this.p2.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.p2.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Stack stack = this.p2;
            synchronized (stack) {
                this.p2.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Stack stack = this.p2;
            synchronized (stack) {
                return Stack.sync((Stack)this.p2.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Stack stack = this.p2;
            synchronized (stack) {
                return this.p2.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(n3 array, int index) {
            Stack stack = this.p2;
            synchronized (stack) {
                this.p2.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Stack stack = this.p2;
            synchronized (stack) {
                return new Enumerator(this.p2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Stack stack = this.p2;
            synchronized (stack) {
                return this.p2.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object pop() {
            Stack stack = this.p2;
            synchronized (stack) {
                return this.p2.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void push(Object obj) {
            Stack stack = this.p2;
            synchronized (stack) {
                this.p2.push(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Stack stack = this.p2;
            synchronized (stack) {
                return this.p2.toArray(a);
            }
        }
    }
}

