/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.IAIConversation;
import com.aspose.slides.IAIWebClient;
import com.aspose.slides.SlidesAIAgentException;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.internal.x5.i5;
import com.aspose.slides.internal.x5.l5;
import com.aspose.slides.internal.x5.p2;
import com.aspose.slides.internal.x5.p5;
import com.aspose.slides.internal.x5.s4;
import com.aspose.slides.ms.System.h4;
import com.aspose.slides.w7f;
import java.io.Closeable;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

public class OpenAIWebClient
implements IAIWebClient,
Closeable {
    private l5 p2;
    private final String i5;
    private final HttpURLConnection q5;
    private boolean n3;

    public OpenAIWebClient(String model, String apiKey, String organizationId) {
        this(model, apiKey, organizationId, OpenAIWebClient.p2());
        this.n3 = true;
    }

    public OpenAIWebClient(String model, String apiKey, String organizationId, HttpURLConnection httpClient) {
        if (h4.p2(apiKey)) {
            throw new IllegalArgumentException("API key value can't be null or empty");
        }
        if (h4.p2(model)) {
            throw new IllegalArgumentException("Text model value can't be null or empty");
        }
        if (httpClient == null) {
            throw new IllegalArgumentException("HttpClient instance is not provided");
        }
        this.q5 = httpClient;
        this.p2 = new l5(apiKey, organizationId);
        this.i5 = model;
    }

    private static HttpURLConnection p2() {
        try {
            URL uRL = new URL("https://api.openai.com/v1/chat/completions");
            return (HttpURLConnection)uRL.openConnection();
        }
        catch (IOException iOException) {
            throw new InvalidOperationException("Failed to create default HttpURLConnection");
        }
    }

    @Override
    public String callChat(String instruction) {
        p2 p22 = this.p2(instruction);
        try {
            i5 i52 = this.p2.p2(p22, this.q5);
            if (i52.p2() == null || i52.p2().isEmpty()) {
                throw new ArgumentException("No choices in response");
            }
            return i52.p2().get(0).p2().i5();
        }
        catch (p5 p52) {
            throw new SlidesAIAgentException(p52.getMessage());
        }
    }

    @Override
    public final IAIConversation createConversation() {
        return new w7f(this.p2, this.i5, this.q5);
    }

    private p2 p2(String string) {
        if (h4.p2(string)) {
            throw new ArgumentException("Open AI chat instruction can't be null or empty");
        }
        p2 p22 = new p2();
        String string2 = this.i5;
        if (string2 == null) {
            string2 = "gpt-4o-mini";
        }
        p22.p2(string2);
        s4 s42 = new s4();
        s42.i5(string);
        s42.p2("user");
        p22.p2().add(s42);
        return p22;
    }

    @Override
    public final void close() {
        if (this.n3) {
            this.q5.disconnect();
        }
    }
}

