/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzXCa;
import com.aspose.words.zzLB;
import com.aspose.words.zzRp;
import com.aspose.words.zzWCg;
import com.aspose.words.zzX6h;
import com.aspose.words.zzXtX;
import com.aspose.words.zzYDW;
import com.aspose.words.zzYWR;
import com.aspose.words.zzZ72;
import com.aspose.words.zzZA5;
import com.aspose.words.zzZbH;

public class Cell
extends CompositeNode<Node>
implements zzX6h,
zzZbH {
    private zzYWR zzWQd;
    private CellFormat zzqE;
    private ParagraphCollection zzX3H;
    private TableCollection zz5;

    public Cell(DocumentBase doc) {
        this(doc, new zzYWR());
    }

    Cell(DocumentBase doc, zzYWR cellPr) {
        super(doc);
        this.zzWQd = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    public Cell getNextCell() {
        return (Cell)this.zzqt();
    }

    public Cell getPreviousCell() {
        return (Cell)this.zzXPo();
    }

    public Row getParentRow() {
        return (Row)this.zzYrV();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zzmH() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zzYKD(this, true);
        }
        return -1;
    }

    final int zzpo() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zzpo();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zzqE == null) {
            this.zzqE = new CellFormat(this);
        }
        return this.zzqE;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzX3H == null) {
            this.zzX3H = new ParagraphCollection(this);
        }
        return this.zzX3H;
    }

    public TableCollection getTables() {
        if (this.zz5 == null) {
            this.zz5 = new TableCollection(this);
        }
        return this.zz5;
    }

    final zzYWR zzZ94() {
        return this.zzWQd;
    }

    final void zz45(zzYWR zzYWR2) {
        this.zzWQd = zzYWR2;
    }

    @Override
    final Node zz45(boolean bl, zzYDW zzYDW2) {
        zzYWR zzYWR2;
        Cell cell = (Cell)super.zz45(bl, zzYDW2);
        zzYWR zzYWR3 = this.zzWQd;
        cell.zzWQd = zzYWR2 = (zzYWR)zzYWR3.zzZsT();
        cell.zzqE = null;
        cell.zzX3H = null;
        cell.zz5 = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    public int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitCellStart(this);
    }

    @Override
    public int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitCellEnd(this);
    }

    public void ensureMinimum() {
        zzZ72.zzXbn(this);
    }

    @Override
    final boolean zzWHP(Node node) {
        return zzLB.zzZmZ(node);
    }

    final int zzYEa() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        for (Cell cell = row.getFirstCell(); cell != null; cell = cell.getNextCell()) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell != this) continue;
            return n;
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzWQd.zzXk9(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzWQd.zzXk9(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zzZA5 zzZA52 = zzXCa.zz45(object, zzZA5.class);
        if (zzZA52 != null && zzZA52.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzZdV(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zzYWR.zzYJt(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzWQd.zzZ5g(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzWQd.clear();
    }

    private Object zzZdV(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzXCa.zz45((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zz45(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXtX getInsertRevision() {
        Cell cell = this;
        return cell.zzWQd.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzXtX value) {
        Cloneable cloneable = this;
        zzXtX zzXtX2 = value;
        cloneable = cloneable.zzWQd;
        ((zzWCg)cloneable).zzZ5g(14, zzXtX2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXtX getDeleteRevision() {
        Cell cell = this;
        return cell.zzWQd.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzXtX value) {
        Cloneable cloneable = this;
        zzXtX zzXtX2 = value;
        cloneable = cloneable.zzWQd;
        ((zzWCg)cloneable).zzZ5g(12, zzXtX2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzRp getMoveFromRevision() {
        Cell cell = this;
        return cell.zzWQd.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzRp value) {
        Cloneable cloneable = this;
        zzRp zzRp2 = value;
        cloneable = cloneable.zzWQd;
        ((zzWCg)cloneable).zzZ5g(13, zzRp2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzRp getMoveToRevision() {
        Cell cell = this;
        return cell.zzWQd.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzRp value) {
        Cloneable cloneable = this;
        zzRp zzRp2 = value;
        cloneable = cloneable.zzWQd;
        ((zzWCg)cloneable).zzZ5g(15, zzRp2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzWQd.remove(13);
        cell = this;
        cell.zzWQd.remove(15);
    }

    final zzYWR zzXUE(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zzYWR zzYWR2 = new zzYWR();
        this.zz45(3120, zzYWR2);
        this.zz45(3140, zzYWR2);
        this.zz45(3110, zzYWR2);
        this.zz45(3130, zzYWR2);
        this.zz45(3090, zzYWR2);
        this.zz45(3100, zzYWR2);
        this.zz45(3070, zzYWR2);
        this.zz45(3080, zzYWR2);
        if (bl && (tableStyle = zzXCa.zz45((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zzYFr(this, zzYWR2);
        }
        this.zzWQd.zzYFr((zzWCg)zzYWR2);
        return zzYWR2;
    }

    private void zz45(int n, zzYWR zzYWR2) {
        zzYWR2.zzZ5g(n, this.fetchInheritedCellAttr(n));
    }
}

