/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zzWPP;
import com.aspose.words.internal.zzWf9;
import com.aspose.words.internal.zzWjz;
import com.aspose.words.internal.zzX1N;
import com.aspose.words.internal.zzXCa;
import com.aspose.words.internal.zzXOG;
import com.aspose.words.internal.zzXgJ;
import com.aspose.words.internal.zzXoW;
import com.aspose.words.internal.zzY6i;
import com.aspose.words.internal.zzYNm;
import com.aspose.words.internal.zzYe6;
import com.aspose.words.internal.zzZ1T;
import com.aspose.words.internal.zzZpT;
import com.aspose.words.ref.Ref;
import com.aspose.words.zz68;
import com.aspose.words.zzLB;
import com.aspose.words.zzT1;
import com.aspose.words.zzWUv;
import com.aspose.words.zzWb1;
import com.aspose.words.zzWsQ;
import com.aspose.words.zzWyj;
import com.aspose.words.zzX85;
import com.aspose.words.zzXI4;
import com.aspose.words.zzXkE;
import com.aspose.words.zzYYS;
import com.aspose.words.zzYn0;
import com.aspose.words.zzZ72;
import com.aspose.words.zzZYt;
import com.aspose.words.zzZgf;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private static final String zzY1g = zzWjz.zzZtf().zzWyU(new byte[]{105, 83, 110, 103, 110, 105, 32, 103, 101, 102, 116, 97, 114, 117, 32, 101, 115, 105, 110, 32, 116, 111, 115, 32, 112, 117, 111, 112, 116, 114, 100, 101, 98, 32, 32, 121, 104, 116, 115, 105, 102, 32, 108, 105, 32, 101, 111, 102, 109, 114, 116, 97, 46});

    private DigitalSignatureUtil() {
    }

    private static void zz45(zzWf9 zzWf92, zzWf9 zzWf93, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzXCa.zzYFr((Object)zzWf92, "srcStream");
        zzXCa.zzYFr((Object)zzWf93, "dstStream");
        zzXCa.zzYFr((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzYFr(zzWf92, zzWf93, certificateHolder, signOptions);
        zzWf93.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zz45(zzWf9.zzYFr(srcStream), (zzWf9)zzWf9.zzhG(dstStream), certHolder, signOptions);
    }

    private static void zzYFr(zzWf9 zzWf92, zzWf9 zzWf93, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzhG(digitalSignature);
        }
        DigitalSignatureUtil.zz45(digitalSignature, signOptions);
        if (zzXI4.zzOx(zzWf92)) {
            DigitalSignatureUtil.zz45(zzWf92, zzWf93, digitalSignature, true);
            return;
        }
        zzXI4 zzXI42 = new zzXI4();
        zzWf9 zzWf94 = zzWf92;
        zzXI4 zzXI43 = zzXI42;
        FileFormatInfo fileFormatInfo = zzXI42.zzYFr(zzWf94, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzY6i zzY6i2 = new zzY6i(zzWf92);
                int n = fileFormatInfo.zzXa5() == 1 ? 1 : 2;
                zz68.zz45(zzY6i2, digitalSignature, n);
                zzWf93.zzXbn(0L);
                zzY6i2.zzXky(zzWf93);
                return;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zz45(fileFormatInfo.zzWvO(), zzWf93, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zz45(zzWf92, zzWf93, digitalSignature, false);
                return;
            }
            case 60: 
            case 61: {
                DigitalSignatureUtil.zz45(zzWf92, zzWf93, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException(zzY1g);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzXCa.zzYiH(srcFileName, "srcFileName");
        zzXCa.zzYiH(dstFileName, "dstFileName");
        zzZpT zzZpT2 = zzXCa.zzYFr(srcFileName, 3, 1);
        try {
            zzZpT zzZpT3 = zzXCa.zzYFr(dstFileName, 4, 2);
            try {
                DigitalSignatureUtil.zz45((zzWf9)zzZpT2, (zzWf9)zzZpT3, certHolder, signOptions);
            }
            finally {
                zzZpT3.close();
            }
            return;
        }
        finally {
            zzZpT2.close();
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzYe6 zzYe62 = zzWf9.zzhG(dstStream);
        zzWf9 zzWf92 = zzWf9.zzYFr(srcStream);
        DigitalSignatureUtil.zz45(zzWf92, (zzWf9)zzYe62, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        zzZpT zzZpT2 = zzXCa.zzYFr(srcFileName, 3, 1);
        try {
            zzZpT zzZpT3 = zzXCa.zzYFr(dstFileName, 4, 2);
            try {
                DigitalSignatureUtil.zzYKD(zzZpT2, zzZpT3);
            }
            finally {
                zzZpT3.close();
            }
            return;
        }
        finally {
            zzZpT2.close();
        }
    }

    private static void zzYKD(zzWf9 zzWf92, zzWf9 zzWf93) throws Exception {
        zzXI4 zzXI42 = new zzXI4();
        zzWf9 zzWf94 = zzWf92;
        Object object = zzXI42;
        FileFormatInfo fileFormatInfo = zzXI42.zzYFr(zzWf94, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzY6i zzY6i2 = new zzY6i(zzWf92);
                zzY6i2.zzXIF().zzY8D("_xmlsignatures");
                zzY6i2.zzXIF().zzY8D("_signatures");
                zzWf93.zzW8T(0L);
                zzY6i2.zzXky(zzWf93);
                zzWf9 zzWf95 = zzWf93;
                zzWf95.zzXbn(zzWf95.zzAv());
                return;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                zzX1N zzX1N2 = new zzX1N(zzWf92);
                zzYNm zzYNm2 = zzX1N2.zz45(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzYNm2 != null) {
                    for (zzXgJ zzXgJ2 : zzYNm2.zzXa3()) {
                        String string = zzYNm2.zz45(zzXgJ2);
                        zzX1N2.zzYV0().remove(string);
                    }
                    zzX1N2.zzYV0().remove(zzYNm2.getName());
                    zzXgJ zzXgJ3 = zzX1N2.zzXa3().zzXTr("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzX1N2.zzXa3().remove(zzXgJ3.getId());
                    zzX1N2.zzWXc();
                }
                zzWf93.zzW8T(0L);
                zzX1N2.zzXky(zzWf93);
                zzWf9 zzWf96 = zzWf93;
                zzWf96.zzXbn(zzWf96.zzAv());
                return;
            }
            case 60: 
            case 61: {
                zzX85 zzX852 = new zzX85(zzWf92);
                zzYYS zzYYS2 = zzX852.zzZWj("/META-INF/documentsignatures.xml");
                if (zzYYS2 != null) {
                    zzX852.zz99().remove(zzYYS2.getName());
                }
                zzWf93.zzW8T(0L);
                String string = "application/vnd.oasis.opendocument.text";
                zzWf94 = zzWf93;
                object = zzX852;
                ((zzX85)object).zz45(zzWf94, string, null);
                zzWf9 zzWf97 = zzWf93;
                zzWf97.zzXbn(zzWf97.zzAv());
                return;
            }
        }
        throw new IllegalStateException(zzY1g);
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzYKD(zzWf9.zzYFr(srcStream), zzWf9.zzhG(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        zzZpT zzZpT2 = zzXCa.zzYFr(fileName, 3, 1);
        try {
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzyJ(zzZpT2);
            return digitalSignatureCollection;
        }
        finally {
            zzZpT2.close();
        }
    }

    private static DigitalSignatureCollection zzyJ(zzWf9 zzWf92) throws Exception {
        if (zzXI4.zzOx(zzWf92)) {
            return DigitalSignatureUtil.zzze(zzWf92);
        }
        zzXI4 zzXI42 = new zzXI4();
        zzWf9 zzWf93 = zzWf92;
        zzXI4 zzXI43 = zzXI42;
        FileFormatInfo fileFormatInfo = zzXI42.zzYFr(zzWf93, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 60: 
            case 61: {
                Document document = new Document(zzWf92, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException(zzY1g);
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzyJ(zzWf9.zzYFr(stream));
    }

    static zzWPP zz45(zzY6i zzY6i2, String string) throws Exception {
        zzT1 zzT12 = new zzT1(zzY6i2);
        if (zzT12.zzWuS()) {
            zzWPP zzWPP2 = zzT12.zzZ6t(string);
            return zzWPP2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzxn(int n) {
        switch (n) {
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        return "http://www.w3.org/2000/09/xmldsig#sha1";
    }

    private static void zz45(zzWf9 zzWf92, zzWf9 zzWf93, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzX1N zzX1N2 = new zzX1N(zzWf92);
        zzWsQ zzWsQ2 = bl ? new zzYn0(zzX1N2) : new zzWyj(zzX1N2);
        zzWsQ2.zzYFr(digitalSignature);
        zzWf93.zzXbn(0L);
        zzX1N2.zzXky(zzWf93);
    }

    private static void zz45(zzWf9 zzWf92, zzWf9 zzWf93, DigitalSignature digitalSignature) throws Exception {
        zzX85 zzX852 = new zzX85(zzWf92);
        zzWb1 zzWb12 = new zzWb1(zzX852);
        zzWb12.zzYFr(digitalSignature);
        zzWf93.zzXbn(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzWf9 zzWf94 = zzWf93;
        zzX85 zzX853 = zzX852;
        zzX853.zz45(zzWf94, string, null);
    }

    private static void zz45(zzY6i zzY6i2, zzWf9 zzWf92, DigitalSignature digitalSignature, String string) throws Exception {
        zzWPP zzWPP2 = DigitalSignatureUtil.zz45(zzY6i2, string);
        zzWPP zzWPP3 = new zzWPP();
        DigitalSignatureUtil.zz45((zzWf9)zzWPP2, (zzWf9)zzWPP3, digitalSignature, false);
        zzY6i zzY6i3 = zzT1.zzYFx(zzWPP3, string);
        zzY6i3.zzXky(zzWf92);
    }

    private static DigitalSignatureCollection zzze(zzWf9 zzWf92) throws Exception {
        zzWf92.zzW8T(0L);
        zzX1N zzX1N2 = new zzX1N(zzWf92);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzYNm zzYNm2 = zzX1N2.zz45(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzYNm2 != null) {
            for (zzXgJ zzXgJ2 : zzYNm2.zzXa3()) {
                String string = zzYNm2.zz45(zzXgJ2);
                zzYNm zzYNm3 = zzX1N2.zzY9F(string);
                zzYNm zzYNm4 = zzX1N2.zz45(zzYNm3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzXOG zzXOG2 = zzZ1T.zzYCZ(zzYNm4.zzW2L().zzX3s());
                zzXkE.zz45(zzYNm3.zzZwT(), zzXOG2, new zzZgf(zzX1N2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }

    private static void zz45(DigitalSignature digitalSignature, SignOptions signOptions) {
        byte[] byArray = zzZYt.zzWUj();
        if (byArray == zzWUv.zzZyc) {
            return;
        }
        if (byArray == zzWUv.zzWX5 && zzZYt.zzXrp(30)) {
            return;
        }
        Object t = null;
        Ref<Object> ref = new Ref<Object>(t);
        boolean bl = signOptions != null && zzZ72.zz45(signOptions.zzhC(), ref) == 2;
        ref.get();
        if (bl) {
            return;
        }
        String string = digitalSignature.getComments();
        if (!zzXoW.zzZUY(string, "")) {
            string = zzXoW.zzW9D(string, zzWjz.zzZtf().zzWyU(new byte[]{10, 13}));
        }
        int[] nArray = new int[]{43, 25, 5, 9, 91, 21, 12, 29, 1, 1, 68, 42, 64, 24, 1, 90, 78, 44, 22, 0, 79, 0, 29, 16, 78, 24, 13, 17, 70, 84, 57, 7, 30, 0, 23, 0, 0, 35, 23, 6, 10, 28, 74, 69, 109, 27, 8, 13, 28, 6, 3, 13, 90, 84, 74, 68, 94, 92, 73, 87, 30, 70, 77, 84, 47, 28, 20, 10, 93, 17, 88, 36, 26, 22, 68, 41, 90, 16, 86, 41};
        string = zzXoW.zzW9D(string, zzLB.zzZ60(nArray));
        digitalSignature.setComments(string);
    }
}

