/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.internal.zzXoW;
import com.aspose.words.internal.zzZby;
import com.aspose.words.internal.zzZco;

public final class NativeLibSettings {
    private NativeLibSettings() {
    }

    public static void setTmpDirectoryPath(String path) throws IllegalArgumentException {
        if (zzXoW.zzYBJ(path) || !zzZco.zzXrG(path)) {
            throw new IllegalArgumentException("Custom path " + path + " is invalid");
        }
        System.setProperty("com.aspose.tmpdir", path);
    }

    public static String getTmpDirectoryPath() {
        if (zzXoW.zzYBJ(System.getProperty("com.aspose.tmpdir"))) {
            return System.getProperty("java.io.tmpdir");
        }
        return System.getProperty("com.aspose.tmpdir");
    }

    public static void clearAsposeNativeTmpDirectory() {
        zzZby.zzYZm();
    }

    public static void loadWinNativeLib() {
        System.clearProperty("com.aspose.skip_win_native_lib");
    }

    public static void loadHarfBuzzNativeLib() {
        System.clearProperty("com.aspose.skip_hb_native_lib");
    }

    public static void skipWinNativeLib() {
        System.setProperty("com.aspose.skip_win_native_lib", "true");
    }

    public static void skipHarfBuzzNativeLib() {
        System.setProperty("com.aspose.skip_hb_native_lib", "true");
    }

    public static boolean isWinNativeLibLoaded() {
        return System.getProperty("com.aspose.skip_win_native_lib") == null;
    }

    public static boolean isHarfBuzzNativeLibLoaded() {
        return System.getProperty("com.aspose.skip_hb_native_lib") == null;
    }

    public static void setUseJAIImageRendering(boolean useJAIImageRendering) {
        System.setProperty("com.aspose.use_jai_img_rendering", useJAIImageRendering ? "true" : "false");
    }

    public static boolean getUseJAIImageRendering() {
        if (System.getProperty("com.aspose.use_jai_img_rendering") != null) {
            return Boolean.parseBoolean(System.getProperty("com.aspose.use_jai_img_rendering"));
        }
        return true;
    }

    public static void setInterruptThreadIfImageExceptionThrown(boolean abortSavingIfImageExceptionThrown) {
        System.setProperty("com.aspose.interrupt_thread_if_image_exception_thrown", abortSavingIfImageExceptionThrown ? "true" : "false");
    }

    public static boolean getInterruptThreadIfImageExceptionThrown() {
        if (System.getProperty("com.aspose.interrupt_thread_if_image_exception_thrown") != null) {
            return Boolean.parseBoolean(System.getProperty("com.aspose.interrupt_thread_if_image_exception_thrown"));
        }
        return false;
    }
}

